# JSON API Index

This is the client-side documentation of Fossil's JSON API.  The JSON
API aims to provide access to many of the primary fossil features via
AJAX-style interfaces.

* [Introduction](intro.md)
* [General API Conventions](conventions.md)
* [Tips &amp; Tricks](tips.md)
* [Hacking Guide](hacking.md)

General warnings regarding the APIs linked to in the following list:

- **NOTE** that request/response examples shown in the individual API
pages do not show [the standard request/response envelope](conventions.md)
(for brevity and sanity).
- **Achtung:** just because a given feature is described as being
implemented does not mean that the implementation is "final" - it may be
changed at any time until we find/implement useful APIs.

The APIs, alphabetically by category:

* [Artifact Info](api-artifact.md)
* [Authentication](api-auth.md)
* [Branches](api-branch.md)
* [Checkout Status](api-checkout.md)
* [Config](api-config.md)
* [Diffs](api-diff.md)
* [Directory Listing](api-dir.md)
* [File Info](api-finfo.md)
* [The Obligatory Misc. Category](api-misc.md)
* [Repository Stats](api-stat.md)
* [SQL Query](api-query.md)
* [Tags](api-tag.md)
* [Tickets](api-ticket.md)
* [Timeline](api-timeline.md)
* [User Management](api-user.md)
* [Version](api-version.md)
* [Wiki](api-wiki.md)
