// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  ellint_3
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for k=-0.90000000000000002, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 2.9686139313362077e-16
const testcase_ellint_3<double>
data001[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17525427376115024, -0.90000000000000002, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35492464591297446, -0.90000000000000002, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.54388221416157112, -0.90000000000000002, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.74797400423532490, -0.90000000000000002, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.97463898451966458, -0.90000000000000002, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.2334463254523440, -0.90000000000000002, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.5355247765594913, -0.90000000000000002, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.8882928567775121, -0.90000000000000002, 0.0000000000000000, 
	  1.3962634015954636 },
  { 2.2805491384227703, -0.90000000000000002, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.0141810743801079e-16
const testcase_ellint_3<double>
data002[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17507714233254656, -0.90000000000000002, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35350932904326521, -0.90000000000000002, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53911129989870976, -0.90000000000000002, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.73666644254508395, -0.90000000000000002, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.95250736612100195, -0.90000000000000002, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1950199550905594, -0.90000000000000002, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.4741687286340850, -0.90000000000000002, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.7968678183506057, -0.90000000000000002, 0.10000000000000001, 
	  1.3962634015954636 },
  { 2.1537868513875287, -0.90000000000000002, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.20000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.0588292817405780e-16
const testcase_ellint_3<double>
data003[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17490065089140927, -0.90000000000000002, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.35211377590661436, -0.90000000000000002, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.53448220334204100, -0.90000000000000002, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.72591368943179579, -0.90000000000000002, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.93192539780038763, -0.90000000000000002, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.1600809679692683, -0.90000000000000002, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.4195407225882510, -0.90000000000000002, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.7168966476424525, -0.90000000000000002, 0.20000000000000001, 
	  1.3962634015954636 },
  { 2.0443194576468890, -0.90000000000000002, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.2403611223075570e-16
const testcase_ellint_3<double>
data004[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17472479532647531, -0.90000000000000002, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.35073750187374114, -0.90000000000000002, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52998766129466957, -0.90000000000000002, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.71566993548699553, -0.90000000000000002, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.91271517762560195, -0.90000000000000002, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.1281241199843370, -0.90000000000000002, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.3704929576917451, -0.90000000000000002, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.6461981511487713, -0.90000000000000002, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.9486280260314426, -0.90000000000000002, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3487482375512111e-16
const testcase_ellint_3<double>
data005[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17454957156468837, -0.90000000000000002, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34938003933330430, -0.90000000000000002, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.52562093533067433, -0.90000000000000002, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.70589461324915670, -0.90000000000000002, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.89472658511942849, -0.90000000000000002, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0987419542323440, -0.90000000000000002, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.3261349565496303, -0.90000000000000002, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.5831293909853765, -0.90000000000000002, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.8641114227238349, -0.90000000000000002, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.4538944656036724e-16
const testcase_ellint_3<double>
data006[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17437497557073334, -0.90000000000000002, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34804093691586013, -0.90000000000000002, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.52137576320372891, -0.90000000000000002, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.69655163996912262, -0.90000000000000002, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.87783188683054236, -0.90000000000000002, 0.50000000000000000, 
	  0.87266462599716477 },
  { 1.0716015959755185, -0.90000000000000002, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.2857636916026749, -0.90000000000000002, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.5264263913252363, -0.90000000000000002, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.7888013241937861, -0.90000000000000002, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5560830683344639e-16
const testcase_ellint_3<double>
data007[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17420100334657812, -0.90000000000000002, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34671975876122157, -0.90000000000000002, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.51724631570707946, -0.90000000000000002, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.68760879113743023, -0.90000000000000002, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.86192157779698364, -0.90000000000000002, 0.59999999999999998, 
	  0.87266462599716477 },
  { 1.0464279696166354, -0.90000000000000002, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.2488156247094007, -0.90000000000000002, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.4750988777188472, -0.90000000000000002, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.7211781128919523, -0.90000000000000002, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.4833366769839281e-16
const testcase_ellint_3<double>
data008[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17402765093102207, -0.90000000000000002, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34541608382635131, -0.90000000000000002, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.51322715827061682, -0.90000000000000002, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.67903717872440272, -0.90000000000000002, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.84690113601682671, -0.90000000000000002, 0.69999999999999996, 
	  0.87266462599716477 },
  { 1.0229914311548418, -0.90000000000000002, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.2148329639709381, -0.90000000000000002, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.4283586501307803, -0.90000000000000002, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.6600480747670940, -0.90000000000000002, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.7525301941362493e-16
const testcase_ellint_3<double>
data009[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17385491439925146, -0.90000000000000002, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34412950523113928, -0.90000000000000002, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50931321668729590, -0.90000000000000002, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.67081081392296327, -0.90000000000000002, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.83268846097293259, -0.90000000000000002, 0.80000000000000004, 
	  0.87266462599716477 },
  { 1.0010985015814027, -0.90000000000000002, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.1834394045489680, -0.90000000000000002, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.3855695891683186, -0.90000000000000002, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.6044591960982202, -0.90000000000000002, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for k=-0.90000000000000002, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.8471853989694167e-16
const testcase_ellint_3<double>
data010[10] =
{
  { 0.0000000000000000, -0.90000000000000002, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17368278986240135, -0.90000000000000002, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34285962963961397, -0.90000000000000002, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.50549974644993312, -0.90000000000000002, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.66290623857720876, -0.90000000000000002, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.81921183128847175, -0.90000000000000002, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.98058481956066390, -0.90000000000000002, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.1543223520473569, -0.90000000000000002, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.3462119782292938, -0.90000000000000002, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.5536420236310946, -0.90000000000000002, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1175183168766718e-16
const testcase_ellint_3<double>
data011[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17510154241338899, -0.80000000000000004, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35365068839779390, -0.80000000000000004, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53926804409084550, -0.80000000000000004, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.73587926028070361, -0.80000000000000004, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.94770942970071170, -0.80000000000000004, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1789022995388236, -0.80000000000000004, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.4323027881876009, -0.80000000000000004, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.7069629739121674, -0.80000000000000004, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.9953027776647296, -0.80000000000000004, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1537164503193145e-16
const testcase_ellint_3<double>
data012[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17492468824017163, -0.80000000000000004, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35224443521476911, -0.80000000000000004, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53456851853226950, -0.80000000000000004, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.72488875602364922, -0.80000000000000004, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.92661354274638952, -0.80000000000000004, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1432651144499075, -0.80000000000000004, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.3774479927211429, -0.80000000000000004, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.6287092337196041, -0.80000000000000004, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.8910755418379521, -0.80000000000000004, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1894552974436829e-16
const testcase_ellint_3<double>
data013[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17474847286224940, -0.80000000000000004, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.35085779529084682, -0.80000000000000004, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.53000829263059146, -0.80000000000000004, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.71443466027453384, -0.80000000000000004, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.90698196872715420, -0.80000000000000004, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.1108198200558579, -0.80000000000000004, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.3284988909963957, -0.80000000000000004, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.5600369318140328, -0.80000000000000004, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.8007226661734588, -0.80000000000000004, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2247517409029886e-16
const testcase_ellint_3<double>
data014[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17457289217669889, -0.80000000000000004, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34949028801501258, -0.80000000000000004, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52558024362769307, -0.80000000000000004, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.70447281740094891, -0.80000000000000004, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.88864745641528986, -0.80000000000000004, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0811075819341462, -0.80000000000000004, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.2844589654082377, -0.80000000000000004, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.4991461361277847, -0.80000000000000004, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.7214611048717301, -0.80000000000000004, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2596216594752862e-16
const testcase_ellint_3<double>
data015[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17439794211872175, -0.80000000000000004, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34814144964568972, -0.80000000000000004, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.52127776285273064, -0.80000000000000004, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.69496411438966588, -0.80000000000000004, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.87146878427509589, -0.80000000000000004, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0537579024937762, -0.80000000000000004, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.2445534387922637, -0.80000000000000004, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.4446769766361993, -0.80000000000000004, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.6512267838651289, -0.80000000000000004, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2940800093915668e-16
const testcase_ellint_3<double>
data016[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17422361866118044, -0.80000000000000004, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34681083254170475, -0.80000000000000004, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51709470815494440, -0.80000000000000004, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.68587375344080237, -0.80000000000000004, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.85532571852810624, -0.80000000000000004, 0.50000000000000000, 
	  0.87266462599716477 },
  { 1.0284677391874903, -0.80000000000000004, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.2081693942686225, -0.80000000000000004, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.3955803006426311, -0.80000000000000004, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.5884528947755532, -0.80000000000000004, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3281408974056389e-16
const testcase_ellint_3<double>
data017[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17404991781414089, -0.80000000000000004, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34549800443625167, -0.80000000000000004, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.51302536167001545, -0.80000000000000004, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.67717065003912236, -0.80000000000000004, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.84011512421134416, -0.80000000000000004, 0.59999999999999998, 
	  0.87266462599716477 },
  { 1.0049863847088740, -0.80000000000000004, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.1748145941898920, -0.80000000000000004, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.3510319699755071, -0.80000000000000004, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.5319262547427865, -0.80000000000000004, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.69999999999999996.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 4.3618176466061808e-16
const testcase_ellint_3<double>
data018[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17387683562442199, -0.80000000000000004, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34420254775101611, -0.80000000000000004, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50906439222143673, -0.80000000000000004, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.66882693152688422, -0.80000000000000004, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.82574792844091316, -0.80000000000000004, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.98310431309490931, -0.80000000000000004, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.1440884535113258, -0.80000000000000004, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.3103743938952537, -0.80000000000000004, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.4806912324625332, -0.80000000000000004, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3951228558314112e-16
const testcase_ellint_3<double>
data019[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17370436817515203, -0.80000000000000004, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34292405894783395, -0.80000000000000004, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50520682176250076, -0.80000000000000004, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.66081751679736178, -0.80000000000000004, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.81214672249355102, -0.80000000000000004, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.96264481387685552, -0.80000000000000004, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.1156611352656258, -0.80000000000000004, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.2730756225143889, -0.80000000000000004, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.4339837018309471, -0.80000000000000004, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for k=-0.80000000000000004, nu=0.90000000000000002.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.4280684534289690e-16
const testcase_ellint_3<double>
data020[10] =
{
  { 0.0000000000000000, -0.80000000000000004, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17353251158533151, -0.80000000000000004, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34166214791545768, -0.80000000000000004, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.50144799535130569, -0.80000000000000004, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.65311976193814425, -0.80000000000000004, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.79924384892320866, -0.80000000000000004, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.94345762353365603, -0.80000000000000004, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0892582069219161, -0.80000000000000004, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.2387000876610268, -0.80000000000000004, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.3911845406776222, -0.80000000000000004, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.5930208052157665e-16
const testcase_ellint_3<double>
data021[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17496737466916723, -0.69999999999999996, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35254687535677925, -0.69999999999999996, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53536740275997119, -0.69999999999999996, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.72603797651684454, -0.69999999999999996, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.92698296348313458, -0.69999999999999996, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1400447527693316, -0.69999999999999996, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.3657668117194073, -0.69999999999999996, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.6024686895959159, -0.69999999999999996, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.8456939983747236, -0.69999999999999996, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.10000000000000001.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.6735282577377367e-16
const testcase_ellint_3<double>
data022[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17479076384884684, -0.69999999999999996, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35114844900396364, -0.69999999999999996, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53072776947527001, -0.69999999999999996, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.71530198262386235, -0.69999999999999996, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.90666760677828306, -0.69999999999999996, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1063366517438080, -0.69999999999999996, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.3149477243092149, -0.69999999999999996, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.5314886725038925, -0.69999999999999996, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.7528050171757608, -0.69999999999999996, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.20000000000000001.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.7517969287516802e-16
const testcase_ellint_3<double>
data023[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17461479077791475, -0.69999999999999996, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34976950621407538, -0.69999999999999996, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52622533231350177, -0.69999999999999996, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.70508774017895215, -0.69999999999999996, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.88775302531730294, -0.69999999999999996, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0756195476149006, -0.69999999999999996, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.2695349716654374, -0.69999999999999996, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.4690814617070540, -0.69999999999999996, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.6721098780092145, -0.69999999999999996, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.8280039841080712e-16
const testcase_ellint_3<double>
data024[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17443945136076175, -0.69999999999999996, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34840956983535287, -0.69999999999999996, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52185308551329168, -0.69999999999999996, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.69535240431168255, -0.69999999999999996, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.87007983473964923, -0.69999999999999996, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0474657975577066, -0.69999999999999996, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.2286225419931891, -0.69999999999999996, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.4136490671013271, -0.69999999999999996, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.6011813647733213, -0.69999999999999996, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler024 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3472957053482092e-16
const testcase_ellint_3<double>
data025[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17426474153983229, -0.69999999999999996, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34706817945773732, -0.69999999999999996, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51760452851738148, -0.69999999999999996, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.68605801534722755, -0.69999999999999996, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.85351339387296532, -0.69999999999999996, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0215297967969539, -0.69999999999999996, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1915051074460530, -0.69999999999999996, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.3639821911744707, -0.69999999999999996, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.5382162002954762, -0.69999999999999996, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.50000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.9748346743390620e-16
const testcase_ellint_3<double>
data026[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17409065729516096, -0.69999999999999996, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34574489064986091, -0.69999999999999996, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51347361925579782, -0.69999999999999996, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.67717079489579279, -0.69999999999999996, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.83793902055292280, -0.69999999999999996, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.99752863545289705, -0.69999999999999996, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.1576240080401501, -0.69999999999999996, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.3191464023923762, -0.69999999999999996, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.4818433192178544, -0.69999999999999996, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.59999999999999998.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.0457157538295173e-16
const testcase_ellint_3<double>
data027[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17391719464391614, -0.69999999999999996, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34443927423869031, -0.69999999999999996, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50945473266486063, -0.69999999999999996, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.66866056326513812, -0.69999999999999996, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.82325830002337352, -0.69999999999999996, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.97522808245669368, -0.69999999999999996, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.1265300613705285, -0.69999999999999996, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.2784066076152001, -0.69999999999999996, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.4309994736080540, -0.69999999999999996, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.69999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 5.4867405596732161e-16
const testcase_ellint_3<double>
data028[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17374434963995031, -0.69999999999999996, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34315091562900674, -0.69999999999999996, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50554262375653347, -0.69999999999999996, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.66050025406305801, -0.69999999999999996, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.80938620118847404, -0.69999999999999996, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.95443223855852144, -0.69999999999999996, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0978573207128304, -0.69999999999999996, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.2411754575007123, -0.69999999999999996, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.3848459188329196, -0.69999999999999996, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1829502028913879e-16
const testcase_ellint_3<double>
data029[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17357211837335740, -0.69999999999999996, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34187941416012108, -0.69999999999999996, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50173239465478259, -0.69999999999999996, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.65266550725988315, -0.69999999999999996, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.79624879865249298, -0.69999999999999996, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.93497577043296920, -0.69999999999999996, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0713041566930750, -0.69999999999999996, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.2069772023255654, -0.69999999999999996, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.3427110650397531, -0.69999999999999996, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for k=-0.69999999999999996, nu=0.90000000000000002.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.2494869624129105e-16
const testcase_ellint_3<double>
data030[10] =
{
  { 0.0000000000000000, -0.69999999999999996, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17340049697003637, -0.69999999999999996, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34062438249741556, -0.69999999999999996, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49801946510076867, -0.69999999999999996, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.64513432604750476, -0.69999999999999996, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.78378145487573758, -0.69999999999999996, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.91671799500854623, -0.69999999999999996, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0466193579463123, -0.69999999999999996, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1754218079199146, -0.69999999999999996, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.3040500499695913, -0.69999999999999996, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 2.8964816695821429e-16
const testcase_ellint_3<double>
data031[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17485154362988359, -0.59999999999999998, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35160509865544326, -0.59999999999999998, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53210652578446138, -0.59999999999999998, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.71805304664485659, -0.59999999999999998, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.91082759030195970, -0.59999999999999998, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1112333229323361, -0.59999999999999998, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.3191461190365270, -0.59999999999999998, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.5332022105084773, -0.59999999999999998, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.7507538029157526, -0.59999999999999998, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler031 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 2.6674242225057385e-16
const testcase_ellint_3<double>
data032[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17467514275022011, -0.59999999999999998, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35021333086258255, -0.59999999999999998, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52751664092962691, -0.59999999999999998, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.70752126971957874, -0.59999999999999998, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.89111058756112871, -0.59999999999999998, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0789241202877768, -0.59999999999999998, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2710800210399946, -0.59999999999999998, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.4669060574440276, -0.59999999999999998, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.6648615773343014, -0.59999999999999998, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.20000000000000001.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.1891472451898755e-16
const testcase_ellint_3<double>
data033[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17449937871800650, -0.59999999999999998, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34884093647346553, -0.59999999999999998, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52306221119844087, -0.59999999999999998, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.69749955678982223, -0.59999999999999998, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.87274610682416853, -0.59999999999999998, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0494620540750792, -0.59999999999999998, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.2280847305507339, -0.59999999999999998, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.4085436279696886, -0.59999999999999998, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.5901418016279374, -0.59999999999999998, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 2.9132420715478757e-16
const testcase_ellint_3<double>
data034[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17432424744393932, -0.59999999999999998, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34748744127146447, -0.59999999999999998, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51873632743924825, -0.59999999999999998, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.68794610396313116, -0.59999999999999998, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.85558070175468726, -0.59999999999999998, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0224416343605653, -0.59999999999999998, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1893144457936788, -0.59999999999999998, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.3566435377982575, -0.59999999999999998, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.5243814243493585, -0.59999999999999998, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3897581541285558e-16
const testcase_ellint_3<double>
data035[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17414974487670717, -0.59999999999999998, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34615238767335027, -0.59999999999999998, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51453257838108557, -0.59999999999999998, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.67882386787534399, -0.59999999999999998, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.83948470233173578, -0.59999999999999998, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.99753496200073977, -0.59999999999999998, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1541101404388487, -0.59999999999999998, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.3100911323398814, -0.59999999999999998, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.4659345278069984, -0.59999999999999998, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5022138270566200e-16
const testcase_ellint_3<double>
data036[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17397586700252807, -0.59999999999999998, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34483533397138516, -0.59999999999999998, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51044500461706477, -0.59999999999999998, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.67009988034712664, -0.59999999999999998, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.82434762375735193, -0.59999999999999998, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.97447346702798998, -0.59999999999999998, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.1219494000522143, -0.59999999999999998, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2680242605954484, -0.59999999999999998, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.4135484285693078, -0.59999999999999998, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler036 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.2504224329684343e-16
const testcase_ellint_3<double>
data037[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17380260984469353, -0.59999999999999998, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34353585361777839, -0.59999999999999998, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50646805774321380, -0.59999999999999998, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.66174468108625506, -0.59999999999999998, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.81007462280278408, -0.59999999999999998, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.95303466945718729, -0.59999999999999998, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0924118588677505, -0.59999999999999998, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.2297640574847937, -0.59999999999999998, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.3662507535812816, -0.59999999999999998, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.69999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3559889697529752e-16
const testcase_ellint_3<double>
data038[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17362996946312007, -0.59999999999999998, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34225353454870588, -0.59999999999999998, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50259656397799524, -0.59999999999999998, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.65373184496628933, -0.59999999999999998, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.79658372884056439, -0.59999999999999998, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.93303240100245421, -0.59999999999999998, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0651547944716557, -0.59999999999999998, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1947676204853441, -0.59999999999999998, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.3232737468822813, -0.59999999999999998, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler038 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.80000000000000004.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.1879494682720725e-16
const testcase_ellint_3<double>
data039[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17345794195390685, -0.59999999999999998, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34098797854531027, -0.59999999999999998, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49882569168826213, -0.59999999999999998, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.64603758566475511, -0.59999999999999998, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.78380365594769730, -0.59999999999999998, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.91430946255611190, -0.59999999999999998, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0398955217270607, -0.59999999999999998, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1625948314277679, -0.59999999999999998, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2840021261752192, -0.59999999999999998, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler039 = 2.5000000000000020e-13;

// Test data for k=-0.59999999999999998, nu=0.90000000000000002.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.4768329326726447e-16
const testcase_ellint_3<double>
data040[10] =
{
  { 0.0000000000000000, -0.59999999999999998, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17328652344890030, -0.59999999999999998, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33973880062929018, -0.59999999999999998, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49515092233122743, -0.59999999999999998, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.63864042139737043, -0.59999999999999998, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.77167205646538850, -0.59999999999999998, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.89673202848034383, -0.59999999999999998, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0163984492661304, -0.59999999999999998, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1328845785162431, -0.59999999999999998, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.2479362973851875, -0.59999999999999998, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler040 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1201497220602069e-16
const testcase_ellint_3<double>
data041[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17475385514035785, -0.50000000000000000, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35081868470101585, -0.50000000000000000, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52942862705190574, -0.50000000000000000, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.71164727562630314, -0.50000000000000000, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.89824523594227768, -0.50000000000000000, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0895506700518851, -0.50000000000000000, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2853005857432931, -0.50000000000000000, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4845545520549484, -0.50000000000000000, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6857503548125963, -0.50000000000000000, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler041 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.10000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1662857256911530e-16
const testcase_ellint_3<double>
data042[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17457763120814676, -0.50000000000000000, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34943246340849154, -0.50000000000000000, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52487937869610790, -0.50000000000000000, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.70127785096388384, -0.50000000000000000, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.87898815988624479, -0.50000000000000000, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0582764576094172, -0.50000000000000000, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2391936844060205, -0.50000000000000000, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.4214793542995841, -0.50000000000000000, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.6045524936084892, -0.50000000000000000, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler042 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.20000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2114786773102175e-16
const testcase_ellint_3<double>
data043[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17440204336345433, -0.50000000000000000, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34806552388338824, -0.50000000000000000, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52046416757129810, -0.50000000000000000, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.69140924550993865, -0.50000000000000000, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.86104678636125520, -0.50000000000000000, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0297439459053981, -0.50000000000000000, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1979214112912033, -0.50000000000000000, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3659033858648930, -0.50000000000000000, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.5338490483665983, -0.50000000000000000, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler043 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.29999999999999999.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2557837230041312e-16
const testcase_ellint_3<double>
data044[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17422708752228896, -0.50000000000000000, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34671739434855858, -0.50000000000000000, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51617616305641878, -0.50000000000000000, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.68200047612545167, -0.50000000000000000, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.84427217869498372, -0.50000000000000000, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0035637821389782, -0.50000000000000000, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1606800483933111, -0.50000000000000000, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.3164407134643459, -0.50000000000000000, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4715681939859637, -0.50000000000000000, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler044 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.40000000000000002.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2992508582900068e-16
const testcase_ellint_3<double>
data045[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17405275963859917, -0.50000000000000000, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34538761957029329, -0.50000000000000000, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51200902646603907, -0.50000000000000000, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.67301522212868792, -0.50000000000000000, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.82853844466313320, -0.50000000000000000, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.97942097862681488, -0.50000000000000000, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1268429801220614, -0.50000000000000000, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2720406704533922, -0.50000000000000000, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.4161679518465340, -0.50000000000000000, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.50000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.3419255755184137e-16
const testcase_ellint_3<double>
data046[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17387905570381157, -0.50000000000000000, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34407576010465207, -0.50000000000000000, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50795686560160824, -0.50000000000000000, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.66442115453330164, -0.50000000000000000, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.81373829119355345, -0.50000000000000000, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.95705743313235825, -0.50000000000000000, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0959131991362554, -0.50000000000000000, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2318900529754597, -0.50000000000000000, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3664739530045971, -0.50000000000000000, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler046 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.59999999999999998.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.3838494104749599e-16
const testcase_ellint_3<double>
data047[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17370597174637581, -0.50000000000000000, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34278139158591414, -0.50000000000000000, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50401419439302708, -0.50000000000000000, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.65618938076167210, -0.50000000000000000, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.79977959248855424, -0.50000000000000000, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.93625925190753545, -0.50000000000000000, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0674905658379708, -0.50000000000000000, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1953481298023050, -0.50000000000000000, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.3215740290190876, -0.50000000000000000, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler047 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.69999999999999996.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.4250604066951477e-16
const testcase_ellint_3<double>
data048[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17353350383131641, -0.50000000000000000, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34150410405436771, -0.50000000000000000, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50017589696443487, -0.50000000000000000, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64829398188419951, -0.50000000000000000, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.78658270782402073, -0.50000000000000000, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.91684738336675053, -0.50000000000000000, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0412486789555935, -0.50000000000000000, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1619021847612001, -0.50000000000000000, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2807475181182502, -0.50000000000000000, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler048 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5715240651179632e-16
const testcase_ellint_3<double>
data049[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17336164805979126, -0.50000000000000000, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34024350132086773, -0.50000000000000000, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49643719555734073, -0.50000000000000000, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.64071162456976150, -0.50000000000000000, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.77407836177211908, -0.50000000000000000, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.89867058251905652, -0.50000000000000000, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0169181822134910, -0.50000000000000000, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1311363312779448, -0.50000000000000000, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2434165408189539, -0.50000000000000000, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler049 = 2.5000000000000020e-13;

// Test data for k=-0.50000000000000000, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.4664649039489274e-16
const testcase_ellint_3<double>
data050[10] =
{
  { 0.0000000000000000, -0.50000000000000000, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17319040056865681, -0.50000000000000000, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33899920036578557, -0.50000000000000000, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49279362182695174, -0.50000000000000000, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.63342123379746151, -0.50000000000000000, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.76220595179550321, -0.50000000000000000, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.88160004743532294, -0.50000000000000000, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.99427448642310123, -0.50000000000000000, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1027091512470095, -0.50000000000000000, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.2091116095504744, -0.50000000000000000, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler050 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.0000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.0617918857203532e-16
const testcase_ellint_3<double>
data051[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17467414669441528, -0.40000000000000002, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35018222772483443, -0.40000000000000002, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52729015917508737, -0.40000000000000002, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70662374407341244, -0.40000000000000002, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.88859210497602170, -0.40000000000000002, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0733136290471379, -0.40000000000000002, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2605612170157061, -0.40000000000000002, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4497513956433439, -0.40000000000000002, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6399998658645112, -0.40000000000000002, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler051 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.10000000000000001.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.2644663257577874e-16
const testcase_ellint_3<double>
data052[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17449806706684670, -0.40000000000000002, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34880048623856075, -0.40000000000000002, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52277322065757392, -0.40000000000000002, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69638072056918365, -0.40000000000000002, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.86968426619831540, -0.40000000000000002, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0428044206578095, -0.40000000000000002, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2158651158274378, -0.40000000000000002, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3889447129893324, -0.40000000000000002, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5620566886683604, -0.40000000000000002, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler052 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.20000000000000001.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.4583049464169287e-16
const testcase_ellint_3<double>
data053[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17432262290723397, -0.40000000000000002, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34743795258968596, -0.40000000000000002, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51838919472805101, -0.40000000000000002, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68663134739057907, -0.40000000000000002, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.85206432981833979, -0.40000000000000002, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0149595349004430, -0.40000000000000002, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1758349405464676, -0.40000000000000002, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3353337673882637, -0.40000000000000002, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4941414344266770, -0.40000000000000002, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler053 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.29999999999999999.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.1925080711125793e-16
const testcase_ellint_3<double>
data054[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17414781013591540, -0.40000000000000002, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34609415696777285, -0.40000000000000002, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51413131295862535, -0.40000000000000002, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67733527622935630, -0.40000000000000002, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.83558675182733266, -0.40000000000000002, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.98940140808865906, -0.40000000000000002, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1396968797728058, -0.40000000000000002, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2875920037865090, -0.40000000000000002, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4342789859950078, -0.40000000000000002, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler054 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.40000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.8235661108581362e-16
const testcase_ellint_3<double>
data055[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17397362471112707, -0.40000000000000002, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34476864603333196, -0.40000000000000002, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50999329415379346, -0.40000000000000002, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66845674551396006, -0.40000000000000002, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.82012848346231748, -0.40000000000000002, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.96582449258349057, -0.40000000000000002, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1068473749476286, -0.40000000000000002, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2447132729159989, -0.40000000000000002, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3809986210732901, -0.40000000000000002, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler055 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.50000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.9965792755639576e-16
const testcase_ellint_3<double>
data056[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17380006262854136, -0.40000000000000002, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34346098216756610, -0.40000000000000002, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50596929935059420, -0.40000000000000002, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65996392089131251, -0.40000000000000002, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.80558463511364786, -0.40000000000000002, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.94397834522857704, -0.40000000000000002, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0768075114108115, -0.40000000000000002, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2059184624251333, -0.40000000000000002, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3331797176377398, -0.40000000000000002, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler056 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.59999999999999998.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.1640223038298069e-16
const testcase_ellint_3<double>
data057[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17362711992081245, -0.40000000000000002, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34217074276403953, -0.40000000000000002, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50205389185761606, -0.40000000000000002, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.65182834920372734, -0.40000000000000002, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.79186512820565136, -0.40000000000000002, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.92365535916287134, -0.40000000000000002, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0491915663957907, -0.40000000000000002, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1705934291745106, -0.40000000000000002, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2899514672527024, -0.40000000000000002, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler057 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.3264047918332349e-16
const testcase_ellint_3<double>
data058[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17345479265712868, -0.40000000000000002, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34089751955950354, -0.40000000000000002, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49824200167361332, -0.40000000000000002, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64402450341199402, -0.40000000000000002, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.77889207804122873, -0.40000000000000002, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.90468169720957992, -0.40000000000000002, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0236847823692916, -0.40000000000000002, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1382465247425166, -0.40000000000000002, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2506255923253344, -0.40000000000000002, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler058 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.80000000000000004.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 6.6611561645571024e-16
const testcase_ellint_3<double>
data059[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17328307694277154, -0.40000000000000002, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33964091800132007, -0.40000000000000002, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49452889372467440, -0.40000000000000002, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63652940095937316, -0.40000000000000002, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.76659772511159097, -0.40000000000000002, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.88691047977338111, -0.40000000000000002, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0000273200611638, -0.40000000000000002, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1084787902188009, -0.40000000000000002, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2146499565727209, -0.40000000000000002, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler059 = 2.5000000000000020e-13;

// Test data for k=-0.40000000000000002, nu=0.90000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.6376730823308004e-16
const testcase_ellint_3<double>
data060[10] =
{
  { 0.0000000000000000, -0.40000000000000002, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17311196891868127, -0.40000000000000002, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33840055664911906, -0.40000000000000002, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49091013944075329, -0.40000000000000002, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62932228186809580, -0.40000000000000002, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.75492278323019801, -0.40000000000000002, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.87021659043854294, -0.40000000000000002, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.97800245228239246, -0.40000000000000002, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0809625773173697, -0.40000000000000002, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1815758115929846, -0.40000000000000002, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler060 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3361874537309281e-16
const testcase_ellint_3<double>
data061[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17461228653000099, -0.30000000000000004, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34969146102798415, -0.30000000000000004, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52565822873726320, -0.30000000000000004, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70284226512408532, -0.30000000000000004, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.88144139195111182, -0.30000000000000004, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0614897067260520, -0.30000000000000004, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2428416824174218, -0.30000000000000004, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4251795877015927, -0.30000000000000004, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6080486199305128, -0.30000000000000004, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler061 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.10000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3908043711907203e-16
const testcase_ellint_3<double>
data062[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17443631884814376, -0.30000000000000004, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34831316835124926, -0.30000000000000004, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52116586276523857, -0.30000000000000004, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69269385837910036, -0.30000000000000004, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.86279023163070856, -0.30000000000000004, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0315321461438263, -0.30000000000000004, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1991449111869024, -0.30000000000000004, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3659561780923213, -0.30000000000000004, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5323534693557528, -0.30000000000000004, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler062 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.20000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.4447238179454079e-16
const testcase_ellint_3<double>
data063[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17426098615372088, -0.30000000000000004, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34695402664689923, -0.30000000000000004, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51680555567038933, -0.30000000000000004, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68303375225260210, -0.30000000000000004, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.84540662891295026, -0.30000000000000004, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0041834051646927, -0.30000000000000004, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1599952702345711, -0.30000000000000004, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3137179520499165, -0.30000000000000004, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4663658145259877, -0.30000000000000004, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler063 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.29999999999999999.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.4979715256503266e-16
const testcase_ellint_3<double>
data064[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17408628437042842, -0.30000000000000004, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34561356761638401, -0.30000000000000004, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51257058617875850, -0.30000000000000004, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67382207124602878, -0.30000000000000004, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82914751587825131, -0.30000000000000004, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.97907434814374938, -0.30000000000000004, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1246399297351584, -0.30000000000000004, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2671793970398149, -0.30000000000000004, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4081767433479091, -0.30000000000000004, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler064 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.40000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.5505716921759864e-16
const testcase_ellint_3<double>
data065[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17391220945982727, -0.30000000000000004, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34429133937639689, -0.30000000000000004, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50845471668581632, -0.30000000000000004, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66502347027873854, -0.30000000000000004, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.81389191978012254, -0.30000000000000004, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.95590618002140570, -0.30000000000000004, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0924915195213121, -0.30000000000000004, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2253651604038061, -0.30000000000000004, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3563643538969763, -0.30000000000000004, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler065 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.50000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.7807908859023716e-16
const testcase_ellint_3<double>
data066[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17373875742088232, -0.30000000000000004, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34298690571124157, -0.30000000000000004, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50445214859646936, -0.30000000000000004, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65660648352418516, -0.30000000000000004, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79953670639287289, -0.30000000000000004, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.93443393926588536, -0.30000000000000004, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0630838369016911, -0.30000000000000004, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1875197325653029, -0.30000000000000004, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3098448759814962, -0.30000000000000004, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler066 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.59999999999999998.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.0057999499931649e-16
const testcase_ellint_3<double>
data067[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17356592428950823, -0.30000000000000004, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34169984536697379, -0.30000000000000004, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50055748266498457, -0.30000000000000004, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64854298527106768, -0.30000000000000004, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.78599329284207431, -0.30000000000000004, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.91445452089128199, -0.30000000000000004, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0360412952290587, -0.30000000000000004, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1530473919778641, -0.30000000000000004, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2677758800420669, -0.30000000000000004, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler067 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.69999999999999996.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.2239502844122443e-16
const testcase_ellint_3<double>
data068[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17339370613812224, -0.30000000000000004, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34042975138455933, -0.30000000000000004, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49676568368075985, -0.30000000000000004, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64080774055753720, -0.30000000000000004, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.77318507779667278, -0.30000000000000004, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.89579782346548609, -0.30000000000000004, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0110573286052202, -0.30000000000000004, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1214710972949635, -0.30000000000000004, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2294913236274982, -0.30000000000000004, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler068 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.80000000000000004.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.4358357000101250e-16
const testcase_ellint_3<double>
data069[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17322209907520358, -0.30000000000000004, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33917623046949996, -0.30000000000000004, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49307204894329176, -0.30000000000000004, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63337802830291734, -0.30000000000000004, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.76104540997689407, -0.30000000000000004, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.87832009635450714, -0.30000000000000004, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.98787879723171790, -0.30000000000000004, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0924036340069339, -0.30000000000000004, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1944567571590048, -0.30000000000000004, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler069 = 2.5000000000000020e-13;

// Test data for k=-0.30000000000000004, nu=0.90000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.6419688299804087e-16
const testcase_ellint_3<double>
data070[10] =
{
  { 0.0000000000000000, -0.30000000000000004, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17305109924485945, -0.30000000000000004, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33793890239556984, -0.30000000000000004, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48947218005089738, -0.30000000000000004, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62623332340775151, -0.30000000000000004, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74951596581511148, -0.30000000000000004, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.86189886597755994, -0.30000000000000004, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.96629451153092005, -0.30000000000000004, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0655269133492682, -0.30000000000000004, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1622376896064914, -0.30000000000000004, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler070 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2156475739151676e-16
const testcase_ellint_3<double>
data071[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17456817290292809, -0.19999999999999996, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34934315932086801, -0.19999999999999996, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52450880529443988, -0.19999999999999996, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70020491009844876, -0.19999999999999996, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.87651006649967955, -0.19999999999999996, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0534305870298994, -0.19999999999999996, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2308975521670784, -0.19999999999999996, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4087733584990738, -0.19999999999999996, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.5868678474541660, -0.19999999999999996, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler071 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3374593253183472e-16
const testcase_ellint_3<double>
data072[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17439228502691748, -0.19999999999999996, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34796731137565740, -0.19999999999999996, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52003370294544848, -0.19999999999999996, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69012222258631462, -0.19999999999999996, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.85803491465566772, -0.19999999999999996, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0238463961099364, -0.19999999999999996, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1878691059202153, -0.19999999999999996, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3505985031831940, -0.19999999999999996, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5126513474261087, -0.19999999999999996, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler072 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.4549984059502760e-16
const testcase_ellint_3<double>
data073[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17421703179583747, -0.19999999999999996, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34661057411998791, -0.19999999999999996, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51569006052647393, -0.19999999999999996, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68052412821107244, -0.19999999999999996, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.84081341263313825, -0.19999999999999996, 0.20000000000000001, 
	  0.87266462599716477 },
  { 0.99683359988842890, -0.19999999999999996, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1493086715118852, -0.19999999999999996, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.2992699693957541, -0.19999999999999996, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4479323932249564, -0.19999999999999996, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler073 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.29999999999999999.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.3140668101543467e-16
const testcase_ellint_3<double>
data074[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17404240913577704, -0.19999999999999996, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34527248032587193, -0.19999999999999996, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51147118981668416, -0.19999999999999996, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67137107867777601, -0.19999999999999996, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82470418188668893, -0.19999999999999996, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.97202873223594299, -0.19999999999999996, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1144773569375266, -0.19999999999999996, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2535292433701000, -0.19999999999999996, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.3908453514752477, -0.19999999999999996, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler074 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.6788709752760483e-16
const testcase_ellint_3<double>
data075[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17386841301066674, -0.19999999999999996, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34395257914113253, -0.19999999999999996, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50737088376869466, -0.19999999999999996, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66262801717277631, -0.19999999999999996, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.80958766645079094, -0.19999999999999996, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.94913754236162040, -0.19999999999999996, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0827985514222997, -0.19999999999999996, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2124212429050478, -0.19999999999999996, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3400002519661005, -0.19999999999999996, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler075 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.7788201301356829e-16
const testcase_ellint_3<double>
data076[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17369503942181799, -0.19999999999999996, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34265043534362660, -0.19999999999999996, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50338337208655415, -0.19999999999999996, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65426373297163609, -0.19999999999999996, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79536193036145808, -0.19999999999999996, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.92791875910061605, -0.19999999999999996, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0538145052725829, -0.19999999999999996, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1752060022875899, -0.19999999999999996, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.2943374404397372, -0.19999999999999996, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler076 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.8899223779598256e-16
const testcase_ellint_3<double>
data077[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17352228440746925, -0.19999999999999996, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34136562863713626, -0.19999999999999996, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.49950328177638481, -0.19999999999999996, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64625032705690799, -0.19999999999999996, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.78193941198403083, -0.19999999999999996, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.90817230934317128, -0.19999999999999996, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0271563751276462, -0.19999999999999996, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1412999379040518, -0.19999999999999996, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2530330675914556, -0.19999999999999996, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler077 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.9999318361775115e-16
const testcase_ellint_3<double>
data078[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17335014404233895, -0.19999999999999996, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34009775298617811, -0.19999999999999996, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49572560201923810, -0.19999999999999996, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.63856276669886503, -0.19999999999999996, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.76924438644867565, -0.19999999999999996, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.88973060843856466, -0.19999999999999996, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0025230471636377, -0.19999999999999996, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1102356376093103, -0.19999999999999996, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2154356555075863, -0.19999999999999996, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler078 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 5.0901276230707249e-16
const testcase_ellint_3<double>
data079[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17317861443718538, -0.19999999999999996, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33884641598718701, -0.19999999999999996, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49204565281259494, -0.19999999999999996, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63117851188220320, -0.19999999999999996, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.75721095949544170, -0.19999999999999996, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.87245201443919118, -0.19999999999999996, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.97966584238831089, -0.19999999999999996, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0816336325174360, -0.19999999999999996, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1810223448909909, -0.19999999999999996, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler079 = 2.5000000000000020e-13;

// Test data for k=-0.19999999999999996, nu=0.90000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 6.4833128442756722e-16
const testcase_ellint_3<double>
data080[10] =
{
  { 0.0000000000000000, -0.19999999999999996, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17300769173837277, -0.19999999999999996, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33761123827372508, -0.19999999999999996, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48845905690769426, -0.19999999999999996, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62407720017324952, -0.19999999999999996, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74578146525124289, -0.19999999999999996, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.85621583540073076, -0.19999999999999996, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.95837725988001199, -0.19999999999999996, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0551821412633928, -0.19999999999999996, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1493679916141861, -0.19999999999999996, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler080 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.1735566504509650e-16
const testcase_ellint_3<double>
data081[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17454173353063659, -0.099999999999999978, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34913506721468091, -0.099999999999999978, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52382550016538942, -0.099999999999999978, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.69864700854177020, -0.099999999999999978, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.87361792586964870, -0.099999999999999978, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0487386319621683, -0.099999999999999978, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2239913752078757, -0.099999999999999978, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.3993423113684049, -0.099999999999999978, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.5747455615173562, -0.099999999999999978, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler081 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3097339877269682e-16
const testcase_ellint_3<double>
data082[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17436589347616613, -0.099999999999999978, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34776067871237359, -0.099999999999999978, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.51936064354727796, -0.099999999999999978, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.68860303749364349, -0.099999999999999978, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.85524561882332051, -0.099999999999999978, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0193708301908335, -0.099999999999999978, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1813474067123044, -0.099999999999999978, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3417670770424983, -0.099999999999999978, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5013711111199950, -0.099999999999999978, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler082 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.4399947764827574e-16
const testcase_ellint_3<double>
data083[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17419068786141340, -0.099999999999999978, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34640537686230133, -0.099999999999999978, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51502689171753946, -0.099999999999999978, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.67904147863672715, -0.099999999999999978, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.83811885126105179, -0.099999999999999978, 0.20000000000000001, 
	  0.87266462599716477 },
  { 0.99255278555742787, -0.099999999999999978, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1431260546194930, -0.099999999999999978, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.2909589656532101, -0.099999999999999978, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4373749386463430, -0.099999999999999978, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler083 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5650492137236872e-16
const testcase_ellint_3<double>
data084[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17401611261390104, -0.099999999999999978, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34506869507511773, -0.099999999999999978, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51081757604259859, -0.099999999999999978, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.66992297597712303, -0.099999999999999978, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82209722856174228, -0.099999999999999978, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.96792430487669590, -0.099999999999999978, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1085964108954092, -0.099999999999999978, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2456748370836999, -0.099999999999999978, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.3809159606704959, -0.099999999999999978, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler084 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.6854758534459740e-16
const testcase_ellint_3<double>
data085[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17384216369897931, -0.099999999999999978, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34375018311376787, -0.099999999999999978, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50672650758380455, -0.099999999999999978, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66121264213337616, -0.099999999999999978, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.80706202005774441, -0.099999999999999978, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.94519376138245870, -0.099999999999999978, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0771880300759584, -0.099999999999999978, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2049711557188272, -0.099999999999999978, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3306223265207477, -0.099999999999999978, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler085 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.8017534281650347e-16
const testcase_ellint_3<double>
data086[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17366883711936548, -0.099999999999999978, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34244940634881882, -0.099999999999999978, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50274793281634367, -0.099999999999999978, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65287941633275082, -0.099999999999999978, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79291198790315398, -0.099999999999999978, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.92412201537880323, -0.099999999999999978, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0484480076799372, -0.099999999999999978, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1681168130475206, -0.099999999999999978, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.2854480708580160, -0.099999999999999978, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler086 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.9142834151672032e-16
const testcase_ellint_3<double>
data087[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17349612891469013, -0.099999999999999978, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34116594505539444, -0.099999999999999978, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.49887649430466674, -0.099999999999999978, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64489553282165146, -0.099999999999999978, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.77956016553782437, -0.099999999999999978, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.90451074530096287, -0.099999999999999978, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0220113666961632, -0.099999999999999978, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1345351441065563, -0.099999999999999978, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2445798942989255, -0.099999999999999978, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler087 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.5172091551439012e-16
const testcase_ellint_3<double>
data088[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17332403516105047, -0.099999999999999978, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.33989939374896883, -0.099999999999999978, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49510719568614070, -0.099999999999999978, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.63723607776354974, -0.099999999999999978, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.76693133887935327, -0.099999999999999978, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.88619382078823805, -0.099999999999999978, 0.69999999999999996, 
	  1.0471975511965976 },
  { 0.99758012018676490, -0.099999999999999978, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1037642270814410, -0.099999999999999978, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2073745911083185, -0.099999999999999978, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler088 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1294144515772258e-16
const testcase_ellint_3<double>
data089[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17315255197057014, -0.099999999999999978, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33864936055747991, -0.099999999999999978, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49143537041117613, -0.099999999999999978, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.62987861760047492, -0.099999999999999978, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.75496005490917517, -0.099999999999999978, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.86903081862701881, -0.099999999999999978, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.97490814820725591, -0.099999999999999978, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0754290107171083, -0.099999999999999978, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1733158866987732, -0.099999999999999978, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler089 = 2.5000000000000020e-13;

// Test data for k=-0.099999999999999978, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2325599449457852e-16
const testcase_ellint_3<double>
data090[10] =
{
  { 0.0000000000000000, -0.099999999999999978, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17298167549096563, -0.099999999999999978, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33741546662741589, -0.099999999999999978, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48785665376856868, -0.099999999999999978, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62280288554518959, -0.099999999999999978, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74358903115455188, -0.099999999999999978, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.85290207679298335, -0.099999999999999978, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.95379006645397379, -0.099999999999999978, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0492213119872327, -0.099999999999999978, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1419839485283374, -0.099999999999999978, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler090 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.1203697876423452e-16
const testcase_ellint_3<double>
data091[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17453292519943292, 0.0000000000000000, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34906585039886584, 0.0000000000000000, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52359877559829870, 0.0000000000000000, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.69813170079773168, 0.0000000000000000, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.87266462599716477, 0.0000000000000000, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0471975511965974, 0.0000000000000000, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2217304763960304, 0.0000000000000000, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.3962634015954631, 0.0000000000000000, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.5707963267948966, 0.0000000000000000, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler091 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.10000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.1813975824747021e-16
const testcase_ellint_3<double>
data092[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17435710107516605, 0.0000000000000000, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34769194715329604, 0.0000000000000000, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.51913731575866107, 0.0000000000000000, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.68810051897078450, 0.0000000000000000, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.85432615661706823, 0.0000000000000000, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0179006647340794, 0.0000000000000000, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1792120640746322, 0.0000000000000000, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3388834245070498, 0.0000000000000000, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.4976955329233277, 0.0000000000000000, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler092 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.20000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.2402804784409065e-16
const testcase_ellint_3<double>
data093[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17418191132226074, 0.0000000000000000, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34633712256943405, 0.0000000000000000, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51480684302043700, 0.0000000000000000, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.67855102942481937, 0.0000000000000000, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.83723056090326253, 0.0000000000000000, 0.20000000000000001, 
	  0.87266462599716477 },
  { 0.99114645269578161, 0.0000000000000000, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1411014627915537, 0.0000000000000000, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.2882448138013969, 0.0000000000000000, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4339343023863691, 0.0000000000000000, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler093 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.29999999999999999.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.2972291118632678e-16
const testcase_ellint_3<double>
data094[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17400735186871724, 0.0000000000000000, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34500091027020219, 0.0000000000000000, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51060069523901530, 0.0000000000000000, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.66944393961375448, 0.0000000000000000, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82123776744538157, 0.0000000000000000, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.96657579245516501, 0.0000000000000000, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1066703663542414, 0.0000000000000000, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2431094251944901, 0.0000000000000000, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.3776795151134889, 0.0000000000000000, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler094 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.40000000000000002.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.3524218164111537e-16
const testcase_ellint_3<double>
data095[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17383341868035862, 0.0000000000000000, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34368286022299821, 0.0000000000000000, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50651268947499395, 0.0000000000000000, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66074441806097539, 0.0000000000000000, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.80622931670113474, 0.0000000000000000, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.94389791565435210, 0.0000000000000000, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0753503387899728, 0.0000000000000000, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2025374759127518, 0.0000000000000000, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3275651989026320, 0.0000000000000000, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler095 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.50000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.6090167266677240e-16
const testcase_ellint_3<double>
data096[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17366010776037044, 0.0000000000000000, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34238253799539309, 0.0000000000000000, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50253707775976397, 0.0000000000000000, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65242145347295766, 0.0000000000000000, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79210420018698058, 0.0000000000000000, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.92287437995632171, 0.0000000000000000, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0466900550798659, 0.0000000000000000, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1658007366618623, 0.0000000000000000, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.2825498301618641, 0.0000000000000000, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler096 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.59999999999999998.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.4581288258006758e-16
const testcase_ellint_3<double>
data097[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17348741514884700, 0.0000000000000000, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34109952405241289, 0.0000000000000000, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.49866850781226285, 0.0000000000000000, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64444732407062499, 0.0000000000000000, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.77877564686544720, 0.0000000000000000, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.90330743691883475, 0.0000000000000000, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0203257987604104, 0.0000000000000000, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1323247918768629, 0.0000000000000000, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2418235332245127, 0.0000000000000000, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler097 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.69999999999999996.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 2.5088894797856263e-16
const testcase_ellint_3<double>
data098[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17331533692234474, 0.0000000000000000, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.33983341309265935, 0.0000000000000000, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49490198805931979, 0.0000000000000000, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.63679715525145297, 0.0000000000000000, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.76616861049481944, 0.0000000000000000, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.88503143209004198, 0.0000000000000000, 0.69999999999999996, 
	  1.0471975511965976 },
  { 0.99596060249112173, 0.0000000000000000, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1016495050260424, 0.0000000000000000, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2047457872617382, 0.0000000000000000, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler098 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.80000000000000004.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.8375904358197891e-16
const testcase_ellint_3<double>
data099[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17314386919344210, 0.0000000000000000, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33858381342073240, 0.0000000000000000, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49123285640844727, 0.0000000000000000, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.62944854858904509, 0.0000000000000000, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.75421778305499343, 0.0000000000000000, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.86790634112156617, 0.0000000000000000, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.97334918087427558, 0.0000000000000000, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0734012615283985, 0.0000000000000000, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1708024551734544, 0.0000000000000000, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler099 = 2.5000000000000020e-13;

// Test data for k=0.0000000000000000, nu=0.90000000000000002.
// max(|f - f_GSL|): 1.1102230246251565e-16
// max(|f - f_GSL| / |f_GSL|): 1.7838310376154469e-16
const testcase_ellint_3<double>
data100[10] =
{
  { 0.0000000000000000, 0.0000000000000000, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17297300811030597, 0.0000000000000000, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33735034635360817, 0.0000000000000000, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48765675230233130, 0.0000000000000000, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62238126886123568, 0.0000000000000000, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74286600807269243, 0.0000000000000000, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.85181283909264949, 0.0000000000000000, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.95228683995371133, 0.0000000000000000, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0472730487412552, 0.0000000000000000, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1395754288497419, 0.0000000000000000, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler100 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.1735566504509650e-16
const testcase_ellint_3<double>
data101[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17454173353063659, 0.10000000000000009, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34913506721468091, 0.10000000000000009, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52382550016538942, 0.10000000000000009, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.69864700854177020, 0.10000000000000009, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.87361792586964870, 0.10000000000000009, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0487386319621683, 0.10000000000000009, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2239913752078757, 0.10000000000000009, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.3993423113684049, 0.10000000000000009, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.5747455615173562, 0.10000000000000009, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler101 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3097339877269682e-16
const testcase_ellint_3<double>
data102[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17436589347616613, 0.10000000000000009, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34776067871237359, 0.10000000000000009, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.51936064354727796, 0.10000000000000009, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.68860303749364349, 0.10000000000000009, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.85524561882332051, 0.10000000000000009, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0193708301908335, 0.10000000000000009, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1813474067123044, 0.10000000000000009, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3417670770424983, 0.10000000000000009, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5013711111199950, 0.10000000000000009, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler102 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.4399947764827574e-16
const testcase_ellint_3<double>
data103[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17419068786141340, 0.10000000000000009, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34640537686230133, 0.10000000000000009, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51502689171753946, 0.10000000000000009, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.67904147863672715, 0.10000000000000009, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.83811885126105179, 0.10000000000000009, 0.20000000000000001, 
	  0.87266462599716477 },
  { 0.99255278555742787, 0.10000000000000009, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1431260546194930, 0.10000000000000009, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.2909589656532101, 0.10000000000000009, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4373749386463430, 0.10000000000000009, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler103 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5650492137236872e-16
const testcase_ellint_3<double>
data104[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17401611261390104, 0.10000000000000009, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34506869507511773, 0.10000000000000009, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51081757604259859, 0.10000000000000009, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.66992297597712303, 0.10000000000000009, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82209722856174228, 0.10000000000000009, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.96792430487669590, 0.10000000000000009, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1085964108954092, 0.10000000000000009, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2456748370836999, 0.10000000000000009, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.3809159606704959, 0.10000000000000009, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler104 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.6854758534459740e-16
const testcase_ellint_3<double>
data105[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17384216369897931, 0.10000000000000009, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34375018311376787, 0.10000000000000009, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50672650758380455, 0.10000000000000009, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66121264213337616, 0.10000000000000009, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.80706202005774441, 0.10000000000000009, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.94519376138245870, 0.10000000000000009, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0771880300759584, 0.10000000000000009, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2049711557188272, 0.10000000000000009, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3306223265207477, 0.10000000000000009, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler105 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.8017534281650347e-16
const testcase_ellint_3<double>
data106[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17366883711936548, 0.10000000000000009, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34244940634881882, 0.10000000000000009, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50274793281634367, 0.10000000000000009, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65287941633275082, 0.10000000000000009, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79291198790315398, 0.10000000000000009, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.92412201537880323, 0.10000000000000009, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0484480076799372, 0.10000000000000009, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1681168130475206, 0.10000000000000009, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.2854480708580160, 0.10000000000000009, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler106 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.9142834151672032e-16
const testcase_ellint_3<double>
data107[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17349612891469013, 0.10000000000000009, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34116594505539444, 0.10000000000000009, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.49887649430466674, 0.10000000000000009, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64489553282165146, 0.10000000000000009, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.77956016553782437, 0.10000000000000009, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.90451074530096287, 0.10000000000000009, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0220113666961632, 0.10000000000000009, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1345351441065563, 0.10000000000000009, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2445798942989255, 0.10000000000000009, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler107 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.5172091551439012e-16
const testcase_ellint_3<double>
data108[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17332403516105047, 0.10000000000000009, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.33989939374896883, 0.10000000000000009, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49510719568614070, 0.10000000000000009, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.63723607776354974, 0.10000000000000009, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.76693133887935327, 0.10000000000000009, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.88619382078823805, 0.10000000000000009, 0.69999999999999996, 
	  1.0471975511965976 },
  { 0.99758012018676490, 0.10000000000000009, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1037642270814410, 0.10000000000000009, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2073745911083185, 0.10000000000000009, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler108 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1294144515772258e-16
const testcase_ellint_3<double>
data109[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17315255197057014, 0.10000000000000009, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33864936055747991, 0.10000000000000009, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49143537041117613, 0.10000000000000009, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.62987861760047492, 0.10000000000000009, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.75496005490917517, 0.10000000000000009, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.86903081862701881, 0.10000000000000009, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.97490814820725591, 0.10000000000000009, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0754290107171083, 0.10000000000000009, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1733158866987732, 0.10000000000000009, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler109 = 2.5000000000000020e-13;

// Test data for k=0.10000000000000009, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2325599449457852e-16
const testcase_ellint_3<double>
data110[10] =
{
  { 0.0000000000000000, 0.10000000000000009, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17298167549096563, 0.10000000000000009, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33741546662741589, 0.10000000000000009, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48785665376856868, 0.10000000000000009, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62280288554518959, 0.10000000000000009, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74358903115455188, 0.10000000000000009, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.85290207679298335, 0.10000000000000009, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.95379006645397379, 0.10000000000000009, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0492213119872327, 0.10000000000000009, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1419839485283374, 0.10000000000000009, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler110 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2156475739151676e-16
const testcase_ellint_3<double>
data111[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17456817290292809, 0.19999999999999996, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34934315932086801, 0.19999999999999996, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52450880529443988, 0.19999999999999996, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70020491009844876, 0.19999999999999996, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.87651006649967955, 0.19999999999999996, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0534305870298994, 0.19999999999999996, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2308975521670784, 0.19999999999999996, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4087733584990738, 0.19999999999999996, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.5868678474541660, 0.19999999999999996, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler111 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3374593253183472e-16
const testcase_ellint_3<double>
data112[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17439228502691748, 0.19999999999999996, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34796731137565740, 0.19999999999999996, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52003370294544848, 0.19999999999999996, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69012222258631462, 0.19999999999999996, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.85803491465566772, 0.19999999999999996, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0238463961099364, 0.19999999999999996, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1878691059202153, 0.19999999999999996, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3505985031831940, 0.19999999999999996, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5126513474261087, 0.19999999999999996, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler112 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.4549984059502760e-16
const testcase_ellint_3<double>
data113[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17421703179583747, 0.19999999999999996, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34661057411998791, 0.19999999999999996, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51569006052647393, 0.19999999999999996, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68052412821107244, 0.19999999999999996, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.84081341263313825, 0.19999999999999996, 0.20000000000000001, 
	  0.87266462599716477 },
  { 0.99683359988842890, 0.19999999999999996, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1493086715118852, 0.19999999999999996, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.2992699693957541, 0.19999999999999996, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4479323932249564, 0.19999999999999996, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler113 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.29999999999999999.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.3140668101543467e-16
const testcase_ellint_3<double>
data114[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17404240913577704, 0.19999999999999996, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34527248032587193, 0.19999999999999996, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51147118981668416, 0.19999999999999996, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67137107867777601, 0.19999999999999996, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82470418188668893, 0.19999999999999996, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.97202873223594299, 0.19999999999999996, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1144773569375266, 0.19999999999999996, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2535292433701000, 0.19999999999999996, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.3908453514752477, 0.19999999999999996, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler114 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.6788709752760483e-16
const testcase_ellint_3<double>
data115[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17386841301066674, 0.19999999999999996, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34395257914113253, 0.19999999999999996, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50737088376869466, 0.19999999999999996, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66262801717277631, 0.19999999999999996, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.80958766645079094, 0.19999999999999996, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.94913754236162040, 0.19999999999999996, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0827985514222997, 0.19999999999999996, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2124212429050478, 0.19999999999999996, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3400002519661005, 0.19999999999999996, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler115 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.7788201301356829e-16
const testcase_ellint_3<double>
data116[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17369503942181799, 0.19999999999999996, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34265043534362660, 0.19999999999999996, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50338337208655415, 0.19999999999999996, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65426373297163609, 0.19999999999999996, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79536193036145808, 0.19999999999999996, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.92791875910061605, 0.19999999999999996, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0538145052725829, 0.19999999999999996, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1752060022875899, 0.19999999999999996, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.2943374404397372, 0.19999999999999996, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler116 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.8899223779598256e-16
const testcase_ellint_3<double>
data117[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17352228440746925, 0.19999999999999996, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34136562863713626, 0.19999999999999996, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.49950328177638481, 0.19999999999999996, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64625032705690799, 0.19999999999999996, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.78193941198403083, 0.19999999999999996, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.90817230934317128, 0.19999999999999996, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0271563751276462, 0.19999999999999996, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1412999379040518, 0.19999999999999996, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2530330675914556, 0.19999999999999996, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler117 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.69999999999999996.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 5.9999318361775115e-16
const testcase_ellint_3<double>
data118[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17335014404233895, 0.19999999999999996, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34009775298617811, 0.19999999999999996, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49572560201923810, 0.19999999999999996, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.63856276669886503, 0.19999999999999996, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.76924438644867565, 0.19999999999999996, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.88973060843856466, 0.19999999999999996, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0025230471636377, 0.19999999999999996, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1102356376093103, 0.19999999999999996, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2154356555075863, 0.19999999999999996, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler118 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 5.0901276230707249e-16
const testcase_ellint_3<double>
data119[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17317861443718538, 0.19999999999999996, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33884641598718701, 0.19999999999999996, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49204565281259494, 0.19999999999999996, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63117851188220320, 0.19999999999999996, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.75721095949544170, 0.19999999999999996, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.87245201443919118, 0.19999999999999996, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.97966584238831089, 0.19999999999999996, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0816336325174360, 0.19999999999999996, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1810223448909909, 0.19999999999999996, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler119 = 2.5000000000000020e-13;

// Test data for k=0.19999999999999996, nu=0.90000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 6.4833128442756722e-16
const testcase_ellint_3<double>
data120[10] =
{
  { 0.0000000000000000, 0.19999999999999996, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17300769173837277, 0.19999999999999996, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33761123827372508, 0.19999999999999996, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48845905690769426, 0.19999999999999996, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62407720017324952, 0.19999999999999996, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74578146525124289, 0.19999999999999996, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.85621583540073076, 0.19999999999999996, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.95837725988001199, 0.19999999999999996, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0551821412633928, 0.19999999999999996, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1493679916141861, 0.19999999999999996, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler120 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3361874537309281e-16
const testcase_ellint_3<double>
data121[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17461228653000099, 0.30000000000000004, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.34969146102798415, 0.30000000000000004, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52565822873726320, 0.30000000000000004, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70284226512408532, 0.30000000000000004, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.88144139195111182, 0.30000000000000004, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0614897067260520, 0.30000000000000004, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2428416824174218, 0.30000000000000004, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4251795877015927, 0.30000000000000004, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6080486199305128, 0.30000000000000004, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler121 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.10000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.3908043711907203e-16
const testcase_ellint_3<double>
data122[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17443631884814376, 0.30000000000000004, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34831316835124926, 0.30000000000000004, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52116586276523857, 0.30000000000000004, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69269385837910036, 0.30000000000000004, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.86279023163070856, 0.30000000000000004, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0315321461438263, 0.30000000000000004, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.1991449111869024, 0.30000000000000004, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3659561780923213, 0.30000000000000004, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5323534693557528, 0.30000000000000004, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler122 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.20000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.4447238179454079e-16
const testcase_ellint_3<double>
data123[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17426098615372088, 0.30000000000000004, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34695402664689923, 0.30000000000000004, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51680555567038933, 0.30000000000000004, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68303375225260210, 0.30000000000000004, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.84540662891295026, 0.30000000000000004, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0041834051646927, 0.30000000000000004, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1599952702345711, 0.30000000000000004, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3137179520499165, 0.30000000000000004, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4663658145259877, 0.30000000000000004, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler123 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.29999999999999999.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.4979715256503266e-16
const testcase_ellint_3<double>
data124[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17408628437042842, 0.30000000000000004, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34561356761638401, 0.30000000000000004, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51257058617875850, 0.30000000000000004, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67382207124602878, 0.30000000000000004, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.82914751587825131, 0.30000000000000004, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.97907434814374938, 0.30000000000000004, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1246399297351584, 0.30000000000000004, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2671793970398149, 0.30000000000000004, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4081767433479091, 0.30000000000000004, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler124 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.40000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.5505716921759864e-16
const testcase_ellint_3<double>
data125[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17391220945982727, 0.30000000000000004, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34429133937639689, 0.30000000000000004, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50845471668581632, 0.30000000000000004, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66502347027873854, 0.30000000000000004, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.81389191978012254, 0.30000000000000004, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.95590618002140570, 0.30000000000000004, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.0924915195213121, 0.30000000000000004, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2253651604038061, 0.30000000000000004, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3563643538969763, 0.30000000000000004, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler125 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.50000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.7807908859023716e-16
const testcase_ellint_3<double>
data126[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17373875742088232, 0.30000000000000004, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34298690571124157, 0.30000000000000004, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50445214859646936, 0.30000000000000004, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65660648352418516, 0.30000000000000004, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.79953670639287289, 0.30000000000000004, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.93443393926588536, 0.30000000000000004, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0630838369016911, 0.30000000000000004, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.1875197325653029, 0.30000000000000004, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3098448759814962, 0.30000000000000004, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler126 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.59999999999999998.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.0057999499931649e-16
const testcase_ellint_3<double>
data127[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17356592428950823, 0.30000000000000004, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34169984536697379, 0.30000000000000004, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50055748266498457, 0.30000000000000004, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.64854298527106768, 0.30000000000000004, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.78599329284207431, 0.30000000000000004, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.91445452089128199, 0.30000000000000004, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0360412952290587, 0.30000000000000004, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1530473919778641, 0.30000000000000004, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2677758800420669, 0.30000000000000004, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler127 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.69999999999999996.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.2239502844122443e-16
const testcase_ellint_3<double>
data128[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17339370613812224, 0.30000000000000004, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34042975138455933, 0.30000000000000004, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49676568368075985, 0.30000000000000004, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64080774055753720, 0.30000000000000004, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.77318507779667278, 0.30000000000000004, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.89579782346548609, 0.30000000000000004, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0110573286052202, 0.30000000000000004, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1214710972949635, 0.30000000000000004, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2294913236274982, 0.30000000000000004, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler128 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.80000000000000004.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.4358357000101250e-16
const testcase_ellint_3<double>
data129[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17322209907520358, 0.30000000000000004, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33917623046949996, 0.30000000000000004, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49307204894329176, 0.30000000000000004, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63337802830291734, 0.30000000000000004, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.76104540997689407, 0.30000000000000004, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.87832009635450714, 0.30000000000000004, 0.80000000000000004, 
	  1.0471975511965976 },
  { 0.98787879723171790, 0.30000000000000004, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.0924036340069339, 0.30000000000000004, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.1944567571590048, 0.30000000000000004, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler129 = 2.5000000000000020e-13;

// Test data for k=0.30000000000000004, nu=0.90000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.6419688299804087e-16
const testcase_ellint_3<double>
data130[10] =
{
  { 0.0000000000000000, 0.30000000000000004, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17305109924485945, 0.30000000000000004, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33793890239556984, 0.30000000000000004, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.48947218005089738, 0.30000000000000004, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62623332340775151, 0.30000000000000004, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.74951596581511148, 0.30000000000000004, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.86189886597755994, 0.30000000000000004, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.96629451153092005, 0.30000000000000004, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0655269133492682, 0.30000000000000004, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1622376896064914, 0.30000000000000004, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler130 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 5.4157225142938039e-16
const testcase_ellint_3<double>
data131[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17467414669441528, 0.39999999999999991, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35018222772483443, 0.39999999999999991, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52729015917508737, 0.39999999999999991, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.70662374407341244, 0.39999999999999991, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.88859210497602170, 0.39999999999999991, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0733136290471379, 0.39999999999999991, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2605612170157061, 0.39999999999999991, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4497513956433439, 0.39999999999999991, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6399998658645112, 0.39999999999999991, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler131 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.10000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 5.6859551010103832e-16
const testcase_ellint_3<double>
data132[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17449806706684670, 0.39999999999999991, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34880048623856075, 0.39999999999999991, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52277322065757392, 0.39999999999999991, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.69638072056918365, 0.39999999999999991, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.86968426619831540, 0.39999999999999991, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0428044206578095, 0.39999999999999991, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2158651158274378, 0.39999999999999991, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.3889447129893324, 0.39999999999999991, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.5620566886683604, 0.39999999999999991, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler132 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.20000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 5.9444065952225719e-16
const testcase_ellint_3<double>
data133[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17432262290723397, 0.39999999999999991, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34743795258968596, 0.39999999999999991, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.51838919472805112, 0.39999999999999991, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.68663134739057907, 0.39999999999999991, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.85206432981833979, 0.39999999999999991, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0149595349004430, 0.39999999999999991, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1758349405464676, 0.39999999999999991, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3353337673882637, 0.39999999999999991, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.4941414344266770, 0.39999999999999991, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler133 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.29999999999999999.
// max(|f - f_GSL|): 1.1102230246251565e-15
// max(|f - f_GSL| / |f_GSL|): 7.7406350888907249e-16
const testcase_ellint_3<double>
data134[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17414781013591540, 0.39999999999999991, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34609415696777285, 0.39999999999999991, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51413131295862535, 0.39999999999999991, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.67733527622935630, 0.39999999999999991, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.83558675182733266, 0.39999999999999991, 0.29999999999999999, 
	  0.87266462599716477 },
  { 0.98940140808865906, 0.39999999999999991, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1396968797728058, 0.39999999999999991, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.2875920037865090, 0.39999999999999991, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4342789859950078, 0.39999999999999991, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler134 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.40000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.4314214811441816e-16
const testcase_ellint_3<double>
data135[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17397362471112707, 0.39999999999999991, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34476864603333196, 0.39999999999999991, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.50999329415379346, 0.39999999999999991, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.66845674551396006, 0.39999999999999991, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.82012848346231748, 0.39999999999999991, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.96582449258349057, 0.39999999999999991, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1068473749476286, 0.39999999999999991, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2447132729159989, 0.39999999999999991, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.3809986210732901, 0.39999999999999991, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler135 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.50000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.6621057007519435e-16
const testcase_ellint_3<double>
data136[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17380006262854136, 0.39999999999999991, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34346098216756610, 0.39999999999999991, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50596929935059420, 0.39999999999999991, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.65996392089131251, 0.39999999999999991, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.80558463511364786, 0.39999999999999991, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.94397834522857704, 0.39999999999999991, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0768075114108115, 0.39999999999999991, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2059184624251333, 0.39999999999999991, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3331797176377398, 0.39999999999999991, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler136 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.59999999999999998.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 6.8853630717730749e-16
const testcase_ellint_3<double>
data137[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17362711992081245, 0.39999999999999991, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34217074276403953, 0.39999999999999991, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50205389185761606, 0.39999999999999991, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.65182834920372734, 0.39999999999999991, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.79186512820565136, 0.39999999999999991, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.92365535916287134, 0.39999999999999991, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0491915663957907, 0.39999999999999991, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1705934291745106, 0.39999999999999991, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.2899514672527024, 0.39999999999999991, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler137 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.69999999999999996.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.1018730557776469e-16
const testcase_ellint_3<double>
data138[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17345479265712868, 0.39999999999999991, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34089751955950354, 0.39999999999999991, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.49824200167361332, 0.39999999999999991, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64402450341199402, 0.39999999999999991, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.77889207804122873, 0.39999999999999991, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.90468169720957992, 0.39999999999999991, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0236847823692916, 0.39999999999999991, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1382465247425166, 0.39999999999999991, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2506255923253344, 0.39999999999999991, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler138 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.80000000000000004.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.3122171115555478e-16
const testcase_ellint_3<double>
data139[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17328307694277154, 0.39999999999999991, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.33964091800132007, 0.39999999999999991, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49452889372467440, 0.39999999999999991, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.63652940095937316, 0.39999999999999991, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.76659772511159097, 0.39999999999999991, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.88691047977338111, 0.39999999999999991, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0000273200611638, 0.39999999999999991, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1084787902188009, 0.39999999999999991, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2146499565727209, 0.39999999999999991, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler139 = 2.5000000000000020e-13;

// Test data for k=0.39999999999999991, nu=0.90000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 7.5168974431077345e-16
const testcase_ellint_3<double>
data140[10] =
{
  { 0.0000000000000000, 0.39999999999999991, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17311196891868127, 0.39999999999999991, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33840055664911906, 0.39999999999999991, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49091013944075329, 0.39999999999999991, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.62932228186809580, 0.39999999999999991, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.75492278323019801, 0.39999999999999991, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.87021659043854294, 0.39999999999999991, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.97800245228239246, 0.39999999999999991, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.0809625773173697, 0.39999999999999991, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.1815758115929846, 0.39999999999999991, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler140 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.0000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1201497220602069e-16
const testcase_ellint_3<double>
data141[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17475385514035785, 0.50000000000000000, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35081868470101585, 0.50000000000000000, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.52942862705190574, 0.50000000000000000, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.71164727562630314, 0.50000000000000000, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.89824523594227768, 0.50000000000000000, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.0895506700518851, 0.50000000000000000, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.2853005857432931, 0.50000000000000000, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.4845545520549484, 0.50000000000000000, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.6857503548125963, 0.50000000000000000, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler141 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.10000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.1662857256911530e-16
const testcase_ellint_3<double>
data142[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17457763120814676, 0.50000000000000000, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.34943246340849154, 0.50000000000000000, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52487937869610790, 0.50000000000000000, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.70127785096388384, 0.50000000000000000, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.87898815988624479, 0.50000000000000000, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0582764576094172, 0.50000000000000000, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2391936844060205, 0.50000000000000000, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.4214793542995841, 0.50000000000000000, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.6045524936084892, 0.50000000000000000, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler142 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.20000000000000001.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2114786773102175e-16
const testcase_ellint_3<double>
data143[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17440204336345433, 0.50000000000000000, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34806552388338824, 0.50000000000000000, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52046416757129810, 0.50000000000000000, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.69140924550993865, 0.50000000000000000, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.86104678636125520, 0.50000000000000000, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0297439459053981, 0.50000000000000000, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.1979214112912033, 0.50000000000000000, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.3659033858648930, 0.50000000000000000, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.5338490483665983, 0.50000000000000000, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler143 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.29999999999999999.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2557837230041312e-16
const testcase_ellint_3<double>
data144[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17422708752228896, 0.50000000000000000, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34671739434855858, 0.50000000000000000, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51617616305641878, 0.50000000000000000, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.68200047612545167, 0.50000000000000000, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.84427217869498372, 0.50000000000000000, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0035637821389782, 0.50000000000000000, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1606800483933111, 0.50000000000000000, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.3164407134643459, 0.50000000000000000, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.4715681939859637, 0.50000000000000000, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler144 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.40000000000000002.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.2992508582900068e-16
const testcase_ellint_3<double>
data145[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17405275963859917, 0.50000000000000000, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34538761957029329, 0.50000000000000000, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51200902646603907, 0.50000000000000000, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.67301522212868792, 0.50000000000000000, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.82853844466313320, 0.50000000000000000, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.97942097862681488, 0.50000000000000000, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1268429801220614, 0.50000000000000000, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.2720406704533922, 0.50000000000000000, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.4161679518465340, 0.50000000000000000, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler145 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.50000000000000000.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.3419255755184137e-16
const testcase_ellint_3<double>
data146[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17387905570381157, 0.50000000000000000, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34407576010465207, 0.50000000000000000, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.50795686560160824, 0.50000000000000000, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.66442115453330164, 0.50000000000000000, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.81373829119355345, 0.50000000000000000, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.95705743313235825, 0.50000000000000000, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.0959131991362554, 0.50000000000000000, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2318900529754597, 0.50000000000000000, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.3664739530045971, 0.50000000000000000, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler146 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.59999999999999998.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.3838494104749599e-16
const testcase_ellint_3<double>
data147[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17370597174637581, 0.50000000000000000, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34278139158591414, 0.50000000000000000, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50401419439302708, 0.50000000000000000, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.65618938076167210, 0.50000000000000000, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.79977959248855424, 0.50000000000000000, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.93625925190753545, 0.50000000000000000, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0674905658379708, 0.50000000000000000, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.1953481298023050, 0.50000000000000000, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.3215740290190876, 0.50000000000000000, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler147 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.69999999999999996.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 3.4250604066951477e-16
const testcase_ellint_3<double>
data148[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17353350383131641, 0.50000000000000000, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34150410405436771, 0.50000000000000000, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50017589696443487, 0.50000000000000000, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.64829398188419951, 0.50000000000000000, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.78658270782402073, 0.50000000000000000, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.91684738336675053, 0.50000000000000000, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0412486789555935, 0.50000000000000000, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1619021847612001, 0.50000000000000000, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.2807475181182502, 0.50000000000000000, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler148 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5715240651179632e-16
const testcase_ellint_3<double>
data149[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17336164805979126, 0.50000000000000000, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34024350132086773, 0.50000000000000000, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49643719555734073, 0.50000000000000000, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.64071162456976150, 0.50000000000000000, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.77407836177211908, 0.50000000000000000, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.89867058251905652, 0.50000000000000000, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0169181822134910, 0.50000000000000000, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1311363312779448, 0.50000000000000000, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2434165408189539, 0.50000000000000000, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler149 = 2.5000000000000020e-13;

// Test data for k=0.50000000000000000, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.4664649039489274e-16
const testcase_ellint_3<double>
data150[10] =
{
  { 0.0000000000000000, 0.50000000000000000, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17319040056865681, 0.50000000000000000, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33899920036578557, 0.50000000000000000, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49279362182695174, 0.50000000000000000, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.63342123379746151, 0.50000000000000000, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.76220595179550321, 0.50000000000000000, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.88160004743532294, 0.50000000000000000, 0.90000000000000002, 
	  1.0471975511965976 },
  { 0.99427448642310123, 0.50000000000000000, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1027091512470095, 0.50000000000000000, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.2091116095504744, 0.50000000000000000, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler150 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3664899092028927e-16
const testcase_ellint_3<double>
data151[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17485154362988359, 0.60000000000000009, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35160509865544326, 0.60000000000000009, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53210652578446138, 0.60000000000000009, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.71805304664485659, 0.60000000000000009, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.91082759030195970, 0.60000000000000009, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1112333229323361, 0.60000000000000009, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.3191461190365270, 0.60000000000000009, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.5332022105084775, 0.60000000000000009, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.7507538029157526, 0.60000000000000009, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler151 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.4937942733669112e-16
const testcase_ellint_3<double>
data152[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17467514275022011, 0.60000000000000009, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35021333086258255, 0.60000000000000009, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.52751664092962691, 0.60000000000000009, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.70752126971957874, 0.60000000000000009, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.89111058756112871, 0.60000000000000009, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.0789241202877768, 0.60000000000000009, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.2710800210399946, 0.60000000000000009, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.4669060574440276, 0.60000000000000009, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.6648615773343014, 0.60000000000000009, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler152 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.20000000000000001.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.1891472451898755e-16
const testcase_ellint_3<double>
data153[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17449937871800650, 0.60000000000000009, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34884093647346553, 0.60000000000000009, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52306221119844087, 0.60000000000000009, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.69749955678982223, 0.60000000000000009, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.87274610682416853, 0.60000000000000009, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0494620540750792, 0.60000000000000009, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.2280847305507339, 0.60000000000000009, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.4085436279696888, 0.60000000000000009, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.5901418016279374, 0.60000000000000009, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler153 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.7339932380431439e-16
const testcase_ellint_3<double>
data154[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17432424744393932, 0.60000000000000009, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34748744127146447, 0.60000000000000009, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.51873632743924825, 0.60000000000000009, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.68794610396313116, 0.60000000000000009, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.85558070175468726, 0.60000000000000009, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0224416343605653, 0.60000000000000009, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.1893144457936788, 0.60000000000000009, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.3566435377982575, 0.60000000000000009, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.5243814243493585, 0.60000000000000009, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler154 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.40000000000000002.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.5440898085101625e-16
const testcase_ellint_3<double>
data155[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17414974487670717, 0.60000000000000009, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34615238767335027, 0.60000000000000009, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51453257838108557, 0.60000000000000009, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.67882386787534399, 0.60000000000000009, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.83948470233173578, 0.60000000000000009, 0.40000000000000002, 
	  0.87266462599716477 },
  { 0.99753496200073977, 0.60000000000000009, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1541101404388487, 0.60000000000000009, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.3100911323398816, 0.60000000000000009, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.4659345278069984, 0.60000000000000009, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler155 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.50000000000000000.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 4.7124937590522226e-16
const testcase_ellint_3<double>
data156[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17397586700252807, 0.60000000000000009, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34483533397138516, 0.60000000000000009, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51044500461706477, 0.60000000000000009, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.67009988034712664, 0.60000000000000009, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.82434762375735193, 0.60000000000000009, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.97447346702798998, 0.60000000000000009, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.1219494000522143, 0.60000000000000009, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.2680242605954486, 0.60000000000000009, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.4135484285693078, 0.60000000000000009, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler156 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.0652177678695900e-16
const testcase_ellint_3<double>
data157[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17380260984469353, 0.60000000000000009, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34353585361777839, 0.60000000000000009, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50646805774321380, 0.60000000000000009, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.66174468108625506, 0.60000000000000009, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.81007462280278408, 0.60000000000000009, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.95303466945718729, 0.60000000000000009, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.0924118588677505, 0.60000000000000009, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.2297640574847937, 0.60000000000000009, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.3662507535812816, 0.60000000000000009, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler157 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.69999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1692457486457856e-16
const testcase_ellint_3<double>
data158[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17362996946312007, 0.60000000000000009, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34225353454870588, 0.60000000000000009, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50259656397799524, 0.60000000000000009, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.65373184496628933, 0.60000000000000009, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.79658372884056439, 0.60000000000000009, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.93303240100245421, 0.60000000000000009, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0651547944716557, 0.60000000000000009, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.1947676204853441, 0.60000000000000009, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.3232737468822813, 0.60000000000000009, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler158 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2705175719241326e-16
const testcase_ellint_3<double>
data159[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17345794195390685, 0.60000000000000009, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34098797854531027, 0.60000000000000009, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.49882569168826213, 0.60000000000000009, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.64603758566475511, 0.60000000000000009, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.78380365594769730, 0.60000000000000009, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.91430946255611190, 0.60000000000000009, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0398955217270607, 0.60000000000000009, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.1625948314277679, 0.60000000000000009, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.2840021261752192, 0.60000000000000009, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler159 = 2.5000000000000020e-13;

// Test data for k=0.60000000000000009, nu=0.90000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.5585887739668036e-16
const testcase_ellint_3<double>
data160[10] =
{
  { 0.0000000000000000, 0.60000000000000009, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17328652344890030, 0.60000000000000009, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.33973880062929018, 0.60000000000000009, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49515092233122743, 0.60000000000000009, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.63864042139737043, 0.60000000000000009, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.77167205646538850, 0.60000000000000009, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.89673202848034383, 0.60000000000000009, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0163984492661304, 0.60000000000000009, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1328845785162431, 0.60000000000000009, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.2479362973851873, 0.60000000000000009, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler160 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.0000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.5930208052157665e-16
const testcase_ellint_3<double>
data161[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17496737466916723, 0.69999999999999996, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35254687535677925, 0.69999999999999996, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53536740275997119, 0.69999999999999996, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.72603797651684454, 0.69999999999999996, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.92698296348313458, 0.69999999999999996, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1400447527693316, 0.69999999999999996, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.3657668117194073, 0.69999999999999996, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.6024686895959159, 0.69999999999999996, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.8456939983747236, 0.69999999999999996, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler161 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.10000000000000001.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.6735282577377367e-16
const testcase_ellint_3<double>
data162[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17479076384884684, 0.69999999999999996, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35114844900396364, 0.69999999999999996, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53072776947527001, 0.69999999999999996, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.71530198262386235, 0.69999999999999996, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.90666760677828306, 0.69999999999999996, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1063366517438080, 0.69999999999999996, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.3149477243092149, 0.69999999999999996, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.5314886725038925, 0.69999999999999996, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.7528050171757608, 0.69999999999999996, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler162 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.20000000000000001.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.7517969287516802e-16
const testcase_ellint_3<double>
data163[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17461479077791475, 0.69999999999999996, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.34976950621407538, 0.69999999999999996, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.52622533231350177, 0.69999999999999996, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.70508774017895215, 0.69999999999999996, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.88775302531730294, 0.69999999999999996, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.0756195476149006, 0.69999999999999996, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.2695349716654374, 0.69999999999999996, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.4690814617070540, 0.69999999999999996, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.6721098780092145, 0.69999999999999996, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler163 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.8280039841080712e-16
const testcase_ellint_3<double>
data164[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17443945136076175, 0.69999999999999996, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34840956983535287, 0.69999999999999996, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52185308551329168, 0.69999999999999996, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.69535240431168255, 0.69999999999999996, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.87007983473964923, 0.69999999999999996, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0474657975577066, 0.69999999999999996, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.2286225419931891, 0.69999999999999996, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.4136490671013271, 0.69999999999999996, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.6011813647733213, 0.69999999999999996, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler164 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3472957053482092e-16
const testcase_ellint_3<double>
data165[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17426474153983229, 0.69999999999999996, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34706817945773732, 0.69999999999999996, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.51760452851738148, 0.69999999999999996, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.68605801534722755, 0.69999999999999996, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.85351339387296532, 0.69999999999999996, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0215297967969539, 0.69999999999999996, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.1915051074460530, 0.69999999999999996, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.3639821911744707, 0.69999999999999996, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.5382162002954762, 0.69999999999999996, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler165 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.50000000000000000.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.9748346743390620e-16
const testcase_ellint_3<double>
data166[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17409065729516096, 0.69999999999999996, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34574489064986091, 0.69999999999999996, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51347361925579782, 0.69999999999999996, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.67717079489579279, 0.69999999999999996, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.83793902055292280, 0.69999999999999996, 0.50000000000000000, 
	  0.87266462599716477 },
  { 0.99752863545289705, 0.69999999999999996, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.1576240080401501, 0.69999999999999996, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.3191464023923762, 0.69999999999999996, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.4818433192178544, 0.69999999999999996, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler166 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.59999999999999998.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.0457157538295173e-16
const testcase_ellint_3<double>
data167[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17391719464391614, 0.69999999999999996, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34443927423869031, 0.69999999999999996, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.50945473266486063, 0.69999999999999996, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.66866056326513812, 0.69999999999999996, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.82325830002337352, 0.69999999999999996, 0.59999999999999998, 
	  0.87266462599716477 },
  { 0.97522808245669368, 0.69999999999999996, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.1265300613705285, 0.69999999999999996, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.2784066076152001, 0.69999999999999996, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.4309994736080540, 0.69999999999999996, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler167 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.69999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 5.4867405596732161e-16
const testcase_ellint_3<double>
data168[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17374434963995031, 0.69999999999999996, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34315091562900674, 0.69999999999999996, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50554262375653347, 0.69999999999999996, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.66050025406305801, 0.69999999999999996, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.80938620118847404, 0.69999999999999996, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.95443223855852144, 0.69999999999999996, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.0978573207128304, 0.69999999999999996, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.2411754575007123, 0.69999999999999996, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.3848459188329196, 0.69999999999999996, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler168 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1829502028913879e-16
const testcase_ellint_3<double>
data169[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17357211837335740, 0.69999999999999996, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34187941416012108, 0.69999999999999996, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50173239465478259, 0.69999999999999996, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.65266550725988315, 0.69999999999999996, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.79624879865249298, 0.69999999999999996, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.93497577043296920, 0.69999999999999996, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.0713041566930750, 0.69999999999999996, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.2069772023255654, 0.69999999999999996, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.3427110650397531, 0.69999999999999996, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler169 = 2.5000000000000020e-13;

// Test data for k=0.69999999999999996, nu=0.90000000000000002.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.2494869624129105e-16
const testcase_ellint_3<double>
data170[10] =
{
  { 0.0000000000000000, 0.69999999999999996, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17340049697003637, 0.69999999999999996, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34062438249741556, 0.69999999999999996, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.49801946510076867, 0.69999999999999996, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.64513432604750476, 0.69999999999999996, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.78378145487573758, 0.69999999999999996, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.91671799500854623, 0.69999999999999996, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0466193579463123, 0.69999999999999996, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.1754218079199146, 0.69999999999999996, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.3040500499695913, 0.69999999999999996, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler170 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.0000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1175183168766718e-16
const testcase_ellint_3<double>
data171[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17510154241338899, 0.80000000000000004, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35365068839779390, 0.80000000000000004, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.53926804409084550, 0.80000000000000004, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.73587926028070361, 0.80000000000000004, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.94770942970071170, 0.80000000000000004, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.1789022995388236, 0.80000000000000004, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.4323027881876009, 0.80000000000000004, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.7069629739121674, 0.80000000000000004, 0.0000000000000000, 
	  1.3962634015954636 },
  { 1.9953027776647296, 0.80000000000000004, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler171 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.10000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1537164503193145e-16
const testcase_ellint_3<double>
data172[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17492468824017163, 0.80000000000000004, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35224443521476911, 0.80000000000000004, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53456851853226950, 0.80000000000000004, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.72488875602364922, 0.80000000000000004, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.92661354274638952, 0.80000000000000004, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1432651144499075, 0.80000000000000004, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.3774479927211429, 0.80000000000000004, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.6287092337196041, 0.80000000000000004, 0.10000000000000001, 
	  1.3962634015954636 },
  { 1.8910755418379521, 0.80000000000000004, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler172 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.20000000000000001.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.1894552974436829e-16
const testcase_ellint_3<double>
data173[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17474847286224940, 0.80000000000000004, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.35085779529084682, 0.80000000000000004, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.53000829263059146, 0.80000000000000004, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.71443466027453384, 0.80000000000000004, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.90698196872715420, 0.80000000000000004, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.1108198200558579, 0.80000000000000004, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.3284988909963957, 0.80000000000000004, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.5600369318140328, 0.80000000000000004, 0.20000000000000001, 
	  1.3962634015954636 },
  { 1.8007226661734588, 0.80000000000000004, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler173 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.29999999999999999.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2247517409029886e-16
const testcase_ellint_3<double>
data174[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17457289217669889, 0.80000000000000004, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.34949028801501258, 0.80000000000000004, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52558024362769307, 0.80000000000000004, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.70447281740094891, 0.80000000000000004, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.88864745641528986, 0.80000000000000004, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.0811075819341462, 0.80000000000000004, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.2844589654082377, 0.80000000000000004, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.4991461361277847, 0.80000000000000004, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.7214611048717301, 0.80000000000000004, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler174 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.40000000000000002.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2596216594752862e-16
const testcase_ellint_3<double>
data175[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17439794211872175, 0.80000000000000004, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34814144964568972, 0.80000000000000004, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.52127776285273064, 0.80000000000000004, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.69496411438966588, 0.80000000000000004, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.87146878427509589, 0.80000000000000004, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0537579024937762, 0.80000000000000004, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.2445534387922637, 0.80000000000000004, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.4446769766361993, 0.80000000000000004, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.6512267838651289, 0.80000000000000004, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler175 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.50000000000000000.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.2940800093915668e-16
const testcase_ellint_3<double>
data176[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17422361866118044, 0.80000000000000004, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34681083254170475, 0.80000000000000004, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.51709470815494440, 0.80000000000000004, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.68587375344080237, 0.80000000000000004, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.85532571852810624, 0.80000000000000004, 0.50000000000000000, 
	  0.87266462599716477 },
  { 1.0284677391874903, 0.80000000000000004, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.2081693942686225, 0.80000000000000004, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.3955803006426311, 0.80000000000000004, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.5884528947755532, 0.80000000000000004, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler176 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.59999999999999998.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3281408974056389e-16
const testcase_ellint_3<double>
data177[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17404991781414089, 0.80000000000000004, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34549800443625167, 0.80000000000000004, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.51302536167001545, 0.80000000000000004, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.67717065003912236, 0.80000000000000004, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.84011512421134416, 0.80000000000000004, 0.59999999999999998, 
	  0.87266462599716477 },
  { 1.0049863847088740, 0.80000000000000004, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.1748145941898920, 0.80000000000000004, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.3510319699755071, 0.80000000000000004, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.5319262547427865, 0.80000000000000004, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler177 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.69999999999999996.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 4.3618176466061808e-16
const testcase_ellint_3<double>
data178[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17387683562442199, 0.80000000000000004, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34420254775101611, 0.80000000000000004, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.50906439222143673, 0.80000000000000004, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.66882693152688422, 0.80000000000000004, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.82574792844091316, 0.80000000000000004, 0.69999999999999996, 
	  0.87266462599716477 },
  { 0.98310431309490931, 0.80000000000000004, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.1440884535113258, 0.80000000000000004, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.3103743938952537, 0.80000000000000004, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.4806912324625332, 0.80000000000000004, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler178 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3951228558314112e-16
const testcase_ellint_3<double>
data179[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17370436817515203, 0.80000000000000004, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34292405894783395, 0.80000000000000004, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50520682176250076, 0.80000000000000004, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.66081751679736178, 0.80000000000000004, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.81214672249355102, 0.80000000000000004, 0.80000000000000004, 
	  0.87266462599716477 },
  { 0.96264481387685552, 0.80000000000000004, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.1156611352656258, 0.80000000000000004, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.2730756225143889, 0.80000000000000004, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.4339837018309471, 0.80000000000000004, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler179 = 2.5000000000000020e-13;

// Test data for k=0.80000000000000004, nu=0.90000000000000002.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 4.4280684534289690e-16
const testcase_ellint_3<double>
data180[10] =
{
  { 0.0000000000000000, 0.80000000000000004, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17353251158533151, 0.80000000000000004, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34166214791545768, 0.80000000000000004, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.50144799535130569, 0.80000000000000004, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.65311976193814425, 0.80000000000000004, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.79924384892320866, 0.80000000000000004, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.94345762353365603, 0.80000000000000004, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.0892582069219161, 0.80000000000000004, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.2387000876610268, 0.80000000000000004, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.3911845406776222, 0.80000000000000004, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler180 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.0000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 3.8945813740035884e-16
const testcase_ellint_3<double>
data181[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.0000000000000000, 
	  0.0000000000000000 },
  { 0.17525427376115024, 0.89999999999999991, 0.0000000000000000, 
	  0.17453292519943295 },
  { 0.35492464591297446, 0.89999999999999991, 0.0000000000000000, 
	  0.34906585039886590 },
  { 0.54388221416157112, 0.89999999999999991, 0.0000000000000000, 
	  0.52359877559829882 },
  { 0.74797400423532490, 0.89999999999999991, 0.0000000000000000, 
	  0.69813170079773179 },
  { 0.97463898451966458, 0.89999999999999991, 0.0000000000000000, 
	  0.87266462599716477 },
  { 1.2334463254523440, 0.89999999999999991, 0.0000000000000000, 
	  1.0471975511965976 },
  { 1.5355247765594910, 0.89999999999999991, 0.0000000000000000, 
	  1.2217304763960306 },
  { 1.8882928567775117, 0.89999999999999991, 0.0000000000000000, 
	  1.3962634015954636 },
  { 2.2805491384227703, 0.89999999999999991, 0.0000000000000000, 
	  1.5707963267948966 },
};
const double toler181 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.10000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 4.1237990617685137e-16
const testcase_ellint_3<double>
data182[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.10000000000000001, 
	  0.0000000000000000 },
  { 0.17507714233254656, 0.89999999999999991, 0.10000000000000001, 
	  0.17453292519943295 },
  { 0.35350932904326521, 0.89999999999999991, 0.10000000000000001, 
	  0.34906585039886590 },
  { 0.53911129989870976, 0.89999999999999991, 0.10000000000000001, 
	  0.52359877559829882 },
  { 0.73666644254508395, 0.89999999999999991, 0.10000000000000001, 
	  0.69813170079773179 },
  { 0.95250736612100195, 0.89999999999999991, 0.10000000000000001, 
	  0.87266462599716477 },
  { 1.1950199550905594, 0.89999999999999991, 0.10000000000000001, 
	  1.0471975511965976 },
  { 1.4741687286340848, 0.89999999999999991, 0.10000000000000001, 
	  1.2217304763960306 },
  { 1.7968678183506053, 0.89999999999999991, 0.10000000000000001, 
	  1.3962634015954636 },
  { 2.1537868513875287, 0.89999999999999991, 0.10000000000000001, 
	  1.5707963267948966 },
};
const double toler182 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.20000000000000001.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 4.3446165733924066e-16
const testcase_ellint_3<double>
data183[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.20000000000000001, 
	  0.0000000000000000 },
  { 0.17490065089140927, 0.89999999999999991, 0.20000000000000001, 
	  0.17453292519943295 },
  { 0.35211377590661436, 0.89999999999999991, 0.20000000000000001, 
	  0.34906585039886590 },
  { 0.53448220334204100, 0.89999999999999991, 0.20000000000000001, 
	  0.52359877559829882 },
  { 0.72591368943179579, 0.89999999999999991, 0.20000000000000001, 
	  0.69813170079773179 },
  { 0.93192539780038763, 0.89999999999999991, 0.20000000000000001, 
	  0.87266462599716477 },
  { 1.1600809679692683, 0.89999999999999991, 0.20000000000000001, 
	  1.0471975511965976 },
  { 1.4195407225882508, 0.89999999999999991, 0.20000000000000001, 
	  1.2217304763960306 },
  { 1.7168966476424521, 0.89999999999999991, 0.20000000000000001, 
	  1.3962634015954636 },
  { 2.0443194576468895, 0.89999999999999991, 0.20000000000000001, 
	  1.5707963267948966 },
};
const double toler183 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.29999999999999999.
// max(|f - f_GSL|): 1.1102230246251565e-15
// max(|f - f_GSL| / |f_GSL|): 5.6974600067013622e-16
const testcase_ellint_3<double>
data184[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.29999999999999999, 
	  0.0000000000000000 },
  { 0.17472479532647531, 0.89999999999999991, 0.29999999999999999, 
	  0.17453292519943295 },
  { 0.35073750187374114, 0.89999999999999991, 0.29999999999999999, 
	  0.34906585039886590 },
  { 0.52998766129466957, 0.89999999999999991, 0.29999999999999999, 
	  0.52359877559829882 },
  { 0.71566993548699553, 0.89999999999999991, 0.29999999999999999, 
	  0.69813170079773179 },
  { 0.91271517762560195, 0.89999999999999991, 0.29999999999999999, 
	  0.87266462599716477 },
  { 1.1281241199843370, 0.89999999999999991, 0.29999999999999999, 
	  1.0471975511965976 },
  { 1.3704929576917448, 0.89999999999999991, 0.29999999999999999, 
	  1.2217304763960306 },
  { 1.6461981511487711, 0.89999999999999991, 0.29999999999999999, 
	  1.3962634015954636 },
  { 1.9486280260314426, 0.89999999999999991, 0.29999999999999999, 
	  1.5707963267948966 },
};
const double toler184 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.40000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 4.7646208744449464e-16
const testcase_ellint_3<double>
data185[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.40000000000000002, 
	  0.0000000000000000 },
  { 0.17454957156468837, 0.89999999999999991, 0.40000000000000002, 
	  0.17453292519943295 },
  { 0.34938003933330430, 0.89999999999999991, 0.40000000000000002, 
	  0.34906585039886590 },
  { 0.52562093533067433, 0.89999999999999991, 0.40000000000000002, 
	  0.52359877559829882 },
  { 0.70589461324915670, 0.89999999999999991, 0.40000000000000002, 
	  0.69813170079773179 },
  { 0.89472658511942849, 0.89999999999999991, 0.40000000000000002, 
	  0.87266462599716477 },
  { 1.0987419542323440, 0.89999999999999991, 0.40000000000000002, 
	  1.0471975511965976 },
  { 1.3261349565496301, 0.89999999999999991, 0.40000000000000002, 
	  1.2217304763960306 },
  { 1.5831293909853763, 0.89999999999999991, 0.40000000000000002, 
	  1.3962634015954636 },
  { 1.8641114227238351, 0.89999999999999991, 0.40000000000000002, 
	  1.5707963267948966 },
};
const double toler185 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.50000000000000000.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 4.9652155758573562e-16
const testcase_ellint_3<double>
data186[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.50000000000000000, 
	  0.0000000000000000 },
  { 0.17437497557073334, 0.89999999999999991, 0.50000000000000000, 
	  0.17453292519943295 },
  { 0.34804093691586013, 0.89999999999999991, 0.50000000000000000, 
	  0.34906585039886590 },
  { 0.52137576320372891, 0.89999999999999991, 0.50000000000000000, 
	  0.52359877559829882 },
  { 0.69655163996912262, 0.89999999999999991, 0.50000000000000000, 
	  0.69813170079773179 },
  { 0.87783188683054236, 0.89999999999999991, 0.50000000000000000, 
	  0.87266462599716477 },
  { 1.0716015959755185, 0.89999999999999991, 0.50000000000000000, 
	  1.0471975511965976 },
  { 1.2857636916026749, 0.89999999999999991, 0.50000000000000000, 
	  1.2217304763960306 },
  { 1.5264263913252358, 0.89999999999999991, 0.50000000000000000, 
	  1.3962634015954636 },
  { 1.7888013241937863, 0.89999999999999991, 0.50000000000000000, 
	  1.5707963267948966 },
};
const double toler186 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.59999999999999998.
// max(|f - f_GSL|): 6.6613381477509392e-16
// max(|f - f_GSL| / |f_GSL|): 3.8702201113622378e-16
const testcase_ellint_3<double>
data187[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.59999999999999998, 
	  0.0000000000000000 },
  { 0.17420100334657812, 0.89999999999999991, 0.59999999999999998, 
	  0.17453292519943295 },
  { 0.34671975876122157, 0.89999999999999991, 0.59999999999999998, 
	  0.34906585039886590 },
  { 0.51724631570707946, 0.89999999999999991, 0.59999999999999998, 
	  0.52359877559829882 },
  { 0.68760879113743023, 0.89999999999999991, 0.59999999999999998, 
	  0.69813170079773179 },
  { 0.86192157779698364, 0.89999999999999991, 0.59999999999999998, 
	  0.87266462599716477 },
  { 1.0464279696166354, 0.89999999999999991, 0.59999999999999998, 
	  1.0471975511965976 },
  { 1.2488156247094004, 0.89999999999999991, 0.59999999999999998, 
	  1.2217304763960306 },
  { 1.4750988777188470, 0.89999999999999991, 0.59999999999999998, 
	  1.3962634015954636 },
  { 1.7211781128919525, 0.89999999999999991, 0.59999999999999998, 
	  1.5707963267948966 },
};
const double toler187 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.69999999999999996.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 4.3410843563834748e-16
const testcase_ellint_3<double>
data188[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.69999999999999996, 
	  0.0000000000000000 },
  { 0.17402765093102207, 0.89999999999999991, 0.69999999999999996, 
	  0.17453292519943295 },
  { 0.34541608382635131, 0.89999999999999991, 0.69999999999999996, 
	  0.34906585039886590 },
  { 0.51322715827061682, 0.89999999999999991, 0.69999999999999996, 
	  0.52359877559829882 },
  { 0.67903717872440272, 0.89999999999999991, 0.69999999999999996, 
	  0.69813170079773179 },
  { 0.84690113601682671, 0.89999999999999991, 0.69999999999999996, 
	  0.87266462599716477 },
  { 1.0229914311548418, 0.89999999999999991, 0.69999999999999996, 
	  1.0471975511965976 },
  { 1.2148329639709381, 0.89999999999999991, 0.69999999999999996, 
	  1.2217304763960306 },
  { 1.4283586501307799, 0.89999999999999991, 0.69999999999999996, 
	  1.3962634015954636 },
  { 1.6600480747670940, 0.89999999999999991, 0.69999999999999996, 
	  1.5707963267948966 },
};
const double toler188 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.80000000000000004.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 3.3100928058463168e-16
const testcase_ellint_3<double>
data189[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.80000000000000004, 
	  0.0000000000000000 },
  { 0.17385491439925146, 0.89999999999999991, 0.80000000000000004, 
	  0.17453292519943295 },
  { 0.34412950523113928, 0.89999999999999991, 0.80000000000000004, 
	  0.34906585039886590 },
  { 0.50931321668729590, 0.89999999999999991, 0.80000000000000004, 
	  0.52359877559829882 },
  { 0.67081081392296327, 0.89999999999999991, 0.80000000000000004, 
	  0.69813170079773179 },
  { 0.83268846097293259, 0.89999999999999991, 0.80000000000000004, 
	  0.87266462599716477 },
  { 1.0010985015814027, 0.89999999999999991, 0.80000000000000004, 
	  1.0471975511965976 },
  { 1.1834394045489678, 0.89999999999999991, 0.80000000000000004, 
	  1.2217304763960306 },
  { 1.3855695891683182, 0.89999999999999991, 0.80000000000000004, 
	  1.3962634015954636 },
  { 1.6044591960982202, 0.89999999999999991, 0.80000000000000004, 
	  1.5707963267948966 },
};
const double toler189 = 2.5000000000000020e-13;

// Test data for k=0.89999999999999991, nu=0.90000000000000002.
// max(|f - f_GSL|): 8.8817841970012523e-16
// max(|f - f_GSL| / |f_GSL|): 5.7167507456081732e-16
const testcase_ellint_3<double>
data190[10] =
{
  { 0.0000000000000000, 0.89999999999999991, 0.90000000000000002, 
	  0.0000000000000000 },
  { 0.17368278986240135, 0.89999999999999991, 0.90000000000000002, 
	  0.17453292519943295 },
  { 0.34285962963961397, 0.89999999999999991, 0.90000000000000002, 
	  0.34906585039886590 },
  { 0.50549974644993312, 0.89999999999999991, 0.90000000000000002, 
	  0.52359877559829882 },
  { 0.66290623857720876, 0.89999999999999991, 0.90000000000000002, 
	  0.69813170079773179 },
  { 0.81921183128847175, 0.89999999999999991, 0.90000000000000002, 
	  0.87266462599716477 },
  { 0.98058481956066390, 0.89999999999999991, 0.90000000000000002, 
	  1.0471975511965976 },
  { 1.1543223520473569, 0.89999999999999991, 0.90000000000000002, 
	  1.2217304763960306 },
  { 1.3462119782292934, 0.89999999999999991, 0.90000000000000002, 
	  1.3962634015954636 },
  { 1.5536420236310948, 0.89999999999999991, 0.90000000000000002, 
	  1.5707963267948966 },
};
const double toler190 = 2.5000000000000020e-13;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_ellint_3<Tp> (&data)[Num], Tp toler)
  {
    bool test __attribute__((unused)) = true;
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Tp f = std::ellint_3(data[i].k, data[i].nu,
		     data[i].phi);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  test(data065, toler065);
  test(data066, toler066);
  test(data067, toler067);
  test(data068, toler068);
  test(data069, toler069);
  test(data070, toler070);
  test(data071, toler071);
  test(data072, toler072);
  test(data073, toler073);
  test(data074, toler074);
  test(data075, toler075);
  test(data076, toler076);
  test(data077, toler077);
  test(data078, toler078);
  test(data079, toler079);
  test(data080, toler080);
  test(data081, toler081);
  test(data082, toler082);
  test(data083, toler083);
  test(data084, toler084);
  test(data085, toler085);
  test(data086, toler086);
  test(data087, toler087);
  test(data088, toler088);
  test(data089, toler089);
  test(data090, toler090);
  test(data091, toler091);
  test(data092, toler092);
  test(data093, toler093);
  test(data094, toler094);
  test(data095, toler095);
  test(data096, toler096);
  test(data097, toler097);
  test(data098, toler098);
  test(data099, toler099);
  test(data100, toler100);
  test(data101, toler101);
  test(data102, toler102);
  test(data103, toler103);
  test(data104, toler104);
  test(data105, toler105);
  test(data106, toler106);
  test(data107, toler107);
  test(data108, toler108);
  test(data109, toler109);
  test(data110, toler110);
  test(data111, toler111);
  test(data112, toler112);
  test(data113, toler113);
  test(data114, toler114);
  test(data115, toler115);
  test(data116, toler116);
  test(data117, toler117);
  test(data118, toler118);
  test(data119, toler119);
  test(data120, toler120);
  test(data121, toler121);
  test(data122, toler122);
  test(data123, toler123);
  test(data124, toler124);
  test(data125, toler125);
  test(data126, toler126);
  test(data127, toler127);
  test(data128, toler128);
  test(data129, toler129);
  test(data130, toler130);
  test(data131, toler131);
  test(data132, toler132);
  test(data133, toler133);
  test(data134, toler134);
  test(data135, toler135);
  test(data136, toler136);
  test(data137, toler137);
  test(data138, toler138);
  test(data139, toler139);
  test(data140, toler140);
  test(data141, toler141);
  test(data142, toler142);
  test(data143, toler143);
  test(data144, toler144);
  test(data145, toler145);
  test(data146, toler146);
  test(data147, toler147);
  test(data148, toler148);
  test(data149, toler149);
  test(data150, toler150);
  test(data151, toler151);
  test(data152, toler152);
  test(data153, toler153);
  test(data154, toler154);
  test(data155, toler155);
  test(data156, toler156);
  test(data157, toler157);
  test(data158, toler158);
  test(data159, toler159);
  test(data160, toler160);
  test(data161, toler161);
  test(data162, toler162);
  test(data163, toler163);
  test(data164, toler164);
  test(data165, toler165);
  test(data166, toler166);
  test(data167, toler167);
  test(data168, toler168);
  test(data169, toler169);
  test(data170, toler170);
  test(data171, toler171);
  test(data172, toler172);
  test(data173, toler173);
  test(data174, toler174);
  test(data175, toler175);
  test(data176, toler176);
  test(data177, toler177);
  test(data178, toler178);
  test(data179, toler179);
  test(data180, toler180);
  test(data181, toler181);
  test(data182, toler182);
  test(data183, toler183);
  test(data184, toler184);
  test(data185, toler185);
  test(data186, toler186);
  test(data187, toler187);
  test(data188, toler188);
  test(data189, toler189);
  test(data190, toler190);
  return 0;
}
