// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivs provides the client and types for making API
// requests to Amazon Interactive Video Service.
//
// Introduction
//
// The Amazon Interactive Video Service (IVS) API is REST compatible, using
// a standard HTTP API and an AWS SNS (http://aws.amazon.com/sns) event stream
// for responses. JSON is used for both requests and responses, including errors.
//
// The API is an AWS regional service, currently in these regions: us-west-2,
// us-east-1, and eu-west-1.
//
//  All API request parameters and URLs are case sensitive.
//
// For a summary of notable documentation changes in each release, see Document
// History (https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html).
//
// Service Endpoints
//
// The following are the Amazon IVS service endpoints (all HTTPS):
//
// Region name: US West (Oregon)
//
//    * Region: us-west-2
//
//    * Endpoint: ivs.us-west-2.amazonaws.com
//
// Region name: US East (Virginia)
//
//    * Region: us-east-1
//
//    * Endpoint: ivs.us-east-1.amazonaws.com
//
// Region name: EU West (Dublin)
//
//    * Region: eu-west-1
//
//    * Endpoint: ivs.eu-west-1.amazonaws.com
//
// Allowed Header Values
//
//    * Accept: application/json
//
//    * Accept-Encoding: gzip, deflate
//
//    * Content-Type: application/json
//
// Resources
//
// The following resources contain information about your IVS live stream (see
// Getting Started with Amazon IVS (https://docs.aws.amazon.com/ivs/latest/userguide/GSIVS.html)):
//
//    * Channel — Stores configuration data related to your live stream. You
//    first create a channel and then use the channel’s stream key to start
//    your live stream. See the Channel endpoints for more information.
//
//    * Stream key — An identifier assigned by Amazon IVS when you create
//    a channel, which is then used to authorize streaming. See the StreamKey
//    endpoints for more information. Treat the stream key like a secret, since
//    it allows anyone to stream to the channel.
//
//    * Playback key pair — Video playback may be restricted using playback-authorization
//    tokens, which use public-key encryption. A playback key pair is the public-private
//    pair of keys used to sign and validate the playback-authorization token.
//    See the PlaybackKeyPair endpoints for more information.
//
// Tagging
//
// A tag is a metadata label that you assign to an AWS resource. A tag comprises
// a key and a value, both set by you. For example, you might set a tag as topic:nature
// to label a particular video category. See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// for more information, including restrictions that apply to tags.
//
// Tags can help you identify and organize your AWS resources. For example,
// you can use the same tag for different resources to indicate that they are
// related. You can also use tags to manage access (see Access Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
//
// The Amazon IVS API has these tag-related endpoints: TagResource, UntagResource,
// and ListTagsForResource. The following resources support tagging: Channels,
// Stream Keys, and Playback Key Pairs.
//
// Channel Endpoints
//
//    * CreateChannel — Creates a new channel and an associated stream key
//    to start streaming.
//
//    * GetChannel — Gets the channel configuration for the specified channel
//    ARN (Amazon Resource Name).
//
//    * BatchGetChannel — Performs GetChannel on multiple ARNs simultaneously.
//
//    * ListChannels — Gets summary information about all channels in your
//    account, in the AWS region where the API request is processed. This list
//    can be filtered to match a specified string.
//
//    * UpdateChannel — Updates a channel's configuration. This does not affect
//    an ongoing stream of this channel. You must stop and restart the stream
//    for the changes to take effect.
//
//    * DeleteChannel — Deletes the specified channel.
//
// StreamKey Endpoints
//
//    * CreateStreamKey — Creates a stream key, used to initiate a stream,
//    for the specified channel ARN.
//
//    * GetStreamKey — Gets stream key information for the specified ARN.
//
//    * BatchGetStreamKey — Performs GetStreamKey on multiple ARNs simultaneously.
//
//    * ListStreamKeys — Gets summary information about stream keys for the
//    specified channel.
//
//    * DeleteStreamKey — Deletes the stream key for the specified ARN, so
//    it can no longer be used to stream.
//
// Stream Endpoints
//
//    * GetStream — Gets information about the active (live) stream on a specified
//    channel.
//
//    * ListStreams — Gets summary information about live streams in your
//    account, in the AWS region where the API request is processed.
//
//    * StopStream — Disconnects the incoming RTMPS stream for the specified
//    channel. Can be used in conjunction with DeleteStreamKey to prevent further
//    streaming to a channel.
//
//    * PutMetadata — Inserts metadata into an RTMPS stream for the specified
//    channel. A maximum of 5 requests per second per channel is allowed, each
//    with a maximum 1KB payload.
//
// PlaybackKeyPair Endpoints
//
//    * ImportPlaybackKeyPair — Imports the public portion of a new key pair
//    and returns its arn and fingerprint. The privateKey can then be used to
//    generate viewer authorization tokens, to grant viewers access to authorized
//    channels.
//
//    * GetPlaybackKeyPair — Gets a specified playback authorization key pair
//    and returns the arn and fingerprint. The privateKey held by the caller
//    can be used to generate viewer authorization tokens, to grant viewers
//    access to authorized channels.
//
//    * ListPlaybackKeyPairs — Gets summary information about playback key
//    pairs.
//
//    * DeletePlaybackKeyPair — Deletes a specified authorization key pair.
//    This invalidates future viewer tokens generated using the key pair’s
//    privateKey.
//
// AWS Tags Endpoints
//
//    * TagResource — Adds or updates tags for the AWS resource with the specified
//    ARN.
//
//    * UntagResource — Removes tags from the resource with the specified
//    ARN.
//
//    * ListTagsForResource — Gets information about AWS tags for the specified
//    ARN.
//
// See https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14 for more information on this service.
//
// See ivs package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivs/
//
// Using the Client
//
// To contact Amazon Interactive Video Service with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon Interactive Video Service client IVS for more
// information on creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivs/#New
package ivs
