// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package marketplacemetering provides a client for AWSMarketplace Metering.
package marketplacemetering

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opMeterUsage = "MeterUsage"

// MeterUsageRequest generates a request for the MeterUsage operation.
func (c *MarketplaceMetering) MeterUsageRequest(input *MeterUsageInput) (req *request.Request, output *MeterUsageOutput) {
	op := &request.Operation{
		Name:       opMeterUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MeterUsageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &MeterUsageOutput{}
	req.Data = output
	return
}

// API to emit metering records. For identical requests, the API is idempotent.
// It simply returns the metering record ID.
func (c *MarketplaceMetering) MeterUsage(input *MeterUsageInput) (*MeterUsageOutput, error) {
	req, out := c.MeterUsageRequest(input)
	err := req.Send()
	return out, err
}

type MeterUsageInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the permissions required for the action, but does
	// not make the request. If you have the permissions, the request returns DryRunOperation;
	// otherwise, it returns UnauthorizedException.
	DryRun *bool `type:"boolean" required:"true"`

	// Product code is used to uniquely identify a product in AWS Marketplace. The
	// product code should be the same as the one used during the publishing of
	// a new product.
	ProductCode *string `min:"1" type:"string" required:"true"`

	// Timestamp of the hour, recorded in UTC. The seconds and milliseconds portions
	// of the timestamp will be ignored.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// It will be one of the 'fcp dimension name' provided during the publishing
	// of the product.
	UsageDimension *string `min:"1" type:"string" required:"true"`

	// Consumption value for the hour.
	UsageQuantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s MeterUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeterUsageInput) GoString() string {
	return s.String()
}

type MeterUsageOutput struct {
	_ struct{} `type:"structure"`

	MeteringRecordId *string `type:"string"`
}

// String returns the string representation
func (s MeterUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeterUsageOutput) GoString() string {
	return s.String()
}
