/*
 * Copyright (C) 2002-2018 Free Software Foundation, Inc.
 *
 * This file is part of LIBTASN1.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/****************************************************************/
/* Description: reproducer for CVE-2018-1000654			*/
/****************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "CVE-2018-1000654-1_asn1_tab.h"
#include "CVE-2018-1000654-2_asn1_tab.h"

int
main (int argc, char *argv[])
{
  int result, verbose = 0;
  asn1_node definitions = NULL;
  char errorDescription[ASN1_MAX_ERROR_DESCRIPTION_SIZE];

  if (argc > 1)
    verbose = 1;

  printf("Test 1\n");

  result = asn1_array2tree (CVE_2018_1000654_1_asn1_tab, &definitions, errorDescription);
  if (result != ASN1_RECURSION)
    {
      asn1_perror (result);
      printf ("ErrorDescription = %s\n\n", errorDescription);
      exit (1);
    }

  asn1_delete_structure (&definitions);

  printf("Test 2\n");

  result = asn1_array2tree (CVE_2018_1000654_2_asn1_tab, &definitions, errorDescription);
  if (result != ASN1_RECURSION)
    {
      asn1_perror (result);
      printf ("ErrorDescription = %s\n\n", errorDescription);
      exit (1);
    }

  asn1_delete_structure (&definitions);

  if (verbose)
    printf ("Success\n");
  exit (0);
}
