.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbComputeShapeBounds __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbComputeShapeBounds \- Updates the bounding box of a shape
.SH SYNOPSIS
.HP
.B Bool XkbComputeShapeBounds
.BI "(\^XkbShapePtr " "shape" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I shape
shape to be examined
.SH DESCRIPTION
.LP
Xkb provides a number of convenience functions to help use a keyboard geometry. These include 
functions to return the bounding box of a shape's top surface and to update the bounding box 
of a shape row or section.

A shape is made up of a number of outlines. Each outline is a polygon made up of a number of 
points. The bounding box of a shape is a rectangle that contains all the outlines of that 
shape. 

A ShapeRec contains a BoundsRec that describes the bounds of the shape. If you add or delete 
an outline to or from a shape, the bounding box must be updated.

.I XkbComputeShapeBounds 
updates the BoundsRec contained in the 
.I shape 
by examining all the outlines of the shape and setting the BoundsRec to the minimum x and 
minimum y, and maximum x and maximum y values found in those outlines. 
.I XkbComputeShapeBounds 
returns False if 
.I shape 
is NULL or if there are no outlines for the shape; otherwise, it returns True.

If you add or delete a key to or from a row, or if you update the shape of one of the keys in that row, you may need to update the bounding box of that row. To update the bounding box of a row, use 
.I XkbComputeRowBounds.
.SH STRUCTURES
.LP
.nf

typedef struct _XkbShape {
    Atom           name;         /\&* shape's name */
    unsigned short num_outlines; /\&* number of outlines for the shape */
    unsigned short sz_outlines;  /\&* size of the outlines array */
    XkbOutlinePtr  outlines;     /\&* array of outlines for the shape */
    XkbOutlinePtr  approx;       /\&* pointer into the array to the approximating outline */
    XkbOutlinePtr  primary;      /\&* pointer into the array to the primary outline */
    XkbBoundsRec   bounds;       /\&* bounding box for the shape; encompasses all outlines */
} XkbShapeRec, *XkbShapePtr;

typedef struct _XkbBounds {
    short	x1,y1;	/\&* upper left corner of the bounds, in mm/10 */
    short	x2,y2;	/\&* lower right corner of the bounds, in mm/10 */
} XkbBoundsRec, *XkbBoundsPtr;

.fi
.SH "SEE ALSO"
.BR XkbComputeRowBounds (__libmansuffix__)

