<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


include('auth.php');

include_once( "class.SQLInteger.php" );
 
include_once( "../include/data_source/class.SQLQuery.php" );
include_once( "../include/data_source/class.CompoundValue.php" );
include_once( "../include/data_source/class.ValueLocale.php" );
include_once( "../include/data_source/class.ValueFromArray.php" );
include_once( "../include/data_source/class.ValueFormated.php" );
include_once( "../include/data_source/class.ConversedDBValue.php" );
include_once( "../include/data_source/class.DataValue.php" );

include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.CheckDataField.php" );
include_once( "../include/elements/data/class.ButtonData.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.PagedTableView.php" );
include_once( "../include/elements/data/class.IconDataField.php" );

include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/class.CompoundElement.php" );
include_once( "../include/elements/html/class.PPButtonElement.php" );
include_once( "../include/elements/html/class.ButtonURLElement.php" );
include_once( "../include/elements/html/class.SimpleSearchElement.php" );

include_once( "../include/elements/html/module.Constants.php" );

include_once( "defines.php");



global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "iprestriction.php: POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><br>\n";
}


global $email_mode;

switch( $action ){
 case 'new':
	 $action = '';
	 if( $ip ) {
		 if( preg_match ( "/^(\*|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])".
											"(\\.(\*|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){1,3}$/", $ip ) ) {
			 $rest = $accept? 'accept': 'deny';
			 $id = db_query("SELECT id FROM iprestriction WHERE ip='$ip' AND server_id='$ServerID'");
			 if( db_num_rows( $id ) ) {
				 $fehlertext = ltext( 'ipr_error2', array( $ip ) );
			 } else {
				 db_query( "INSERT INTO iprestriction (ip,rest, server_id) VALUES ( '$ip', '$rest', '$ServerID')");
			 } /*ipr_yourip*/
		 } else {
			 $fehlertext = ltext( 'ipr_incorrectip', array( $ip ) );
		 }
	 }
	 break;
 case 'delete':
	 $action = '';
	 if( is_array( $ip_ids ) ) {
		 $loFields = new SQLFieldSet();
		 foreach ($ip_ids as $loID){
			 $loFields->addField( 'id', $loID );
		 }
		 $lcIDs = $loFields->getSQLValues();
		 db_query( "DELETE FROM iprestriction WHERE id IN ( $lcIDs ) AND server_id='$ServerID'" );
	 }
	 break;
 case 'accept':
	 $action='';
	 if(is_numeric($ip_id)){
		 if( !$rest == 'accept' ) {
			 $rest='deny';
		 }
		 safe_query2( "UPDATE iprestriction SET rest=? WHERE id=? AND server_id='$ServerID'",
									new SQLString( $rest ), new SQLInteger( $ip_id ) );
	 }
	 break;
}

//======================================================
//
// add form

$loNewIP = new SetOfRowsData();
$loNewIP->AppendRow( new HTMLDataField( ltext('ipr_ipaddress')),
										 new TextDataField( $ip, 'ip' ),
										 new CheckDataField( 1, 'accept' ),
										 new HTMLDataField( ltext('ipr_accept'))
										 );
$loNewIP->AppendButton( ltext("ll_add"), "javascript:doChange()",cc_IDAdd );

$loNewIP->AppendHidden( new TextDataField( 'new', 'action' ));

$loAddForm = $loNewIP->GetInputPresentation( array('action' => 'iprestriction.php',
																									 'method' => 'post',
																									 'name' => 'add' )
																						 , ltext( 'ipr_addnew' ) );
// end add form
//
//========================================================
//
// list

initPagingSettings( $_POST, array( 'ip_to_serach' => $ip_to_search ) );

$lcSQL = "SELECT COUNT(id) FROM iprestriction WHERE server_id='$ServerID'";
$res = db_query( $lcSQL );
list( $total_number ) = db_fetch_array( $res );
if(!$total_number){
	$fehlertext .= '<br>'.ltext( 'ipr_norestrictions'	);
}

//Sort settings 
	$listFormIndex = 1;
	if (!isset($direction)) $direction = 'asc';
	if (!isset($order)) $order = 'ip';
	$lcDirIcon = ( $direction =='desc' ) ? cc_DescIcon : cc_AscIcon;
	$lcNewDir =  ( $direction =='desc' ) ? 'asc' : 'desc';

switch ( $order ) {
 case 'ip':
	 $lcOrder = "  ORDER BY ip";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 case 'rest':
	 $lcOrder = " ORDER BY rest";
	 if ( $direction == 'desc' ) $lcOrder .= " DESC";
	 break;
 }


if( isset($ip_to_search)&&strlen($ip_to_search) ) {
	$lcSQL .= " AND ip LIKE '%?%'";
	$loQuery = new SQLQuery( $lcSQL, array( new SQLValue($ip_to_search, 'S' ) ) );
	$loQuery->doQuery();
	list($total_number) = $loQuery->fetchArray('N');

	$lcSQL = "SELECT id, ip, rest FROM iprestriction WHERE ip LIKE '%?%' AND server_id='$ServerID'".$lcOrder;
	$loQuery->Query( $lcSQL );

} else {
	$loQuery = new SQLQuery( "SELECT id, ip, rest FROM iprestriction WHERE server_id='$ServerID'".$lcOrder );
}

$loDS = new ConversedDBValue( $loQuery, $page_size, $start_index-1 );

$loTemplate = new CompoundValue( new CompoundValue( new ValueFromArray( 'rest' ),
																										new ValueFromArray( 'id' ) 
																										),
																 new ValueFromArray( 'ip' ),
																 new ValueFromArray( 'id' ) /* select */
																 );

$loCheckBox = new CheckDataField( 1, 'selectAll' );
$loCheckBox->Attribute('onclick', "javascript:checkedAll('ip_ids', this.checked, 1)");
$loSelValue = new DataValue( 'selectAll', 1, $loCheckBox );
$loSelValue->setTypeOfPresentation( 'Input' );
$laContent =array();

	if( $order == 'ip' ) {
	$laContent['ip'] = new CompoundDataField( new HTMLDataField( ltext( 'ipr_ipaddress' )),
																						 new IconDataField( $lcDirIcon ));
	$laContent['ip']->SetSeparator('');
 } else {
	$laContent['ip'] = new HTMlDataField( ltext( 'ipr_ipaddress' ) );
 }
 if( $order == 'rest' ) {
	$laContent['rest'] = new CompoundDataField( new HTMLDataField( ltext( 'ipr_accept' )),
																						 new IconDataField( $lcDirIcon ));
	$laContent['rest']->SetSeparator('');
 } else {
	$laContent['rest'] = new HTMlDataField( ltext( 'ipr_accept' ) );
 }
$loTitle = new CompoundValue( new DataValue( 'rest', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','rest',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['rest']
																																)
																						 ),
															new DataValue( 'ip', 
																						 NULL, 
																						 new LinkDataField( "javascript:setValue('order','ip',$listFormIndex);".
																																"setValue('start_index',1,$listFormIndex);".
																																"submitForm('direction','$lcNewDir',$listFormIndex)",
																																'',
																																array(),
																																$laContent['ip']
																																)
																						 ),
															
															$loSelValue
															);
$laWidths = array('10%', '87%', '3%' );

$loDS->Template( $loTemplate );

//======================================================
//
// call-back functions

$gcSwitchDeny = ltext( 'ipr_switch_deny' );
$gcSwitchAccept = ltext( 'ipr_switch_accept' );

function makeAccept( $poSrc ){

	global $gcSwitchDeny, $gcSwitchAccept,$confixx_interface_version;

	$loVal =& $poSrc->Value(0);
	$lcAccept = $loVal->Value();
	if($lcAccept == 'accept'){
		$lcIcon = cc_AcceptIcon;
		$lcTitle = $gcSwitchDeny;
		$lcNewValue = 'deny';
	} else {
		$lcIcon = cc_DenyIcon;
		$lcTitle = $gcSwitchAccept;
		$lcNewValue = 'accept';
	}
	$loVal =& $poSrc->Value(1);
	$liID = $loVal->Value();

	$text = ($lcAccept == 'accept')? ltext('ipr_accepted'): ltext('ipr_denied');
	
	$loLink = new LinkDataField( "javascript:setValue('ip_id',$liID,1);".
															 "setValue('rest','$lcNewValue',1);".
															 "submitForm('action','accept',1)",
															 '',
															 array(),
															 ($confixx_interface_version == 'powp')?new IconDataField( $lcIcon ):$text
															 );
	$loLink->AppendAttributes( array( 'title' => $lcTitle ) );
	$loLink->AppendParentAttributes( array( 'align' => 'center' ) );
	
	return $loLink;
}

function makeSelect( $poSrc ){

	$loCheckBox = new CheckDataField( $poSrc, 'ip_ids[]');
	$loCheckBox->ParentAttribute('align','center');
	
	return array( $loCheckBox->GetInputPresentation(), array('align'=>'center'));
	
}


// end call-back functions
//
//=====================================================

$loConv = new CompoundValue( new ValueFormated( 'accept', NULL, 'makeAccept'),
														 NULL,
														 new ValueFormated( 'select', NULL, 'makeSelect' )
														 );

$loDS->Conversion( $loConv );

$loDS->doQuery();

$loPTV = new PagedTableView( $loDS, $total_number );

$loPTV->Title( $loTitle	);
$loPTV->Widths( $laWidths );
$loPTV->setParameter( 'menu_node_id', $menu_node_id );
$loPTV->setParameter( 'cur_page', $cur_page?$cur_page:'' );
$loPTV->setParameter( 'head_text', $head_text );
 
$loPTV->setParameter( 'action', '' );
$loPTV->setParameter( 'ip_id', '' );
$loPTV->setParameter( 'rest', '' );
$loPTV->setParameter( 'order', $order );
$loPTV->setParameter( 'direction', $direction );
$loPTV->Anchor( 'list' );
$loPTV->FormIndex( 1 );

if (isset($ip_to_search)&&strlen($ip_to_search)) {
		$loPTV->NoItemsMessage(ltext('ll_empty_search'));
	}	else {
		$loPTV->NoItemsMessage(ltext('ll_empty_list'));
}
$tbl = $loPTV->GetOutputPresentation( array( 'action' => 'iprestriction.php#list',
																						 'name' => 'list_rest' ), 
																			ltext( 'ma_iprestriction' ) );

$dsSearch = new CompoundValue( new ValueFromArray( 'ip_to_search', $ip_to_search ),
															 new ValueLocale( 'll_search' ),
															 new ValueLocale( 'll_show_all' )
															 );

$loSearch = new SimpleSearchElement( array(), 
																		 new InputTextElement( array( 'name' => 'ip_to_search', 
																																	'size' => '16',
																																	'value' => $ip_to_search,
																																	'MAXLENGTH'=> '16' )
																													 ) 
																		 );
	
$loGroup = new DivElement(array('class'=>'buttons'));
	

$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:submitForm('start_index',1,1)", 
																							 'bid-search' 
																							 )
													);
$loSearch->appendElement( new PPButtonElement( '', 
																							 "javascript:setValue('ip_to_search','',1);".
																							 "submitForm('start_index',1,1)", 
																							 'bid-show-all'
																							 ) 
													);

$head_text = ltext('ll_delete');
$lcConfirm = ltext('ll_confirm_delete');
$lcNothing = ltext('ll_nothing');

$loGroup->AppendToContent( new PPButtonElement( $head_text,
																								"javascript:setValue('action','delete',1);".
																								"deleteSelected('ip_ids','$lcConfirm',1,'$lcNothing')",
																								'bid-delete' 
																								)
													 );

	
$loSearch->setDataSource( $dsSearch, array( 'mail_to_search' => $mail_to_search ) );

if ((isset($ip_to_search)&&strlen($ip_to_search))||$total_number>0) {
	$tbl->setSearchElement( $loSearch );
}
if ($total_number>0) {
	$tbl->setGroupActionElement( $loGroup );
}

$tbl->updateBodyContent();


// end list
//
//==============================================================

$page = new MainPageElement( $loAddForm, $tbl );

$page->OutputHTML( array( '../js/paged_form.js' ), js_f_call_help('', 'empo_desc1'));

?>
