package Confixx::Dir;

BEGIN{
	no utf8;

	use FindBin;
	use File::Basename;

	use lib $FindBin::Bin =~ s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib dirname( $FindBin::Bin );
}

use SOAP::Lite;

use Fcntl ':mode';
use Cwd;
use MIME::Base64;

use Confixx::Session;

no utf8;
use strict;

#===================================================
#
# SOAP methods

sub ls{
	my  $this = shift;
	my $som = pop; ## last item
	my $ref = ref( $som );

	my($session_id, $user, $path, $keys, $sort, $ptrSession );

	if( $ref =~ /SOAP::SOM/  ) {
		$session_id = $som->valueof( '//ls/session_id' );
		unless( $session_id ){
			die SOAP::Fault->faultcode( 'Server.Parameter' )
				->faultstring( "Error: Parameter 'session_id' is not set" );		
		}
	}else{
		($session_id, $user, $path, $keys, $sort ) = ( @_, $som );
	}

	unless( $ptrSession = &loadSession( $session_id ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: session '$session_id' is not found" );		
	}
	
	&checkRights( $ptrSession, $user );

	my( $user_homeDir );
	unless( $user_homeDir = &getConfig( 'user_homeDir' ) ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: parameter 'user_homeDir' is not found" );		
	}

	unless( -d $user_homeDir ){
		die SOAP::Fault->faultcode( 'Server.Session' )
				->faultstring( "Error: parameter 'user_homeDir' is not a dir ($user_homeDir)" );		
	}

	if( ! $path || $path =~ /\.\./ ){
		die SOAP::Fault->faultcode( 'Dir.Parameter' )
				->faultstring( "Error:  wrong path ($path)" );		
	}

	$path =~ s%^/%%; ## trim the first slash
	$path =~ s%/$%%; ## trim the last slash

	my $dirPath = join( '/', ( $user_homeDir, $user, $path ) );
	
	unless( -d $dirPath ){
		return 0, "Error: the path is not a dir ($dirPath)";
	}

	my %keys = map{ $_ => 1 } split( /:/, $keys );

#-------------------------------------------------
#
# read the dir

	

	unless( opendir( DIR, $dirPath ) ){
		die SOAP::Fault->faultcode( 'Dir.Parameter' )
				->faultstring( "Error: open dir error ($dirPath): $!" );		
	}

	my $cwd = getcwd();
	chdir( $dirPath ) or
		die SOAP::Fault->faultcode( 'Dir.Change' )
			->faultstring( "Error: change dir error ($dirPath): $!" );

	my( $file, $key_A, $key_a, $key_d, $fullPath, @attr, @list );
	unless( $key_a = $keys{'a'} ){
		$key_A = $keys{'A'};
	}
	$key_d = $keys{'d'};

	while( $file = readdir(DIR) ){

		if( $file =~ /^\./ ){
			if( $key_A ){
				if( $file =~ /^\.\.?$/ ){
					next; ## skip . and ..
				}
			}
			unless( $key_a ){
				next; ## skip all .*
			}
		}

		if( $key_d ){
			unless( -d $file ){
				next; ## skip non dir
			}
		}
		@attr = ( stat( $file ) )[2,4,5,9]; ## mode, uid, gid, last modify time

		unless( @attr ){
			die SOAP::Fault->faultcode( 'Dir.Stat' )
				->faultstring( "Error: can't get stat of '$file' : $!" );		
		}

		push @list, [ $file,                      ## file name
									&getTypeOfItem( $attr[0] ), ## type of file/dir
									@attr                       ## attributes
								];
	}

	chdir( $cwd );

	close( DIR );

# end read dir
#
#---------------------------------
#
# sort

	$sort = lc( $sort );
	unless( $sort eq 'ext' || $sort eq 'name' || $sort eq 'none' ){
		$sort = 'name';
	}

	my( $aname, $bname, $aext, $bext, $atype, $btype, %cache, $name, $ret, $type);
	my $rev = ( exists $keys{'r'} )? 1: 0;

	my @sortedList = sort {
		( $aname, $atype ) = @{$a};
		( $bname, $btype ) = @{$b};
		
		if( exists $cache{$aname} ){ ## there is in cache
			( $atype, $aname, $aext ) = @{ $cache{$aname} };

		}else{
			$name = $aname;
			$atype = ( $atype =~ /d/ )?0:1;
			if( $aname =~ /^(.*)(\.[^.]+)$/ ){
				$aname = $1;
				$aext = $2;
			}else{
				$aext = '';
			}
# store into cache
			$cache{$name} = [ $atype, $aname, $aext ];
		}

		if( exists $cache{$bname} ){ ## there is in cache
			( $btype, $bname, $bext ) = @{ $cache{$bname} };
		}else{
			$name = $bname;
			$btype = ( $btype =~ /d/ )?0:1;
			if( $bname =~ /^(.*)(\.[^.]+)$/ ){
				$bname = $1;
				$bext = $2;
			}else{
				$bext = '';
			}
# store into cache
			$cache{$name} = [ $btype, $bname, $bext ];
		}

		if( $atype == $btype ){ ## dir <-> dir or file <-> file

			if( $sort eq 'ext' ){
				if( $aext eq $bext ){
					$ret = $aname cmp $bname;        ## sort in an extansion 
				}else{
					$ret = $aext cmp $bext;          ## sort by extension
				}

			}elsif( $sort eq 'name' ){
				if( $aname eq $bname ){
					$ret = $aext cmp $bext;          ## sort in a name
				}else{	
					$ret = $aname cmp $bname;        ## sort by name
				}

			}else{ ## none - without sorting
				$ret = 0;
			}

			$ret -= $ret if $rev; ## reverse sorting

		}else{
			$ret = $atype <=> $btype; ## dirs first
		}

		$ret; ## return result

	} @list;
	

# end sort
#
#-------------------------------------


	$ret = SOAP::Data->name('list' )
		->attr( {'path' => $path} )
			->type('DirList');

	@list = map{ 

		( $name, $type ) = @{$_};

#		if( $name =~ /[^\x01-\x7F]/ ){
#			$name = encode_base64( $name );
#			$type .= 'm';
#		}

		SOAP::Data->name( 'item' )
				->type('DirItem')
					->value( SOAP::Data->name( 'name' )->value( $name ),
									 SOAP::Data->name( 'type' )->value( $type )
								 );
	} @sortedList;

	$ret->value( @list );

	return $ret;
}


# end SOAP methods
#
#========================================================

sub new {
	my $class = shift;
	my $this = {};
	bless( $this, $class);
	return $this;
}

sub getTypeOfItem {
	my $mode = shift;
	my $type = '';

	if( S_ISREG( $mode ) ){
		$type = 'f';

	}elsif( S_ISDIR( $mode ) ){
		$type = 'd';

	}elsif( S_ISBLK( $mode ) ){
		$type = 'b';

	}elsif( S_ISCHR( $mode ) ){
		$type = 'c';

	}elsif( S_ISFIFO( $mode ) ){
		$type = 'p';

	}elsif( S_ISSOCK( $mode ) ){
		$type = 'S';
	}

	if( S_ISLNK( $mode ) ){
		$type .= 'l';
	}

	return $type;
}

1;
