#!/usr/bin/perl

BEGIN {
	use FindBin;
	use lib $FindBin::Bin=~s%(?<=.)/$%%?$FindBin::Bin:$FindBin::Bin;
	use lib $FindBin::Bin.'/modules';

}

use SOAP::Lite;
use Getopt::Long;

use lib_module_db;
use lib_module_events;
use Confixx::Session;

use strict;

my @config_opts = (
									 'host|h=s',
									 'login|l=s',
									 'pass|p=s',

									 'sid=s',

									 'move-users:s',

									 'db-srv|dbs=s',
									 'db-port=s',
									 'db-name|dbn=s',
									 'db-user|dbu=s',
									 'db-pass|dbp=s',
									
									 'logout!',

									 'debug|dbg:i'
									);
									 
my %args = ();
unless ( &GetOptions( \%args, @config_opts ) ) {

	warn "Error: errors in the command line found\n";
	&print_help();
	exit 1;
}

unless( exists( $args{'logout'})){
	$args{'logout'} = 1;
}
if( exists( $args{'debug'})){
	$args{'debug'} = 1 unless $args{'debug'};
}

if($args{'debug'}){
	SOAP::Lite->import( +trace => 'all' );
}

unless( $args{'host'} ){
	warn "Error: hostname is not set\n";
	&print_help();
	exit 1;
}

my $soap_host = $args{'host'};
$soap_host =~ s/^('|")(.*)\1/$2/;

unless( $args{'sid'} || ( $args{'login'} && $args{'pass'} ) ){
	warn "Error: missing parameters of connection\n";
	&print_help();
	exit 1;
}

my $masterServerID = Confixx::Session::getConfig( 'masterServerID' );

unless( $masterServerID ){
	warn "Error: 'masterServerID' is not found\n";
	exit 2;
}


my $soap_session = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/Session')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my $soap_mysql = SOAP::Lite -> uri( 'http://www.soaplite.com/Confixx/MySQL')
	-> proxy( "http://$soap_host/cgi-bin/soap/server.cgi" )
	-> on_fault( \&on_error );

my ($session_id);
if( $args{'sid'} ){
	$session_id = $args{'sid'};
}else{
	$session_id = $soap_session->login( $args{'login'}, $args{'pass'} )->result;
	print "session_id: $session_id\n";

	my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
																SOAP::Data->name('server')->value( $args{'db-srv'} ),
																SOAP::Data->name('port')->value( $args{'db-port'} ),
																SOAP::Data->name('db_name')->value( $args{'db-name'} ),
																SOAP::Data->name('db_user')->value( $args{'db-user'} ),
																SOAP::Data->name('db_paswd')->value( $args{'db-pass'} )
														);
	my $host = $soap_mysql->check_connect( $args )->result;

	print "host: $host\n";
	

}
my $localMasterConfixx = $soap_session->get_config( $session_id, 'master_confixx' )->result;
if( $localMasterConfixx == 1){
	if( $args{'logout'} ){
		$soap_session->logout( $session_id );
	}
	die "error-code:Cluster.Info\nerror-string:The server is already in a cluster\n";
}

#this actually returns 0 or 1 if there any of dc license if available 3adddc or 3dc
#if no one found 0 returned
my $licence_ver = $soap_session->get_licence( $session_id )->result;
unless( $licence_ver ){
	if( $args{'logout'} ){
		$soap_session->logout( $session_id );
	}
	die "error-code:Cluster.Licence\nerror-string:The server's licence is not valid\n";
}

my $server_id = $soap_mysql->copy_table( $session_id, 'admin' )->result;

print "server_id: $server_id\n";

my $data = "dsn='".&makeDSN( 'mysql', $args{'db-srv'}, $args{'db-name'}, $args{'db-port'}).
	"';user='".$args{'db-user'}."';pass='".$args{'db-pass'}."'";


my $args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
															SOAP::Data->name('object')->value( $OBJECT_SERVER ),
															SOAP::Data->name('object_id')->value( undef ),
															SOAP::Data->name('object_prop')->value( $masterServerID ),
															SOAP::Data->name('event_type')->value( $EVENT_CONNECT ),
															SOAP::Data->name('event_prop')->value( undef ),
															SOAP::Data->name('data')->value( $data )													
														);

my $ret = $soap_mysql->rise_event( $args )->result;

if( exists( $args{'move-users'} ) ){

	my $dest = $args{'move-users'} || 'res0';

	$args = SOAP::Data->value( SOAP::Data->name('session_id')->value( $session_id ),
														 SOAP::Data->name('object')->value( $OBJECT_USER ),
														 SOAP::Data->name('object_id')->value( undef ),
														 SOAP::Data->name('object_prop')->value( 'all' ),
														 SOAP::Data->name('event_type')->value( $EVENT_MOVE ),
														 SOAP::Data->name('event_prop')->value( $dest )									
													 );

	$ret = $soap_mysql->rise_event( $args )->result;
	
}


if( $args{'logout'} ){
	$soap_session->logout( $session_id );
}

exit 0;

#
#
#============================================
#
#

sub on_error {
	my( $soap, $res ) = @_;
	if( ref($res) =~ /SOAP/ ){
		print STDERR "error-code: ",$res->faultcode,
			"\nerror-string: ",$res->faultstring,
			"\nerror-detail: ",$res->faultdetail,"\n";
		exit 2;
	}else{
		die $soap->transport->status,"\n";
	}
}

sub print_help {
	print <<"HELP";

start_cluster.pl - start process of connection to cluster

command line options:

  --host |-h = < hostname of the Confixx's server >
  --login|-l = < login name of the Confixx's administrator >
  --pass |-p = < password of the Confixx's administrator >

  --db-srv |-dbs = < hostname of the master database >
  --db-port      = < port >
  --db-name|-dbn = < name of the master database >
  --db-user|-dbu = < name of the databases's user to connect to the master database >
  --db-pass|-dbp = < password to connect to the master database >

  --no-logout  -  don't logout after starting
  --sid = < session's ID >

  --debug|-dbg = < debug level >

HELP

}

