<?php
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'class.CsvDataProcess.php');

/**
 * Class for import/export addressbook in WebMail
 *
 */
class AddressBookCsvDataProcess extends  CsvDataProcess {
  
  var $_mcEmailClientType;
  
  function AddressBookCsvDataProcess($paHeaders = array(), $pcLineEnd = "\r\n", $pcDelimiter = ',',
                                     $pcEmailClientType = 'MS Outlook 2003') {
    $this->_mcEmailClientType = $pcEmailClientType;
    CsvDataProcess::CsvDataProcess($paHeaders, $pcLineEnd, $pcDelimiter);
  }
  
  function &csvToArray(&$pcInput, $pcInputType = 'f') {
    if ($pcInputType == 'f') {
       if (file_exists($pcInput)) {
         $pcInputData = file_get_contents($pcInput);
       } else {
         return array();
       }
    } else {
      $pcInputData = $pcInput;
    }
    
    $laImportContacts    = array();
    $laTmpImportContacts = array();
    $laImportHeaders     = array();
    
    switch ($this->_mcEmailClientType) {
      case 'MS Outlook 2003':
          foreach (explode($this->_mcLineEnd,$pcInputData) as $value) {
        		$laTmpImportContacts[] = explode( ',', $value );
        	}
        	
         	array_shift($laTmpImportContacts);
         	
          	foreach ($laTmpImportContacts as $key => $value) {
          	  $laImportContacts[$key]['name']       = $value[0] ? $this->unescape($value[0]) : $this->unescape($value[1]);
          	  $laImportContacts[$key]['first_name'] = $this->unescape($value[1]);
          	  $laImportContacts[$key]['last_name']  = $this->unescape($value[2]);
          	  $laImportContacts[$key]['tel_work']   = '';
          	  $laImportContacts[$key]['tel_fax']    = '';
          	  $laImportContacts[$key]['tel_home']   = '';
          	  $laImportContacts[$key]['tel_mobile'] = '';
          	  $laImportContacts[$key]['email']      = '';
          	  $laImportContacts[$key]['address']    = '';
          	  
          	  foreach ($value as $lcValue) {
          		  if (strpos($lcValue, '@') !== false) {
          			  $laImportContacts[$key]['email'] =	$this->unescape($lcValue);			
          			}					
          		}
            }
        break;
      default:
        foreach (explode($this->_mcLineEnd,$pcInputData) as $value) {
        		$laTmpImportContacts[] = explode(',', $value);
        	}
        	
         	array_shift($laTmpImportContacts);
         	
          	foreach ($laTmpImportContacts as $key => $value) {
          	  $laImportContacts[$key]['name']       = $value[0] ? $this->unescape($value[0]) : $this->unescape($value[1]);
          	  $laImportContacts[$key]['first_name'] = $this->unescape($value[1]);
          	  $laImportContacts[$key]['last_name']  = $this->unescape($value[2]);
          	  $laImportContacts[$key]['tel_work']   = '';
          	  $laImportContacts[$key]['tel_fax']    = '';
          	  $laImportContacts[$key]['tel_home']   = '';
          	  $laImportContacts[$key]['tel_mobile'] = '';
          	  $laImportContacts[$key]['email']      = '';
          	  $laImportContacts[$key]['address']    = '';
          	  
          	  foreach ($value as $lcValue) {
          		  if (strpos($lcValue, '@') !== false) {
          			  $laImportContacts[$key]['email'] =	$this->unescape($lcValue);			
          			}					
          		}
            }
        break;
    }
    return $laImportContacts;
  }
  
}

?>