<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( dirname(__FILE__) ."/class.Cond.php");
include_once( dirname(__FILE__) ."/db/class.DBConnect.php");

//require("mysql.php");

class _DataRow
{
	var $_values;
	var $_old_values;
	
	var $_key = false;
	
	function _DataRow($v = false, $key = false)
	{
		if($v)
		{
			$this->_values = $v;
			$this->_old_values = $v;
		}
		else 
		{
			$this->_values = array();
			$this->_old_values = array();
		}
		
		$this->_key = $key;
		
	}
	
	function getValue($var)
	{
		if( $this->isValueSet($var) )		
		{
			return $this->_values[$var];	
		}
		return null;
	}
	
	function getAllValues()
	{
		return $this->_values;	
	}
	
	function setValue($var, $value)
	{
		$this->_values[$var] = $value;
	}
	
	function getValuesList()
	{
		return array_keys($this->_values);
	}
	
	function isValueChanged($v)
	{
		if(array_key_exists($v, $this->_values) && !array_key_exists($v, $this->_old_values))
		{
			return true;	
		}
		if(!array_key_exists($v, $this->_values) && !array_key_exists($v, $this->_old_values))
		{
			return false;
		}
		return ($this->_values[$v] !== $this->_old_values[$v]);
	}

	function isValueSet($v)
	{
		return array_key_exists($v, $this->_values);
	}
	
	function delValue($v)
	{
		unset($this->_values[$v]);
	}
	
	function save()
	{
		return true;
	}
}
//////////////////////////////// DataTable ////////////////////////////////////////////

class DataTable
{
	var $_rows;
	
	var $_new_rows = false;
	
	var $_conds = false;
	
	var $_pagenum = 0;
	var $_pagesize = 0;
	
	var $key = false;
	
	var $currentrow = 0;
	var $_num_rows = false;
	
	function DataTable( $rows = false, $key = false )
	{
		$this->_rows = array();
		if($rows && is_array($rows))
		{
			foreach ($rows as $r)
			{
				$this->addArrRow($r);
			}
		}
		$this->key = $key;
	}
	
	function getNextRow()
	{
		if( !is_array($this->_new_rows) )
		{
			$this->_selectData();	
		}
		$cr = $this->currentrow;
		if( isset($this->_new_rows[$cr]) )
		{
			$this->currentrow++;
			return $this->_new_rows[$cr];
		}
		else
		{
			return false;	
		}
	}
	
	function getNumRows()
	{
		if( !is_array($this->_new_rows) )
		{
			$this->_selectData();	
		}
		//return count($this->_new_rows);
		return $this->_num_rows;
	}
	
	function getAllNumRows()
	{
		if(is_array($this->_rows)) 
		{
			return count($this->_rows);
		}
		return false;
	}
	
	function _selectData()
	{
		if( is_array($this->_rows) )
		{
			$count_rows = 0;
			$this->_new_rows = array();
			$start_adding = $this->_pagenum * $this->_pagesize;
			$stop_adding = $start_adding + $this->_pagesize;
			if($this->_pagesize == 0)
			{
				$stop_adding = count($this->_rows);
			}
			foreach ($this->_rows as $k => $r)
			{
				if( !$this->_conds || ( is_object($this->_conds) && $this->_conds->check($r) ) )
				{
					$count_rows++;
					if( $count_rows > $start_adding )
					{
						$this->_new_rows[] = &$this->_rows[$k];
					}
					if( $count_rows >= $stop_adding )
					{
						break;
					}
				}
			}
			//$this->_num_rows = count($this->_new_rows);
			$this->_num_rows = $count_rows;
		}
	}
	
	function setConds($conds)
	{
		$this->freeResult();
		if( is_object($conds)  )
		{
			$this->_conds = $conds;
		}
	}
	

	function &getRow($cond)
	{
		if(is_array($cond))
		{
			$cond = $this->_getConds($cond);	
		}
		foreach ($this->_rows as $k => $r)
		{
			if( !$r->isRemoved() && $cond->check($r) )
			{
				return $this->_rows[$k];
			}
		}
		return false;
		//if(is_array($this->_new_rows))
		//{
		//	return $this->_new_rows[$num];
		//}
		//return false;
	}
	
	function existRow($cond)
	{
		//if(is_array($cond))
		//{
		$cond = $this->_getConds($cond);	
		//}
		foreach ($this->_rows as $r)
		{
			if($cond->check($r))
			{
				return true;
			}
		}
		return false;
	}
	
	function &addRow(&$row)
	{
		if( !$this->existRow( $this->_getConds($row->getAllValues()) ) )
		{
			$this->_rows[] = &$row;
			return $row;
		}
		return false;
	}
	
	function &addArrRow($arr)
	{

		if(is_array($arr))
		{
			$row =& new _DataRow($arr);
			
			return $this->addRow(&$row);
		}
		return false;
	}
	
	function &_getConds($arr)
	{
		if(is_object($arr) && method_exists($arr, 'check'))
		{
			//$arr = $arr->getAllValues();
			return $arr;
		}
		//if(is_object($arr) && method_exists($arr, 'getAllValues'))
		//{
		//	$arr = $arr->getAllValues();
			//return $arr;
		//}		
		$conds = new CondAND();
		//if( is_array($this->keys) && sizeof($this->keys) )
		if($this->key)
		{
			//foreach($this->keys as $k)	
			//{
			$conds->addCond( new CondEq($this->key, $arr[$this->key]) );
			//}
		}
		else 
		{
			foreach( $arr as $k => $v )
			{
				$conds->addCond( new CondEq($k, $v) );
			}
		}
		return $conds;
	}
	
	function setPageNum($pagenum)
	{
		$this->freeResult();
		settype($pagenum, 'integer');
		if($pagenum < 0)
		{
			$pagenum = 0;
		}
		$this->_pagenum = $pagenum;
	}
	
	function setPageSize($pagesize)
	{
		$this->freeResult();
		settype($pagesize, 'integer');
		if($pagesize < 0)
		{
			$pagesize = 0;
		}
		$this->_pagesize = $pagesize;
	}
	
	function freeResult()
	{
		$this->currentrow = 0;
		//unset($this->_new_rows);
		$this->_new_rows = false;
	}
	
}
//////////////////////////////// SQLDataRow ////////////////////////////////////////////

class SQLDataRow extends _DataRow 
{
	var $_table;
	
	var $db_connection = null;

	function SQLDataRow( $table, $v = false, $key = false )
	{
		$this->db_connection =& get_db_connection();
		$this->_table = $table;
		$this->_DataRow($v, $key);
	}
	
	function insert()
	{
		$fields = $this->getValuesList();
		$ufl = array();
		$uvl = array();
		foreach ($fields as $f)
		{
			if( $f != $this->_key && !is_null($this->getValue($f)) )	
			{
				$ufl[] = $f;
				$uvl[] = '\'' . $this->db_connection->Quote($this->getValue($f)) . '\'';
			}
		}
		
		$query = 'INSERT INTO ' . $this->_table . '(' . implode(",", $ufl) . ') values (' . implode(',', $uvl) . ')';
		
		$ret = $this->db_connection->Insert($query);
		
		//echo $query;
		if( $ret && $this->_key )
		{
			$this->setValue( $this->_key, $this->db_connection->getLastID() );
		}
		
		return $ret;
		//print_r($fields);
	}
	
	function update()
	{
		$fields = $this->getValuesList();
		$ul = array();
		foreach ($fields as $f)
		{
			if( $f != $this->_key && $this->isValueChanged($f) )	
			{
				$ul[] = $f . "='" . $this->db_connection->Quote($this->getValue($f)) . "'";
			}
		}
		
		$query = "update " . $this->_table . " SET " . implode(",", $ul);
		
		if($this->_key)
		{
			$co = new CondEq($this->_key, $this->getValue($this->_key));
			$query .= " WHERE " . $co->getSQL();
		}
		
		return $this->db_connection->Update($query);
		
		//echo $query;
		
		//print_r($ul);
	}
	
	function delete()
	{
		if($this->_key)
		{
			$c = new CondEq($this->_key, $this->getValue($this->_key));
			$query = "delete from " . $this->_table . ' where ' . $c->getSQL();	
			//echo $query;
			return $this->db_connection->Delete($query);
		}
	}
	
	function save()
	{
		$fields = $this->getValuesList();
		print_r($fields);
		if( $this->_key && is_null($this->getValue($this->_key)) )
		{
			$this->insert();
		}
		else 
		{
			$this->update();
		}
	}
	
}


class SQLDataTable extends DataTable 
{
	var $_table;
	
	var $_query = false;

	var $db_connection = null;
	//var $db_query_class = 'CMysqlQuery';

	var $db_query = false;
	
	var $return_fields = '*';
	
	function SQLDataTable($table, $key = false, $query = false)
	{
		$this->db_connection =& get_db_connection();
		$this->_query = $query;
		$this->_table = $table;
		$this->DataTable(false, $key);
		//echo $this->_query;
	}
	
	//function &getNextRow()
	//{
	//	if( !is_array($this->_new_rows) )
	//	{
	//		$this->_selectData();	
	//	}
	//	
	//}
	function getNumRows()
	{
		//if( !is_array($this->_new_rows) )
		//{
		//	$this->_selectData();	
		//}
		//return count($this->_new_rows);
		//echo "++++++++++++++";
		//print_r($this);
		if($this->_query)
		{
			//echo "------------";
			$q =& $this->db_connection->Select($this->_query);
			$row = $q->getNumRows();
			$q->Close();
			return $row;
		}
		$query = 'select count(*) as cnt from ' . $this->_table;
		if($this->_conds)
		{
			$query .= ' where ' . $this->_conds->getSQL();	
		}
		$q =& $this->db_connection->Select($query);
		$row = $q->nextrow();
		$q->Close();
		return $row['cnt'];
	}
	
	function _selectData()
	{
		if($GLOBALS['DEBUG']) echo "SQLDataTable::_selectData--<br>";
		$this->freeResult();
		//if( $this->_new_rows && is_array($this->_new_rows) )
		//{
		//}
		
		//echo $this->_query;
		//echo "<br>";
		if($this->_query)
		{
			$query = $this->_query;
		}
		else 
		{
			$query = 'select ' . $this->return_fields . ' from ' . $this->_table;
			if($this->_conds)
			{
				$query .= ' where ' . $this->_conds->getSQL();	
			}
		}
		//echo $query;
		//return;
		$this->db_query =& $this->db_connection->Select($query, $this->_pagesize, $this->_pagenum);
		if($this->db_query)
		{
			$this->_new_rows = array();
			while( $ar = $this->db_query->nextrow() )
			{
				$r = new SQLDataRow($this->_table, $ar, $this->key);
				//$r->changed = false;
				//$r->added = false;
				$this->_new_rows[] = $r;
			}
		}
		if($GLOBALS['DEBUG']) echo "SQLDataTable::_selectData-end-<br>";
	}
	
	function setReturnFields($fields = false)
	{
		if( is_array($fields) )
		{
			$this->return_fields = implode($fields, ',');
		}
		else 
		{
			$this->return_fields = '*';
		}
	}
	
	function freeQuery()
	{
		$this->_query = false;	
	}
	
	function freeResult()
	{
		if( is_object($this->db_query) && method_exists($this->db_query, 'Close') )	
		{
			$this->db_query->Close();
		}
		//$this->_query = false;
		$this->db_query = false;
		//unset($this->_new_rows);
		DataTable::freeResult();
	}
}

?>
