<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( dirname( __FILE__ ) . '/class.HOPermissions.php' );

/**
 * Class for manage httpd options states.
 */
class HOStates {

  var $mcServerID;
  var $mcReseller;
  var $mcUser;
  var $maOverWriteData;
  var $mcErrorMessage;

  /**
   * Constructor
   * 
   * @param string $pcServerID
   * @param string $pcReseller
   * @param string $pcUser
   * @param array $paOverWriteData
   */
  function HOStates( $pcServerID = null, $pcReseller = null, $pcUser = null, $paOverWriteData = array() ){/*{{{*/
    $this->mcServerID = $pcServerID;
    $this->mcReseller = $pcReseller;
    $this->mcUser = $pcUser;
    $this->maOverWriteData = empty( $paOverWriteData ) ? array() : $paOverWriteData;
  }
  /*}}}*/

  /**
   * Set/Get method for $this->mcServerID
   *
   * @param string $pcServerID
   * @return string $this->mcServerID
   */
    function ServerID( $pcServerID = null ){/*{{{*/
    if( is_string( $pcServerID ) ){
      $this->mcServerID = $pcServerID;
    }
    return $this->mcServerID;
  }/*}}}*/

  /**
   * Set/Get method for $this->mcReseller
   *
   * @param string $pcReseller
   * @return string $this->mcReseller
   */
  function Reseller( $pcReseller = null ){/*{{{*/
    if( is_string($pcReseller ) ){
      $this->mcReseller = $pcReseller;
    }
    return $this->mcReseller;
  }/*}}}*/

  /**
   * Set/Get method for $this->mcUser
   *
   * @param string $pcUser
   * @return string $this->mcUser
   */
  function User( $pcUser = null ){/*{{{*/
    if( is_string($pcUser ) ){
      $this->mcUser = $pcUser;
    }
    return $this->mcUser;
  }/*}}}*/

/**
 * OverWrirte methods
 */

  /**
   * Set/Get method for $this->maOverWriteData from
   * array ( 5 => 25, ... ), where 5 - is httpd option id, 
   * 25 - is httpd option state id.
   *
   * @param  array $paOverWriteData
   * @return array $this->maOverWriteData
   */
  function OverWriteData( $paOverWriteData = null ){/*{{{*/
    if( is_array($paOverWriteData ) ){
      $this->maOverWriteData = $paOverWriteData;
    }
    return $this->maOverWriteData;
  }/*}}}*/

  /**
   * Set/Get method for $this->maOverWriteData from domain
   * If $pmDomain is not a array or numeric return false
   *
   * @param  mixed $pmDomain
   * @return bool
   */
  function OverWriteDataForDomain( $pmDomain ){/*{{{*/

    if( ! ( is_string( $pmDomain ) || is_numeric( $pmDomain ) ) ){
      return false;
    }

    if( ! is_numeric( $pmDomain ) ){
      $lrId = safe_query2( "SELECT id FROM domains WHERE domain=? 
                            AND server_id=? AND richtigedomain NOT IN (5,7)", 
                            new SQLString( $pmDomain ), 
                            new SQLString( $this->mcServerID ) );
  		list( $pmDomain ) = db_fetch_array( $lrId );
    	db_free_query( $lrId );
    }
    
    if( ! $this->mcUser ){
      $lcUser = $this->findUserByDomain( $pmDomain );
    }else{
      $lcUser = $this->mcUser;
    }

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $lcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }
    

    $this->maOverWriteData = array();
    $lrId = safe_query2( "SELECT httpd_id, state FROM httpd_entries 
                          WHERE reseller=? AND user=? AND domain_id  = ? AND server_id =?",
                          new SQLString( $lcReseller ), 
                          new SQLString( $lcUser ), 
                          new SQLString( $pmDomain ), 
                          new SQLString( $this->mcServerID ) );
    while( $laRow = db_fetch_array( $lrId, 'A' ) ){
      $this->maOverWriteData[$laRow['httpd_id']] = $laRow['state'];
    }
    db_free_query( $lrId );

    return true;
  }/*}}}*/

  /**
   * Factory for SetOfRowsOfData for domain.generate SetOfRowsOfData of httpd
   * options states for domain.
   * If $pmDomain is not null, overwrite data for it.
   *
   * @param  mixed $pmDomain
   * @return SetOfRowsOfSata $loData
   */
  function & getSORDForDomain( $pmDomain = null ){/*{{{*/

    include_once( dirname(__FILE__) . "/elements/data/class.SetOfRowsData.php" );/*{{{*/
    include_once( dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ShellServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.OptionsDataField.php" );
/*}}}*/

    if( ! is_null( $pmDomain )  ){
      $this->OverWriteDataForDomain( $pmDomain );
    }
  
    $loData = new SetOfRowsData();
    $loServerID = new SQLString( $this->mcServerID );

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();

    foreach( $laPerms as $liId => $lcLabel ){
       $lrId2 = safe_query2( "SELECT id, label FROM httpd_states WHERE httpd_id = ?",
                              new SQLInteger( $liId ) );
       $sel_action = array();
  
       while( $laStates = db_fetch_array( $lrId2, 'A' ) ){
         $sel_action[$laStates['id']] = $laStates['label'];
       }
  
       $sel_action[0] = ltext('httpd_options_not_set');

       db_free_query( $lrId2 );

       $action_field = new OptionsDataField( $sel_action,
                                    array_key_exists( $liId, $this->maOverWriteData ) 
                                    ? $this->maOverWriteData[$liId] 
                                    : 0, "httpd_ids[$liId]", cc_RadioGroupPresentation );
       $loData->AppendRow(new HTMLDataField( $lcLabel), $action_field );
       $loData->AppendRow(new HTMLDataField( '<hr>', false, array(), array( 'colspan' => 2 ) ) );
    }
   
    return $loData; 
  }/*}}}*/
 /**
   * Wrapper for getSORD()  
   */
  function & getSORDForUser(){
    return $this->getSORD();
  }

  /**
   * Wrapper for getSORD()  
   */  
  function & getSORDForReseller(){
    return $this->getSORD(); 
 }

  /**
   * Factory for SetOfRowsOfSata. Generate SetOfRowsOfData of httpd options
   * states for current Confixx.
   * user.
   *
   * @return SetOfRowsOfSata $loData
   */
  function & getSORD(){/*{{{*/

    include_once( dirname(__FILE__) . "/elements/data/class.SetOfRowsData.php" );/*{{{*/
    include_once( dirname(__FILE__) . "/elements/data/class.HTMLDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.ShellServiceDataField.php" );
    include_once( dirname(__FILE__) . "/elements/data/class.OptionsDataField.php" );
/*}}}*/

    $loData = new SetOfRowsData();

    $loServerID = new SQLString( $this->mcServerID );

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();

     foreach( $laPerms as $liId => $lcLabel ){
         $lrId2 = safe_query2( "SELECT id, label FROM httpd_states WHERE httpd_id = ?",
                                new SQLInteger( $liId ) );
         $sel_action = array();

         while( $laStates = db_fetch_array( $lrId2, 'A' ) ){
           $sel_action[$laStates['id']] = $laStates['label'];
         }

         $sel_action['0'] = ltext('httpd_options_not_set');
         $sel_action['-1'] = ltext('httpd_options_do_not_change');

         db_free_query( $lrId2 );

         $action_field = new OptionsDataField( $sel_action, '-1', "httpd_ids[$liId]", cc_RadioGroupPresentation );
         $loData->AppendRow(new HTMLDataField( $lcLabel ), $action_field );
         $loData->AppendRow(new HTMLDataField( '<hr>', false, array(), array( 'colspan' => 2 ) ) );
      }
    return $loData; 
 }/*}}}*/

  /**
   * Get array of options for domain 
   * Example, array ( 5 => array( 'label' => 'Foo option', 'state' => array(
   * 'label' => 'test', 'id' => 6 ) )
   *
   * @param numeric $piDomain
   * @return array $laOptions
   */
  function getOptionsForDomain( $piDomain = null ){/*{{{*/

    $laOptions = array();

    if( ! is_numeric( $piDomain ) ){
      return false;
    }

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();
    
    $loServerID = new SQLString( $this->mcServerID );
    $loDomain   = new SQLInteger( $piDomain );

    if( ! $this->mcUser ){
      $lcUser = $this->findUserByDomain( $piDomain );
    }else{
      $lcUser = $this->mcUser;
    }

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $lcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }
    
    $loReseller = new SQLString( $lcReseller );
    $loUser     = new SQLString( $lcUser );

    foreach( $laPerms as $liId => $lcLabel ){
      $lrId = safe_query2( " SELECT e.state, s.label FROM httpd_entries e, httpd_states s".
                           " WHERE e.reseller=? AND e.user=? AND e.domain_id = ? AND e.server_id=? ".
                           " AND e.httpd_id=? AND e.state=s.id",
                            $loReseller,
                            $loUser,
                            $loDomain,
                            $loServerID, 
                            new SQLString( $liId ) 
                          );
     $laRow = db_fetch_array( $lrId, 'A' );
     $liCount = db_num_rows( $lrId );
     db_free_query($lrId );

     if( $liCount ){
        $laOptions[$liId] = array( 'label' => $lcLabel, 
                                   'state' => array( 'id' => $laRow['state'], 
                                                     'label' => $laRow['label'] ) );
      }
    }
    return $laOptions; 
  }/*}}}*/

 /**
  * Save data methods
  */

  /**
   * Sets httpd options states for domain
   *
   * @param mixed $pmDomain
   * @param array $paData
   * @return bool
   */
  function setForDomain( $pmDomain, $paData  ){/*{{{*/

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();
 
    if( ! $this->mcUser ){
      $lcUser = $this->findUserByDomain($pmDomain );
    }else{
      $lcUser = $this->mcUser;
    }

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $lcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }

    if( ! $this->checkOwnershipOfDomain( $pmDomain ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this domain';
      return false;
    }

    $loServerID = new SQLString( $this->mcServerID );
    $loReseller = new SQLString( $lcReseller );
    $loUser     = new SQLString( $lcUser );
    
    $laTmp = $paData;
    
    foreach( $laTmp as $id => $value ){
        if( ! array_key_exists( $id, $laPerms ) ){
            unset( $paData[$id] );
        }
    }
    
    $laTmp = $paData;
    
    /**
     * "Not set"
     */
    foreach( $paData as $id => $value ){
      if( ! $value ){
        safe_query2( "DELETE FROM httpd_entries 
                      WHERE reseller=? AND user=? AND domain_id = ? AND httpd_id = ?  AND server_id = ?", 
                      $loReseller,
                      $loUser,
                      new SQLInteger( $pmDomain ), 
                      new SQLInteger( $id ), 
                      $loServerID );
        unset( $laTmp[$id] );
      }
    }
    
    $paData = $laTmp;
    
    /**
     * Update
     */
    $lrId = safe_query2( " SELECT id, state, httpd_id FROM httpd_entries ".
                         " WHERE type = 0 AND reseller=? AND user=? AND domain_id=? AND server_id=? ",
                         $loReseller,
                         $loUser,
                         new SQLInteger( $pmDomain ),
                         $loServerID );

    while( $laRow = db_fetch_array( $lrId, 'A' ) ){
      if( isset( $paData[$laRow['httpd_id']] ) 
          && $laRow['state'] != $paData[$laRow['httpd_id']] ){
        safe_query2( "UPDATE httpd_entries SET state = ? WHERE reseller=? AND user=? AND  id = ? AND server_id=?",
                      new SQLInteger( $paData[$laRow['httpd_id']] ),
                      $loReseller,
                      $loUser,
                      new SQLInteger( $laRow['id'] ),
                      $loServerID );
        
      }   
      unset($laTmp[$laRow['httpd_id']]);
    }
    db_free_query( $lrId );
    
    $paData = $laTmp;

    foreach( $laTmp as $id => $value ){
      safe_query2( "INSERT httpd_entries SET httpd_id=?, domain_id=?, state =?, 
                    reseller=?, user=?, server_id=?  ", 
                    new SQLInteger( $id ), 
                    new SQLInteger( $pmDomain ), 
                    new SQLInteger( $value ),
                    $loReseller, 
                    $loUser, 
                    $loServerID );
    }
    return true;
  }/*}}}*/

  /**
   * Sets httpd options states for user
   *
   * @param string $pcUser
   * @param array $paData
   * @param  bool $piAll
   * @return bool
   */
  function setForUser( $pcUser, $paData, $piAll = 0 ){/*{{{*/

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();

    /**
     * Do not change
     */
    $laTmp = $paData;
  
    foreach( $laTmp as $id => $value ){
        if( ! array_key_exists( $id, $laPerms ) ){
            unset( $paData[$id] );
        }
    }
    
    $laTmp = $paData;

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $pcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }
    
    if( ! $this->checkOwnershipOfUser( $pcUser ) ){
      $this->mcErrorMessage = 'You does not have permissions use this user';
      return false;
    }

    foreach( $paData as $id => $value ){
      if( $value == -1 ){
        unset( $laTmp[$id] );
      }
    }
    $paData = $laTmp;
    /**
     * "Not setted"
     */
    foreach( $paData as $id => $value ){
      if( ! $value ){
        safe_query2( "DELETE FROM httpd_entries WHERE user  = ? AND type=0 AND httpd_id = ?  AND server_id = ?", 
                      new SQLString( $pcUser ), 
                      new SQLInteger( $id ), 
                      new SQLString( $this->mcServerID ) );
        unset( $laTmp[$id] );
      }
    }
    
    $paData = $laTmp;

    /**
     * Template
     */
    if( $piAll ){
      safe_query2( "DELETE FROM httpd_entries WHERE user  = ? AND type=1 AND server_id = ?", 
                      new SQLString( $pcUser ), 
                      new SQLString( $this->mcServerID ) );
     
      foreach( $paData as $id => $value ){
        safe_query2( " INSERT INTO httpd_entries SET httpd_id =?, state = ?, user =?, reseller =? , type = 1, server_id=?",
                        new SQLInteger( $id ),
                        new SQLInteger( $value ),
                        new SQLString( $pcUser ), 
                        new SQLString( $lcReseller ),                       
                        new SQLString( $this->mcServerID ) 
                      );
          
      }     
    }


    /**
     * Update
     */
    foreach( $paData as $id => $value ){
       safe_query2( " UPDATE httpd_entries SET state = ? ".
                    " WHERE user = ? AND httpd_id = ? AND type = 0 AND state <> ? AND server_id=?",
                      new SQLInteger( $value ),
                      new SQLString( $pcUser ), 
                      new SQLInteger( $id ), 
                      new SQLInteger( $value ),
                      new SQLString( $this->mcServerID ) 
                    );
    }     

    /**
     * Insert new entries
     */
    foreach( $paData as $id => $value ){
      $lrId = safe_query2(" SELECT d.id, d.domain,d.anbieter, h.httpd_id FROM domains d ".
                          " LEFT JOIN httpd_entries h ON d.id=h.domain_id AND d.server_id = h.server_id AND h.httpd_id=?  ".
                          " WHERE d.richtigedomain NOT IN (5,7) AND  d.kunde = ? AND h.httpd_id IS NULL AND d.server_id=?",
                          new SQLInteger( $id ),
                          new SQLString( $pcUser ),
                          new SQLString( $this->mcServerID )    
                        );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        safe_query2( "INSERT httpd_entries SET httpd_id=?, domain_id=?, state =?, 
                      reseller=?, user=?, server_id=?  ", 
                      new SQLInteger( $id ), 
                      new SQLInteger( $laRow['id'] ), 
                      new SQLInteger( $value ),
                      new SQLString( $laRow['anbieter'] ), 
                      new SQLString( $pcUser ), 
                      new SQLString( $this->mcServerID ) );
      }
      db_free_query( $lrId );
    }
    return true;
  }/*}}}*/

  /**
   * Sets httpd options states for reseller
   *
   * @param string $pcReseller
   * @param array $paData
   * @param  bool $piAll
   * @return bool
   */
  function setForReseller( $pcReseller, $paData, $piAll  ){/*{{{*/

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();

    /**
     * Do not change
     */
    $laTmp = $paData;
  
    foreach( $laTmp as $id => $value ){
        if( ! array_key_exists( $id, $laPerms ) ){
            unset( $paData[$id] );
        }
    }
    
    $laTmp = $paData;

    if( ! $this->checkOwnershipOfReseller( $pcReseller ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this reseller';
      return false;
    }

    foreach( $paData as $id => $value ){
      if( $value == -1 ){
        unset( $laTmp[$id] );
      }
    }
    $paData = $laTmp;

    /**
     * "Not setted"
     */
    foreach( $paData as $id => $value ){
      if( ! $value ){
        safe_query2( " DELETE FROM httpd_entries WHERE reseller =? ".
                     " AND type = 0 AND httpd_id = ? AND server_id = ?", 
                      new SQLString( $pcReseller ), 
                      new SQLInteger( $id ), 
                      new SQLString( $this->mcServerID ) );
        unset( $laTmp[$id] );
      }
    }
    
    $paData = $laTmp;

    /**
     * Template
     */
    if( $piAll ){
      safe_query2( "DELETE FROM httpd_entries WHERE reseller =? AND user  = '' AND type=1 AND server_id = ?", 
                      new SQLString( $pcReseller ), 
                      new SQLString( $this->mcServerID ) );
     
      foreach( $paData as $id => $value ){
        safe_query2( " INSERT INTO httpd_entries SET httpd_id =?, state = ?, reseller =? , type = 1, server_id=?",
                        new SQLInteger( $id ),
                        new SQLInteger( $value ),
                        new SQLString( $pcReseller ),                       
                        new SQLString( $this->mcServerID ) 
                      );
      }     
    }

    /**
     * Update
     */
    foreach( $paData as $id => $value ){
       safe_query2( " UPDATE httpd_entries SET state = ? ".
                    " WHERE reseller = ? AND httpd_id =? AND type = 0 AND state <> ? AND server_id=?",
                      new SQLInteger( $value ),
                      new SQLString( $pcReseller ), 
                      new SQLInteger( $id ),
                      new SQLInteger( $value ),
                      new SQLString( $this->mcServerID ) 
                    );
    }     

    /**
     * Insert new entries
     */
    foreach( $paData as $id => $value ){
      $lrId = safe_query2(" SELECT d.id, d.domain,d.kunde, h.httpd_id FROM domains d ".
                          " LEFT JOIN httpd_entries h ON d.id=h.domain_id AND d.server_id = h.server_id AND h.httpd_id=?  ".
                          " WHERE d.richtigedomain NOT IN (5,7) AND d.anbieter = ? AND h.httpd_id IS NULL AND d.server_id=?",
                          new SQLInteger( $id ),
                          new SQLString( $pcReseller ),
                          new SQLString( $this->mcServerID )    
                        );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        safe_query2( "INSERT httpd_entries SET httpd_id=?, domain_id=?, state =?, 
                      reseller=?, user=?, server_id=?  ", 
                      new SQLInteger( $id ), 
                      new SQLInteger( $laRow['id'] ), 
                      new SQLInteger( $value ),
                      new SQLString( $pcReseller ), 
                      new SQLString( $laRow['kunde'] ), 
                      new SQLString( $this->mcServerID ) );
      }
      db_free_query( $lrId );
    }
    return true;
  }/*}}}*/
  
  /**
   * Sets httpd options states for server
   *
   * @param array $paData
   * @param  bool $piAll
   * @return bool
   */
  function setForServer( $paData, $piAll  ){/*{{{*/

    $loHOPermissions = new HOPermissions( $this->mcServerID, $this->mcReseller, $this->mcUser );
    $laPerms = $loHOPermissions->getPermissions();

    /**
     * Do not change
     */
    $laTmp = $paData;
  
    foreach( $laTmp as $id => $value ){
        if( ! array_key_exists( $id, $laPerms ) ){
            unset( $paData[$id] );
        }
    }
    
    $laTmp = $paData;

    foreach( $paData as $id => $value ){
      if( $value == -1 ){
        unset( $laTmp[$id] );
      }
    }
    $paData = $laTmp;

    /**
     * "Not setted"
     */
    foreach( $paData as $id => $value ){
      if( ! $value ){
        safe_query2( " DELETE FROM httpd_entries WHERE  ".
                     " type = 0 AND httpd_id = ? AND server_id = ?", 
                      new SQLInteger( $id ), 
                      new SQLString( $this->mcServerID ) );
        unset( $laTmp[$id] );
      }
    }
    
    $paData = $laTmp;

    /**
     * Template
     */
    if( $piAll ){
      safe_query2( "DELETE FROM httpd_entries WHERE reseller = '' AND user  = '' AND type=1 AND server_id = ?", 
                      new SQLString( $this->mcServerID ) );
     
      foreach( $paData as $id => $value ){
        safe_query2( " INSERT INTO httpd_entries SET httpd_id =?, state = ? , type = 1, server_id=?",
                        new SQLInteger( $id ),
                        new SQLInteger( $value ),
                        new SQLString( $this->mcServerID ) 
                      );
      }     
    }

    /**
     * Update
     */
    foreach( $paData as $id => $value ){
       safe_query2( "UPDATE httpd_entries SET state = ? WHERE type = 0 AND httpd_id=? AND state <> ? AND server_id=?",
                      new SQLInteger( $value ),
                      new SQLInteger( $id ),
                      new SQLInteger( $value ),
                      new SQLString( $this->mcServerID ) 
                    );
    }     
    /**
     * Insert new entries
     */
    foreach( $paData as $id => $value ){

      $lrId = safe_query2(" SELECT d.id, d.domain, d.anbieter, d.kunde, h.httpd_id FROM domains d ".
                          " LEFT JOIN httpd_entries h ON d.id=h.domain_id AND d.server_id = h.server_id ".
                          " AND h.type= 0 AND h.httpd_id=?  ".
                          " WHERE d.richtigedomain NOT IN (5,7) AND h.httpd_id IS NULL ".
                          " AND d.server_id=? and d.richtigedomain NOT IN ( 5,7) ",
                          new SQLInteger( $id ),
                          new SQLString( $this->mcServerID )    
                        );

      $liBuffer = 2;
      $i = 0;
      $laBuffer = array();
      $liCount = db_num_rows( $lrId );  
      
      $liCounter = 0;

      while( $laRow = db_fetch_array( $lrId, 'A' ) ){

       if( ( $i >= $liBuffer || $liCounter == ($liCount - 1 ) ) 
         && ! empty( $laBuffer ) ){

           $laBuffer[] = $laRow;

          $laSQL = array();
          $laArgs = array();         
          $lcSQL = "INSERT INTO httpd_entries (httpd_id, domain_id, state, reseller, user, server_id ) VALUES " ;

          foreach( $laBuffer as $laBufRow ){
            $laSQL[] = " (?, ?,?,?,?,?) ";
            $laArgs[] =  new SQLInteger( $id );
            $laArgs[] =  new SQLInteger( $laBufRow['id'] );
            $laArgs[] =  new SQLInteger( $value );
            $laArgs[] =  new SQLString( $laBufRow['anbieter'] );
            $laArgs[] =  new SQLString( $laBufRow['kunde'] );
            $laArgs[] =  new SQLString( $this->mcServerID );
          }  

          $lcSQL .= implode(', ', $laSQL );
          array_unshift($laArgs, $lcSQL );
          call_user_func_array( 'safe_query2', $laArgs );
          $i = 0;
          $laBuffer = array();
        }else{
          $laBuffer[] = $laRow;
          $i++;
        }
        $liCounter++;
      }
      db_free_query( $lrId );
    }
    return true;
  }/*}}}*/
 
  /**
   * Sets httpd options states for all servers of Data Center
   *
   * @param array $paData
   * @param  bool $piAll
   * @return bool
   */
  function setForAllServers( $paData, $piAll  ){/*{{{*/
    /**
     * Do not change
     */
    $laTmp = $paData;
  
    foreach( $paData as $id => $value ){
      if( $value == -1 ){
        unset( $laTmp[$id] );
      }
    }
    $paData = $laTmp;

    /**
     * "Not setted"
       */
    foreach( $paData as $id => $value ){
      if( ! $value ){
        safe_query2( " DELETE FROM httpd_entries WHERE  ".
                     " type = 0 AND httpd_id = ?", 
                      new SQLInteger( $id )
                    );
        unset( $laTmp[$id] );
      }
    }
    
    $paData = $laTmp;

    /**
     * Template
     */
    if( $piAll ){
      safe_query2( "DELETE FROM httpd_entries WHERE reseller = '' 
                    AND user  = '' AND server_id = '' AND type=1" );
     
      foreach( $paData as $id => $value ){
        safe_query2( " INSERT INTO httpd_entries SET httpd_id =?, state = ? , type = 1, server_id=''",
                        new SQLInteger( $id ),
                        new SQLInteger( $value )
                      );
      }     
    }

    /**
     * Update
     */
    foreach( $paData as $id => $value ){
       safe_query2( "UPDATE httpd_entries SET state = ? WHERE type = 0 AND httpd_id=? AND state <> ?",
                      new SQLInteger( $value ),
                      new SQLInteger( $id ),
                      new SQLInteger( $value )
                    );
    }     
    /**
     * Insert new entries
     */
    foreach( $paData as $id => $value ){

      $lrId = safe_query2(" SELECT d.id, d.domain, d.anbieter, d.kunde, d.server_id, h.httpd_id FROM domains d ".
                          " LEFT JOIN httpd_entries h ON d.id=h.domain_id AND d.server_id = h.server_id ".
                          " AND h.type= 0 AND h.httpd_id=?  ".
                          " WHERE d.richtigedomain NOT IN (5,7 ) AND h.httpd_id IS NULL  AND d.richtigedomain NOT IN ( 5,7) ",
                          new SQLInteger( $id )
                        );

      $liBuffer = 2;
      $i = 0;
      $laBuffer = array();
      $liCount = db_num_rows( $lrId );  
      
      $liCounter = 0;

      while( $laRow = db_fetch_array( $lrId, 'A' ) ){

       if( ( $i >= $liBuffer || $liCounter == ($liCount - 1 ) ) 
         && ! empty( $laBuffer ) ){

           $laBuffer[] = $laRow;

          $laSQL = array();
          $laArgs = array();         
          $lcSQL = "INSERT INTO httpd_entries (httpd_id, domain_id, state, reseller, user, server_id ) VALUES " ;

          foreach( $laBuffer as $laBufRow ){
            $laSQL[] = " (?, ?,?,?,?,?) ";
            $laArgs[] =  new SQLInteger( $id );
            $laArgs[] =  new SQLInteger( $laBufRow['id'] );
            $laArgs[] =  new SQLInteger( $value );
            $laArgs[] =  new SQLString( $laBufRow['anbieter'] );
            $laArgs[] =  new SQLString( $laBufRow['kunde'] );
            $laArgs[] =  new SQLString( $laBufRow['server_id'] );
          }  

          $lcSQL .= implode(', ', $laSQL );
          array_unshift($laArgs, $lcSQL );
          call_user_func_array( 'safe_query2', $laArgs );
          $i = 0;
          $laBuffer = array();
        }else{
          $laBuffer[] = $laRow;
          $i++;
        }
        $liCounter++;
      }
      db_free_query( $lrId );
    }
    return true;
  }/*}}}*/

/**
 * Set default values methods
 */
 
  /**
   * Sets default httpd options states for domain. Default httpd options states
   * may be for all servers/server/reseller/user
   *
   * @param mixed $pmDomain
   * @return bool
   */
  function setDefaultsForDomain( $pmDomain ){/*{{{*/
    global $DEBUG;
    
    $loServerID = new SQLString( $this->mcServerID );

    if( ! is_numeric( $pmDomain ) ){
      $lrId = safe_query2( "SELECT id FROM domains 
                            WHERE domain = ? AND richtigedomain NOT IN (5,7)  AND server_id=? ", 
                           new SQLString( $pmDomain ), $loServerID );
      list( $pmDomain ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    } 
    if( ! $this->mcUser ){
      $lcUser = $this->findUserByDomain($pmDomain );
    }else{
      $lcUser = $this->mcUser;
    }

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $lcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }

    if( ! $this->checkOwnershipOfDomain( $pmDomain ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this domain.';
      return false;
    }
    
    $loReseller = new SQLString( $lcReseller );
    $loUser     = new SQLString( $lcUser );

    if( $this->mcReseller && $this->mcUser ){
      $lrId = safe_query2( "SELECT * FROM httpd_entries 
                            WHERE ( reseller = ? OR reseller = '') AND (user =? OR user ='' )
                            AND type = 1 AND ( server_id = ? OR server_id = '' ) GROUP BY httpd_id",
                            $loReseller,$loUser, $loServerID );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        $laData[$laRow['httpd_id']] = $laRow['state'];
      }
      db_free_query( $lrId );
      
    }elseif( $this->mcReseller ){
      $lrId = safe_query2( "SELECT * FROM httpd_entries 
                            WHERE ( reseller = ? OR reseller = '')
                            AND type = 1 AND ( server_id = ? OR server_id = '' ) GROUP BY httpd_id",
                            $loReseller, $loServerID );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        $laData[$laRow['httpd_id']] = $laRow['state'];
      }
      db_free_query( $lrId );
    }else{
      $laData = array();
    }

    if( empty( $laData ) ){
      $laData = array();
    }

    foreach( $laData as $id => $value ){
      safe_query2( "INSERT httpd_entries SET httpd_id=?, domain_id=?, state =?, 
                    reseller=?, user=?, server_id=?  ", 
                    new SQLInteger( $id ), 
                    new SQLInteger( $pmDomain ), 
                    new SQLInteger( $value ),
                    $loReseller, 
                    $loUser, 
                    $loServerID );
    }
    return true;
  }/*}}}*/

  /**
   * Sets default httpd options states for all of user domains. Default httpd options states
   * may be for all servers/server/reseller/
   *
   * @param  string $pcUser
   * @return bool
   */
  function setDefaultsForUser( $pcUser  ){/*{{{*/

    $loUser     = new SQLString( $pcUser );
    $loServerID = new SQLString( $this->mcServerID );

    $laData = array();

    if( ! $this->checkOwnershipOfUser( $pcUser ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this user.';
      return false;
    }
 
    if( $this->mcReseller ){
      $loReseller = new SQLString( $this->mcReseller );
      $lrId = safe_query2( "SELECT * FROM httpd_entries 
                            WHERE ( reseller = ? OR reseller = '') AND type = 1 AND ( server_id = ? OR server_id = '' )",
                            $loReseller, $loServerID );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        $laData[$laRow['httpd_id']] = $laRow['state'];
      }
      db_free_query( $lrId );
    }

    foreach( $laData as $id => $value ){
      $lrId = safe_query2(" SELECT d.id, d.domain,d.anbieter FROM domains d ".
                          " WHERE  d.kunde = ? AND d.richtigedomain NOT IN (5, 7)  AND d.server_id=?",
                          $loUser,
                          $loServerID     
                        );
      while( $laRow = db_fetch_array( $lrId, 'A' ) ){
        safe_query2( "INSERT httpd_entries SET httpd_id=?, domain_id=?, state =?, 
                      reseller=?, user=?, server_id=?  ", 
                      new SQLInteger( $id ), 
                      new SQLInteger( $laRow['id'] ), 
                      new SQLInteger( $value ),
                      new SQLString( $laRow['anbieter'] ), 
                      $loUser, 
                      $loServerID );
      }
      db_free_query( $lrId );
    }
    return true;
  }/*}}}*/


/**
 * Drop  methods
 */

  /**
   * Drop all httpd options states for user.
   *
   * @param  string $pcUser
   * @return bool
   */
  function dropForUser( $pcUser  ){/*{{{*/

    if( ! $this->mcReseller ){
      $lcReseller = $this->findResellerByUser( $pcUser );
    }else{
      $lcReseller = $this->mcReseller;
    }
 
    if( ! $this->checkOwnershipOfUser( $pcUser ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this user.';
      return false;
    }
       
    safe_query2( "DELETE FROM httpd_entries WHERE user  = ? AND reseller=? AND server_id = ?", 
                  new SQLString( $pcUser ), 
                  new SQLString( $lcReseller ), 
                  new SQLString( $this->mcServerID ) );
    return true;   
  }/*}}}*/

  /**
   * Drop all httpd options states for domain.
   *
   * @param  mixed $pmDomain
   * @return bool
   */
  function dropForDomain( $pmDomain  ){/*{{{*/

   $loServerID = new SQLString( $this->mcServerID );   

   if( ! is_numeric( $pmDomain ) ){
      $lrId = safe_query2( "SELECT id FROM domains WHERE domain = ? AND richtigedomain NOT IN (5,7) AND server_id=? ", 
                           new SQLString( $pmDomain ), 
                           $loServerID );
      list( $pmDomain ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }
 
    if( ! $this->checkOwnershipOfDomain( $pmDomain ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this domain.';
      return false;
    }
      
    safe_query2( "DELETE FROM httpd_entries WHERE domain_id  = ?  AND server_id = ?", 
                      new SQLString( $pmDomain ), 
                      $loServerID );
    return true;   
  }/*}}}*/

  /**
   * Drop all httpd options states for reseller.
   *
   * @param  string $pcReseller
   * @return bool
   */
  function dropForReseller( $pcReseller  ){/*{{{*/

    if( ! $this->checkOwnershipOfReseller( $pcReseller ) ){
      $this->mcErrorMessage = 'You does not have permissions to use this reseller.';
      return false;
    }
 
    safe_query2( "DELETE FROM httpd_entries WHERE reseller=? AND server_id = ?", 
                  new SQLString( $pcReseller ), 
                  new SQLString( $this->mcServerID ) );
    return true;   
  }/*}}}*/


  /**
   * Move states from source reseller for all or specified users
   *
   * @param string $pcSReseller
   * @param string $pcSServerID
   * @param array|string $pmUsers
   * @return bool
   */
  function moveFromReseller( $pcSReseller, $pcSServerID = null, $pmUsers = null ){/*{{{*/
    
    if( empty( $pcSReseller ) ){
      $this->mcErrorMessage = 'Empty pcSReseller in HOStates::moveFromReseller call';
      return false;
    }

    if( is_null( $pcSServerID ) ){
      $pcSServerID = $this->mcServerID;
    }

    $loSServerID = new SQLString( $pcSServerID );
    $loSReseller = new SQLString( $pcSReseller );
    $loReseller  = new SQLString( $this->mcReseller );
    $loServerID  = new SQLString( $this->mcServerID );

    // Move states of all users
    if( is_null( $pmUsers ) ){
      safe_query2( "UPDATE httpd_entries SET reseller = ?, server_id = ? 
                    WHERE user != '' AND reseller = ? AND server_id = ?",
                    $loReseller, 
                    $loServerID, 
                    $loSReseller, 
                    $loSServerID 
                  );
    // Move states for some users
    }elseif( is_array( $pmUsers ) ){
      foreach( $pmUsers as $pcUser  ){
        safe_query2( "UPDATE httpd_entries SET reseller = ?, server_id = ? 
                      WHERE user = ? AND reseller = ? AND server_id = ?",
                      $loReseller, 
                      $loServerID, 
                      new SQLString($pcUser ),
                      $loSReseller, 
                      $loSServerID 
                    );
      }
    // Move states for one user
    }elseif( is_string( $pmUsers ) ){
      safe_query2( "UPDATE httpd_entries SET reseller = ?, server_id = ? 
                          WHERE user = ? AND reseller = ? AND server_id = ?",
                          $loReseller, 
                          $loServerID, 
                          new SQLString($pmUsers ),
                          $loSReseller, 
                          $loSServerID 
                        );
    }

    return true;
  }/*}}}*/

/**
 * Ownership methods
 */

  /**
   * Checks ownership of domain for current Confixx user
   *
   * @param int $piDomain
   * @return bool
   */
  function checkOwnershipOfDomain( $piDomain ){/*{{{*/
    $lbIsOwner = false;
    
    if( $this->mcServerID && $this->mcReseller && $this->mcUser ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM domains 
                            WHERE id = ? AND richtigedomain NOT IN (5,7) AND anbieter=? AND kunde=? AND server_id=?",
                            new SQLInteger( $piDomain ),
                            new SQLString( $this->mcReseller ),
                            new SQLString( $this->mcUser ),
                            new SQLString( $this->mcServerID )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }elseif( $this->mcServerID && $this->mcReseller ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM domains 
                              WHERE id = ? AND richtigedomain NOT IN (5,7) AND anbieter=? AND server_id=?",
                              new SQLInteger( $piDomain ),
                              new SQLString( $this->mcReseller ),
                              new SQLString( $this->mcServerID )
                              );
        list( $liCount ) = db_fetch_array( $lrId, 'N' );
        db_free_query( $lrId );
    }elseif( $this->mcServerID && $this->mcUser ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM domains 
                            WHERE id = ? AND richtigedomain NOT IN (5,7) AND kunde=? AND server_id=?",
                            new SQLInteger( $piDomain ),
                            new SQLString( $this->mcUser ),
                            new SQLString( $this->mcServerID )
                              );
        list( $liCount ) = db_fetch_array( $lrId, 'N' );
        db_free_query( $lrId );
    }elseif( $this->mcServerID ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM domains 
                            WHERE id = ? AND richtigedomain NOT IN (5,7) AND server_id=?",
                            new SQLInteger( $piDomain ),
                            new SQLString( $this->mcServerID )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }else{
      $lrId = safe_query2( "SELECT COUNT(*) FROM domains 
                            WHERE id = ? AND richtigedomain NOT IN (5,7)",
                            new SQLInteger( $piDomain )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }

    $lbIsOwner = (bool) $liCount;
    return $lbIsOwner;
  
  }/*}}}*/

  /**
   * Checks ownership of user for current Confixx user
   *
   * @param  string $pcUser
   * @return bool
   */
  function checkOwnershipOfUser( $pcUser ){/*{{{*/
    $lbIsOwner = false;
    $liCount   = 0;

    if( $this->mcServerID && $this->mcReseller && $this->mcUser ){
      if( $this->mcUser == $pcUser ){
        $liCount = 1;
      }
    }elseif( $this->mcServerID && $this->mcReseller ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM kunden 
                             WHERE  anbieter=? AND kunde = ? AND server_id=?",
                              new SQLString( $this->mcReseller ),
                              new SQLString( $pcUser ),
                              new SQLString( $this->mcServerID )
                              );
        list( $liCount ) = db_fetch_array( $lrId, 'N' );
        db_free_query( $lrId );
    }elseif( $this->mcServerID && $this->mcUser ){
      if( $this->mcUser == $pcUser ){
        $liCount = 1;
      }
    }elseif( $this->mcServerID ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM kunden
                            WHERE kunde = ? AND server_id=?",
                            new SQLString( $pcUser ),
                            new SQLString( $this->mcServerID )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }else{
      $lrId = safe_query2( "SELECT COUNT(*) FROM kunden
                            WHERE kunde = ?",
                            new SQLString( $pcUser )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }

    $lbIsOwner = (bool) $liCount;
    return $lbIsOwner;
  }/*}}}*/

  /**
   * Checks ownership of reseller for current Confixx user
   *
   * @param  string $pcReseller
   * @return bool
   */
  function checkOwnershipOfReseller( $pcReseller ){/*{{{*/
    $lbIsOwner = false;
    $liCount   = 0;

    if( $this->mcServerID && $this->mcReseller ){
      if( $this->mcReseller == $pcReseller ){
        $liCount = 1;
      }
    }elseif( $this->mcServerID ){
      $lrId = safe_query2( "SELECT COUNT(*) FROM anbieter
                            WHERE anbieter = ? AND server_id=?",
                            new SQLString( $pcReseller ),
                            new SQLString( $this->mcServerID )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }else{
      $lrId = safe_query2( "SELECT COUNT(*) FROM anbieter
                            WHERE anbieter = ?",
                            new SQLString( $pcReseller )
                            );
      list( $liCount ) = db_fetch_array( $lrId, 'N' );
      db_free_query( $lrId );
    }

    $lbIsOwner = (bool) $liCount;
    return $lbIsOwner;
  }/*}}}*/

/**
 * Auxiliary methods
 */
 
  /**
   * Tries to find reseller by server_id and user. Return false if can't find
   * reseller.
   *
   * @param  string $pcUser
   * @return false|string $lcReseller
   */
  function findResellerByUser( $pcUser ){/*{{{*/
    
    $lcReseller = false;

    $lrId = safe_query2( "SELECT anbieter FROM kunden WHERE kunde = ? AND server_id = ? ",
                         new SQLString( $pcUser ),
                         new SQLString( $this->mcServerID ) 
                       );
    if( db_num_rows( $lrId ) ){
      list( $lcReseller ) = db_fetch_array( $lrId, 'N' );
    }
    db_free_query( $lrId );
    return $lcReseller;
  }/*}}}*/

  /**
   * Tries to find user by server_id and domain. Return false if can't find
   * user.
   *
   * @param  mixed $pmDomain
   * @return false|string $lcUser
   */
  function findUserByDomain( $pmDomain ){/*{{{*/
    
    $lcUser = false;

    $lrId = safe_query2( "SELECT kunde FROM domains WHERE id = ? AND richtigedomain NOT IN (5, 7) AND server_id = ? ",
                         new SQLString( $pmDomain ),
                         new SQLString( $this->mcServerID ) );
    if( db_num_rows( $lrId ) ){
      list( $lcUser ) = db_fetch_array( $lrId, 'N' );
    }
    db_free_query( $lrId );
    return $lcUser;
  }/*}}}*/
 
/**
 * Return current error message
 * 
 * @return string $this->mcErrorMessage
 */
  function getErrorMessage(){/*{{{*/
    return $this->mcErrorMessage;
  }/*}}}*/
}
?>
