<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ListColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.LinkDataField.php" );





class LinkColumn extends ListColumn
{

    /* -------------------- Members -------------------- */
 	var $ms_Link; // href attribute of <a>
  var $ms_InnerHTML; // HTML between <a> and </a>
  var $mm_Query; // query part of link - string or array
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
  function LinkColumn ( $ps_Link, $pm_Query, $ps_InnerHTML, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(),
	$ps_Width=NULL, $ps_Align=NULL, $ps_ID=NULL ){
		$this->ms_Link = $ps_Link;
		$this->ms_InnerHTML = $ps_InnerHTML;
		$this->mm_Query = $pm_Query;
		$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
  }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Get... & Set... -------------------- */
  function GetLink ()
    {
	return $this->ms_Link;
    }

    function SetLink ( $ps_Link )
    {
	$this->ms_Link = $ps_Link;
    }

    function GetInnerHTML ()
    {
    	return $this->ms_InnerHTML.$this->GetValue();
    }

    function SetInnerHTML ( $ps_InnerHTML )
    {
	$this->ms_InnerHTML = $ps_InnerHTML;
    }

    function GetQuery ()
    {
	return $this->mm_Query;
    }

    function SetQuery ( $pm_Query )
    {
	$this->mm_Query = $pm_Query;
    }

    function GetQueryString ()
    {
	$lm_Query = $this->GetQuery();
	if ( is_null($lm_Query) )
	    return "";
	if ( is_array($lm_Query) )
	    return implode ( "&", array_map ( array( &$this, "Merge" ), array_keys($lm_Query), array_values($lm_Query) ) );
	return $lm_Query;
    }

    // to help GetQueryString
    function Merge ( $ps_First, $ps_Second )
    {
	return urlencode($ps_First) . "=" . urlencode($ps_Second);
    }

    function GetFullLink ()
    {
	$ls_Result = $this->GetLink();
	if ( !strlen($ls_Result) )
	    return "";
	$ls_Query = $this->GetQueryString();
	return 'href="' . ( strlen($ls_Query) ? $ls_Result . "?" . $ls_Query : $ls_Result ) . '"';
    }
    /* -------------------- end Get... & Set... -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
			return "<a " . $this->GetFullLink() . " " . $this->GetAttributesHTML() . ">" . $this->GetInnerHTML() . "</a>";
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		$lo_Result = new LinkDataField( $this->GetLink(), $this->GetQueryString(), array(), $this->GetInnerHTML() );
		$lo_Result->SetAttributes( $this->GetAttributes() );
		return $lo_Result;
	}
    /* -------------------- end definitions "abstract" methods -------------------- */

}
?>
