<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/module.Database.php" );
include_once ( dirname(__FILE__) . "/class.MenuItems.php" );





class MenuBlocks
{
    /* -------------------- Members -------------------- */
    var $mo_Query; // query object
    var $ms_ID; // id of block
    var $ms_Text; // text of block
    var $ms_UserType;
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function MenuBlocks ( $ps_UserType )
    {
			$this->ms_UserType = $ps_UserType;
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- iteration -------------------- */
    function Start(){	
			global $master_confixx;
			global $ServerID, $oldServerID, $masterServerID;

			$lcServerID = "'$ServerID'";
		
			if( $confixx_master == 2 && /* in master panel */
    			$oldServerID && /* the is a saved original value */
    			$oldServerID != $ServerID  /* the original values is changed */
			  ){
		      $lo_DB =& get_db_master();
	     }else{ 
			   $lo_DB =& get_db_connection();
	     }
			  
		    if( $master_confixx == 2 ){
		    	$lcServerID .= ", '$masterServerID'";
		    }
		    
				$lcSQL = "SELECT * FROM menublock WHERE usertype=" . db_full_quote($this->ms_UserType) .
				" AND server_id IN ( $lcServerID ) ORDER BY id";
			$this->mo_Query =& $lo_DB->Select( $lcSQL );
			if( ! $this->mo_Query->getNumRows() ){
				$this->mo_Query = NULL;
			}
    }

    function NextElement(){
			if( ! is_object( $this->mo_Query ) ){
				return NULL;
			}
			$la_Row = $this->mo_Query->nextrow();
			if( ! $la_Row ){
				return NULL;
			}
			$this->ms_ID = $la_Row["id"];
			$this->ms_Text = htmlspecialchars($la_Row["label"],ENT_QUOTES);
			return new MenuItems ( $la_Row["id"] );
    }


		function Stop(){
			if( is_object( $this->mo_Query ) ){
				$this->mo_Query->Close();
			}
			
		}
    /* -------------------- end iteration -------------------- */





    /* -------------------- access to one element -------------------- */
    function GetLabel()
    {
			return $this->ms_Text;
    }

    function GetID()
    {
			return $this->ms_ID;
    }
    /* -------------------- end access to one element -------------------- */

}
?>
