<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR . 'class.DomainsList.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR . 'class.InputDecode.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR . 'class.Data.php');

class Page{/*{{{*/

	var $pagesize = 5;
	var $pagenum = 0;
	var $smarty;
	var $user;
	
	function Page($user, &$smarty)
	{
	  global $ServerID;
		$this->smarty = &$smarty;
		$this->user = $user;
		$db =& get_db_connection();
		$res = $db->Select('SELECT list_size FROM kunden WHERE server_id=\''.$ServerID.'\' AND kunde=\'' . $this->user . '\'');
		$vals = $res->nextrow();
		$res->Close();
		$this->setPageSize($vals['list_size']);
	}

	function setPageSize($p)
	{
		$p *= 1;
		$this->pagesize = $p;
	}
	
	function setPageNum($p)
	{
		$p *= 1;
		$this->pagenum = $p;
	}
}/*}}}*/

class MailListPage extends Page 
{/*{{{*/
	var $search_word = null;
	var $ml_count = 0;
	var $maxml_count = 0;
	
	function MailListPage($user, &$smarty)
	{
		$this->Page($user, $smarty);
		$this->smarty->setUserType('user');
		$this->smarty->setModule('maillist');
		$this->setCounts();
	}

	function setCounts()
	{
	  global $ServerID;
		$db =& get_db_connection();
		$nres = $db->Select('SELECT COUNT(*) AS cnt FROM maillist INNER JOIN domains ON'
		                   .' (domains.id = maillist.domain_id) AND maillist.server_id=domains.server_id'
		                   .' WHERE maillist.neu <= 1  AND maillist.server_id=\''.$ServerID.'\' AND domains.kunde=\'' . $db->Quote($this->user) . '\'');
		$nr = $nres->nextrow();
		$nres->Close();
		$this->ml_count = $nr['cnt'];
		$nres = $db->Select('SELECT maxmaillist FROM kunden WHERE server_id=\''.$ServerID.'\' AND kunde=\'' . $db->Quote($this->user) . '\'');
		$nr = $nres->nextrow();
		$nres->Close();
		$this->maxml_count = $nr['maxmaillist'];
	}	
	
	function setSearchWord($word)
	{
		$this->search_word = $word;
	}
	
	function checkMailList($maillist)
	{
	  global $ServerID;
		if($maillist)	
		{
			$maillist = strtolower($maillist);
			if(preg_match('/^[a-z0-9_-]+$/', $maillist))
			{
				$db =& get_db_connection();
				$dres = $db->Select('SELECT COUNT(*) AS cnt FROM maillist INNER JOIN domains ON' 
     		                   .' (domains.id = maillist.domain_id) AND maillist.server_id=domains.server_id'
                  		     .' WHERE maillist.name=\'' . $db->Quote($maillist) . '\'  AND maillist.server_id=\''.$ServerID.'\' AND domains.kunde=\'' . $db->Quote($this->user) . '\'');
				if($dres)
				{
					$wer = $dres->nextrow();
					if ($wer['cnt']) {
						$this->smarty->addMessage(ERROR, ltext('ml_err_alreadymaillist', array($maillist)));
						return false;
					}
				}
				else
				{
					$this->smarty->addMessage(ERROR, ltext('err_system'));
					return false;	
				}
			}
			else
			{
				$this->smarty->addMessage(ERROR, ltext('ml_err_invalidmaillist', array($maillist)));
				return false;	
			}
		}
		else 
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_emptymaillist'));
			return false;
		}
		return true;
	}
	

	
	function checkOwnerMail($owner)
	{
		if(!preg_match('/^[\w.-]+\@(?:[\w-]+\.)+\w+$/', $owner))
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_invalidemail'));
			return false;
		}
		
		return true;	
	}

	function checkEmailConflict($maillist, $domain)
	{
	  global $ServerID;
		$db =& get_db_connection();
		$qres = $db->Select('SELECT email.prefix AS email_prefix, email.domain AS email_domain '
	                     .' FROM email INNER JOIN domains ON (email.domain = domains.domain)  AND email.server_id=domains.server_id'
	                     .' WHERE email.server_id=\''.$ServerID.'\' AND domains.id = ' . intval($domain));
		
		if($qres) {
			while($darr = $qres->nextrow()) {
				if ($maillist == $darr['email_prefix'] || $darr['email_prefix'] == $maillist.'-owner' || $darr['email_prefix'] == $maillist.'-approval' ||
					$darr['email_prefix'] == $maillist.'-outgoing' || $darr['email_prefix'] == $maillist.'-archive' ||
					$darr['email_prefix'] == $maillist.'-request') {
					$this->smarty->addMessage(ERROR, ltext('ml_err_emailconflict', array($darr['email_prefix'].'@'.$darr['email_domain'])));
					return false;
				}
			}
		}
		else {
			$this->smarty->addMessage(ERROR, ltext('err_system'));
			return false;	
		}
					
		return true;	
	}
		
	function checkPassword($p1, $p2, $id = false)
	{
		if ($id && (!$p1 || !$p2)) {
			$this->smarty->addMessage(ERROR, ltext('ml_err_emptypass'));
			return false;
		}

		if ( (substr_count($p1, " ")) || (substr_count($p2, " ")) ) {
			$this->smarty->addMessage(ERROR, ltext('ml_err_invalidpassword'));
			return false;
		}
				
		if ($p1 != $p2) {
			$this->smarty->addMessage(ERROR, ltext('ml_err_passnotmatch'));
			return false;
		}

		return true;
	}
	
	function checkId($id)
	{
	  global $ServerID;
		$id *= 1;
		$db =& get_db_connection();
		//$GLOBALS['DEBUG'] = true;
		if($dres = $db->Select('SELECT COUNT(*) AS cnt FROM maillist INNER JOIN domains'
		                      .' ON (maillist.domain_id = domains.id) AND maillist.server_id=domains.server_id'
		                      .' WHERE maillist.id=\'' . $id . '\' AND domains.kunde=\'' . $db->Quote($this->user) . '\' AND maillist.server_id=\''.$ServerID.'\''))
		{
			$wer = $dres->nextrow();
			if (!$wer['cnt']) {
				$this->smarty->addMessage(ERROR, ltext('err_hacker'));
				return false;
			}
		}
		else 
		{
			$this->smarty->addMessage(ERROR, ltext('err_system'));
			return false;	
		}
		return true;
	}
	
	function save($maillist, $domain, $owner, $pass1, $pass2, $id = false)
	{
	  global $ServerID;
		if(!$id && !(($this->ml_count < $this->maxml_count) || ($this->maxml_count == -1)))
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_maxml'));
			return false;
		}
		$ret = true;
		//echo $id;
		if ($id) 
		{
			$ret = $this->checkId($id);
		}
		else
		{
			if (!$this->checkMailList($maillist))
			{
				$ret = false;
			}
			if (!$this->checkEmailConflict($maillist, $domain))
			{
				$ret = false;
			}			
			$domlist = new DomainsList($this);
			if (!$domlist->checkDomain($domain))
			{
				$ret = false;
			}
			if (!$this->checkOwnerMail($owner))
			{
				$ret = false;
			}		
		}
		
		if(!$this->checkPassword($pass1, $pass2, $id)) {
			$ret = false;	
		}		
		
		if($ret)
		{
			$nl = new SQLDataRow('maillist', false, 'id');
			
			if($id) {
				$id *= 1;
				$nl->setValue('pwd', $pass1);
				$nl->setValue('id', $id);	
				$ret = $nl->update();
				$message = ltext('ml_pwdchanged');
			}
			else {
				if($pass1)
				{
					$nl->setValue('pwd', $pass1);
					$message = ltext('ml_listcreated', array($maillist));
				}
				else
				{
					$pass2 = mkpasswd(8);
					$nl->setValue('pwd', $pass2);
					$message = ltext('ml_listcreated_pwd', array($maillist, $pass2));
				}
				$nl->setValue('domain_id', $domain);
				$nl->setValue('name', $maillist);
				$nl->setValue('owner_mail', $owner);
				$nl->setValue('neu', 1);
				$ret = $nl->insert();
			}
			if($ret)
			{
				$this->smarty->addMessage(NONE, $message);
				$db =& get_db_connection();
				$db->Update("update allgemein set aliases='1' WHERE server_id='$ServerID'");
			}
			else
			{
				$this->smarty->addMessage(ERROR, ltext('err_system'));
			}
			
		}
		return $ret;
	}
/*	
	function getDomainsList($user = false)
	{
		if ($user === false) {
			$user = $this->user;	
		}
		$db =& get_db_connection();
		$query = 'SELECT id, domain FROM domains WHERE richtigedomain=1 AND kunde=\'' . $db->Quote($user) . '\' ORDER BY domain';	
		//echo $query;
		$qres = $db->Select($query);
		if($qres)
		{
			$domains = array();
			while($darr = $qres->nextrow())	
			{
				//$d_ids[] = $darr['id'];
				//$d_names[] = $darr['domain'];
				$domains[$darr['id']] = $darr['domain'];
			}
			return $domains;
			//$this->smarty->assign('DOMAIN_OUTPUT', $d_names);
		}
		else
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_system'));
		}
		return false;
	}
*/
	function makeDomainsList($default = false)
	{
		$cond = new CondAND(new CondEq('richtigedomain', 1));
		$cond->addCond(new CondEq('kunde', $this->user));
		$domlist = new DomainsList($this);
		$domlist->make($cond, $default);
		/*
		$this->smarty->assign('DOMAINS', $fact->getDomainsList($cond));
		if($fact->isError())
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_system'));	
		}
		if($default !== false)
		{
			$this->smarty->assign('DOMAINS_DEFAULT', $default);	
		}
		*/
	}
	
	function makeMLList()
	{
	  global $ServerID;
		$db =& get_db_connection();
		$query = "SELECT maillist.name AS mlname, domains.domain AS mldomain, domains.id AS domain_id, maillist.id AS id " .
		"FROM maillist " .
		"INNER JOIN domains ON ( maillist.domain_id = domains.id ) AND maillist.server_id=domains.server_id"; // WHERE domains.kunde='" . $db->Quote($this->user) . "'";
		$where = new CondAND(new CondEq('domains.kunde', $db->Quote($this->user)));
		$where->addCond(new CondNe('maillist.neu', 3));
		$where->addCond(new CondEq('maillist.gesperrt', 0));
		if($this->search_word)
		{
			$cond = new CondOR(new CondLike('maillist.name', $db->Quote($this->search_word)));
			$cond->addCond(new CondLike('domains.domain', $db->Quote($this->search_word)));
			$where->addCond($cond);
			
			$this->smarty->assign('search', $this->search_word);
		}
		$query .= " WHERE maillist.server_id='$ServerID' AND " . $where->getSQL();
		//echo $query;
		$qres = $db->Select($query, $this->pagesize, $this->pagenum);
		if($qres)
		{
			if($qres->getNumRows())
			{
				$this->smarty->assign('LISTS', $qres->getAll());	
				if($this->pagesize)
				{
					$nres = $db->Select("SELECT COUNT(*) AS cnt FROM maillist INNER JOIN domains ON "
					                   ." ( maillist.domain_id = domains.id )  AND maillist.server_id=domains.server_id"
					                   ." WHERE maillist.server_id='$ServerID' AND " . $where->getSQL());
					$nr = $nres->nextrow();
					$nres->Close();
					//$nr = $nr['cnt'];
					
					$count_p = ceil($nr['cnt'] / $this->pagesize);
					$prp = $this->pagenum - 1;
					if($prp < 0)
					{
						$prp = -1;
					}
								
					$nep = $this->pagenum + 1;
					if($nep > ($count_p - 1))
					{
						$nep = -1;
					}
					
					$this->smarty->assign("prev", $prp);
					$this->smarty->assign("next", $nep);
					$this->smarty->assign("COUNT", $count_p);
					$this->smarty->assign("NUMROWS", $nr['cnt']);
					
				}
			}
		}
		else 
		{
			$this->smarty->addMessage(ERROR, ltext('err_system'));	
		}
	}
	
	function setFormTexts()
	{
		$this->smarty->setText('maillist', ltext('ml_maillistname'));
		$this->smarty->setText('domain', ltext('ml_domain'));
		$this->smarty->setText('email', ltext('ml_owneremail'));
		$this->smarty->setText('password', ltext('ml_password'));
		$this->smarty->setText('confirmpassword', ltext('ml_confirmpassword'));
	}
	
	function setListTexts()
	{
		//global $lang_text;
		$this->smarty->setText('maillist', ltext('ml_maillistname'));
		$this->smarty->setText('domain', ltext('ml_domain'));
		$this->smarty->setText('search', ltext('ml_search'));
		$this->smarty->setText('add', ltext('ml_add'));
		$this->smarty->setText('delete', ltext('ml_delete'));
		$this->smarty->setText('next', ltext('g_next'));
		$this->smarty->setText('prev', ltext('g_prev'));
		$this->smarty->setText('majordomo', ltext('ml_majordomo'));
		$this->smarty->setText('changepass', ltext('ml_changepass'));
		$this->smarty->setText('delquest', ltext('ml_delquest'));
		$this->smarty->setText('you_have', ltext('ml_havend', array($this->ml_count, sinnv_intwert($this->maxml_count, ltext("g_nolimit")))));
	}

	function buldMailList()
	{
		$this->makeDomainsList();	
		$this->makeMLList();
		$this->setCounts();
		$this->setListTexts();
		$this->smarty->assign('showform', (($this->ml_count < $this->maxml_count) || ($this->maxml_count == -1)));
		$this->smarty->assign ( 'showsearch', $this->ml_count>0 );
		$this->smarty->setTpl('table');
	}
	
	function buildForm($maillist = false, $domain = false, $owner = false, $id = false)
	{
		$this->setCounts();
		if($maillist !== false)
		{
			if(!$this->checkMailList($maillist))
			{
				$maillist = "";
			}
			$this->smarty->assign('maillist', $maillist);
		}
		if($domain !== false)
		{
			$domlist = new DomainsList($this);
			if(!$domlist->checkDomain($domain))
			{
				$domain = false;
			}
		}
		if($maillist !== false && $domain !== false) {
			if(!$this->checkEmailConflict($maillist, $domain)) {
				$maillist = "";
			}
			$this->smarty->assign('maillist', $maillist);
		}
		$this->makeDomainsList($domain);
		if($owner !== false)
		{
			if(!$this->checkOwnerMail($owner))
			{
				$owner = "";	
			}
			$this->smarty->assign('owner', $owner);
		}
		if($id !== false)
		{
			$id *= 1;	
			$this->smarty->assign('id', $id);
		}
		
		$this->setFormTexts();
		
		//$this->smarty->assign('domain', $domain);
		
		
		
		$this->smarty->setTpl('form');
	}
	 
	function buildFormDB($id)
	{
	  global $ServerID;
		$id *= 1;
		$db =& get_db_connection();
		$dres = $db->Select('SELECT * FROM maillist WHERE server_id=\''.$ServerID.'\' AND id='.$id);
		if($dres)
		{
			if($mlarr = $dres->nextrow())
			{
				$this->buildForm($mlarr['name'], $mlarr['domain_id'], $mlarr['owner_mail'], $mlarr['id']);	
				return true;
			}
		}
		return false;
	}

	function deleteList ( $id, $server_id = NULL ){
		global $OBJECT_MLLIST, $EVENT_DELETE, $ServerID;

    if( empty( $server_id ) ){
      $server_id = $ServerID;
    }

    safe_query2("UPDATE maillist SET neu=3 WHERE id = ? AND server_id=?", 
                 new SQLInteger( $id ), 
                 new SQLString( $server_id ) );

		eventAdd( $OBJECT_MLLIST, $EVENT_DELETE, $id, $server_id );
	}

	function deleteLists ( $ids, $server_id = NULL ){
		if ( is_array($ids) && count($ids) ){
			foreach ( $ids as $id ){
				MailListPage::deleteList( $id, $server_id );
			}
		}
	}

}/*}}}*/

class IDNPage extends Page 
{/*{{{*/
	
	var $idn_count = 0;
	var $maxidn_count = 0;
	
	function IDNPage($user, &$smarty)
	{
		$this->Page($user, $smarty);
		$this->smarty->setUserType('user');
		$this->smarty->setModule('idn');	
		$this->setCounts();
	}
	
	function setCounts()
	{
	  global $ServerID;
		$db =& get_db_connection();
		$nres = $db->Select('SELECT COUNT(*) AS cnt FROM idn_aliases INNER JOIN domains ON'
		                   .' (domains.id = idn_aliases.domain_id) AND idn_aliases.server_id=domains.server_id'
		                   .' WHERE idn_aliases.server_id=\''.$ServerID.'\' AND domains.kunde=\'' . $db->Quote($this->user) . '\'');
		$nr = $nres->nextrow();
		$nres->Close();
		$this->idn_count = $nr['cnt'];

	}

	
	function setTexts()
	{
		$this->smarty->setText('idndomain', ltext('idn_nationaldomain'));
		$this->smarty->setText('origdomain', ltext('idn_origdomain'));
		$this->smarty->setText('add', ltext('idn_add'));
		$this->smarty->setText('edit', ltext('idn_edit'));
		$this->smarty->setText('delete', ltext('idn_delete'));
		$this->smarty->setText('delquest', ltext('idn_delquest'));
		$this->smarty->setText('next', ltext('g_next'));
		$this->smarty->setText('prev', ltext('g_prev'));
	}
	
	function makeDomainsList($default = false)
	{
		$cond = new CondAND(new CondEq('kunde', $this->user));
		$cond->addCond(new CondIn('richtigedomain', array(1, 2)));
		$domlist = new DomainsList($this);
		$domlist->make($cond, $default);
		/*
		$this->smarty->assign('DOMAINS', $fact->getDomainsList($cond));
		if($fact->isError())
		{
			$this->smarty->addMessage(ERROR, ltext('ml_err_system'));	
		}
		if($default !== false)
		{
			$this->smarty->assign('DOMAINS_DEFAULT', $default);	
		}
		*/
	}	
	
	function checkId($id)
	{
	  global $ServerID;
		$id *= 1;
		$db =& get_db_connection();
		if($dres = $db->Select('SELECT COUNT(*) AS cnt FROM idn_aliases INNER JOIN domains ON'
		                      .' (idn_aliases.domain_id = domains.id)AND idn_aliases.server_id=domains.server_id'
		                      .' WHERE idn_aliases.id=\'' . $id . '\' AND domains.kunde=\'' . $db->Quote($this->user) . '\' AND idn_aliases.server_id=\''.$ServerID.'\''))
		{
			$wer = $dres->nextrow();
			if (!$wer['cnt']) {
				$this->smarty->addMessage(ERROR, ltext('err_hacker'));
				return false;
			}
		}
		else 
		{
			$this->smarty->addMessage(ERROR, ltext('err_system'));
			return false;	
		}
		return true;
	}	
	
	function checkIDNDomain($domain, $id = false)
	{
	  global $ServerID;
		$id *= 1;
		if(!preg_match('/^[^\\\\\'"&\\?\\*\\(\\),\\{\\}\\[\\];\\:\\+\\=\\^%\\$#@\!`~\\/]+\.[a-zA-Z]{1,4}$/', $domain))
		{
			$this->smarty->addMessage(ERROR, ltext('idn_err_baddomain'));
			return false;	
		}
		$db =& get_db_connection();
		
		$query = 'SELECT COUNT(*) AS cnt FROM idn_aliases'
		        .' WHERE server_id=\''.$ServerID.'\' AND idn_name=\'' . $db->Quote($domain) . '\'';
		if($id)
		{
			$query .= ' AND id <> ' . $id;	
		}
		if($dres = $db->Select($query))
		{
			$wer = $dres->nextrow();
			if ($wer['cnt']) {
				$this->smarty->addMessage(ERROR, ltext('idn_err_domainalready'));
				return false;
			}
		}
		else 
		{
			$this->smarty->addMessage(ERROR, ltext('err_system'));
			return false;	
		}
		return true;
	}
	
	function save($idn_name, $domain_id, $id = false)
	{
		$idn_name = InputDecode::decode($idn_name);
		
		//$idn_name =  html_entity_decode($idn_name);
		
		if(!$this->checkIDNDomain($idn_name, $id))
		{
			return false;
		}
		
		$domlist = new DomainsList($this);
		if (!$domlist->checkDomain($domain_id))
		{
			return false;
		}
		$nl = new SQLDataRow('idn_aliases', false, 'id');
		$nl->setValue('idn_name', $idn_name);
		$nl->setValue('domain_id', $domain_id);
		if($id !== false) 
		{
			$id *= 1;
			if (!$this->checkId($id))
			{
				return false;	
			}
			$nl->setValue('id', $id);
//			$db =& get_db_connection();
//			$db->Update("UPDATE allgemein SET httpd=1, httpdupdate=0");
			return $nl->update();
		}
		else
		{
//			$db =& get_db_connection();
//			$db->Update("UPDATE allgemein SET httpd=1, httpdupdate=0");
			return $nl->insert();	
		}
	}
	
	function build($id = false)
	{
	  global $ServerID;
		$this->setCounts();
		//echo preg_quote('\\\'"&?*(),{}[];:+=^%$#@!`~');
		//$n = '\\\\\'"&\\?\\*\\(\\),\\{\\}\\[\\];\\:\\+\\=\\^%\\$#@\!`~';
		
		$db =& get_db_connection();
		$origdomain = false;
		if($id) {
			$query = 'SELECT * FROM idn_aliases WHERE server_id=\''.$ServerID.'\' AND id='.$id;
			if($dres = $db->Select($query))	{
				if($darr = $dres->nextrow())
				{
					$origdomain = $darr['domain_id'];	
					$this->smarty->assign('id', $darr['id']);
					$this->smarty->assign('idndomain', InputDecode::utf8ToUnicodeEntities(htmlspecialchars($darr['idn_name'])));
				}
			}
			else
			{
				$this->smarty->addMessage(ERROR, ltext('idn_err_system'));
			}
		}
		
		$this->makeDomainsList($origdomain);

		
		$query = 'SELECT idn_aliases.id AS id, idn_aliases.idn_name AS idndomain, domains.domain AS origdomain'
		          .'  FROM idn_aliases INNER JOIN domains ON '
		          .'(domains.id = idn_aliases.domain_id) AND idn_aliases.server_id=domains.server_id='
		          .' WHERE domains.kunde=\'' . $db->Quote($this->user) . '\' AND idn_aliases.server_id=\''.$ServerID.'\'';
		
		if($dres = $db->Select($query, $this->pagesize, $this->pagenum)) {
			$idndomains = array();
			while($darr = $dres->nextrow()) {
				$darr['idndomain'] = InputDecode::utf8ToUnicodeEntities($darr['idndomain']);
				$idndomains[] = $darr;
			}
			$this->smarty->assign('IDNDOMAINS', $idndomains);
			if($this->pagesize)
			{
				//$nr = $nr['cnt'];
				
				$count_p = ceil($this->idn_count / $this->pagesize);
				$prp = $this->pagenum - 1;
				if($prp < 0)
				{
					$prp = -1;
				}
							
				$nep = $this->pagenum + 1;
				if($nep > ($count_p - 1))
				{
					$nep = -1;
				}
				
				$this->smarty->assign("prev", $prp);
				$this->smarty->assign("next", $nep);
				$this->smarty->assign("COUNT", $count_p);
				$this->smarty->assign("NUMROWS", $this->idn_count);
				
			}
		}
		else
		{
			$this->smarty->addMessage(ERROR, ltext('idn_err_system'));
		}
		
		$this->smarty->assign('showform', true);
		$this->setTexts();
		$this->smarty->setTpl('table');
	}
	
}/*}}}*/

class SettingsPage extends Page 
{/*{{{*/
	function SettingsPage($user, &$smarty)
	{
		$this->Page($user, $smarty);
		$this->smarty->setUserType('user');
		$this->smarty->setModule('settings');	
		$this->smarty->setTpl('form');
	}
	
	function save()
	{
	  global $ServerID;
		$db =& get_db_connection();
		if(!preg_match('/^[0-9]+$/', $_POST['list_size']))
		{
			$this->smarty->addMessage(ERROR, ltext('ls_error'));
			return false;	
		}
		$_POST['list_size'] *= 1;
		if(!$_POST['list_size'])
		{
			$_POST['list_size'] = 10;	
		}
		$db->Update('UPDATE kunden SET list_size=\'' . $_POST['list_size'] . '\' WHERE server_id=\''.$ServerID.'\' AND kunde=\'' . $this->user . '\'');
		$this->pagesize = $_POST['list_size'];
		return true;
	}
	
	function setTexts()
	{
		$this->smarty->setText('save', ltext('g_save'));
		$this->smarty->setText('listsize', ltext('g_listsize'));
	}
	
	function build()
	{
		$this->setTexts();
		
		$this->smarty->assign('list_size', $this->pagesize);	
	}
}/*}}}*/


?>
