<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ListColumn.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.OptionsDataField.php" );





class RadioGroupColumn extends ListColumn
{
    /* -------------------- Members -------------------- */
    var $ma_Options; // array of arrays - values
    var $ms_Separator; // separator
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function RadioGroupColumn (  $pa_Options, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	    $ps_Align=NULL, $ps_ID=NULL )
    {
	$this->ma_Options = $pa_Options;
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->SetSeparator ( "<br>" );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Set.../Get... -------------------- */
    function SetSeparator ( $ps_Separator )
    {
	$this->ms_Separator = $ps_Separator;
    }

    function GetSeparator()
    {
	return $this->ms_Separator;
    }
    /* -------------------- end Set.../Get... -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	$ls_More = $this->GetAttributesHTML();
	$ls_Result = "";
	$ls_Separator = $this->GetSeparator();
	foreach ( $this->ma_Options as $ls_Value => $ls_Text ){
	    $ls_Checked = $this->GetValue() == $ls_Value ? "checked" : "";
	    $ls_Result .= "$ls_Separator<input type=radio value=\"" . htmlspecialchars($ls_Value) . "\" name=\"" .
		    htmlspecialchars($this->GetName()) . "\" $ls_More $ls_Checked> " . htmlspecialchars($ls_Text);
	}
	return substr ( $ls_Result, strlen($ls_Separator) );
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		$lo_Result = new OptionsDataField( $this->ma_Options, $this->GetValue(), $this->GetPureName(),
				cc_RadioGroupPresentation );
		$lo_Result->SetSeparator( $this->GetSeparator() );
		return $lo_Result;
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
