<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.ResellerLimitColumn.php" );
include_once ( dirname(__FILE__) . "/elements/data/class.KBLimitDataField.php" );




class ResellerTrafficColumn extends ResellerLimitColumn
{

    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function ResellerTrafficColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	    $ps_Align=NULL, $ps_ID=NULL )
    {
	$this->ResellerLimitColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
	$this->CallOnValidator ( "SetMaximum", 0x7FFFFFFF );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- GetHTML -------------------- */
    function GetHTML()
    {
	global $lang_format_mb_expr;
	if ( ! $this->GetInput() )
	    return ResellerLimitColumn::GetHTML();
	$ls_More = $this->GetAttributesHTML();
	return "<input name=\"" . htmlspecialchars($this->GetName()) . "\" value=\"" . htmlspecialchars($this->GetValue())
		. "\" $ls_More> $lang_format_mb_expr";
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		global $lang_format_mb_expr;
		$ls_Value = $this->GetValue();
		if ( $ls_Value > 0 )
			$ls_Value *= 1024;
		$lo_Result = new KBLimitDataField( $this->GetPureName(), NULL, $ls_Value, "MB" );
		$lo_Result->AppendToOptions( array( "MB"=>$lang_format_mb_expr ) );
		return $lo_Result;
	}
    /* -------------------- end GetHTML -------------------- */

}
?>
