<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ListColumn.php" );
include_once (  dirname(__FILE__) . "/elements/data/class.OptionsDataField.php" );





class SelectColumn extends ListColumn
{
    /* -------------------- Members -------------------- */
    var $ma_Options; // options
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function SelectColumn (  $pa_Options, $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	    $ps_Align=NULL, $ps_ID=NULL )
    {
	if ( is_array( current($pa_Options) ) )
	    foreach ( $pa_Options as $ls_Key=>$la_Value )
		$this->ma_Options[ $la_Value[0] ] = $la_Value[1];
	else
	    $this->ma_Options = $pa_Options;
	$this->ListColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetHTML()
    {
	if ( ! $this->GetInput() )
	    return array_key_exists( $this->GetValue(), $this->ma_Options ) ?
		    $this->ma_Options[$this->GetValue()] : "&nbsp;";

	$ls_More = $this->GetAttributesHTML();
	$ls_Result = "<select name=\"" . htmlspecialchars($this->GetName()) . "\" $ls_More>";
	foreach ( $this->ma_Options as $ls_Value => $ls_Text ){
	    $ls_Selected = $this->GetValue() == $ls_Value ? "selected" : "";
	    $ls_Result .= "<option value=\"" . htmlspecialchars($ls_Value) . "\" $ls_Selected>" .
		    htmlspecialchars($ls_Text) . "</option>";
	}
	return $ls_Result . "</select>";
    }

	// method that maps old classes to include/elements/*
	function GetDataField() {
		if( !$this->GetInput() )
			return array_key_exists( $this->GetValue(), $this->ma_Options ) ?
				new ReadOnlyDataField( $this->ma_Options[$this->GetValue()] ) : new HTMLDataField("");
		$lo_Result = new OptionsDataField( $this->ma_Options, $this->GetValue(), $this->GetPureName() );
		$lo_Result->SetAttributes( $this->GetAttributes() );
		return $lo_Result;
	}
    /* -------------------- end definitions of "abstract" methods -------------------- */

}
?>
