<?
include_once( 'class.ConversedDBValue.php');
include_once( 'class.KeyHref.php');

class ConditionalyDBValue extends ConversedDBValue {
	var $moConversion;
	var $mlSkipRow;
	var $mlSkipPolicy;


	function ConditionalyDBValue ( $poSQLQuery, $piSize = NULL, $piStart = NULL ){

		$this->ConversedDBValue( $poSQLQuery, $piSize, $piStart );

		$this->SkipRow( 0 );
		$this->SkipPolicy( 0 );
	}

	function &SkipPolicy( $plSkip = NULL ){
		if( !is_null( $plSkip ) ) {
			$this->mlSkipPolicy = $plSkip;
		}
		return $this->mlSkipPolicy;
	}

	function &SkipRow( $plSkip = NULL ){
		if(!is_null($plSkip)){
			$this->mlSkipRow = $plSkip;
		}

		return $this->mlSkipRow;
	}

	function AcceptPolicy( $plAccept = NULL){

		if(is_null($plAccept)){
			return $this->SkipPolicy()?0:1;

		}else{
			return $this->SkipPolicy($plAccept?0:1)?0:1;
		}
	}

	function AcceptRow( $plAccept = NULL){

		global $DEBUG;
		
		if( is_null( $plAccept ) ) {
			$llRet = $this->SkipRow()?0:1;

		}else{
			$llRet =  $this->SkipRow($plAccept?0:1)?0:1;
		}

		/*
		echo "AcceptRow($plAccept) mlSkipRow = ".$this->mlSkipRow."<br>\n";
		echo "AcceptRow($plAccept) llRet = $llRet<br>\n";
		*/

		return $llRet;
	}

	function &Conversion( $poConv = NULL ) {
		if( is_a( $poConv, 'CompoundValue' ) ){
			$this->moConversion = $poConv;
		} elseif( is_a( $poConv, 'KeyValue' ) ) {
			$this->moConversion = new CompoundValue( func_get_args() );
		} elseif( is_array( $poConv ) ) {
			$this->moConversion = new CompoundValue( $poConv );
		}
		return $this->moConversion;
	}

	function &getConversedRow( &$poSrc, $poConv = NULL ) {

		global $DEBUG;

		
		if( $DEBUG ) {
			//			echo "ConditionalydDBValue::getConversedRow : start<br>\n";
			/*
			echo "<pre>\n";
			print_r($poSrc);
			echo "</pre><hr>\n";
			*/
		}
		

		$laRow = array();
		if( is_null( $poConv ) ){
			$poConv =& $this->Conversion();
		}

		//		echo "ConditionalydDBValue::getConversedRow : set up from accept policy<br>\n";

		$liAccept = $this->AcceptRow( $this->AcceptPolicy() );

		/*
		if( $DEBUG ) {
			echo "ConditionalydDBValue::getConversedRow : accept row = $liAccept<br>\n";
		}
		*/

		if( is_a( $poConv, 'CompoundValue' ) ){

			$loIterConv =& $poConv->getFirstIterator();
			$loIterData =& $poSrc->getFirstIterator();

			while( $loConv =& $loIterConv->getNext() ) {

				unset($loCellData);
				$loCellData =& $loIterData->getNext();

				if( is_a( $loConv, 'ValueFormated' ) ) {

					/* dangerous
					if( method_exists( $loConv, 'setHook')){
						$loConv->setHook( $this );
					}
					*/
					if( is_a( $loCellData, 'CompoundValue' ) ) {
						$loCellData->addValue( new KeyHref( 'skip_row', $this->SkipRow()));
					}

					$loCell = $loConv->Value( $loCellData ); // call the converse function

					if( is_a( $loCellData, 'CompoundValue' ) ) {
						$loItem =& $loCellData->Value('skip_row');
						if( $loItem->Value() != $this->SkipPolicy() ) {

							$this->SkipRow( $loItem->Value() );
							if($DEBUG){
								echo "ConditionalydDBValue::getConversedRow: skip status of row is ".$this->SkipRow()."<br>\n";
								echo 'mlSkipRow='.$this->mlSkipRow."<br>\n";
							}
						}
					}

				} elseif( is_a( $loConv, 'DataValue' ) ) {

					$loConv->Value( $loCellData->Value() );

					$loCell = array( $loConv->getPresentation(), $loConv->getParentAttributes());

				} else {
					if( is_a( $loCellData, 'KeyValue' ) ) {
						$loCell = new TextDataField( $loCellData->Value(), $loCellData->Key().'[]' );

					} elseif( is_a( $loCellData, 'CompoundData' ) ) {
						$loCell = new CompondDataField();
						$loIter =& $loCellData->getTreeIterator();
						while( $loItem =& $loIter->getNext() ){
							$loCell->AppendToContent( new TextDataField( $loItem->Value(), $loItem->Key().'[]' ) );
						}
					}
				}

				$laRow[] = $loCell;
				unset($loConv);

			}

		} else {
			$loIterCell =& $poSrc->getTreeIterator();
			while( $loCell =& $loIterCell->getNext() ){
				$laRow[] = new TextDataField( $loCell->Value(), $loCell->Key().'[]');
				unset($loCell);
			}
		}
		
		//		echo 'mlSkipRow='.$this->mlSkipRow."<br>\n";
		//		echo "ConditionalydDBValue::getConversedRow : check accept status<br>\n";
		

		if( $this->SkipRow() ) {
			
			if($DEBUG){
				echo "ConditionalydDBValue::getConversedRow: row is skiped<br>\n";
				echo 'mlSkipRow='.$this->mlSkipRow."<br>\n";

				/*
				echo "<pre>\n";
				print_r($this);
				echo "</pre><hr>\n";
				*/
			}
			
			$laRow = NULL;
		}

		//		echo "ConditionalydDBValue::getConversedRow : stop<br>\n";

		return $laRow;

	} // end of method

} // end of class


?>