<?
class IndexIterator {
	var $miIndex;
	var $miMin;
	var $miMax;
	var $maContent;
	
	function IndexIterator( &$paContent ) {
		if ( is_array($paContent) ) {
			$this->maContent =& $paContent;
		} else {
			$this->maContent = array();
		}
		$this->miMin = 0;
		$this->miMax = count($this->maContent)-1;
		$this->miIndex = 0;
	}
	
	function Min( $piMin = NULL ){
		if( is_numeric( $piMin ) ){
			$this->miMin = $piMin;
		}
		return $this->miMin;
	}
	
	function Max( $piMax = NULL ){
		if(is_numeric( $piMax ) ) {
			$this->miMax = $piMax;
		}
		return $this->miMax;
	}

	function &Index( $piIndex = NULL ){
		if(is_numeric($piIndex)){
			$this->miIndex = $piIndex;
		}
		return $this->miIndex;
	}

	function nextIndex( $piDelta = 1 ) {
		global $DEBUG;
		if( $this->isValid( $this->miIndex + $piDelta ) ) {
			$this->miIndex += $piDelta;
			//			if($DEBUG){
			//				echo "IndexIterator::nextIndex: ".$this->miIndex."<br>\n";
			//			}
			return TRUE;
		} else {
			return FALSE;
		}
	}

	function prevIndex( $piDelta = 1 ) {
		return $this->nextIndex( -$piDelta );
	}


	function isValid( $piIndex = NULL ){
		global $DEBUG;
		if ( is_numeric( $piIndex ) ) {
			//			if($DEBUG){
			//				echo "IndexIterator::isValid: ".join(', ',array($this->miMin, $piIndex, $this->miMax))."<br>\n";
			//			}
			return ( $this->miMin <= $piIndex ) && ( $piIndex <= $this->miMax );
		} else {
			//			if($DEBUG){
			//				echo "IndexIterator::isValid: ".join(', ',array($this->miMin, $this->miIndex, $this->miMax))."<br>\n";
			//			}
			return ( $this->miMin <= $this->miIndex ) && ( $this->miIndex <= $this->miMax );
		}
	}

	function &getCurrent(){
		global $DEBUG;
		if ($this->isValid()){
			//			if($DEBUG){
			//				echo "IndexIterator::getCurrent : ".$this->miIndex."<br>\n";
			//			}
			return $this->maContent[$this->miIndex];
		} else {
			//			if($DEBUG){
			//				echo "IndexIterator::getCurrent : NULL<br>\n";
			//			}
			return NULL;
		}
	}

}

//
//============================================================
//

class CnfxxArrayIterator {
	var $maArray;

	function CnfxxArrayIterator( &$paArray ){
		if(is_array($paArray)){
			$this->maArray =& $paArray;
		} else {
			$this->maArray = array();
		}
		reset( $this->maArray );
	}


	function doReset(){
		$this->toBegin();
	}

	function toBegin(){
		reset( $this->maArray );
	}

	function toEnd(){
		end( $this->maArray );
	}

	function &getNext(){
		return each($this->maArray);
	}

	function &getCurrent(){
		return current($this->maArray);
	}
}

//
//====================================================================
//

class FirstIterator extends IndexIterator {

	function FirstIterator( &$paContent ){
		$this->IndexIterator( $paContent );
		$this->doReset();
	}

	function doReset(){
		$this->Index( $this->Min()-1 );
	}

	function &getNext( $piDelta = 1 ) {
		global $DEBUG;
		if( $this->nextIndex( $piDelta ) ) {
			return $this->getCurrent();
		} else {
			//			if($DEBUG){
			//				echo "FirstIterator::getNext - NULL<br>\n";
			//			}
			return NULL;
		} 
	}

	function &getPrev( $piDelta = 1 ) {
		if( $this->prevIndex( $piDelta ) ) {
			return $this->getCurrent();
		} else {
			return NULL;
		} 
	}
}

//
//====================================================================
//


class LastIterator extends IndexIterator {

	function LastIterator( &$paContent ){
		$this->IndexIterator( $paContent );
		$this->doReset();
	}

	function doReset(){
		$this->Index( $this->Max()+1 );
	}

	function &getNext( $piDelta = 1 ) {
		if( $this->prevIndex( -$piDelta ) ) {
			return $this->getCurrent();
		} else {
			return NULL;
		} 
	}

	function &getPrev( $piDelta = 1 ) {
		if( $this->nextIndex( -$piDelta ) ) {
			return $this->getCurrent();
		} else {
			return NULL;
		} 
	}
}

//
//====================================================================
//

class RandomIterator extends FirstIterator {

	function RandomIterator( &$paContent ){
		$this->FirstIterator( $paContent );
	}

	function &getByIndex( $piIndex = NULL){
		if( is_numeric( $piIndex ) ){ 
			if( $this->isValid( $piIndex ) ) {
				$this->Index( $piIndex );
				return $this->getCurrent();
			} else {
				return NULL;
			}
		} else {
			return $this->getCurrent();
		}
	}

}

//
//=====================================================================
//

class TreeIterator extends FirstIterator {
	
	var $moChildIter;

	function TreeIterator ( &$paContent ) {
		$this->moChildIter = NULL;
		$this->FirstIterator( $paContent );
	}

	function &getNext() {

		global $DEBUG;

		if ( is_null( $this->moChildIter ) ){ ## main loop
			$llMainLoop = TRUE;
			$loEntry =& parent::getNext();

			if( method_exists( $loEntry, 'getTreeIterator' ) ){
				/*
				if($DEBUG){
					echo "TreeIterator::getNext<br><pre>\n";
					print_r($loEntry);
					echo "</pre><hr>\n";
				}
				*/
				$this->moChildIter = $loEntry->getTreeIterator(); ## go into child 
				$llMainLoop = FALSE;
			}

		} else {
			$llMainLoop = FALSE;
		}

		if ( $llMainLoop ){ ## /main loop
			return $loEntry;

		} else {

			$loChildEntry =& $this->moChildIter->getNext(); ## child loop

			if( is_null($loChildEntry ) ) { ## /child loop
				$this->moChildIter = NULL;
				return $this->getNext(); ## return to main loop

			} else {
				return $loChildEntry; ## continue child loop
			}
		} 
	}

}
?>
