<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/../html/class.ImageElement.php" );




class IconDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_IconName; // file name
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function IconDataField( $ps_IconName, $pa_Attributes = array(), $pa_ParentAttributes = array() ) {

		$this->DataField( $pa_Attributes, $pa_ParentAttributes );
		$this->SetIconName( $ps_IconName );

	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetIconName( $ps_IconName ) {
		$this->ms_IconName = $ps_IconName;
	}

	function GetIconName() {
		return $this->ms_IconName;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetInputPresentation( $ps_ID=NULL ) {
		global $strSkinName;
		$la_Attributes = $this->GetAttributes( $ps_ID );
		$la_Attributes["border"] = 0;
		$la_Attributes["src"] = "$strSkinName/" . $this->GetIconName();
		return new ImageElement( $la_Attributes );
	}

	function GetOutputPresentation() {
		return $this->GetInputPresentation();
	}

	function GetHiddenPresentation( $ps_ID=NULL ) {
		return new HTMLElement( "" );
	}

	function SetFromArray( $pa_Data ) {
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
