<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.HTMLDataField.php" );
include_once( dirname(__FILE__) . "/class.YesNoDataField.php" );
include_once( dirname(__FILE__) . "/class.CompoundDataField.php" );





class Limit {

	/* -------------------- Members -------------------- */
	var $ms_Name; // name of limit
	var $ms_HardName; // name of "hard limit" field
	var $ms_Value; // value of field
	var $ms_Hard; // if this is a hard limit
	var $mi_FormIndex;
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function Limit( $ps_Name, $ps_HardName, $ps_Value="-1", $pi_FormIndex = 0 ) {
		$this->SetName( $ps_Name );
		$this->SetHardName( $ps_HardName );
		$this->SetValue( $ps_Value );
		$this->SetHard(1);
		$this->mi_FormIndex = 0;
		$this->FormIndex($pi_FormIndex);
	}
	/* -------------------- end Constructor -------------------- */


	function FormIndex ( $pi_Index = NULL ){
		if (is_numeric($pi_Index)){
			$this->mi_FormIndex = $pi_Index;
		}
		return $this->mi_FormIndex;
	}


	/* -------------------- Set.../Get... -------------------- */
	function SetHard( $ps_Hard ) {
		$this->ms_Hard = $ps_Hard;
	}

	function GetHard() {
		return $this->ms_Hard;
	}

	function SetName( $ps_Name ) {
		$this->ms_Name = $ps_Name;
	}

	function GetName() {
		return $this->ms_Name;
	}

	function SetHardName( $ps_HardName ) {
		$this->ms_HardName = $ps_HardName;
	}

	function GetHardName() {
		return $this->ms_HardName;
	}

	function SetValue( $ps_Value ) {
		$this->ms_Value = $ps_Value;
	}

	function GetValue() {
		return $this->ms_Value;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		$ls_Name = $this->GetName();
		if( !is_null($ls_Name) )
			$this->SetValue( array_key_exists( $ls_Name, $pa_Data ) ? $pa_Data[$ls_Name] : "-1" );
		$ls_Name = $this->GetHardName();
		if( !is_null($ls_Name) )
			$this->SetHard( array_key_exists( $ls_Name, $pa_Data ) ? $pa_Data[$ls_Name] : "0" );
	}
	/* -------------------- end SetFromArray -------------------- */





	/* -------------------- methods to generate data fields -------------------- */
	function GetHardLimitField() {
		$ls_Name = $this->GetHardName();
		if( is_null($ls_Name) )
			return new HTMLDataField( "" );
		$lo_Result = new CompoundDataField( new YesNoDataField( array( "1"=>"" ), array( "0"=>"" ), $this->GetHard(),
					$ls_Name ), new HTMLDataField( ltext("ldf_hardlimit") ) );
		$lo_Result->SetSeparator( "\n" );
		if( $this->GetValue()<0 )
			$lo_Result->SetDisabled( TRUE );
		return $lo_Result;
	}

	function GetUnlimitedField() {
		global $DEBUG;
		$lo_Checkbox = new YesNoDataField( array( "-1"=>"" ), array( ""=>"" ), $this->GetValue(), $this->GetName() );
		$lo_Checkbox->SetDependableFields( array(), $this->GetOff( $this->FormIndex() ) );
		if($DEBUG){
			/*
			echo "Limit::GetUnlimitedField<pre><br>\n";
			print_r($lo_Checkbox);
			echo "</pre><hr>\n";
			*/
		}
		$lo_Result = new CompoundDataField( $lo_Checkbox, new HTMLDataField( ltext("ldf_unlimited") ) );
		$lo_Result->SetSeparator( "\n" );
		return $lo_Result;
	}
	/* -------------------- end methods to generate data fields -------------------- */





	/* -------------------- "abstract" methods -------------------- */
	function GetField() {
		echo( "method GetField should return object!" );
	}

	function GetOff() {
		echo( "method GetOff should return array!" );
	}
	/* -------------------- end "abstract" methods -------------------- */

}
?>
