<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####


/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.DataField.php" );
include_once( dirname(__FILE__) . "/class.HTMLDataField.php" );
include_once( dirname(__FILE__) . "/../html/class.HTMLElement.php" );
include_once( dirname(__FILE__) . "/../html/class.AElement.php" );
include_once( dirname(__FILE__) . "/../html/class.TextElement.php" );





class LinkDataField extends DataField {

	/* -------------------- Members -------------------- */
	var $ms_Link; // href of link, don't include "?"
	var $ms_Permanent; // permanent part of query, don't include "?" and trailing "&"
	var $ma_Query; // array of query elements that could be changed
	var $mo_Internal; // field between <a> and </a>
	var $ms_Target; // link target
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function LinkDataField( $ps_Link, $ps_Permanent="", $pa_Query=array(), $pm_Internal="", $ps_Target='' ) {

		$this->DataField(); ## call parent constructor

		if( is_a( $ps_Link, 'LinkDataField' ) ) { ## copy constructor
			$this->copyFrom( $ps_Link );

		} elseif( is_array( $ps_Link ) ) { ## technical constructor
			$this->SetLink( $ps_Link[0] );
			$this->SetPermanent( $ps_Link[1] );
			$this->SetQuery( $ps_Link[2] );
			$this->SetInternal( $ps_Link[3] );
			if(isset($ps_Link[4])&&!empty($ps_Link[4]))
				$this->SetTarget( $ps_Link[4] );

		} else {
			$this->SetLink( $ps_Link );
			$this->SetPermanent( $ps_Permanent );
			$this->SetQuery( $pa_Query );
			$this->SetInternal( $pm_Internal );
			$this->SetTarget( $ps_Target );
		}
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Set.../Get... -------------------- */
	function SetLink( $ps_Link ) {
		$this->ms_Link = $ps_Link;
	}

	function &GetLink() {
		return $this->ms_Link;
	}

	function SetPermanent( $ps_Permanent ) {
		$this->ms_Permanent = $ps_Permanent;
	}

	function &GetPermanent() {
		return $this->ms_Permanent;
	}

	function SetQuery( $pa_Query ) {
		$this->ma_Query = $pa_Query;
	}

	function &GetQuery() {
		return $this->ma_Query;
	}

	function SetInternal( $pm_Internal ) {
		$this->mo_Internal = is_object($pm_Internal) ? $pm_Internal : new HTMLDataField( $pm_Internal );
	}
	
	function SetTarget( $ps_Target ) {
		$this->ms_Target = $ps_Target;
	}

	function &GetInternal() {
		return $this->mo_Internal;
	}
	function &GetTarget() {
		return $this->ms_Target;
	}
	/* -------------------- end Set.../Get... -------------------- */





	/* -------------------- SetFromArray -------------------- */
	function SetFromArray( $pa_Data ) {
		$la_Query = $this->GetQuery();
		if(is_array($la_Query)){
			foreach( array_keys($la_Query) as $ls_Key ) {
				$la_Query[$ls_Key] = array_key_exists( $ls_Key, $pa_Data ) ? $pa_Data[$ls_Key] : "";
			}
			$this->SetQuery( $la_Query );
		}
		$lo_Internal =& $this->GetInternal();
		$lo_Internal->SetFromArray( $pa_Data );
	}
	/* -------------------- end SetFromArray -------------------- */





	/* -------------------- definitions of "abstract" methods & related -------------------- */
	function GetHREF() {
		$ls_Result = $this->GetPermanent();
		foreach( $this->GetQuery() as $ls_Key=>$ls_Value )
			$ls_Result .= "&" . urlencode($ls_Key) . "=" . urlencode($ls_Value);
		if( substr( $ls_Result, 0, 1 ) == "&" )
			$ls_Result = substr( $ls_Result, 1 );
		if($ls_Result)
			return $this->GetLink() . "?" . $ls_Result;
		else
			return $this->GetLink();
	}

	function GetInputPresentation() {
		return $this->GetOutputPresentation();
	}

	function GetOutputPresentation() {
		$lo_Internal = $this->GetInternal();
		$la_Attributes = $this->GetAttributes();
		$la_Attributes["href"] = $this->GetHREF();
		$la_Attributes["class"] = "data";
		if(strlen($this->GetTarget())) 
			$la_Attributes["target"] = $this->GetTarget();
		return new AElement( $la_Attributes, $lo_Internal->GetOutputPresentation() );
	}

	function GetHiddenPresentation() {
		return new HTMLElement( "" );
	}
	/* -------------------- end definitions of "abstract" methods & related -------------------- */

	function copyFrom( $poSrc ){
		if( is_a( $poSrc, 'LinkDataField' ) ) {
			$this->SetLink( $poSrc->GetLink() );
			$this->SetPermanent( $poSrc->GetPermanent() );
			$this->SetQuery( $poSrc->GetQuery() );
			$this->SetTarget( $poSrc->GetTarget() );
			$this->SetInternal( getClone( $poSrc->GetInternal()) );
		}
	}

	function &getClone(){
		return new LinkDataField( $this );
	}

}
?>
