<?

include_once( 'class.CompoundDataField.php' );

include_once( dirname(__FILE__) .'/../html/class.HTMLElement.php' );
include_once( dirname(__FILE__) .'/../html/class.DivElement.php' );
include_once( dirname(__FILE__) .'/../html/class.FieldsetElement.php' );


class ToolsButtons extends CompoundDataField {
	var $msLegend;
	var $maFirstDivAttributes;
	var $maSecondDivAttributes;
	var $maHiddens;
	var $mcAnchor;

	function ToolsButtons(){

		$this->maFirstDivAttributes = array( 'class' => 'toolsArea' );
		$this->maSecondDivAttributes = array( 'class' => 'screenButtons' );
		$this->CompoundDataField( func_get_args() );
		$this->SetSeparator("\n");
		$this->maHiddens = array();
	}

	function &Hiddens( $paHiddens = NULL ) {
		if( is_array( $paHiddens ) ) {
			$this->maHiddens = $paHiddens;
		}
		return $this->maHiddens;
	}

	function &Anchor( $pcName = NULL ) {
		if( !is_null( $pcName ) ) {
			$this->mcAnchor = $pcName;
		}
		return $this->mcAnchor;
	}


	function &Legend( $psLegend = NULL ){
		if( !is_null( $psLegend ) ){
			$this->setLegend( $psLegend );
		}

		return $this->getLegend();
	}

	function &setLegend( $psLegend ){
		$this->msLegend = $psLegend;
		return $this->msLegend;
	}

	function &getLegend(){
		return $this->msLegend;
	}

	function &GetOutputPresentation( $paFirstDivAttributes = NULL, 
																	 $paSecondDivAttributes = NULL ){

		global $DEBUG;


		if(is_array( $paFirstDivAttributes ) ) {
			$this->maFirstDivAttributes = array_merge( $this->maFirstDivAttributes, 
																									$paFirstDivAttributes );
		}
		if(is_array( $paSecondDivAttributes ) ) {
			$this->maSecondDivAttributes = array_merge( $this->maSecondDivAttributes, 
																									 $paSecondDivAttributes );
		}
		$loLF = new HTMLElement("\n");
		$loOutput = new DivElement( $this->maFirstDivAttributes, $loLF );
		if( $lcAnchor = $this->Anchor() ){
			$loOutput->AppendToContent( new AElement(array('name'=>$lcAnchor)), $loLF );
		}
		
		$loFieldSet = new FieldsetElement( array() );
		$loFieldSet->setLegend( $this->msLegend );

		$loContent =& $loFieldSet->AppendToContent( $loLF, new DivElement( $this->maSecondDivAttributes ) );

		$loOutItem =& parent::GetOutputPresentation();
		$loContent->AppendToContent( $loOutItem );

		$loFieldSet->AppendToContent( $loLF );
		$loOutput->AppendToContent( $loFieldSet, $loLF );

		return $loOutput;
	}

	function &GetInputPresentation( $paFormAttributes = NULL, 
																	$paFirstDivAttributes = NULL, 
																	$paSecondDivAttributes = NULL ) {
		global $DEBUG;


		if(is_array( $paFirstDivAttributes ) ) {
			$this->maFirstDivAttributes = array_merge( $this->maFirstDivAttributes, 
																									$paFirstDivAttributes );
		}
		if(is_array( $paSecondDivAttributes ) ) {
			$this->maSecondDivAttributes = array_merge( $this->maSecondDivAttributes, 
																									 $paSecondDivAttributes );
		}
		$loLF = new HTMLElement("\n");
		$loOutput = new DivElement( $this->maFirstDivAttributes, $loLF );
		if( $lcAnchor = $this->Anchor() ){
			$loOutput->AppendToContent( new AElement(array('name'=>$lcAnchor)), $loLF );
		}
		
		$loFieldSet = new FieldsetElement( array() );
		$loFieldSet->setLegend( $this->msLegend );

		$loContent =& $loFieldSet->AppendToContent( $loLF, new DivElement( $this->maSecondDivAttributes ) );

		$loOutItem =& parent::GetInputPresentation();
		$loContent->AppendToContent( $loOutItem );

		$loFieldSet->AppendToContent( $loLF );

		if( is_array( $paFormAttributes ) ) {
			$loForm = new FormElement( $paFormAttributes, $loLF, $loFieldSet );

			if(count($this->Hiddens())){
				foreach ( $this->Hiddens() as $lcKey => $lcValue ){
					$loHidden = NULL;
					if( is_object( $lcValue ) ){
						if( method_exists( $lcValue, 'GetHiddenPresentation' ) ) {
							$loHidden = $lcValue->GetHiddenPresentation();
						}
					} else {
						$loHidden = new InputHiddenElement(array('name'=>$lcKey,'value'=>$lcValue));
					}
					$loForm->AppendToContent( $loLF, $loHidden );
				}
				$loForm->AppendToContent( $loLF );
			}

			$loOutput->AppendToContent( $loForm, $loLF );


		} else {
			$loOutput->AppendToContent( $loFieldSet, $loLF );
		}

		return $loOutput;


	}
}
?>