<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.Element.php" );
include_once( dirname(__FILE__) . "/../../page_functions.php" );





class ButtonElement extends Element {

	/* -------------------- Members -------------------- */
	var $ms_Label; // label on button
	var $ms_JS; // javascript of button
	var $ms_ID; // ID of button
	var $maAttr;
	/* -------------------- end Members -------------------- */





	/* -------------------- Constructor -------------------- */
	function ButtonElement( $ps_Label, $ps_JS="javascript:doChange()", 
													$ps_ID=NULL, $paAttr=NULL ) {
		$this->Element();
		$this->SetLabel($ps_Label);
		$this->SetJS($ps_JS);
		$this->SetID($ps_ID);
		$this->Attributes($paAttr);
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- Get.../Set... -------------------- */
	function SetLabel( $ps_Label ) {
		$this->ms_Label = $ps_Label;
	}

	function GetLabel() {
		return $this->ms_Label;
	}

	function SetJS( $ps_JS ) {
		$this->ms_JS = $ps_JS;
	}

	function GetJS() {
		return $this->ms_JS;
	}

	function SetID( $ps_ID ) {
		$this->ms_ID = $ps_ID;
	}

	function GetID() {
		return $this->ms_ID;
	}

	function &Attributes( $paAttr = NULL ){
		if( is_array( $paAttr ) ) {
			$this->maAttr = $paAttr;
		}
		return $this->maAttr;
	}
	/* -------------------- end Get.../Set... -------------------- */





	/* -------------------- definitions of "abstract" methods -------------------- */
	function GetHTML( $withoutDiv = FALSE ) {
		return std_button( $this->GetLabel(), $this->GetJS(), $this->GetID(), 
											 $withoutDiv, $this->Attributes() );
	}

	function printHTML( $withoutDiv = FALSE ){
		echo $this->GetHTML( $withoutDiv );
	}
	/* -------------------- end definitions "abstract" methods -------------------- */

}
?>
