<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once( dirname(__FILE__) . "/class.CompoundElement.php" );
include_once( dirname(__FILE__) . "/class.FormElement.php" );
include_once( dirname(__FILE__) . "/class.PElement.php" );
include_once( dirname(__FILE__) . "/class.TableElement.php" );
include_once( dirname(__FILE__) . "/class.RowOfButtonElement.php" );





class MultiTablesForm extends CompoundElement {

	/* -------------------- Constructor -------------------- */
	function MultiTablesForm( $pa_FormAttributes ) {
		$this->CompoundElement( new FormElement( $pa_FormAttributes ), 
														new RowOfButtonElement() 
														);
		$lo_Form =& $this->GetForm();
		$lo_Form->SetSeparator( "<p>" );
	}
	/* -------------------- end Constructor -------------------- */





	/* -------------------- methods for internal use only -------------------- */
	function &GetForm() {
		return $this->GetContent(0);
	}

	function &GetButtonsArea() {
		return $this->GetContent(1);
	}
	/* -------------------- end methods for internal use only -------------------- */





	/* -------------------- input forms -------------------- */
	function AppendForm( $po_Form ) {
		$lo_Form =& $this->GetForm();
		$lo_Form->AppendToContent( $po_Form );
	}

	function CallOnForms( $ps_Method ) {
		$la_Arguments = func_get_args();
		array_shift( $la_Arguments );
		$lo_Form =& $this->GetForm();
		$la_Elements =& $lo_Form->GetContent();
		foreach( array_keys($la_Elements) as $ls_Key )
			call_user_func_array( array( &$la_Elements[$ls_Key], $ps_Method ), $la_Arguments );
	}
	/* -------------------- end input forms -------------------- */





	/* -------------------- buttons -------------------- */
	function AppendButton( $po_Button ) {
		$lo_ButtonsArea =& $this->GetButtonsArea();
		$lo_ButtonsArea->AppendToContent( $po_Button );
	}
	/* -------------------- end buttons -------------------- */

	/* -------------------- add hidden fields -------------------- */
	function AppendHidden( $po_First ) {
		$la_Arguments = func_get_args();
		$lo_Form =& $this->GetForm();
		call_user_func_array( array( &$lo_Form, "AppendToContent" ), $la_Arguments );
	}
	/* -------------------- end add hidden fields -------------------- */

}
?>
