<?
include_once('class.GenericButtonElement.php');
include_once('class.DivElement.php');
include_once('class.HTMLElement.php');
include_once('class.SpanElement.php');

class PPButtonElement extends DivElement {

	function PPButtonElement( $psLabel, $psOnClick, $psID=NULL, 
														$paDivAttributes = array(), $paButtonAttributes = array() ){

		global $DEBUG;
	
		/*
		if($DEBUG){
			echo "PPButtonElement::PPButtonElement<br><pre>\n";
			print_r(func_get_args());
			echo "</pre><hr>\n";
		}
		*/
	
		$paDivAttributes['title'] = $psLabel;
		$paDivAttributes['onclick'] = $psOnClick;
		if( $psID ){
			$paDivAttributes['id'] = $psID;
		}
		if( !$paDivAttributes['class']) {
			$paDivAttributes['class'] = 'commonButton';
		}

		$loLabel = new HTMLElement( $psLabel );
		$this->DivElement( $paDivAttributes, 
											 new GenericButtonElement( $paButtonAttributes, $loLabel ),
											 new SpanElement( array(), $loLabel ) );

		
	}

	function &getButton() {
		return $this->GetContent( 0 );
	}

	function &getPrompt() {
		return $this->GetContent( 1 );
	}

	function &setLabel( $psLabel ) {
		if(is_object( $psLabel ) ){
			$loLabel =& $psLabel;
		} else {
			$loLabel = new HTMLElement( $psLabel );
		}

		$loItem =& $this->getButton();

		$lcLabel = $loLabel->GetHTML();
		if( strlen($lcLabel)>10){
			$lcLabel = substr( $lcLabel, 0, 7).'...';
		}
		$loItem->Label( $lcLabel );

		$this->setPromptLabel( $loLabel );
	}

	function getLabelString(){
		$loItem =& $this->getPrompt();
		$loHtml =& $loItem->GetContent(0);
		return $loHtml->GetHTML();
	}

	function getOnClick(){
		return $this->GetAttribute('onclick');
	}

	function getID(){
		return $this->GetAttribute('id');
	}

	function setTitle( $psTitle ){
		$this->SetAttribute('title', $psTitle);
	}

	function setPromptLabel( $psLabel ) {
		if(is_object( $psLabel ) ){
			$loLabel =& $psLabel;
		} else {
			$loLabel = new HTMLElement( $psLabel );
		}

		$loItem =& $this->getPrompt();
		$loItem->SetContent( 0, $loLabel );

	}

	function setButtonName( $psName ) {
		$loItem =& $this->getButton();
		return $loItem->SetAttribute('name',$psName);
	}

	function GetHTML(){
		global $confixx_interface_version;

 		if( $confixx_interface_version == 'powp' ) {
			return parent::GetHTML();

		} else {

			return std_button( $this->getLabelString(), 
												 $this->getOnClick(), 
												 $this->getID(), 
												 FALSE ); 
		}
	}

}
?>