<?
/*
 * Classes for drawing interface elements of Confixx Power Pack skin:
 */
class t_GuiPP_PathBar {
	var $path_bar;
	function t_GuiPP_PathBar( $laPathBar=NULL){

		global $PHP_AUTH_USER, $ServerID;
		
		if(is_array($laPathBar)){
			$this->path_bar = $laPathBar;
		} else {
			$this->path_bar = $_SESSION['_users'][$ServerID][$PHP_AUTH_USER][$PHP_AUTH_USER.'_head_info']['path_bar'];
		}

	}

	function draw(){

		global $confixx_skin_dir;
		global $confixx_jscript_dir;
		global $lang_html_charset;
		/*
		echo "<br><pre>\n";
		print_r($this->path_bar);
		echo "</pre><hr>\n";
		*/

		if(count($this->path_bar) > 1) {
			
			$path = '';
			$pathbar = $this->path_bar;
			array_pop($pathbar);
			reset($pathbar);
			foreach($pathbar as $onelink) {
				$help_url = "ver_pp_frame_help.php?help_head_key=".$onelink[4].
					"&help_text_key=".$onelink[5];

				$main_url = "gouplevel.php?pathid=".key($pathbar)."&menu_node_id=".$onelink[2].
					'&prev_page='.$onelink[0];

				$path .= '<a href="#" onClick="parent.contentFrame.mainFrame.location.href='.
					"'$main_url';parent.contentFrame.helpFrame.location.href='$help_url';".
					'return false;">'.($onelink[6]?$onelink[6]:$onelink[1]).'</a> &gt;&nbsp;';
				$prevlink = $onelink;
				next($pathbar);
			}
			$retInd = count($this->path_bar)-2;
			$help_url = "ver_pp_frame_help.php?help_head_key=".$this->path_bar[$retInd][4].
				"&help_text_key=".$this->path_bar[$retInd][5];
			?>
	<table width="100%" cellspacing="0" cellpadding="0" border="0">
	<tr>
	<td><div class="pathbar"><?=$path?></div>
	<div class="screenTitle">
	<table width="100%" cellspacing="0" border="0" cellspacing="0">
	<tr>	
	<td class="icon" style="width:16px;vertical-align:middle;"><div id="menu_item_<?=$this->path_bar[count($this->path_bar)-1][2]?>">
	<img src="<?=$confixx_skin_dir?>images/1x1.gif" width="16" height="16" border="0" alt=""></div></td>
	<td>&nbsp;<?=$this->path_bar[count($this->path_bar)-1][1]?></td>
		<td class="uplevel" nowrap>
		<div class="commonButton" id="bid-up-level" title="<?=ltext('uplevel_label')?>"  
		 onClick="parent.contentFrame.mainFrame.location.href='gouplevel.php?prev_page=<?=$this->path_bar[count($this->path_bar)-2][0]?>&menu_node_id=<?=$this->path_bar[count($this->path_bar)-2][2]?>';parent.contentFrame.helpFrame.location.href='<?=$help_url?>';return false;" >
		<button name="bname_up_level" ><?=ltext('uplevel_label')?></button><span><?=ltext('uplevel_label')?></span></div>
		</td>
	</tr></table>
	</div>
	</td>
	</tr></table>
<?		
		 } else { 
?>
	<table border="0" cellpadding="0" cellspacing="0" summary="Header Layout">
	<tr>
	<td class="icon"><div id="menu_head_<?=$this->path_bar[count($this->path_bar)-1][3]?>">
	<img src="<?=$confixx_skin_dir?>images/1x1.gif" width="32" height="32" border="0" alt=""></div></td>
	<td id="title"><?=$this->path_bar[count($this->path_bar)-1][1]?></td>
	</tr>
	</table>			
<?
				}
		
	}
}
 
 


class tGuiPP_HeadMenuPage {

	var $items  = array();

	var $default_block_name;
	var $default_item_name;
	var $default_url = false;
	var $default_height = 100;
	
	var $head_id;
	var $head_text;
	var $path_bar;
	var $menu_node_id;
	
	function tGuiPP_HeadMenuPage($items, $head_id = '', $head_text = '', $path_bar = array(), $menu_node_id = '') {
		$this->items = $items;
		$this->head_id = $head_id;
		$this->head_text = $head_text;
		$this->path_bar = $path_bar;
		$this->menu_node_id = $menu_node_id;
	}
	
	function set_default($block_name, $item_name) {
		$nav_tree =& $this->items[0];
		$nav_tree->set_default($block_name, $item_name);
		if (!is_array($nav_tree->navigation_items) || !array_key_exists($block_name, $nav_tree->navigation_items))
			return;
		$default_block =& $nav_tree->navigation_items[$block_name];
		if (!array_key_exists($item_name, $default_block->menu_items))			
			return;
		$this->default_block_name = $block_name;
		$this->default_item_name  = $item_name;
	}


	function draw() {

		//		$this->draw_header_();

		if (count($this->items)) {
			$this->draw_menu_header_();
			foreach ($this->items as $item) {
				$item->draw();
			}
			$this->draw_footer_();
		}
	}
	
	function set_default_url($url)
	{
		$this->default_url = $url;
	}
	
	function draw_header_()	{

		$loPathBar = new t_GuiPP_PathBar($this->path_bar);

		$loPathBar->draw();
	
	}
	
	function draw_menu_header_() {
		global $confixx_skin_dir;
		global $confixx_jscript_dir;
		global $lang_html_charset;

?>
	<div class="toolsArea" id="tls_main" name="tls_main">
	<fieldset>
	<legend>Tools</legend>
	<div class="screenButtons">

<?
	}
	
	function draw_footer_() {
?>
	</div>
	</fieldset>
	</div>
<?
	}
}

class tGuiPP_HeadMenuItem {
	var $id = '';		// for decoration
	var $node_id = '';	// for javascript
	var $orig_id = '';	//  
	var $text = "Menu Item";
	var $href = NULL;
	var $enabled = true;
	
	// href is an object of tGuixPP_HrefXxx
	function tGuiPP_HeadMenuItem($id, $text, $href, $enabled = true) {
		$this->id = "menu_head_$id";	// element prefix
		$this->orig_id = $id;
		$this->text = $text;
		$this->href = $href;
		$this->enabled = $enabled;
	}

	function getName() {
		return $this->orig_id;
	}
	
	function make_unique($parent_id) {
		$this->node_id = "menu_node_" . $parent_id . "_" . $this->orig_id;
	}

	function getNavigationId() {
		//echo $this->id.' -- menuitem<br>';
		return $this->node_id;
	}

	/**
	 * Return content URL
	 * return: (string) content url or false 
	 */
	function getContentUrl() {
		return (method_exists($this->href, 'getContentUrl')) ? $this->href->getContentUrl() : false;
	}
		
	function getText() {
		return $this->text;
	}
	
	function draw() {
		global $confixx_skin_dir;

		if (!$this->enabled)
			return;
		
		$a_str = $this->href->getTarget($this->orig_id, $this->node_id, $this->text);
// ******************************************************** html ?>		
		<div class="commonButton" id="<?=$this->id?>" title="<?=$this->text?>" <?=$a_str?> >
		<button name="<?=$this->id?>" ><?=$this->text?></button>
		<span><?=$this->text?></span>
		</div>
<? // ***************************************************** end of html
	}
}

class tGuiPP_HeadMenuHref {
	var $content_url   = "";
	var $help_head_key = "";
	var $help_text_key = "";

	function tGuiPP_HeadMenuHref($content_url, $help_head_key = '', $help_text_key = '') {
		$this->content_url = $content_url;
		$this->help_head_key = $help_head_key;
		$this->help_text_key = $help_text_key;	
	}

	function set_content_url($url) {
		$this->content_url = $url;
	}

	function getContentUrl() {
		return $this->content_url;
	}
		
	function getTarget($item_id, $node_id, $head_text) {
		$js_f = $this->getJsFunc($item_id, $node_id, $head_text);
		return "onclick=\"return $js_f;\"";
	}
	
	function getJsFunc($item_id, $node_id, $head_text) {
		global $PHP_AUTH_USER;
		$enc_head_text = urlencode($head_text);
		if (substr_count($this->content_url,"?")) $delimeter = "&";
		else $delimeter = "?";				
		$href_str = $this->content_url.$delimeter."menu_node_id=".$item_id."&cur_page=".$this->content_url."&head_text=".$enc_head_text;
		$help_href_str = "ver_pp_help.php?help_head_key=$this->help_head_key&help_text_key=$this->help_text_key";		
		$lcHead = $this->help_head_key;
		$lcText = $this->help_text_key;
		return "parent.parent.openHeadMenuItem ('$href_str', '$lcHead', '$lcText')";
	}	
}

/**
 *  Functional element: returns properties of <A> to open menu item in new window
 */
class tGuiPP_HeadMenuHrefExt {
	var $href   = "";

	function tGuiPP_HeadMenuHrefExt($href) {
		$this->href = $href;
	}

	function getTarget($item_id, $node_id, $head_text) {
		$js_f = $this->getJsFunc($item_id, $node_id, $head_text);
		return 'onclick = "'.$js_f.'"';
	}
	
	function getJSFunc()
	{
		return 'window.open(\''.$this->href.'\')';
	}	
	
}

class tGuiPP_HrefTop {
	var $href   = "";

	function tGuiPP_HrefTop($href) {
		$this->href = $href;
	}

	function getTarget() {
		return 'onclick="top.location.href=\''.$this->href.'\'"';
	}
	
	function getJSFunc()
	{
		return 'top.location.href=\''.$this->href.'\'';
	}
}

//////////////// make functions /////////////////////////////////////
function make_menu_item($id, $text, $href, $enabled = true) {
	return (new tGuiPP_HeadMenuItem($id, $text, $href, $enabled));
}

function make_menu_target_int($url, $help_head_key = '', $help_text_key = '') {
	return (new tGuiPP_HeadMenuHref($url, $help_head_key, $help_text_key));
}

function make_menu_target_ext($url) {
	return (new tGuiPP_HeadMenuHrefExt($url));
}

function make_menu_target_top($url) {
	return (new tGuiPP_HrefTop($url));
}
?>
