<?php
/*
 * Classes for drawing interface elements:
 *   tGuiXP_LeftMenuPage
 *   tGuiXP_ShortcutsBlock
 *   tGuiXP_ShortcutItem
 *   tGuiXP_NavigationContainer
 *   tGuiXP_MenuBlock
 *   tGuiXP_MenuItem
 */

include_once ( dirname(__FILE__) . "/../class.PathBar.php" );

class tGuiXP_LeftMenuPage {

	var $items  = array();

	var $default_block_name;
	var $default_item_name;
	var $default_url = false;
	var $default_height = 100;
	
	function tGuiXP_LeftMenuPage($items, $pi_height=100) {
		$this->default_height = $pi_height;
		$this->items = $items;
	}

	function set_height ( $pi_height ){
		$this->default_height = $pi_height;
 	}
	
	function set_default($block_name, $item_name) {
		$nav_tree =& $this->items[0];
		$nav_tree->set_default($block_name, $item_name);
		if (!is_array($nav_tree->navigation_items) || !array_key_exists($block_name, $nav_tree->navigation_items))
			return;
		$default_block =& $nav_tree->navigation_items[$block_name];
		if (!array_key_exists($item_name, $default_block->menu_items))			
			return;
		
    $laParams = array(
      "head_id"        => $default_block->menu_items[$item_name]->getName(),
      "head_text"      => $default_block->menu_items[$item_name]->getText(), 
      "menu_node_id"   => $default_block->menu_items[$item_name]->getNavigationId(),
      "main_menu_page" => $default_block->menu_items[$item_name]->getContentUrl()
    );
    
    $loPathBar = new PathBar();
    
    if( $laParams['top'] ){ 
      $loPathBar->cleanPathBar();
    } 
    
    $loPathBar->pushPathBar( $laParams );
    
		$this->default_block_name = $block_name;
		$this->default_item_name  = $item_name;
	}


	function draw() {
		$this->draw_header_();
		foreach ($this->items as $item) {
			$item->draw();
		}
		$this->draw_footer_();
	}
	
	function set_default_url($url)
	{
		$this->default_url = $url;
	}
	
	function draw_header_() {
		global $confixx_skin_dir;
		global $confixx_jscript_dir;
		global $lang_html_charset;
		global $ServerID;
		global $master_confixx;
		
    $lcLogo = $confixx_skin_dir;
		$lcLogo .= $master_confixx == 2 ? 'images/logodc.gif' : 'images/logo.gif' ;
		
		// 	
?>
<!--</body></html>-->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
  <html>
  <head>
      <title></title>
      <meta http-equiv="Content-Type" content="text/html; charset=<?=$lang_html_charset?>"/>
      <link rel="stylesheet" type="text/css" href="<?=$confixx_skin_dir?>css/general.css"/>
      <link rel="stylesheet" type="text/css" href="<?=$confixx_skin_dir?>css/nav.css"/>
      <link rel="stylesheet" type="text/css" href="<?=$confixx_skin_dir?>css/images.css"/>
      <link rel="stylesheet" type="text/css" href="<?=$confixx_skin_dir?>css/dtree.css"/>
  </head>

<script language="javascript" type="text/javascript" src="<?=$confixx_jscript_dir?>ver_xp30_leftframe.js"></script>
<script language="javascript" type="text/javascript" src="<?=$confixx_jscript_dir?>dtree.js"></script>
<body>
<table id="navArea" cellspacing="0" cellpadding="0" width="100%" border="0" height="<?=$this->default_height?>%" summary="Navigation Items Area">
<tr>
<td>
	<a href="http://www.swsoft.de/products/confixx/" target="_blank"  title="<?=ltext('go_to_confixx')?>"><img src="<?=$lcLogo?>" width="158" height="67" border="0" alt="<?=ltext('go_to_confixx')?>" /></a>
	
<?		if($_SESSION['_users'][$ServerID][$PHP_AUTH_USER]['type'] == USERTYPE_ADMIN) {
			$id = safe_query("select defaultserver from bdefault WHERE server_id='$ServerID'");
			if ($werte = db_fetch_array($id)) {
				$keyserver = $werte["defaultserver"];
				
				if ($keyserver){
					$id = safe_query( "SELECT Servername FROM bmysql WHERE KeyServer = ? AND server_id='$ServerID'", TRUE, new SQLInteger($keyserver) );
					if ($werte = db_fetch_array($id)) $servername = $werte["Servername"];
					?>
					<table border="0" cellspacing="0" cellpadding="0" width="100%" class="navOpened"><tr><td>
						<table border="0" cellspacing="0" cellpadding="0" class="navTitle" width="100%">
						<tr><td class="titleLeft"><img src="<?=$confixx_skin_dir?>images/1x1.gif" width="8" height="1" border="0" alt=""/></td>
						<td class="titleText">
							<?=ltext("m_server")?>:&nbsp;<?=$servername?>
						</td></tr>
						</table></td></tr>
					</table>
					<?
				}
			}
		}
	}
	
	function draw_footer_() {
		global $confixx_skin_dir;
		
		$nav_tree =& $this->items[0];
		if(is_array($nav_tree->navigation_items))
		{
			//return;	
		
		if (!empty($this->default_block_name) 
		 && !empty($this->default_item_name)) {
			$default_block =& $nav_tree->navigation_items[$this->default_block_name];
			$default_item =& $default_block->menu_items[$this->default_item_name];
		} else {
			$default_block =& reset($nav_tree->navigation_items);
			$default_item =&  reset($default_block->menu_items);
		}
		$def_block_id  = $default_block->getNavigationId();
		$def_item_id   = $default_item->getNavigationId();

		// lets think how to do it in OO-approach

		$def_item_href = $default_item->href;
		if($this->default_url)
		{
			$def_item_href->set_content_url($this->default_url);
		}
		$activate_f    = $def_item_href->getJsFunc($default_item->orig_id, $def_item_id, $default_item->text);
		}
?>
</td>
</tr>
<tr>
  <td align="left">


<!-- SWsoft copyright -->
<div id="swsoftInfo">
        <div id="poweredBy"><table border="0" cellspacing="0" cellpadding="0"><tr><td><a href="http://www.swsoft.de" target="_blank" title="<?=ltext('go_to_swsoft')?>">Powered by </a></td><td style="padding-left:5px;"><a href="http://www.swsoft.de" target="_blank" title="<?=ltext('go_to_swsoft')?>"><img src="<?=$confixx_skin_dir?>images/swsoftpoweredby.gif" border="0" alt="<?=ltext('go_to_swsoft')?>" ></a></td></tr></table>
</div>
<div id="copyright"><a href="http://www.swsoft.de" target="_blank" title="<?=ltext('go_to_swsoft')?>" >&copy; Copyright 1999-2006 SWsoft, Inc.<br/> All rights reserved</a></div>
      </div>
</td>
</tr>
</table>


</body>
<script language="javascript">
<!--
var activeItem = '';
<?=$activate_f?>;
//-->
</script>
</html>
<?
	}
}

class tGuiXP_ShortcutsBlock {
	var $shortcut_items = array();

	//function tGuiXP_ShortcutsContainer ($items) {
	function tGuiXP_ShortcutsBlock ($items) {
		$this->shortcut_items = $items;
	}
	
	function draw() {
		if (sizeof($this->shortcut_items) == 0)
			return;
		$this->draw_header_();
		foreach ($this->shortcut_items as $item) {
			$item->draw();
		}
		$this->draw_footer_();
	}
	
	function draw_header_() {
?>
		<fieldset class="shortcuts">
		    <legend><? echo ltext('confixx_easy');?></legend>
<?
	}
	
	function draw_footer_() {
?>
		</fieldset>
<?
	}
}

class tGuiXP_ShortcutItem {
	var $href = '#';
	var $text = 'Bookmark';
	var $icon = 'images/icon1.gif';
	var $id   = '';
	var $orig_id = '';
	
	function tGuiXP_ShortcutItem($id, $text, $href) {
		$this->id = 'shortcut_' . $id;
		$this->orig_id = $id;
		$this->text = $text;
		$this->href = $href;
	}
	
	function draw() {
		global $confixx_skin_dir;
		global $confixx_jscript_dir;
		// "title=?"
		$a_str = $this->href->getTarget(); 
?>
		<a <?=$a_str?> title="<?=$this->text?>" id="<?=$this->id?>" class="node"><?=$this->text?></a>
<?
	}
}

class tGuiXP_NavigationContainer {
	var $navigation_items = array();

	function tGuiXP_NavigationContainer($items) {
		foreach ($items as $item) {
			$this->navigation_items[$item->getName()] = $item;
		}
	}

	function draw() {
		if (sizeof($this->navigation_items) == 0)
			return;
		$this->draw_header_();
		foreach ($this->navigation_items as $item) {
			$item->draw();
		}
		$this->draw_footer_();
	}
	
	function set_default($a, $b)
	{
		
	}

	function draw_header_() {
	
?>	
		<div id="navLayout">
<?
	}
	
	function draw_footer_() {
?>
		</div>
<?
	}
}

class tGuiXP_ActionButton
{
	var $id = '';	
	var $text = '';
	var $href = '';
	var $orig_id = '';
	
	function tGuiXP_ActionButton($id, $text, $href)
	{
		$this->orig_id = $id;
		$this->id = "action_button_".$id;
		$this->text = $text;
		$this->href = $href;
	}
	
	function draw()
	{
		$a_str = $this->href->getTarget(); 
?>
		<table border="0" cellspacing="0" cellpadding="0" class="navSpecial" width="100%">
			<tr>
				<td>
					<a <?=$a_str?> title="<?=$this->text?>" class="node" id="<?=$this->id?>"><?=$this->text?></a>
				</td>
			</tr>
		</table>
<?		
	}
}

class tGuiXP_MenuBlock {
	var $id = '';
	var $id_orig = '';
	var $menu_items = array();
	var $default_item_id = '';
	var $text = "Item";
	var $opened = false;
	
	function tGuiXP_MenuBlock($id, $text, $default, $items, $opened = false) {
		$this->id = "menu_block_$id";
		$this->orig_id = $id;
		$this->text = $text;
		$this->default_item_id = $default;
		$this->opened = $opened;
		
		foreach ($items as $item) {
			$item->make_unique($this->orig_id);
			$this->menu_items[$item->getName()] = $item;
		}
	}

	function getName() {
		return $this->orig_id;
	}

	function getNavigationId() {
		//echo $this->id.' -- menublock<br>';
		return $this->id;
	}
	
	function draw() {
		$this->draw_header_();
		foreach ($this->menu_items as $item) {
			$item->draw();
		}
		$this->draw_footer_();
	}

	function draw_header_() {
		global $confixx_skin_dir;
?>
		<table border="0" cellspacing="0" cellpadding="0" width="100%" class="<?=(($this->opened) ? 'navOpened' : 'navClosed')?>" id="<?=$this->id?>">
			<tr>
				<td>

	
					<table border="0" cellspacing="0" cellpadding="0" width="100%" class="navTitle" onclick="return opentree ('<?=$this->id?>');">
					<tr>
						<td class="titleLeft"><img src="<?=$confixx_skin_dir?>images/1x1.gif" width="14" height="1" border="0" alt=""/></td>
						<td class="titleText" width="100%"><?=htmlspecialchars($this->text)?></td>
						<td class="titleHandle" id="<?=$this->id?>_title"><img src="<?=$confixx_skin_dir?>images/1x1.gif" width="22" height="1" border="0" alt=""/></td>
						<td class="titleRight"><img src="<?=$confixx_skin_dir?>images/1x1.gif" width="3" height="1" border="0" alt=""/></td>
					</tr>
					</table>
	
	
	
	
				</td>
			</tr>
			<tr>
				<td>
      <div class="tree" id="<?=$this->id?>_tree">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td>
<?
	}

	function draw_footer_() {
?>
							</td>
						</tr>
					</table>
      </div>
				</td>
			</tr>
		</table>
<?
	}
}

class tGuiXP_MenuItem {
	var $id = '';		// for decoration
	var $node_id = '';	// for javascript
	var $orig_id = '';	//  
	var $text = "Menu Item";
	var $href = NULL;
	var $enabled = true;
	var $top = false;
	var $class = 'nodeImage';
	
	// href is an object of tGuixXP_HrefXxx
	function tGuiXP_MenuItem($id, $text, $href, $enabled = true, $top = false, $class = 'nodeImage') {
		$this->id = "menu_item_$id";	// element prefix
		$this->orig_id = $id;
		$this->text = $text;
		$this->href = $href;
		$this->enabled = $enabled;
		$this->top = $top;
		$this->class = $class;
	}

	function getName() {
		return $this->orig_id;
	}
	
	function make_unique($parent_id) {
		$this->node_id = "menu_node_" . $parent_id . "_" . $this->orig_id;
	}

	function getNavigationId() {
		//echo $this->id.' -- menuitem<br>';
		return $this->node_id;
	}
	
  function setClass( $class = null ){
	  if( is_string( $class ) ){
		  $this->class = $class;
	  }
	}
	
	function getClass(){
		return $this->class;
	}
	
	function setTop( $top = null ){
	  if( is_string( $top ) ){
		  $this->top = $top;
	  }
	}
	
	function getTop(){
		return $this->top;
	}
	
	/**
	 * Return content URL
	 * return: (string) content url or false 
	 */
	function getContentUrl() {
		return (method_exists($this->href, 'getContentUrl')) ? $this->href->getContentUrl() : false;
	}
		
	function getText() {
		return $this->text;
	}
	
	function draw() {
		global $confixx_skin_dir;

		if (!$this->enabled)
			return;
		
		$a_str = $this->href->getTarget($this->orig_id, $this->node_id, $this->text);
		// title = ?
		// 2 ids (<table> and <td>) ???
// ******************************************************** html ?> 
				 <table border="0" cellspacing="0" cellpadding="0" width="100%" id="<?=$this->node_id?>" class="node">
				 <tr>
			 		<td class="<?=$this->class?>" id="<?=$this->id?>"><a title="<?=$this->text?>" <?=$a_str?>><img src="<?=$confixx_skin_dir?>images/1x1.gif" width="16" height="16" border="0" alt=""></a></td>
					<td width="100%" style="vertical-align: middle;"><span class="name"><a title="<?=$this->text?>" <?=$a_str?>><?=$this->text?></a></span></td> 
				 </tr>
				 </table>
<? // ***************************************************** end of html
	}
}

/**
 *  Functional element: returns properties of <A> to open menu item in new window
 */

class tGuiXP_HrefFrame {
	var $href   = "";
	var $target = "";

	function tGuiXP_HrefFrame ( $href, $target='' ) {
		$this->href = $href;
		$this->target = $target;
	}

	// item_id = item id (w/o any prefix)
	// node_id = full js name
	function getTarget($item_id, $node_id, $head_text) {
		$ret = 'href="'.$this->href.'"';
		if ( $this->target ){
			$ret .=  ' target="'.$this->target.'"';
		}
		return $ret;
	}
	
	function getJSFunc()
	{
		return 'open(\''.$this->href.'\')';
	}	
	
}

 
class tGuiXP_HrefExt {
	var $href   = "";

	function tGuiXP_HrefExt($href) {
		$this->href = $href;
	}

	// item_id = item id (w/o any prefix)
	// node_id = full js name
	function getTarget($item_id, $node_id, $head_text) {
		return 'href="'.$this->href.'" target="_new"';
	}
	
	function getJSFunc()
	{
		return 'open(\''.$this->href.'\')';
	}	
	
}

class tGuiXP_HrefTop {
	var $href   = "";

	function tGuiXP_HrefTop($href) {
		$this->href = $href;
	}

	// item_id = item id (w/o any prefix)
	// node_id = full js name
	function getTarget() {
		return 'href="#" onclick="top.location.href=\''.$this->href.'\'"';
	}
	
	function getJSFunc()
	{
		return 'top.location.href=\''.$this->href.'\'';
	}
}
	
/**
 *  Functional element: returns properties of <A> to open menu item in new window
 */
class tGuiXP_HrefInt {
	var $content_url   = "";
	var $help_head_key = "";
	var $help_text_key = "";
	var $top;

	function tGuiXP_HrefInt($content_url, $help_head_key, $help_text_key, $top = false) {
		$this->content_url   = $content_url;
		$this->help_head_key = $help_head_key;
		$this->help_text_key = $help_text_key;
		$this->top = $top;
	}
	
	function set_content_url($url)
	{
		$this->content_url = $url;
	}

	function getContentUrl() {
		return $this->content_url;
	}
	
	// item_id = css name (w/o prefix)
	// node_id = full js name
	function getTarget($item_id, $node_id, $head_text) {
		$js_f = $this->getJsFunc($item_id, $node_id, $head_text);
		return "href=\"#\" onclick=\"return $js_f;\"";
	}

	// item_id = css name (w/o prefix)
	// node_id = full js name
	function getJsFunc($item_id, $node_id, $head_text) {
		$enc_head_text = urlencode($head_text);
		$href_str = "$this->content_url";
		$help_href_str = "ver_xp30_frame_help.php?help_head_key=$this->help_head_key&help_text_key=$this->help_text_key";
		$top_href_str = "ver_xp30_frame_top.php?head_id=$item_id&head_text=$enc_head_text";
		
		return "openScreen ('$node_id', '$href_str', '$help_href_str', '$top_href_str')";
	}
}

class tGuiXP_HrefIntTree
{
	var $content_url   = "";
	var $help_head_key = "";
	var $help_text_key = "";
	
	function tGuiXP_HrefIntTree($content_url, $help_head_key, $help_text_key)
	{
		$this->content_url   = $content_url;
		$this->help_head_key = $help_head_key;
		$this->help_text_key = $help_text_key;
	}
	
	function set_content_url($url)
	{
		$this->content_url = $url;
	}
	
	function getJsFunc($item_id, $head_text) {
		$enc_head_text = urlencode($head_text);
		$href_str = "$this->content_url";
		$help_href_str = "ver_xp30_frame_help.php?help_head_key=$this->help_head_key&help_text_key=$this->help_text_key";
		$top_href_str = "ver_xp30_frame_top.php?head_id=$item_id&head_text=$enc_head_text";
		
		return "openScreenFromTree ('$href_str', '$help_href_str', '$top_href_str')";
	}
}

class MenuItem
{
	var $title = '';
	var $iid;
	var $pid;
	var $icon;
	
	var $m_pid = '';
	
	var $m_id;
	
	function MenuItem($title, $icon = '')
	{
		$this->title = $title;
		$this->icon = $icon;
	}
	
	function setId($id)
	{
		$this->iid = $id;
	}
	
	function setPid($pid)
	{
		$this->pid = $pid;
	}
	
	function getId()
	{
		return $this->iid;
	}
	
	function getPid()
	{
		return $this->pid;
	}
	
	function isEnabled()
	{
		return true;
	}
	
	function getString()
	{
		return '';
	}
	
	function setParentId($id)
	{
		
	}
	
	function getMenuId()
	{
		return $this->m_id;	
	}
}


class FolderMenuItem extends MenuItem
{
	var $op_icon;
	var $opened = false;
	var $items = array();
	//var $m_id;
	
	
	function FolderMenuItem($id, $title, $items, $icon ='', $op_icon = '', $opened = false)
	{
		$this->MenuItem($title, $icon);
		$this->op_icon = $op_icon;
		$this->opened = $opened;
		$this->m_id = $id;
		$this->items = $items;
	}
	
	function addMenuItem($item)
	{
		$this->items[] = $item;
	}
	
	function getString()
	{
		return "$this->iid, $this->pid, '$this->title', '', '$this->title', '', '$this->icon', '$this->op_icon', " . ($this->opened?'true':'false');
	}
	
}

class LinkMenuItem extends MenuItem
{
	var $link;
	//var $m_id;
	var $orig_id;
	var $enabled;
	
	function LinkMenuItem($id, $title, $link, $icon = '', $enabled = true)
	{
		$this->MenuItem($title, $icon);
		$this->orig_id = $id;
		$this->m_id = "menu_item_$id";
		$this->link = $link;
		$this->enabled = $enabled;
	}
	
	function isEnabled()
	{
		return $this->enabled;	
	}
	
	function getLink()
	{
		return $this->link->getJsFunc($this->orig_id, $this->title);
		
	}
	
	function getString()
	{
		//mytree.add(1, 0, 'My node', 'node.html', 'node title', 'mainframe', 'img/musicfolder.gif');
		
		//print_r($this->link);
		$link = str_replace("'", "\\'", $this->getLink());
		return "$this->iid, $this->pid, '$this->title', 'javascript:$link', '$this->title', '', '$this->icon', '', '', '$this->m_id'";
		//id, pid, name, url, title, target, icon, iconOpen, open, im_id
	}
	
	function setParentId($id)
	{
		$this->m_pid = $id;	
	}
}


class TreeMenu
{
	var $items = array();
	
	var $_items_to_draw = array();
	
	var $counter = 0;
	
	var $skindir;
	
	var $title = 'Confixx';
	
	var $default_block = '';
	
	var $default_item = '';
	
	var $default_url = '';
	
	function TreeMenu($items, $title, $skindir)
	{
		$this->items = $items;
		$this->title = $title;
		$this->skindir = $skindir;
	}	
	
	function set_default($block_name, $item_name)
	{
		$this->default_block = $block_name;
		$this->default_item = $item_name;
	}
	
	function set_default_url($url)
	{
		$this->default_url = $url;
	}
	
	function addMenuItem($item)
	{
		$this->items[] = $item;		
	}
	
	function _addDrawItem($item)
	{
		$this->_items_to_draw[] = $item;	
	}
	
	function _u($item)
	{
		if(isset($item->items) && count($item->items))	
		{
			foreach ($item->items as $i)	
			{
				if($i->isEnabled())
				{
					$i->setPid($item->getId());
					$i->setId($this->_getNextId());
					$i->setParentId($item->getMenuId());
					$this->_addDrawItem($i);
					$this->_u($i);
				}
			}
		}
	}
	
	function _setCounters()
	{
		foreach ($this->items as $item)	
		{
			if($item->isEnabled())
			{
				$item->setPid(0);
				$item->setId($this->_getNextId());
				$this->_addDrawItem($item);
				$this->_u($item);
			}
		}
	}
	
	function _getNextId()
	{
		//$c = $this->counter;
		$this->counter++;
		return $this->counter;	
	}
	
	function draw()
	{
		$this->_setCounters();
		//print_r($this->_items_to_draw);
		$link = '';
		$link_id = 0;
?>
<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td>
<script>
d = new dTree('d');

d.setSkinDir('<?=$this->skindir?>');

d.add(0,-1,'<?=$this->title?>', '', '', '', '', '', true);
<?
		foreach ($this->_items_to_draw as $item):
			if($this->default_block == $item->m_pid && $this->default_item == $item->orig_id)
			{
				//echo "\n //aaa \n";	
				$link = $item->getLink() . ';';
				$link_id = $item->getId();
				
			}
?>
d.add(<?=$item->getString()?>);
<?
		endforeach;
?>



document.write(d);

d.s(<?=$link_id?>);

<?=$link?>

                //q = d.toString();
                //document.write('<pre>');
                //document.write(q.replace( /</g , '&lt;'));
                //document.write('</pre>');
               

</script>
</td></tr></table>
<?
	}
}

?>
