<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/class.Service.php" );





class AllLimits
{

    /* -------------------- Members -------------------- */
    var $ma_Services; // array of objects of type Service
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function AllLimits ( )
    {
			$la_Parameters = func_get_args();
			call_user_func_array ( array( &$this, "Initialize" ), $la_Parameters );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- Initialize -------------------- */
    function Initialize()  {
			$this->ma_Services = array();
			$la_Arguments = func_get_args();

			if ( FALSE ) { ## yet time
				$this->AddService ( $la_Arguments, ltext("al_drweb"), "drweb", 1 );
				$this->AddService ( $la_Arguments, ltext("al_webshop"), "webshop", 1,
														array(  "angebote" => NULL, "kunden" => NULL, "regrequest" => NULL ) );
			} ## /yet time

    }
    /* -------------------- end Initialize -------------------- */





    /* -------------------- AddService -------------------- */
    function AddService ( $pa_Arguments, $ps_Label, $ps_Name, $ps_Value, $pa_Names=array() ) {
			$ls_Method = array_shift ($pa_Arguments);
			if ( !strlen($ls_Method) )
				$this->ma_Services[$ps_Name] = new Service ( $ps_Label, $ps_Name, $ps_Value, $pa_Names );
			else {
				$lo_Service = new Service ( $ps_Label, $ps_Name, $ps_Value, $pa_Names );
				if ( call_user_func_array( array ( &$lo_Service, $ls_Method ) , $pa_Arguments ) )
					$this->ma_Services[$ps_Name] = $lo_Service;
			}
    }
    /* -------------------- end AddService -------------------- */





    /* -------------------- iteration over elements -------------------- */
    function FirstService()
    {
			reset ( $this->ma_Services );
    }

    function &NextService()
    {
			return ( list ( $key ) = each ( $this->ma_Services ) ) ? $this->ma_Services[$key] : NULL;
    }
    /* -------------------- end iteration over elements -------------------- */





    /* -------------------- SetFromRow -------------------- */
    function SetFromRow ( $pa_Row )
    {
			foreach ( array_keys($this->ma_Services) as $ls_Key )
				$this->ma_Services[$ls_Key]->SetFromRow ($pa_Row);
    }
    /* -------------------- end SetFromRow -------------------- */





    /* -------------------- GetHiddens -------------------- */
    function GetHiddens()
    {
			$ls_Result = "";
			foreach ( array_keys($this->ma_Services) as $ls_Key )
				$ls_Result .= $this->ma_Services[$ls_Key]->GetHiddenHTML();
			return $ls_Result;
    }
    /* -------------------- end GetHiddens -------------------- */





    /* -------------------- SQL processing -------------------- */
    function SQLInsertFields ( $ps_Table )
    {
			$ls_Result = "";
			foreach ( array_keys($this->ma_Services) as $ls_Key )
				if ( ! is_null( $ls_Name = $this->ma_Services[$ls_Key]->GetNameForTable ($ps_Table) ) )
					$ls_Result .= ", $ls_Name ";
			return substr ( $ls_Result, 1 );
    }

    function SQLInsertValues ( $ps_Table )
    {
			$ls_Result = "";
			foreach ( array_keys($this->ma_Services) as $ls_Key )
				if ( ! is_null( $this->ma_Services[$ls_Key]->GetNameForTable ($ps_Table) ) )
					$ls_Result .= ", " . $this->ma_Services[$ls_Key]->GetValue(); // that's OK - no quoting is needed here
			return substr ( $ls_Result, 1 );
    }

    function SQLUpdateValues ( $ps_Table )
    {
			$ls_Result = "";
			foreach ( array_keys($this->ma_Services) as $ls_Key )
				if ( ! is_null( $ls_Name = $this->ma_Services[$ls_Key]->GetNameForTable ($ps_Table) ) )
					$ls_Result .= ", $ls_Name=" .
						$this->ma_Services[$ls_Key]->GetValue(); // that's OK - no quoting is needed here
			return substr ( $ls_Result, 1 );
    }

		function &SQLFieldSet ( $ps_Table ) {
			$la_Result = array();
			foreach ( array_keys($this->ma_Services) as $ls_Key ) {
				if ( ! is_null( $ls_Name = $this->ma_Services[$ls_Key]->GetNameForTable ($ps_Table) ) ) {
					$la_Result[ $ls_Name ] =  $this->ma_Services[$ls_Key]->GetValue();
				}
			}
			return $la_Result;
    }
		
    /* -------------------- end SQL processing -------------------- */

}
?>
