<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'Mail.php' );
include_once( 'Mail/mime.php' );

/**
 * Wrapper for PEAR:: Mail_mime
 *
 * @author       Confixx team
 * @category     Mail
 */
class ConfixxMime extends Mail_mime
{
  /**
  * Constructor
  */
  function ConfixxMime()
  {
    $laArgs = func_get_args();
    call_user_func_array( array( &$this, 'Mail_mime'), $laArgs );
  }
 
 /**
  * Set/Get  build parameters
  * @return array 
  */
  function buildParams($paParams = NULL)
  {
    if( is_array( $paParams ) ){
      $this->_build_params = array_merge($this->_build_params, $paParams);
    }
    return $this->_build_params;
  }

  /**
   * Encodes a header as per RFC2047
   *
   * @param  string  $input The header data to encode
   * @return string  Encoded data
   * @access private
   */
  function _encodeHeaders( $input ){
    foreach ($input as $hdr_name => $hdr_value) {
        if( $hdr_name == 'Subject' ){
          $liStrlen = 73 - strlen('=?' . $this->_build_params['head_charset']);
          $laParts = str_split($hdr_value, intval( ceil( $liStrlen / 3 ) ) );
          $input[$hdr_name] = '';
          $liCounter = 0;
          foreach( $laParts as $lcValue ){
            preg_match_all( '/\w*([\x80-\xFF]+)\w*/', $lcValue, $matches );
            foreach ($matches[1] as $value) {
                $replacement = preg_replace('/([\x80-\xFF])/e',
                                            '"=" .
                                            strtoupper(dechex(ord("\1")))',
                                            $value);
                // $lcValue = str_replace( $value, $replacement, $lcValue );
                $lcValue = preg_replace( '~'.preg_quote($value).'~', $replacement, $lcValue, 1 );
            }
            $input[$hdr_name] .= $liCounter ? "\n " : "";
            $input[$hdr_name] .= "=?" . $this->_build_params['head_charset']."?Q?" . $lcValue . "?=";
            $liCounter++;
          }
        }else{
          preg_match_all('/(\w*[\x80-\xFF]+\w*)/', $hdr_value, $matches);
          foreach ($matches[1] as $value) {
              $replacement = preg_replace('/([\x80-\xFF])/e',
                                          '"=" .
                                          strtoupper(dechex(ord("\1")))',
                                          $value);
              $hdr_value = str_replace($value, '=?' .
                                       $this->_build_params['head_charset'] .
                                       '?Q?' . $replacement . '?=',
                                       $hdr_value);
          }
          $input[$hdr_name] = $hdr_value;
      }
    }
    return $input;
  }
}
    
?>
