<?
function &parseURL( $pcURL ){

	global $DEBUG;

	if( $DEBUG ){
		echo "parseURL: start : $pcURL<br>\n";
	}

	$laURL = array();

	$laItems = split( '://', $pcURL, 2);
	if( count( $laItems ) > 1 ){
		if( preg_match( '/^\w+$/', $laItems[0] ) ){
			$laURL['prot'] = $laItems[0];	 
			$pcURL = $laItems[1];
		}
	}

	$laItems = split( '@', $pcURL, 2);
	if( count( $laItems ) > 1 ){
		if( preg_match( '/^((?:\w|\d)+)(:(?:\w|\d)+)?$/', $laItems[0], $laMatchs ) ){
			$laURL['user'] = $laMatchs[1];
			if(count($laMatchs)>1){
				$laURL['pass'] = $laMatchs[2];
			}
			$pcURL = $laItems[1];
		}
	}

	$laItems = split( '/', $pcURL, 2);
	if( count( $laItems ) > 1 ){
		$lcHost = $laItems[0];
		$pcURL = '/'.$laItems[1];
	}else{
		$lcHost = $pcURL;
		$pcURL = '';
	}

	if( preg_match( '/(.*):(\d)+$/', $lcHost, $laMatchs ) ) {
		$laURL['host'] = $laMatchs[1];
		$laURL['port'] = $laMatchs[2];
	}else{
		$laURL['host'] = $lcHost;
	}

	if( $pcURL ){
		$laItems = split( '\?', $pcURL, 2);
		if( count( $laItems ) > 1 ){
			$laURL['path'] = $laItems[0];
			$laURL['query'] = $laItems[1];
		}else{
			$laURL['path'] = $pcURL;
		}
	}

	if( $DEBUG ){
		echo "parseURL: srop<br><pre>\n";
		print_r( $laURL );
		echo "</pre><hr>\n";
	}

	return $laURL;
}

function makeURL( &$paURL ){
	if( ! is_array( $paURL ) ){
		return $paURL;
	}
	$lcURL='';
	if( array_key_exists( 'prot', $paURL ) ){
		$lcRet = $paURL['prot'].'://';
	}
	if( array_key_exists( 'user', $paURL ) ){
		$lcRet .= $paURL['user'];
		if( array_key_exists( 'pass', $paURL ) ){
			$lcRet .= ':'.$paURL['pass'];
		}
		$lcRet .= '@';
	}
	$lcRet .= $paURL['host'];

	if( array_key_exists( 'port', $paURL ) ){
		$lcRet .= ':'.$paURL['port'];
	}

	if( array_key_exists( 'path', $paURL ) ){
		$lcRet .= $paURL['path'];
	}
	if( array_key_exists( 'query', $paURL ) ){
		$lcRet .= '?'.$paURL['query'];
	}

	return $lcRet;

}


function checkDomain( $pcDomain, $pcIpHard = FALSE ){

	global $DEBUG;

	$laItems = explode( '.', $pcDomain );
	if( $DEBUG ){
		echo "checkDomain: '$pcDomain'<br><pre>\n";
		print_r( $laItems );
		echo "</pre><hr>\n";
	}
	if ($pcIpHard) {
		if (preg_match('/[^a-z]+/', end($laItems))) return FALSE;
	} 
	foreach( $laItems as $lcItem ){

		if( preg_match( '/-$/', $lcItem ) ){
			if( $DEBUG ){
				echo "checkDomain: bad tail: '$lcItem'<br>\n";
			}
			return FALSE;
		}
		if( ! preg_match( '/^(\w|\d)(\w|\d|[-_])*$/', $lcItem ) ){
			if( $DEBUG ){
				echo "checkDomain: bad item: '$lcItem'<br>\n";
			}
			return FALSE;
		}
	}
	return TRUE;
}
?>