<?
########## Confixx(R) 3.0 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.SQLValuesSource.php" );
include_once ( dirname(__FILE__) . "/../module.Database.php" );
include_once ( dirname(__FILE__) . "/../module.Genlib.php" );





class MenuItemsValuesSource extends SQLValuesSource
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function MenuItemsValuesSource (  $ps_IDName=0, $ps_PageNumber = NULL, $ps_ItemsPerPage = 5 )
    {
	$this->SQLValuesSource ( $ps_IDName, $ps_PageNumber, $ps_ItemsPerPage );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- definitions of "abstract" methods -------------------- */
    function GetBrowseSQL()
    {
      global $ServerID;
			return "SELECT id, label, href, in_frame FROM menuitem WHERE server_id='$ServerID' AND menublock_id=" .
				intval(ff_GetFromPostGet("menublock_id")) .
				$this->GetOrder();
    }

    // to help GetSearchSQL & GetCountSearchSQL
    function GetSearch ( &$pa_Search )
    {

			global $DEBUG;

			$ls_Result = "";
			if ( strlen($pa_Search[0]->GetValue()) )
				$ls_Result .= " AND label LIKE '%" . db_quote($pa_Search[0]->GetValue()) . "%'";
			if ( strlen($pa_Search[1]->GetValue()) )
				$ls_Result .= " AND href LIKE '%" . db_quote($pa_Search[1]->GetValue()) . "%'";
			if ( strlen($pa_Search[2]->GetValue()) )
				$ls_Result .= " AND in_frame = ". ($pa_Search[2]->GetValue()?'1':'0');

			if ($GLOBAL){
				echo "MenuItemValuesSource::GetSearch: $ls_Result<br>\n";
			}

			return $ls_Result;
    }

    // to help GetBrowseSQL & GetSearchSQL
    function GetOrder()
    {
			$ls_Reverse = $this->GetSortReverse() ? " DESC " : "";
			switch ( $this->GetSortColumn() )	{
			case "href":
				return " ORDER BY href $ls_Reverse ";
			case "in_frame":
				return " ORDER BY in_frame $ls_Reverse ";
	    case "label":
	    default:
				return " ORDER BY label $ls_Reverse ";
			}
    }

    function GetDefaultSort()
    {
			return "label";
    }

    function GetSearchSQL ( &$pa_Search )
    {
      global $ServerID;
			return "SELECT id, label, href FROM menuitem WHERE  server_id='$ServerID' AND menublock_id=" . 
				intval(ff_GetFromPostGet("menublock_id")) .
				$this->GetSearch($pa_Search) . $this->GetOrder();
    }

    function GetCountBrowseSQL()
    {
      global $ServerID;
			return "SELECT COUNT(*) FROM menuitem WHERE  server_id='$ServerID' AND menublock_id=" . intval(ff_GetFromPostGet("menublock_id"));
    }

    function GetCountSearchSQL ( &$pa_Search )
    {
      global $ServerID;
			return "SELECT COUNT(*) FROM menuitem WHERE  server_id='$ServerID' AND menublock_id=" . intval(ff_GetFromPostGet("menublock_id")) .
				$this->GetSearch($pa_Search);
    }

    function AddElement()
    {
      global $ServerID;
			$lo_DB =& get_db_connection();
			$sql = "INSERT INTO menuitem ( menublock_id, label, href, in_frame, server_id )VALUES ( " . 
				intval(ff_GetFromPostGet("menublock_id")). ", " . 
				db_full_quote($_POST["label"]) . ", " .
				db_full_quote(ff_AdjustURL($_POST["href"])) . ", ".
				(ff_GetFromPostGet("in_frame")?'1':'0').
				", '$ServerID' )";
			$lo_DB->Execute ( $sql );
			return NULL;
    }

    function EditElements()
    {
      global $ServerID;
			$la_InFrames = ff_GetFromPostGet("in_frame");
			$lo_DB =& get_db_connection();
			foreach ( $_POST["label"] as $ls_ID => $ls_Value )
			{
				$li_InFrame = $la_InFrames[$ls_ID]?1:0;
				$sql = "UPDATE menuitem SET label=" . db_full_quote($ls_Value) . 
					", href=" .	db_full_quote(ff_AdjustURL($_POST["href"][$ls_ID])) . 
					", in_frame=$li_InFrame WHERE  server_id='$ServerID' AND id=" . db_full_quote($ls_ID);
				$lo_DB->Execute ( $sql );
			}
			return NULL;
    }

    function DeleteElements ( &$pa_IDs )
    {
      global $ServerID;
			$lo_DB =& get_db_connection();
			$lo_DB->Execute ("DELETE FROM menuitem WHERE  server_id='$ServerID' AND id IN ( " . implode( ",", db_full_quote_array($pa_IDs) ) . " )");
    }

    function ValidateAdd()
    {
      global $ServerID;
			$lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select ( "SELECT 1 FROM menublock WHERE  server_id='$ServerID' AND id=" . intval(ff_GetFromPostGet("menublock_id")) );
			if ( ! $lo_Query->nextrow() )
				return array( "message"=>ltext("cm_wrongid") );
			if ( strlen($_POST["label"]) && strlen($_POST["href"]) )
				return NULL;
			return strlen($_POST["label"]) ?
				array( "message"=>ltext("cm_wronghref") ) : array( "message"=>ltext("cm_wronglabel") );
    }

    function ValidateEdit()
    {
      global $ServerID;
			$lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select ( "SELECT 1 FROM menublock WHERE  server_id='$ServerID' AND id=" . intval(ff_GetFromPostGet("menublock_id")) );
			if ( ! $lo_Query->nextrow() )
				return array( "message"=>ltext("cm_wrongid") );
			foreach ( $_POST["label"] as $ls_ID => $ls_Value )
			{
				if ( !strlen($ls_Value) )
					return array( "message"=>ltext("cm_wronglabel") );
				if ( !strlen($_POST["href"][$ls_ID]) )
					return array( "message"=>ltext("cm_wronghref") );
			}
			return NULL;
    }

    function ValidateDelete ( &$pa_IDs )
    {
			return NULL;
    }
    /* -------------------- end definitions of "abstract" methods -------------------- */





    /* -------------------- two methods, should be defined for SQL sources -------------------- */
    function LockAdd()
    {
			$lo_DB =& get_db_connection();
			$lo_DB->lockTables ( "menublock", array ( "menuitem", "sessions" ) );
    }

    function LockEdit()
    {
			$lo_DB =& get_db_connection();
			$lo_DB->lockTables ( "menublock", "menuitem" );
    }
    /* -------------------- end two methods, should be defined for SQL sources -------------------- */

}
?>
