<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.Pager.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputHtmlColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputHiddenColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.SelectColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.InputCheckboxColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.TextColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "class.HtmlColumn.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "module.Genlib.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "module.Database.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ResellerDomainLink.php" );
include_once ( dirname(__FILE__) . DIRECTORY_SEPARATOR . "class.ResellerDNRColumn.php" );
include_once ( dirname(__FILE__) . "/../elements/data/class.MultiSetData.php" );





class ResellerDomainsPager extends Pager
{
    /* -------------------- Members -------------------- */
	var $moLimits;
	var $moServices;
	var $moPersonalInfos;
	var $moUser;
    /* -------------------- end Members -------------------- */




    /* -------------------- Constructor -------------------- */
    function ResellerDomainsPager ( &$po_Source, $ps_Path, $ps_BackURL = '' )
    {
			global $formAction, $fehlertext;

			$this->Limits( $po_Source->Limits() );
			$this->Services( $po_Source->Services() );
			$this->PersonalInfos( $po_Source->PersonalInfos() );
			$this->User( $po_Source->User() );

			$this->Pager ( $po_Source );

			$this->assign ( "formAction", $formAction );
			$this->assign ( "currentPath", $ps_Path );
			$this->assign ( "backurl", $ps_BackURL );
			if ( strlen($fehlertext) )
				$this->addMessage( ERROR, $fehlertext );
			$this->setText ( "delquest", ltext("ed_delquest") );
			$this->setText ( "whichip", ltext("ed_whichip") );
			$this->setText ( "exclusive", ltext("kune4_cell_text3") );
			$this->setText ( "ok", ltext("ed_ok") );
			$this->setText ( "delete", ltext("ed_select") );
			$this->setText ( "apply", ltext("ed_delete") );
			$this->setText ( "noresults", ltext("ed_nodomains") );
			$this->setText ( "back", ltext("ed_back") );
			$this->InitializeIP();
    }
    /* -------------------- end Constructor -------------------- */

		function &Limits( $poLimits = NULL){
			global $DEBUG;
			if ( is_a( $poLimits, 'LimitsData' ) ) {
				$this->moLimits =& $poLimits;
			}
			if($DEBUG){
				/*
				echo "ResellerDomainsPager::Limits<br><pre>\n";
				print_r($this->moLimits);
				echo "</pre><hr>\n";
				*/
			}
			return $this->moLimits;
		}

		function &Services( $poServices = NULL){
			if ( is_a( $poServices, 'ServicesData' ) ) {
				$this->moServices =& $poServices;
			}
			return $this->moServices;
		}

		function &PersonalInfos( $poPersonalInfos = NULL ){
			if ( is_a( $poPersonalInfos, 'PersonalInfosData' ) ) {
				$this->moPersonalInfos =& $poPersonalInfos;
			}
			return $this->moPersonalInfos;
		}

		function &User( $poUser = NULL){
			if ( is_a( $poUser, 'User' ) ) {
				$this->moUser =& $poUser;
			}
			return $this->moUser;
		}


    /* -------------------- definitions of "abstract" methods -------------------- */
    function ShouldShowSummary()
    {
			return TRUE;
    }

    function ShouldShowAddForm()
    {
			return TRUE;
    }

    function GetSummary()
    {
			return ltext ( "ed_summary",
										 array (htmlspecialchars( $_SERVER["REQUEST_METHOD"] == "POST" ? $_POST["kunde"] : $_GET["kunde"] )) );
    }

    function GetAddColumns()
    {
			global $skdns, $skdnr;
			$la_Result = array( new InputHtmlColumn( "domainToAdd", ltext("ed_domain"), "", array( "style"=>"width:100%" ) ) );
			if ( $skdns==1 )
				{
					$la_Result[] = new InputCheckboxColumn ( 1, "dnsToAdd", ltext("kune4_cell_dns1"), 1,
																									 array( "onClick"=>"AddDNROff()" ) );
					if ( $skdnr==1 )
						$la_Result[] = new ResellerDNRColumn ( 0, "dnrToAdd", "DNR", 1, array( "onClick"=>"AddDNSOn()" ) );
				}
			return $la_Result;
    }

    function GetBrowseColumns()
    {
			global $skdns, $skdnr;
			$la_Result = array( new InputHtmlColumn( "domain", ltext("ed_domain"), "", array( "style"=>"width:300" ) ) );
//	$la_Result[] = new InputHiddenColumn("idndomain", "", ff_GetFromPostGet("kunde"));
//	$la_Result[] = new HtmlColumn("idndomain", '', "");
			if ( $skdns==1 )	{
				$la_Result[] = new InputCheckboxColumn ( 1, "domdns", ltext("kune4_cell_dns1"), "",
																								 array( "onClick"=>"DNROff(this,this.name)" ) );
				if ( $skdnr==1 )
					$la_Result[] = new ResellerDNRColumn ( 1, "domdnr", "DNR", "",
																								 array( "onClick"=>"DNSOn(this,this.name)" ) );
			}
			$la_Result[] = new ResellerDomainLink ( "", NULL, ltext("ed_view")." ", "domain", ltext("ed_view"), "",
																							array( "target"=>"_blank" ) );
			
			return $la_Result;
    }

    function GetSearchColumns()
    {
			return array();
    }

    function GetHiddenFields()
    {
			global $DEBUG;

			$la_Result = array();
			$la_Result[] = new InputHiddenColumn ( "kunde", "", ff_GetFromPostGet ( "kunde" ) );
			$la_Result[] = new InputHiddenColumn ( "aktion", "", ff_GetFromPostGet ( "aktion" ) );

			$obj =& $this->User();
			if( is_object( $obj ) ) {
				$obj->FirstService();
				while ( $loService =& $obj->NextService() ) {
					$lcName = $loService->GetName();
					if( $lcName ) {
						$la_Result[] = new InputHiddenColumn ( $lcName, "", $loService->GetValue() );
					}
				}
				$obj->FirstPersonal();
				while( $loPersonalInfo =& $obj->NextPersonal() ) {
					$lcName = $loPersonalInfo->GetName();
					if ( $lcName ) {
						$la_Result[] = new InputHiddenColumn ( $lcName, "", $loPersonalInfo->GetValue() );
					}
				}

			} else {

				$obj  =& $this->Limits();
				if(is_object($obj)){
					foreach ( $obj->GetLimits() as $loLimit ){
						if(is_a($loLimit,'KBLimitDataField')){
							if($DEBUG){
								/*
								 echo "ResellerDomainPager::GetHiddenFields<br><pre>\n";
								 print_r($loLimit);
								 echo "</pre><hr>\n";
								*/
							}
							$la_Result[] = new InputHiddenColumn ( $loLimit->GetName(), "", $loLimit->GetNormalizedValue() );
						}else{
							if($DEBUG){
								/*
								echo "ResellerDomainPager::GetHiddenFields<br><pre>\n";
								print_r($loLimit);
								echo "</pre><hr>\n";
								*/
							}
							$la_Result[] = new InputHiddenColumn ( $loLimit->GetName(), "", $loLimit->GetValue() );
						}
					}
				}

				$obj  =& $this->Services();
				if(is_object($obj)){
					foreach ( $obj->GetServices() as $loService ){
						$la_Result[] = new InputHiddenColumn ( $loService->GetName(), "", $loService->GetValue() );
					}
				}

				$obj  =& $this->PersonalInfos();
				if( $DEBUG ){
					/*
					echo "ResellerDomainPager::GetHiddenFields (pinfos)<br><pre>\n";
					print_r( $obj );
					echo "</pre><hr>\n";
					*/
				}
				if(is_object($obj)){
					foreach ( $obj->GetPersonalInfos() as $loPersonalInfo ){
						$la_Result[] = new InputHiddenColumn ( $loPersonalInfo->GetName(), "", $loPersonalInfo->GetValue() );
					}
				}

			}			
			if($DEBUG){
				/*
				echo "ResellerDomainsPager::GetHiddenFields<br><pre>\n";
				print_r($la_Result);
				echo "</pre><hr>\n";
				*/
			}

			return $la_Result;

    }

    function AddElement()
    {
			$ls_Domain = trim($_POST["domainToAdd"]);

			if (!strlen($ls_Domain))
				return;
	
/*
	// check if international and then translate
	include_once('class.InputDecode.php');
	$ls_DomainTranslated = InputDecode::decode($ls_DomainOrig);
	if ($ls_DomainTranslated != $ls_DomainOrig) {
		// has national characters

		$ls_DomainName = escapeshellarg($ls_DomainTranslated);
		global $bindir;
		$exec = "$bindir/idn_translate.pl UTF8 $ls_DomainName";
		exec($exec, $list, $return);
		if ($return != 0) {
			// error
			echo "<p><b>Error:</b> idn_translate.pl returned with non-zero status:<pre>".implode("\n", $list)."</pre></p>";
			return 0;
		}
		if (sizeof($list) < 1) {
			// error
			echo "<p><b>Error:</b> idn_translate.pl returned with zero output:<pre>".implode("\n", $list)."</pre></p>";
			return 0;
		}
		if (!preg_match("/^to_idn:\s+([a-zA-Z0-9\.-]+)$/", $list[0], $matches)) {
			// error
			echo "<p><b>Error:</b> Can not parse output of the idn_translate.pl utility:<pre>".implode("\n", $list)."</pre></p>";
			return 0;
		} 
		$ls_Domain = $matches[1]; 	
	} else {
		$ls_Domain = $ls_DomainOrig;
	}
*/
	global $domain;
	$domain[$this->mo_Source->TotalElements( $this->ma_SearchColumns )+1] = $ls_Domain;
	$ls_DNS = array_key_exists( "dnsToAdd", $_POST ) ? $_POST["dnsToAdd"] : 0;
	$ls_DNR = array_key_exists( "dnrToAdd", $_POST ) ? $_POST["dnrToAdd"] : 0;
	$this->mo_Source->AddElement (
		array(
			0 => $this->mo_Source->TotalElements( $this->ma_SearchColumns )+1
		,	"domain" => $ls_Domain
		,	"domdnr" => $ls_DNR
		,	"domdns" => $ls_DNS
//		,	'idndomain' => $ls_DomainOrig
		)
	);
	
    }

    function EditElements()
    {
    }

    function DeleteElements ( &$pa_IDs )
    {
	$this->mo_Source->DeleteElements ( $pa_IDs );
    }
    /* -------------------- end definitions "abstract" methods -------------------- */





	/* -------------------- CreateDataObject -------------------- */
	// method that maps old classes to include/elements/*
	function CreateDataObject() {
		global $exklusiv;

		global $DEBUG;

		if($DEBUG){
			/*
			echo "ResellerDomainsPager::CreateDataObject<br><pre>\n";
			print_r($this->ma_HiddenFields);
			echo "</pre><hr>\n";
			*/
		}

		$lo_Add = new SetOfRowsData();
		$lo_Add->AppendHidden( new TextDataField( "Y", "ListEdit" ) );
		$lo_Add->AppendHidden( new TextDataField( "Y", "ListAdd" ) );
		foreach( $this->ma_HiddenFields as $loField ) {
			$lo_Add->AppendHidden( $loField->GetDataField() );
		}

		if($this->get_template_vars("backurl")) {
			$lo_Add->AppendButton( $this->texts["back"], 
														 "javascript:goPrevPage('".$this->get_template_vars("backurl")."')" );
		}

		$lo_Add->AppendButton( $this->texts["add"], "javascript:return SubmitAdd()" );		

		foreach( $this->ma_AddColumns as $lo_Column ) {
			$lo_Add->AppendRow( $lo_Column->GetLabelDataField(), $lo_Column->GetDataField() );
		}

		$lo_List = new SetOfRowsData();
		$lo_List->AppendHeaderRow();
		foreach( $this->ma_BrowseColumns as $lo_Column ) {
			$lo_List->AppendFields( $lo_Column->GetLabelDataField() );
		}

		$lo_List->AppendFields( new HTMLDataField( $this->texts["delete"] ) );
		$lo_Source =& $this->mo_Source;
		for( $lo_Source->Start( $this->ma_SearchColumns ); $la_Element = $lo_Source->NextElement(); ) {
			$lo_Source->UpdateColumns ( $this->ma_BrowseColumns, $la_Element );
			$lo_List->AppendRow();
			$ls_ID = $la_Element[ $lo_Source->GetIDName() ];
			$lo_List->SetRowID( $ls_ID );

			foreach( $this->ma_BrowseColumns as $lo_Column ) {
				$lo_List->AppendFields( $lo_Column->GetDataField() );
			}

			$lo_Checkbox = new YesNoDataField( array( $ls_ID=>"" ), array( ""=>"" ), "", "domdel" );
			$lo_Checkbox->AppendAttributes( array( "onclick"=>"ToDelete[$ls_ID] = !ToDelete[$ls_ID]" ) );
			$lo_List->AppendFields( $lo_Checkbox );
		}
		$lo_List->AppendButton( $this->texts["apply"], "javascript:return askDelete(null)" );
		if( ! $lo_List->GetHasData() ) {
			return $lo_Add;
		}

		$lo_IP = new SetOfRowsData();
		$lo_Field = new CompoundDataField();
		$lo_Field->SetSeparator( " " );
		$lo_Field->AppendToContent( new OptionsDataField( $this->get_template_vars("ipoptions"),
					$this->get_template_vars("selectedip"), "ip" ), new YesNoDataField( array( "1"=>"" ), array( ""=>"" ),
					$exklusiv, "exklusiv" ), new HTMLDataField( $this->texts["exclusive"] ) );
		$lo_IP->AppendRow( $lo_Field );

		$lo_Data = new MultiSetData();
		$lo_Data->AppendData( $lo_Add, $this->texts["add"] );
		$lo_Data->AppendData( $lo_List, $this->GetSummary() );
		$lo_Data->AppendData( $lo_IP, $this->texts["whichip"] );
		$lo_Data->AppendButton( $this->texts["ok"], 
														"javascript:return askDelete('".
														js_message($this->get_template_vars("formAction")) . "')" );

		return $lo_Data;
	}
	/* -------------------- end CreateDataObject -------------------- */





	/* -------------------- CreatePageObject -------------------- */
	// method that maps old classes to include/elements/*
	function CreatePageObject() {
		$lo_Data = $this->CreateDataObject();
		if( get_class($lo_Data) == "multisetdata" )
			$lo_Page = new MainPageElement( $lo_Data->GetInputPresentation(
						array( "action"=>$this->get_template_vars("currentPath"), "method"=>"post",
							"name"=>"inputform" ) ) );
		else
			$lo_Page = new MainPageElement( $lo_Data->GetInputPresentation(
						array( "action"=>$this->get_template_vars("currentPath"), "method"=>"post", "name"=>"inputform" ),
						$this->texts["add"] ), $this->texts["noresults"] );
		return $lo_Page;
	}
	/* -------------------- end CreatePageObject -------------------- */





	/* -------------------- OutputHTML -------------------- */
	// method that maps old classes to include/elements/*
	function OutputHTML() {
		$lo_Page = $this->CreatePageObject();
		$lo_Page->OutputHTML( FALSE, "
ToDelete = new Array();

function SubmitAdd() {
	document.inputform.ListAdd.value = 'Y';
	document.inputform.ListEdit.value = 'N';
	document.inputform.submit();
	return false;
}

function DNSOn( Element, Name ) {
	if ( !Element.checked )
		return;
	var DNSName = Name.substr(0,5) + 's' + Name.substr(6);
	var Elements = document.inputform.elements;
	var i;
	for ( i=0; i<Elements.length; i++ )
		if ( Elements[i].name == DNSName ) {
			Elements[i].checked = true;
			return;
		}
}

function AddDNSOn() {
	var Form = document.inputform;
	if( Form.dnrToAdd.checked )
		Form.dnsToAdd.checked = true;
}

function AddDNROff() {
	var Form = document.inputform;
	if( !Form.dnsToAdd.checked && Form.dnrToAdd )
		Form.dnrToAdd.checked = false;
}

function DNROff( Element, Name ) {
	if( Element.checked )
		return;
	var DNRName = Name.substr(0,5) + 'r' + Name.substr(6);
	var Elements = document.inputform.elements;
	var i;
	for( i=0; i<Elements.length; i++ )
		if( Elements[i].name == DNRName ) {
			Elements[i].checked = false;
			return;
		}
}

function askDelete( Page ) {
	var di, i;
	di = false;
	document.inputform.action = Page ? Page : '" . js_message( $this->get_template_vars("currentPath") ) . "';
	document.inputform.ListAdd.value = 'N';
	document.inputform.ListEdit.value = 'Y';
	for( i in ToDelete ) {
		if( ToDelete[i] ) {
			di = true;
			break;
		}
	}
	if( di ) {
		if( " . js_confirm($this->texts["delquest"]) . " )
			document.inputform.submit();
	}
	else {
		document.inputform.submit();
	}
	return false;
}
				" );
	}
	/* -------------------- end OutputHTML -------------------- */





    /* -------------------- MaybePerformAction & related ------------------ */
    function DeleteFieldName()
    {
			return "domdel";
    }
    /* -------------------- end MaybePerformAction & related ------------------ */





    /* -------------------- InitializeIP -------------------- */
    function InitializeIP()
    {
			global $stdip, $cIP, $PHP_AUTH_USER, $exklusiv;
      global $ServerID;
			$la_IPs = array( "standard" => ltext("kune4_cell_select_stdip") );
			$lo_DB =& get_db_connection();
			$lo_Query =& $lo_DB->Select ( "SELECT ip FROM ipadressen WHERE server_id='$ServerID' AND anbieter=" . db_full_quote($PHP_AUTH_USER) .
																		" AND ip <> " . db_full_quote($stdip) . " AND kunde='' OR ip=" . db_full_quote($cIP) );
			while ( $la_Row = $lo_Query->nextrow() )
				if ( $la_Row["ip"] != $stdip )
					$la_IPs[ $la_Row["ip"] ] = $la_Row["ip"];
			$this->assign ( "ipoptions", $la_IPs );
			$this->assign ( "selectedip", $cIP );
			$this->assign ( "exclusive", array( "1" ) );
			if ( $exklusiv==1 )
				$this->assign ( "checkedex", "checked" );
    }
    /* -------------------- end InitializeIP -------------------- */

}
?>
