<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once (  dirname(__FILE__) . "/../class.InputTextColumn.php" );





class SubscriptionDurationColumn extends InputTextColumn
{

    /* -------------------- Constructor -------------------- */
    function SubscriptionDurationColumn (  $ps_Name, $ps_Label, $ps_Value, $pa_Attributes=array(), $ps_Width=NULL,
	$ps_Align=NULL, $ps_ID=NULL )
    {
	$this->InputTextColumn ( $ps_Name, $ps_Label, $ps_Value, $pa_Attributes, $ps_Width, $ps_Align, $ps_ID );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- value is assigned in different way -------------------- */
    function SetFromArray ( $pa_Data, $ps_ID )
    {
	if ( ! is_null($this->ms_Name) )
	{
	    if ( array_key_exists ( "duration", $pa_Data ) && array_key_exists ( "durationitem", $pa_Data ) &&
		    strlen($pa_Data["durationitem"]) && $pa_Data["duration"]>0 )
	    {
		$durations = array ( 'days', 'weeks', 'monthes', 'years' );
		$this->SetValue ( $pa_Data["duration"] . ' ' .
			ltext ( "anne_cell_durationitem".array_search($pa_Data["durationitem"],$durations) ) );
	    }
	    else
		$this->SetValue (NULL);
	}
	$this->SetID ( $ps_ID );
    }

    /* -------------------- end value is assigned in different way -------------------- */

}
?>
