<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.Pager.php" );
include_once ( dirname(__FILE__) . "/../class.InputTextColumn.php" );
include_once ( dirname(__FILE__) . "/../class.InputCheckboxColumn.php" );
include_once ( dirname(__FILE__) . "/class.SubscriptionEdit.php" );
include_once ( dirname(__FILE__) . "/class.SubscriptionDurationColumn.php" );





class SubscriptionPager extends Pager
{
    /* -------------------- Members -------------------- */
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
    function SubscriptionPager ( &$po_Source )
    {
	$this->Pager ( $po_Source );
	$this->setText ( "noresults", ltext("webshop_sub_noresults") );
	$this->setText ( "addnew", ltext("webshop_sub_addnew") );
    }
    /* -------------------- end Constructor -------------------- */





    /* -------------------- "abstract" methods -------------------- */
    function ShouldShowSummary()
    {
	return FALSE;
    }

    function ShouldShowAddForm()
    {
	return FALSE;
    }

    function GetSummary()
    {
	return "";
    }

    function GetAddColumns()
    {
	return array();
    }

    function GetBrowseColumns()
    {
	$la_Result = array();

	$lo_Column = new InputTextColumn ( "name", ltext("webshop_sub_name"), "", array(), "20%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new InputTextColumn ( "ident", ltext("webshop_sub_id"), "", array(), "10%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new InputTextColumn ( "identifier", ltext("webshop_sub_identifier"), "", array(), "15%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new InputTextColumn ( "price", ltext("webshop_sub_price"), "", array(), "10%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$lo_Column = new SubscriptionDurationColumn ( "durationtext", ltext("webshop_sub_durationtext"), "", array(),
		"15%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	$la_Result[] = new SubscriptionEdit ( "angebote_neu.php", NULL, ltext("webshop_sub_edit"), NULL, "&nbsp;", "",
		array(), "10%" );

	$lo_Column = new InputCheckboxColumn ( 1, "webshop", ltext("webshop_sub_publish"), "", array(), "10%" );
	$lo_Column->SetInput (FALSE);
	$lo_Column->SetSortable (TRUE);
	$la_Result[] = $lo_Column;

	return $la_Result;
    }

    function GetEditColumns()
    {
	return array();
    }

    function GetSearchColumns()
    {
	return array();
    }

    function GetHiddenFields()
    {
	return array();
    }
    /* -------------------- end "abstract" methods -------------------- */





	/* -------------------- CreatePageObject -------------------- */
	function CreatePageObject( $pm_Title ) {
		$lo_Page = Pager::CreatePageObject( $pm_Title );
		$lo_Page->InsertToContent( 0, new AElement( array( "href"=>"angebote_neu.php?plan=1&webshop=1" ),
					new HTMLElement( $this->texts["addnew"] ) ) );
		return $lo_Page;
	}
	/* -------------------- end CreatePageObject -------------------- */

}
?>
