<?
/*
  -------------------- Name conventions --------------------
  Function names (except methods):

  ff_DescriptionOfFunction


  Constant names:

  cc_DescriptionOfConstant


  Variable names:

  $ST_DescriptionOfVariable

  where S is a scope, T is a type.

  The following scopes should be used:
  g - global
  s - static
  l - local
  m - member of class
  p - parameter

  The following types should be used:
  s - scalar
  a - array
  r - resource
  o - object
  m - mixed

  -------------------- end Name conventions --------------------
*/





include_once ( dirname(__FILE__) . "/../class.PersonalInfo.php" );
include_once ( 'class.SQLFieldSet.php' );




class AdminPersonalInfo extends PersonalInfo{

    /* -------------------- Members -------------------- */
	var $ms_FirstTime; // if page is shown at first time
    /* -------------------- end Members -------------------- */





    /* -------------------- Constructor -------------------- */
	function AdminPersonalInfo ( $ps_FormURL, $ps_DB, $ps_FirstTime, 
															 $pcServerID = null){
		global $ServerID;
		$lcServerID =& $this->ServerID( $pcServerID? $pcServerID: $ServerID );
		$lcSQL = "SELECT p.* FROM personalinfo p, admin a ".
			" WHERE p.id=a.personalinfoid AND a.server_id='$lcServerID' ".
			" AND p.server_id='$lcServerID'";
		$this->PersonalInfo ( $ps_FormURL,
													$ps_DB ? $lcSQL: NULL 
													);
		$this->ms_FirstTime = $ps_FirstTime;
	}
    /* -------------------- end Constructor -------------------- */





    /* -------------------- SaveData -------------------- */
	function SaveData(){
		global $gender, $firstname, $name, $firma, $anschrift, $plzort, $plz, $land, $telefon, $fax, $emailadresse,
			$kundennummer, $freifeldname1, $freifeldwert1, $freifeldname2, $freifeldwert2, $freifeldname3,
			$freifeldwert3, $kundendatenanzeigen;

		$kundendatenanzeigen = $kundendatenanzeigen? 1: 0;

		$lo_DB =& get_db_connection();
		$lo_DB->lockTables ( NULL, array( "admin", "personalinfo" ) );
		$lcServerID =& $this->ServerID();

		$loFlds = new SQLFieldSet( array(					'firstname' => array( $firstname, 'C' ),
		 'gender' => array( $gender, 'C' ),
																			'name' => array( $name,'C' ),
																			'anschrift' => array( $anschrift, 'C' ),
																			'firma' => array( $firma, 'C' ),
																			'plzort' => array( $plzort, 'C' ),
																			'plz' => array( $plz, 'C' ),
																			'land' => array( $land, 'C' ),
																			'telefon' => array( $telefon, 'C' ),
																			'emailadresse' => array( $emailadresse, 'C' ),
																			'kundennummer' => array( $kundennummer, 'C' ),
																			'fax' => array( $fax, 'C' ),
																			'freifeldwert1' => array( $freifeldwert1, 'C' ),
																			'freifeldname2' => array( $freifeldname2, 'C' ),
																			'freifeldname1' => array( $freifeldname1, 'C' ),
																			'freifeldname3' => array( $freifeldname3, 'C' ),
																			'freifeldwert3' => array( $freifeldwert3, 'C' ),
																			'freifeldwert2' => array( $freifeldwert2, 'C' ),
																			'kundendatenanzeigen' => $kundendatenanzeigen 
																			)
															 );
		
		$lo_Query =& $lo_DB->Select ( "SELECT personalinfoid FROM admin , personalinfo  ".
																	" WHERE	personalinfo.id=admin.personalinfoid ".
																	" AND admin.server_id='$lcServerID' ".
																	" AND personalinfo.server_id='$lcServerID'" );

		if( $lo_Query ){
			$la_Row =& $lo_Query->nextrow();
		}else{
			$la_Row['personalinfoid'] = 0;
		}
		if( $la_Row['personalinfoid'] ){
			
			$lcSQL = 'UPDATE personalinfo SET '.$loFlds->getSQLUpdate().' WHERE id='.$la_Row["personalinfoid"]." AND server_id='$lcServerID'" ;
			$lo_Query->Close();
			
			$lo_DB->Execute ( $lcSQL );

		}else{
			list( $lcFlds, $lcVals ) = $loFlds->getSQLInsert();
			$lcSQL = "INSERT INTO personalinfo ( $lcFlds,server_id ) VALUES ( $lcVals,'$lcServerID' )";
			$lo_DB->Execute ( $lcSQL );
			$liID = $lo_DB->getLastID( 'personalinfo', 'id');
			$lo_DB->Execute ( "UPDATE admin SET personalinfoid=$liID WHERE server_id='$lcServerID'" );
		}
		$lo_DB->unLockTables();
	}
    /* -------------------- end SaveData -------------------- */





    /* -------------------- methods that generate HTML -------------------- */
	function GetStartHTML(){
		$ls_Start = $this->ms_FirstTime ? "<center>".ltext("install_email")."<p>" : "";
		return $ls_Start . PersonalInfo::GetStartHTML();
	}

	function GetEndHTML(){
		$ls_End = $this->ms_FirstTime ? "</center>" : "";
		return $ls_End . PersonalInfo::GetEndHTML();
	}
    /* -------------------- end methods that generate HTML -------------------- */

}
?>
