<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once("auth.php");
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include("../languages/".$shortlang."/scripts.inc.php");
include_once( "../include/data_source/class.ValueLocale.php");
include_once( "../include/data_source/class.ValueDateFormated.php");
include_once( "../include/data_source/class.ValueHref.php");
include_once( "../include/data_source/class.CompoundValue.php");
include_once( "../include/data_source/class.LabelValue.php");
include_once( "../include/data_source/class.LabelValueInt.php");
include_once( "../include/data_source/class.LabelValueKb.php");
include_once( "../include/elements/data/class.TableView.php" );

global $DEBUG;
//$DEBUG=1;


include_once("../include/cron_functions.php");
include_once("../include/class.Traffic.php");

db_master_connect();

$info = array();

$info['hostname'] = $hostname;

$id = db_query( "SELECT COUNT(server_id) FROM admin WHERE server_id != '$masterServerID'" );
$werte = db_fetch_array($id,'N');
$info['servers'] = $werte[0];
db_free_query( $id );

$lrId = db_query( "SELECT COUNT(domain) FROM domains WHERE richtigedomain = 7 AND server_id!='$masterServerID'");
list( $info['shareddomains'] ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lrId );

$id = db_query( "SELECT COUNT(anbieter) AS anzahlanbieter FROM anbieter WHERE server_id != '$masterServerID'" );
$werte = db_fetch_array($id);
$info['resellers'] = $werte['anzahlanbieter'];
db_free_query( $id );


$id = db_query( "SELECT COUNT(domain) AS anzahldomains FROM domains WHERE richtigedomain = 1");
$werte = db_fetch_array($id);
$info['domains'] = $werte["anzahldomains"];
db_free_query( $id );

$id = db_query("SELECT COUNT(domain) AS anzahlsubdomains from domains where richtigedomain = 0");
$werte = db_fetch_array($id);
$info['subdomains'] = $werte["anzahlsubdomains"];
db_free_query( $id );

$id = db_query("SELECT COUNT(domain) AS anzahlwildcards FROM domains WHERE richtigedomain = 0 AND domain LIKE '*.%'");
$werte = db_fetch_array($id);
$info['wcdomains'] = $werte["anzahlwildcards"];
db_free_query( $id );

$id = db_query("SELECT COUNT(datenbank) AS anzahlmysql FROM mysql_datenbanken");
$werte = db_fetch_array($id);
$info['mysqls'] = $werte["anzahlmysql"];
db_free_query( $id );

$id = db_query("SELECT COUNT(kunde) AS anzahlkunden from kunden");
$werte = db_fetch_array($id);
$info['users'] = $werte["anzahlkunden"];
db_free_query( $id );

$jahr = date("Y");
$monat = date("n");
$monatstr = $lang_months[$monat];

$allTraffic = new Traffic();
$allTraffic->setLog( $trafficLog );
$allTraffic->setFields( array( 'ftp', 'web', 'email', 'pop' ) );
$allTraffic->monthlyQuery( $monat, $jahr );

$info['traffic'] = $allTraffic->getTraffic( "all" );

$id = db_query( "SELECT COUNT(maxkb) AS maxkb FROM anbieter WHERE maxkb = -1");
$werte = db_fetch_array($id);
db_free_query( $id );
if ( $werte['maxkb'] > 0 ) { 
	$info['maxkb'] = -1; 

} else {
  $id = db_query( "SELECT SUM(maxkb) AS maxkb FROM anbieter" );
  $werte = db_fetch_array($id);
  $info['maxkb'] = $werte["maxkb"];
	db_free_query( $id );

}

$id = db_query( "SELECT (SUM(kbhomedir) + SUM(kbdb) + SUM(IF(popmaxkb=0,kbpop,0))) AS du, ".
                " SUM(IF(popmaxkb!=0,kbpop,0)) AS kbpop2  FROM kunden" );
$werte = db_fetch_array($id);
$info['du'] = $werte["du"];
$info['mailspace_usage'] = $werte["kbpop2"];
db_free_query( $id );

## /speicherplatz ermitteln

## laufzeit werte ermitteln
$id = db_query( "SELECT * FROM allgemein" );
$werte = db_fetch_array($id);
db_free_query( $id );

$times = array();

foreach ( array( 'lastrun', 'httpdlr', 'speicherlr',
								 'httpdtraffiklr', 'ftptraffiklr', 'aliaseslr' ) as $field ) {
	$times[$field] = date( $lang_format_datetime_short, $werte[$field] );
}


$id = db_query( "SELECT * FROM zeiten WHERE server_id='$masterServerID'" );
$werte2 = db_fetch_array( $id );
db_free_query( $id );

foreach ( array( "httpdlpr", "aliaseslpr", "mailtraffikletzt", "iptraffikletzt" ) as $field ){
	$times[$field] = date( $lang_format_datetime_short, $werte2[$field] );
}

$nextrun = array();

$liTick = $werte2['confixxfaktor'] * 60;

$nextrun['nextrun'] = $werte['lastrun'] + $liTick;
if( $nextrun['nextrun'] < time() ){
	$nextrun['nextrun'] = time();
 }

$nextrun['nrhttpd'] = $nextrun['nextrun'] + 
	( $werte2['httpdfaktor']>0? ($werte2['httpdfaktor']-1): 0 ) * $liTick;
$nextrun['nraliases'] = $nextrun['nextrun'] + 
	( $werte2['aliasesfaktor']>0? ($werte2['aliasesfaktor']-1): 0 ) * $liTick;

$laCurTime = getdate();
$gtDayStart = mktime(0,0,0,$laCurTime['mon'],$laCurTime['mday'],$laCurTime['year']);
$giOneDay = 24*60*60;
$giCurTime = time();

function getNextRun( $pcPrefix, $piNextRun, &$werte2, &$laCurTime  ){
	global $gtDayStart, $giOneDay, $giCurTime;

	$ltBegin = mktime( $werte2[$pcPrefix.'von'], 0, 0,
										 $laCurTime['mon'], $laCurTime['mday'], $laCurTime['year'] );
	$ltEnd = mktime( $werte2[$pcPrefix.'bis'], 59, 0,
									 $laCurTime['mon'], $laCurTime['mday'], $laCurTime['year'] );

	if( $werte2[$pcPrefix.'von'] > $werte2[$pcPrefix.'bis'] ){
		$ltEnd += $giOneDay;
	}
	if( $ltEnd <= $giCurTime ){
		$ltBegin += $giOneDay;
		$ltEnd += $giOneDay;
	}

	if( $piNextRun <= $ltBegin ){
		return  $ltBegin;
	}elseif( $piNextRun  > $ltEnd ){
		return  $ltBegin + $giOneDay;
	}else{
		$liRet = $werte2[$pcPrefix.'last']+$werte2[$pcPrefix.'freq']*60;
		if( $liRet < $piNextRun || $liRet > $ltEnd  ){
			$liRet = $ltBegin + $giOneDay;
		}
		return $liRet;
	}
}

$nextrun['nrspeicher'] = getNextRun( 'speicher', $nextrun['nextrun'], 
																		 $werte2, $laCurTime  );

$nextrun['nrhttpdtraffik'] = getNextRun( 'httpdtraffik', $nextrun['nextrun'], 
																		 $werte2, $laCurTime  );

$nextrun['nrftptraffik'] = getNextRun( 'ftptraffik', $nextrun['nextrun'], 
																		 $werte2, $laCurTime  );

foreach ( $nextrun as $key => $value ) {
	$times[$key] = date($lang_format_datetime_short,$value);
}

## // wird das script schon vor dem nchsten intervallstart gestartet?
## nchster ftptraffik lauf ermitteln

## calculate next run for mailtraffic & iptraffic
function calcNextRun ($letzt,$von, $bis, $freq){
	$secPerHour=60*60;
	$secPerDay=24*$secPerHour;
	$actTime = time();
	$aktstunde = date('H');
	global $DEBUG;
	
	$nr=$letzt+$freq;
  $nrvon=strtotime(date("Y/m/d")) + $von * $secPerHour;
	$nrbis=strtotime(date("Y/m/d")) + $bis * $secPerHour;
  if ($von>$bis){
		$nrbis+=$secPerDay;
	}
	if ($DEBUG){
		echo "von: ".date("Y-m-d H:i:s",$nrvon).", bis: ".date("Y-m-d H:i:s",$nrbis).
			"<br>\n";
	}
	while( $nrbis<$nr || $nrbis<$actTime ){
		$nrbis+=$secPerDay;
		$nrvon+=$secPerDay;
	}
	if ($DEBUG){
		echo "von: ".date("Y-m-d H:i:s",$nrvon).", bis: ".date("Y-m-d H:i:s",$nrbis).
			"<br>\n";
	}

	if ($nr<$nrvon){
		$nr=$nrvon;
	}
	if ($DEBUG){
		echo "next run: ".date("Y-m-d H:i:s",$nr)."<br>\n";
	}

	return $nr;
}

$nrmailtraffik = calcNextRun($werte2['mailtraffikletzt'],
														 $werte2['mailtraffikvon'],
														 $werte2['mailtraffikbis'],
														 $werte2['mailtraffikfreq'] );
$times['nrmailtraffik'] = date($lang_format_datetime_short,$nrmailtraffik);

$nriptraffik = calcNextRun( $werte2['iptraffikletzt'],
														$werte2['iptraffikvon'],
														$werte2['iptraffikbis'],
														$werte2['iptraffikfreq'] );
$times['nriptraffik'] = date($lang_format_datetime_short,$nriptraffik);

## /calculate next run for mailtraffic & iptraffic

## cron functions
$cron_jobs = 0;
$id = db_query( "SELECT anbieter,server_id FROM anbieter" );
while( $werte = db_fetch_array($id,'N') ){
	$cron_jobs += count_cron_jobs_reseller($werte[0],$werte[1]);
}
db_free_query( $id );
$info['crons'] = $cron_jobs;
##

$id = db_query( "SELECT idn, majordomo FROM admin WHERE server_id='$masterServerID'" );
$werte = db_fetch_array($id);
$majordomo = $werte['majordomo'];
$idn = $werte['idn'];
db_free_query( $id );

//if ($idn){
//	$id = db_query('SELECT COUNT(*) AS cnt FROM idn_aliases');	
//	$werte = db_fetch_array($id);
//	$info['idns'] = $werte['cnt'];
//}

if( $majordomo ){
	$id = db_query('SELECT COUNT(*) AS cnt FROM maillist WHERE neu <= 1');	
	$werte = db_fetch_array($id);
	$info['maillists'] = $werte['cnt'];
	db_free_query( $id );
}


## server time
$id = db_query("select UNIX_TIMESTAMP() as ts");
$werte = db_fetch_array($id);
$info['timestamp'] = $werte['ts'];
db_free_query( $id );
##





/* -------------------- HTML: general information -------------------- */

$ds = new CompoundValue();
$ds->addValue( new LabelValue( 'alst_cell_servername', 'hostname' ) );
$ds->addValue( new LabelValue( 'alst_cell_server', 'servers' ) );

$lcNoLimit = ltext("g_nolimit");
$ds->addValue( new LabelValueInt( 'alst_cell_reseller', 'resellers' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_user', 'users' ) );
////
$ds->addValue( new LabelValueKb( 'alst_cell_traffic', 'traffic' ) );
$ds->addValue( new LabelValueKb( 'alst_cell_space', 'maxkb' ) );
$ds->addValue( new LabelValueKb( 'alst_cell_du', 'du' ) );
$ds->addValue( new LabelValueKb( 'uc_popmaxkb', 'mailspace_usage' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_domains', 'domains' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_shareddomains', 'shareddomains' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_subdomains', 'subdomains' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_wildcards', 'wcdomains' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_mysql', 'mysqls' ) );
$ds->addValue( new LabelValueInt( 'alst_cell_cron', 'crons' ) );
if( $majordomo ){
	$ds->addValue( new LabelValueInt( 'alst_cell_maillist', 'maillists' ) );
}
//if( $idn ){
//	$ds->addValue( new LabelValueInt( 'alst_cell_idn', 'idns' ) );
//}

 
$infoTable = new TableView( $ds );
$infoTable->pushHeader( new ValueLocale( 'alst_title2' ) );


$loFooter =& $infoTable->pushFooter( new ValueLocale( 'alst_servertime' ),
																		 new ValueDateFormated( 'timestamp', NULL,  $lang_format_time )	);
$loFooter->Join( " &nbsp; " );

$infoTable->setFromArray( $info );

$general = $infoTable->GetOutputPresentation( ltext("alst_title1") ) ;

$general->SetWidths( "200" );
/* -------------------- end HTML: general information -------------------- */


/* -------------------- HTML: page -------------------- */
$page = new MainPageElement( $general );

$page->OutputHTML();
/* -------------------- end HTML: page -------------------- */
?>
