<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/class.SQLFieldSet.php' );
include_once( '../include/limits/class.AllLimits.php' );
include_once( '../include/class.HOPermissions.php' );

db_master_connect();

$loReseller = new SQLString( $anbieter );
$loServerID = new SQLString( $server_id );

// check if set & init

$laLimits = array( 'maxkundenlimit', 'maxkblimit', 'maxpoplimit', 'maxemaillimit', 'maxemail',
                   'maxautoresponderlimit', 'maxautoresponder', 'maxftplimit', 'maxftp',             
                   'maxdomainslimit', 'maxsubdomainslimit', 'maxwildcards', 'maxwildcardslimit',
                   'maxatdomainslimit', 'maxatdomains', 'maxsubdomains', 'maxmysqllimit', 
                   'maxmysql','maxcronjobslimit', 'maxcronjobs', 'maxmaillistlimit',  
                   'maxmaillist', 'maxpop', 'dnr', 'dns', 'maxtransfer', 'backup', 
                   'maxkb',  'popmaxkb', 'popmaxkblimit',
                   'maxshareddomains', 'maxshareddomainslimit'
                 );
                 
foreach( $laLimits as $lcLimit ){
  if( istleer( $$lcLimit ) ){ 
    $$lcLimit = 0; 
  }
}

// end check if set & init

## MB/GB in KB bei "max. Speicherplatz vom Anbieter" umwandeln
if( $maxkb <> -1 ){
	if ($maxkb_mbgb == 'MB'){
		$maxkb = $maxkb * 1024;
	}elseif ($maxkb_mbgb == 'GB'){
     $maxkb = $maxkb * 1048576 ;
  }
}
if( $popmaxkb <> -1 ){
  if ($popmaxkb_mbgb == 'MB'){
    $popmaxkb = $popmaxkb * 1024;
  }elseif ($popmaxkb_mbgb == 'GB'){
     $popmaxkb = $popmaxkb * 1048576 ;
  }
}

## /MB/GB in KB bei "max. Speicherplatz vom Anbieter" umwandeln
## MB/GB in KB bei "max. transfer vom Anbieter" umwandeln

if( $maxtransfer <> -1 ){
	if( $maxtransfer_mbgb == 'MB' ){
  	$maxtransfer = $maxtransfer * 1024;
	}elseif( $maxtransfer_mbgb == 'GB' ){
     $maxtransfer = $maxtransfer * 1048576;
  }
}

## /MB/GB in KB bei "max. transfer vom Anbieter" umwandeln

// admin limits
$id = safe_query2( "SELECT * FROM admin WHERE server_id=?",
									 $loServerID );
$laServerSettings = db_fetch_array( $id, 'A' );
db_free_query( $id );

// old res options
// in the future if need more options to get from simply add essential service or limit to query
$id = safe_query2( "SELECT dns, pns, sns FROM anbieter WHERE  anbieter=? AND server_id=?",
									 $loReseller, $loServerID );
$laOldResOptions = db_fetch_array( $id, 'A' );
db_free_query( $id );

$laServices = array('pop' => array( 'maxpop' ),
                    'email' => array( 'maxemail' ),
                    'autoresponder' => array( 'maxautoresponder' ),
                    'ftp' => array( 'maxftp', 'ftp' ),
                    'subdomains' => array( 'maxsubdomains' ),
                    'shareddomains' => array( 'maxshareddomains' ),
                    'mysql' => array( 'maxmysql' ),
                    'php' => array( 'php' ),
                    'perl' => array( 'perl' ),
                    'modpython' => array( 'modpython' ),
                    'ssi' => array( 'ssi' ),
                    'quota' => array( 'popmaxkb' ),
                    'cssl' => array( 'cssl' ),
                    'frontpage' => array( 'frontpage' ),
                    'shell' => array( 'shell' ),
                    'scponly' => array( 'scponly' ),
                    'statistik' => array( 'statistik' ),
                    'awstats' => array( 'awstats' ),
                    'pwschutz' => array( 'pwschutz' ),
                    'webftp' => array( 'webftp' ),
                    'webmail' => array( 'webmail' ),
                    'stdcgi' => array( 'stdcgi' ),
                    'phpupload' => array( 'phpupload' ),
                    'wap' => array( 'wap' ),
                    'coldfusion' => array( 'coldfusion' ),
                    'dirlist' => array( 'dirlist' ),
                    'cronjobs' => array( 'maxcronjobs' ),
                    'majordomo' => array( 'maxmaillist' ) );

foreach( $laServices as $lcService => $laDepend ){
  if( $laServerSettings[$lcService] == 0 ){
    foreach( $laDepend as $lcDepend ){
      $$lcDepend = 0;
    }
  }  
}

$skspamfilter = $laServerSettings["spamfilter"];
if($skspamfilter == 0 || $maxpop == 0)  { $spamfilter = 0; }
 
/**
 * Validate area
 */
function validateSettings($if,$msg){
	global $fehlertext;
	global $DEBUG;
	global $gaAttrTranslate;

	if($if){
		foreach( array_keys( $GLOBALS ) as $key ){ // expand all global variables 
		                                         // like 'global $variable;'
			$$key =& $GLOBALS[$key];
		}
		$fehlertext = $msg;
    db_close();
    include("anbieter_aendern_leistungen.php");
    exit();
	}
}


/**
 * We can't set limit = -1 and hardlimit = 1  at the same time
 */
validateSettings(($maxkundenlimit == 1) && ($maxkunden == -1),ltext("anaele2_error1"));
validateSettings(($maxkblimit == 1) && ($maxkb == -1),ltext("anaele2_error2"));
validateSettings(($popmaxkblimit == 1) && ($popmaxkb == -1),ltext("anaele2_error2"));
validateSettings(($maxpoplimit == 1) && ($maxpop == -1),ltext("anaele2_error4"));
validateSettings(($maxemaillimit == 1) && ($maxemail == -1),ltext("anaele2_error6"));
validateSettings(($maxautoresponderlimit == 1) && ($maxautoresponder == -1),ltext("anaele2_error8"));
validateSettings(($maxshareddomainslimit == 1) && ($maxshareddomains == -1), ltext("anaele2_error_shareddomains"));
validateSettings( $maxatdomainslimit == 1  && $maxatdomains == -1 ,ltext("anaele2_error45"));
validateSettings(($maxftplimit == 1) && ($maxftp == -1),ltext("anaele2_error10"));
validateSettings(($maxdomainslimit == 1) && ($maxdomains == -1), ltext("anaele2_error13"));
validateSettings(($maxsubdomainslimit == 1) && ($maxsubdomains == -1),ltext("anaele2_error14"));
validateSettings( $maxwildcardslimit == 1 && $maxwildcards == -1 ,ltext("anaele2_error47"));
validateSettings(($maxmysqllimit == 1) && ($maxmysql == -1),ltext("anaele2_error16"));
validateSettings(($maxmaillistlimit == 1) && ($maxmaillist == -1),ltext("anan2_error37"));
validateSettings(($maxcronjobslimit == 1) && ($maxcronjobs == -1),ltext("anaele2_error43"));

/**
 * Service depends
 */
validateSettings(($stdcgi == 1) && ($perl != 1),ltext("anaele2_error18"));
validateSettings(($shell == 1) && ($ftp == 0),ltext("anaele2_error19"));
validateSettings(($ftp == 0) && ($maxftp != 0),ltext("anaele2_error12"));
validateSettings(($dns == 0) && ($dnr == 1),ltext("anaele2_error40"));

/**
 * Check of correctness of limit values
 */
validateSettings(!is_numeric($maxcronjobs) || ($maxcronjobs < -1) ,ltext("anaele2_error44"));
validateSettings(!is_numeric($maxmaillist) || ($maxmaillist < -1),ltext("anan2_error38"));
validateSettings(!is_numeric($maxkunden) || ($maxkunden > 32000) || ($maxkunden == 0) || ($maxkunden < -1) ,ltext("anaele2_error20"));
validateSettings(!is_numeric($maxkb),ltext("anaele2_error21"));
validateSettings(!is_numeric($popmaxkb),ltext("anaele2_error21"));
validateSettings((($maxkb < 1024) && ($maxkb <> -1)) || ($maxkb > 2147283647) || ($maxkb < -1),ltext("anaele2_error22"));
validateSettings(!is_numeric($maxpop)||($maxpop > 8388607) || ($maxpop < -1), ltext("anaele2_error23"));
validateSettings(!is_numeric($maxemail)||($maxemail > 8388607) || ($maxemail < -1),ltext("anaele2_error24"));
validateSettings(!is_numeric($maxwildcards)||$maxwildcards > 0x7FFFFF || $maxwildcards < -1 ,ltext("anaele2_error49"));
validateSettings(!is_numeric($maxatdomains)|| $maxatdomains > 0x7FFFFF || $maxatdomains < -1 ,ltext("anaele2_error50"));
validateSettings(!is_numeric($maxautoresponder)||($maxautoresponder > 8388607) || ($maxautoresponder < -1) ,ltext("anaele2_error26"));
validateSettings((($maxemail < $maxautoresponder) && ($maxautoresponder > 0) && ($maxemail <> -1)) || (($maxautoresponder == -1) && ($maxemail <> -1)),ltext("anaele2_error27"));
validateSettings(!is_numeric($maxftp)||$maxftp > 8388607 || ($maxftp < -1) ,ltext("anaele2_error28"));
validateSettings(!is_numeric($maxtransfer)||($maxtransfer < -1) ,ltext("anaele2_error29"));
validateSettings($maxtransfer > 2147283647,ltext("anaele2_error30"));
validateSettings( ! is_numeric( $maxshareddomains ) 
                  || ( $maxshareddomains > 8388607 ) 
                  || ($maxshareddomains < -1 ) ,ltext("anaele2_error52"));

validateSettings(!is_numeric($maxdomains)|| ($maxdomains > 8388607) || ($maxdomains < -1) ,ltext("anaele2_error32"));

validateSettings( (( $maxdomains < $maxkunden ) && $maxdomains != -1 ) 
                  || ( $maxkunden == -1 && $maxdomains != -1 ), 	ltext( 'anaele2_error31' ) );

validateSettings(!is_numeric($maxsubdomains)||($maxsubdomains > 8388607) || ($maxsubdomains < -1) ,ltext("anaele2_error33"));
validateSettings((($maxwildcards > $maxkunden) && ($maxkunden != -1)) || (($maxwildcards == -1) && ($maxkunden != -1)),ltext("anaele2_error34"));
validateSettings(($maxwildcards > $maxsubdomains) && ($maxsubdomains != -1),ltext("anaele2_error35"));
validateSettings(!is_numeric($maxmysql)||($maxmysql > 32000) || ($maxmysql < -1) ,ltext("anaele2_error36"));
validateSettings(($dbext == 1) && ($maxmysql == 0),ltext("anaele2_error37"));
validateSettings(($php == 0) && ($phpupload == 1),ltext("anaele2_error38"));

/**
 * Check of correctness of limit values(overhead)
 */
if( $maxkblimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxkb = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( ( db_num_rows( $lrId ) > 0), ltext("anaele2_error3" ) );
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(maxkb) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array($lrId);
  validateSettings( ( $liCount > $maxkb), ltext("anaele2_error3_2", $maxkb, $liCount ) );
  db_free_query( $lrId );
}

if( $popmaxkblimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND popmaxkb = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( ( db_num_rows( $lrId ) > 0),ltext("anaele2_error51"));
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(popmaxkb) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array($lrId);                       
  validateSettings( ( $liCount > $popmaxkb),ltext("anaele2_error51_2", $popmaxkb, $liCount ) );
  db_free_query( $lrId );
}

if( $maxpoplimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter =? ".
                       " AND maxpop = -1 AND server_id=?", $loReseller, $loServerID);
  validateSettings(db_num_rows($lrId) > 0,ltext("anaele2_error5"));
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(maxpop) FROM kunden WHERE anbieter =? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array($lrId);                                              
  validateSettings( $liCount > $maxpop, ltext("anaele2_error5_2", $maxpop, $liCount ) ); 
  db_free_query( $lrId );
}

if( $maxemaillimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxemail = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0,ltext( "anaele2_error7" ) );
  db_free_query( $lrId );
 
  $lrId = safe_query2( " SELECT SUM(maxemail) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array($lrId);                                                                     
  validateSettings( $liCount > $maxemail, ltext( "anaele2_error7_2", $maxemail, $liCount ) );  
  db_free_query( $lrId );
}

if( $maxautoresponderlimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxautoresponder = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0, ltext("anaele2_error9" ) );
  db_free_query( $lrId ); 
  
  $lrId = safe_query2( " SELECT SUM(maxautoresponder) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                       
  validateSettings( $liCount > $maxautoresponder, ltext("anaele2_error9_2", $maxautoresponder, $liCount ) );
  db_free_query( $lrId );
}

if( $maxatdomainslimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxatdomains = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0 , ltext( "anaele2_error46" ) );
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(maxatdomains) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                       
  validateSettings( $liCount > $maxatdomains, ltext( "anaele2_error46_2", $maxatdomains, $liCount ) ); 
  db_free_query( $lrId );
}

if( $maxftplimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxftp = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0, ltext("anaele2_error11" ) );
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(maxftp) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                       
  validateSettings( $liCount > $maxftp, ltext("anaele2_error11_2", $maxftp, $liCount ) );
  db_free_query( $lrId );
}

if( $maxsubdomainslimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxsubdomains = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows($lrId) > 0,ltext("anaele2_error15"));
  db_free_query( $lrId );
   
  $lrId = safe_query2( " SELECT SUM(maxsubdomains) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                                              
  validateSettings( $liCount > $maxsubdomains, ltext("anaele2_error15_2", $maxsubdomains, $liCount ) );
  db_free_query( $lrId );
}

if( $maxwildcardslimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND wildcard = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0, ltext("anaele2_error48" ) );
  db_free_query( $lrId );
  
  $lrId = safe_query2( " SELECT SUM(wildcard) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                       
  validateSettings( $liCount > $maxwildcards, ltext("anaele2_error48_2", $maxwildcards, $liCount ) );
  db_free_query( $lrId );
}
/**
 * Shared domains
 */
if( $maxshareddomainslimit == 1 ){
	 $lrId = safe_query2( " SELECT domain FROM domains WHERE richtigedomain=7 AND anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  $liCount = db_num_rows( $lrId );                       
  validateSettings( $liCount > $maxshareddomains, ltext( 'anaele2_err_shareddomains', $maxshareddomains, $liCount ) ); 
  db_free_query( $lrId );                          
}


if( $maxmysqllimit == 1 ){
  $lrId = safe_query2( " SELECT * FROM kunden WHERE anbieter = ? ".
                       " AND maxmysql = -1 AND server_id=?", $loReseller, $loServerID );
  validateSettings( db_num_rows( $lrId ) > 0, ltext( "anaele2_error17" ) );
  db_free_query( $lrId ); 
  
  $lrId = safe_query2( " SELECT SUM(maxmysql) FROM kunden WHERE anbieter = ? ".
                       " AND server_id=?", $loReseller, $loServerID );
  list( $liCount ) = db_fetch_array( $lrId );                       
  validateSettings( $liCount > $maxmysql, ltext( "anaele2_error17_2", $maxmysql, $liCount ) );
  db_free_query( $lrId ); 
}

/**
 * Httpd options
 */
$loHttpdOptions = new HOPermissions( $server_id );
if( ! $loHttpdOptions->saveForReseller( $anbieter, $httpd_ids ) ){
  validateSettings( 1 , $loHttpdOptions->getErrorMessage() );  
}


$limits = new AllLimits();
$limits->SetFromRow ($_POST);
for ( $limits->FirstService(); $service =& $limits->NextService(); ){
    if ( ! $service->AdminAllowed($laServerSettings) )
	$service->SetValue(0);
    if ( ! $service->GetValue() )
	switch ( $service->GetName() ){
	case 'drweb':
		safe_query2( "UPDATE email SET drwebfilter=0, drwebnotify=0 ".
								 " WHERE anbieter=? AND server_id=?",
								 $loReseller, $loServerID );
		safe_query2( "UPDATE kunden SET drweb=0 WHERE anbieter=? AND server_id=?",
								 $loReseller, $loServerID );
		safe_query2( "UPDATE allgemein SET drweb=1 WHERE server_id=?",
								 $loServerID );
		break;
	}
    else
	switch ( $service->GetName() ){
	    case 'drweb':
		break;
	}
}

## /nochmal checken, ob leistung vom system aus m glich ist


$timestamp = time();

## in db speichern
$fields = new SQLFieldSet( array ( 
																	'maxkunden' => $maxkunden,
																	'maxpop' => $maxpop,
																	'maxkb' => $maxkb,
                                  'popmaxkb' => $popmaxkb,                 
                                  'popmaxkblimit' => $popmaxkblimit,                 
																	'maxmysql' => $maxmysql,
																	'maxemail' => $maxemail,
																	'maxautoresponder' => $maxautoresponder,
																	'maxftp' => $maxftp,
																	'maxtransfer' => $maxtransfer,
																	'maxdomains' => $maxdomains,
																	'maxsubdomains' => $maxsubdomains,
																	'maxkundenlimit' => $maxkundenlimit,
																	'maxpoplimit' => $maxpoplimit,
																	'maxkblimit' => $maxkblimit,
																	'maxmysqllimit' => $maxmysqllimit,
																	'maxemaillimit' => $maxemaillimit,
																	'maxautoresponderlimit' => $maxautoresponderlimit,
																	'maxftplimit' => $maxftplimit,
																	'maxdomainslimit' => $maxdomainslimit,
																	'maxsubdomainslimit' => $maxsubdomainslimit,
																	'maxwildcards' => $maxwildcards,
                                  'maxwildcardslimit' => $maxwildcardslimit,
                                  'maxshareddomains' => $maxshareddomains,
																	'maxshareddomainslimit' => $maxshareddomainslimit,
																	'maxatdomains' => $maxatdomains,
																	'maxatdomainslimit' => $maxatdomainslimit,
																	'php' => $php,
																	'ftp' => $ftp,
																	'perl' => $perl,
																	'modpython' => $modpython,
																	'ssi' => $ssi,
																	'cssl' => $cssl,
																	'shell' => $shell,
																	'scponly' => $scponly,
																	'statistik' => $statistik,
																	'awstats' => $awstats,
																	'pwschutz' => $pwschutz,
																	'fehlerseiten' => $fehlerseiten,
																	'webftp' => $webftp,
																	'webmail' => $webmail,
																	'stdcgi' => $stdcgi,
																	'frontpage' => $frontpage,
																	'lastchange' => $timestamp,
																	'dbext' => $dbext,
																	'phpupload' => $phpupload,
																	'wap' => $wap,
																	'coldfusion' => $coldfusion,
																	'dirlist' => $dirlist,
																	'dns' => $dns,
																	'dnr' => $dnr,
																	'maxcronjobs' => $maxcronjobs,
																	'maxcronjobslimit' => $maxcronjobslimit,
																	'maxidn' => -1,
																	'maxidnlimit' => 0,
																	'maxmaillist' => $maxmaillist,
																	'maxmaillistlimit' => $maxmaillistlimit,
																	'spamfilter' => $spamfilter,
																	'backup' => $backup )
													 );
// fill pns & sns by hostname if we turn on dns feature and old pns & sns are empty
if( $dns && (!$laOldResOptions['pns'] || !$laOldResOptions['sns'] ) ){
  $fields->addField(new SQLField( 'pns', $laServerSettings["hostname"], 'S' ));
  $fields->addField(new SQLField( 'sns', $laServerSettings["hostname"], 'S' ));
}

$updts = $fields->getSQLUpdate();

if( $updsLim = $limits->SQLUpdateValues("anbieter")){
	$updts .= ', '.$updsLim;
}

$sql = "UPDATE anbieter SET $updts WHERE anbieter =? AND server_id=?";
safe_query2( $sql, $loReseller, $loServerID );

$fehlertext = ltext( 'anaele2_error39' );

$fehlertitel = ltext( 'anaele2_errortitle' );


db_close();

popPathBar( TRUE );
include( "anbieter_start.php");

?>

