<?
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.ButtonData.php' );
include_once( '../include/elements/html/class.ButtonURLElement.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

if( isset($type) ){
	switch( $type ){
	case 'domain':
		include('einstellungen_dnsspezial_domain_suche.php');
		exit();
	case 'reseller':
		include('einstellungen_dnsspezial_anbieter_aendern.php');
		exit();
	}
 }

db_master_connect();
if( isset( $server_id ) ){
	$id = safe_query2( "SELECT a.hostname,s.name FROM admin a ".
										 " LEFT JOIN server s ON s.server_id=a.server_id ".
										 " WHERE a.server_id=?", new SQLString( $server_id ) );
	list( $hostname, $name ) = db_fetch_array( $id, 'N' );
	db_free_query( $id );
 }

$data = new SetOfRowsData();

$domain_field = new CompoundDataField();
$domain_field->SetSeparator("&nbsp;");
$domain_field->AppendToContent( new TextDataField('', 'domain') );
$domain_field->AppendToContent( new HTMLDataField(ltext('eihtdo_cell_domain')) );
$data->AppendRow( $domain_field, new ButtonData(ltext('eihtdo_button1'), "javascript:doChange()") );


$data->AppendHidden( new TextDataField( 'domain', 'type' ) );

if( isset( $ret_path ) ){
	$data->AppendHidden( new TextDataField( $ret_path, 'ret_path' ) );
 }

if( isset( $server ) ){
	$data->AppendHidden( new TextDataField( $server, 'server' ) );
 }




$form = $data->GetInputPresentation( array( 'action'=>'einstellungen_dnsspezial_domain.php',
																						'method'=>'post',
																						'name'=>'form1' ), 
																		 ltext( 'eihtdo_descr2' ) );
if( isset($ret_path) && $ret_path ){
	$page = new MainPageElement( $form,
															 new ButtonURLElement( ltext( 'll_back' ), 
																										 "$ret_path?server=".htmlspecialchars( $server ), 
																										 cc_IDBack ));
 }else{
	$page = new MainPageElement( $form );
 }
									
$page->OutputHTML( array( '../js/paged_form.js' ),
									 js_f_call_help( 'dnshelp_title3', 'dnshelp_descr3' )
									 );

db_close();
?>