<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG = 1;

db_master_connect();

if( isset( $server_id ) ){
	$sql = "SELECT dns.domain,dns.kunde,dns.server_id,a.hostname, ".
		" s.name AS server_name, k.name AS user_name ".
		" FROM dns, kunden k, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
		" WHERE k.server_id=dns.server_id AND k.kunde=dns.kunde ".
		" AND dns.server_id = ? AND dns.server_id=a.server_id AND domain LIKE ? ".
		" ORDER BY dns.domain";
  $id = safe_query2( $sql, new SQLString( $server_id ), new SQLString( "%$domain%" ) );

 }else{
	$sql = "SELECT dns.domain,dns.kunde,dns.server_id,a.hostname,".
		" s.name AS server_name, k.name AS user_name ".
		" FROM dns, kunden k, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
		" WHERE k.server_id=dns.server_id AND k.kunde=dns.kunde ".
		" AND dns.server_id=a.server_id AND dns.domain LIKE ? ".
		" ORDER BY dns.domain";
	$id = safe_query2( $sql, new SQLString( "%$domain%" ) );

 }


if( ! isset( $ret_path ) ){
	$ret_path = '';
 }

$data = new SetOfRowsData();

$data->AppendHeaderRow( new HTMLDataField( ltext( 'eidnspdosu_cell_text3' ) ),
												new HTMLDataField( ltext( 'eidnspdosu_cell_text1' ) ),
												new HTMLDataField( ltext( 'eidnspdosu_cell_text2' ) ),
												new HTMLDataField( ltext( 'eidnspdosu_cell_text8' ) ),
												new HTMLDataField( ltext( 'eidnspdosu_cell_text4' ) ) 
												);

while( $daten = db_fetch_array( $id ) ){
	$domain   = $daten['domain'];
	$kunde    = $daten['kunde'];
	$server_id = $daten['server_id'];
	$server = $daten['server_name'].' ('.$daten['hostname'].')';
	$name = $daten['user_name'];
	
	$data->AppendRow( new HTMLDataField( $domain ),
										new HTMLDataField( $kunde ),
										new HTMLDataField( '&nbsp;'.$name ),
										new HTMLDataField( $server ),

										new LinkDataField( 'einstellungen_dnsspezial_domain_aendern.php',
																			 '',
																			 array( 'domain' => $domain,
																							'server_id' => $server_id,
																							'ret_path' => $ret_path,
																							'server' => $daten['server_name']),
																			 ltext( 'eidnspdosu_cell_text4' ) ) );
}
db_free_query( $id );

$page = new MainPageElement( $data->GetOutputPresentation ( ltext('eidnspdosu_cell_text5') ) );
$page->OutputHTML(js_f_call_help('dnshelp_title3', 'dnshelp_descr3'));

db_close();
?>