<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );/*{{{*/
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/class.HOStates.php' );
/*}}}*/

global $DEBUG;
//$DEBUG = 1;

db_master_connect();

$lrId= db_query( "SELECT COUNT(id) FROM httpd_definitions" );
list( $liHttpdCount ) = db_fetch_array( $lrId, 'N');
db_free_query( $lrId );

$lbHttpdSpecial = 1;
$lbHttpdOptions = $liHttpdCount;

/**
 * Save action
 */
if( isset($act) && $act == 'save' ){/*{{{*/
	$loKunde = new SQLString( $kunde );
	$loText = new SQLString( $zusatz );
  $loServerID = new SQLString( $server_id );

  if( $mode == 'advanced' ){
    if( $ueberschreiben == 'ja' ){
      safe_query2( "UPDATE domains SET zusatz = ? WHERE kunde = ? AND richtigedomain !=7  AND server_id=?", 
                   $loText, $loKunde, $loServerID );

    }elseif( $ueberschreiben == 'nein' ){
      $id = safe_query2( " SELECT domain FROM domains WHERE kunde = ? ".
                         " AND zusatz != '' AND richtigedomain !=7 AND server_id=?", 
                         $loKunde, $loServerID );
      while( $werte = db_fetch_array( $id ) ){
        $nichtgeaendert .= $werte["domain"]."<br>";
      }
      db_free_query( $id );

      safe_query2( " UPDATE domains SET zusatz = ? WHERE kunde = ? AND zusatz = '' ".
                   " AND richtigedomain !=7 AND server_id=?", 
                   $loText, $loKunde, $loServerID );
    }

    if( $all == 1 ){
      safe_query2( "UPDATE kunden SET httpdspezial = ? WHERE kunde = ?  AND server_id=?", 
                   $loText, $loKunde, $loServerID );
    }
  }else{
    /**
     * Httpd options
     */
    $loHttpdOptions = new HOStates( $server_id );
    $loHttpdOptions->setForUser( $kunde, $httpd_ids, $all );
  }

	safe_query2( "UPDATE kunden SET httpd = 1 WHERE kunde = ?  AND server_id=?",
							 $loKunde, $loServerID );

	safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id=?" ,
							 $loServerID);
	db_close();

	$fehlertitel = ltext( 'eihtkuaesp_errortitle1');
	$fehlertext = ltext( 'eihtkuaesp_error1' );
	if( strlen( $nichtgeaendert ) > 0){
		$fehlertext .= ltext( 'eihtkuaesp_error2', array( $nichtgeaendert ) );
	}

	include( 'einstellungen_httpd.php' );
	exit();
 }/*}}}*/

if( ! ( isset( $zusatz ) && $zusatz ) ){
	$id = safe_query2( "SELECT k.httpdspezial, a.confixx_domain, s.name ".
										 " FROM kunden k, admin a LEFT JOIN server s ON s.server_id=a.server_id ".
										 " WHERE k.server_id=a.server_id AND kunde = ? AND k.server_id=?",
										 new SQLString( $kunde ), new SQLString( $server_id) );
	list($zusatz,$hostname,$name) = db_fetch_array($id, 'N' );
	db_free_query( $id );
 }

$loData = new SetOfRowsData();

$loData->AppendRow(new HTMLDataField( '##user##' ),
	new HTMLDataField( ltext("eihtkuae_cell_username") ));
$loData->AppendRow(new HTMLDataField( '##domain##' ),
	new HTMLDataField( ltext("eihtkuae_cell_domain") ));

if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loLinkBlock = new CompoundDataField(  new LinkDataField( "javascript:displayDiv('sim_mode',1);displayDiv('adv_mode',0);",
                                                          "",
	                                                        array( ),
                                                          ltext('simple_mode') ) ,
                                         new LinkDataField( "javascript:displayDiv('adv_mode',1);displayDiv('sim_mode',0);",
                                                           "",
	                                                        array( ),
                                                          ltext('advanced_mode') )             
                                                        );
  $loLinkBlock->SetSeparator(" / ");
  $loLinkBlock->AppendParentAttributes(array("colspan"=>2));
  $loData->AppendRow($loLinkBlock);
}  


$boxLegend = $loData->GetOutputPresentation(ltext("eihtkuae_title2") ); // Infotable
$boxLegend->SetWidths( '20%', '80%' );

$loData->ClearRows();

if( $lbHttpdOptions ){
  $liFormIndex = 1;
}else{
  $liFormIndex = 0;
}
 
$lcTitle = ltext( "eiht_cell_user" )." <strong>".htmlspecialchars( $kunde )."</strong> '".
           htmlspecialchars( $name )."' (".htmlspecialchars( $hostname ) .")";

$loData->AppendRow( new HTMLDataField( ltext( 'eihtkuae_cell_title1',array($kunde,$name,$hostname))), 
	new LongTextDataField( $zusatz, 'zusatz' ) 
);

$loData->AppendRow(new HTMLDataField(ltext("eihtkuae_cell_text3")),
	new YesNoDataField(array("1"=>""),array(),"","all"));


$lo_Radio= new OptionsDataField( array( "ja" => ltext("eihtkuae_cell_text1"),
                                        "nein" => ltext("eihtkuae_cell_text2")),
                                "nein","ueberschreiben",cc_RadioGroupPresentation);
$lo_Radio->SetColSpan(2);
$loData->AppendRow($lo_Radio);

$loData->AppendHidden( new TextDataField( 'advanced', 'mode' ) );
$loData->AppendHidden(new TextDataField( $kunde, 'kunde' ) );
$loData->AppendHidden(new TextDataField( $server_id, 'server_id' ) );
$loData->AppendHidden(new TextDataField( 'save', 'act' ) );
$loData->AppendHidden( new TextDataField( 'einstellungen_httpd_kunde_aendern.php', 'ret_path' ) );
$loData->AppendHidden( new TextDataField( 'kunde', 'ret_field' ) );

$loData->AppendButton( ltext('eihtkuae_button1'), 
										 "javascript:doChange($liFormIndex)",
										 cc_IDOk );
$loData->AppendButton( ltext( 'eiht_test' ),
										 "javascript:document.forms[$liFormIndex].action='settings_httpd_special.php';doChange($liFormIndex)" );

$form = $loData->GetInputPresentation(array('action'=>"einstellungen_httpd_kunde_aendern.php",'method'=>'post'),
	      $lcTitle );
$form->SetWidths( '20%', '80%' );

$laTmp = array( 'id'=>'adv_mode' ); 

if( $lbHttpdOptions ){
  $laTmp['style'] = 'display:none';
}

$loSpecial = new DivElement( $laTmp );
$loSpecial->AppendToContent( $form );

/**
 * Httpd options
 */
if( $lbHttpdOptions ){
  $loStates = new HOStates( $server_id );
  $loHttpdOptions = & $loStates->getSORDForUser();
  $loHttpdOptions->AppendRow( new HTMLDataField( '' ),
                              new YesNoDataField( array( '1'=> ltext('eihtkuae_cell_text3')  ), array(),'','all' ) 
                            );

  $loHttpdOptions->AppendHidden(new TextDataField( 'save', 'act' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'simple', 'mode' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $kunde, 'kunde' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( $server_id, 'server_id' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'einstellungen_httpd_kunde_aendern.php', 'ret_path' ) );
  $loHttpdOptions->AppendHidden( new TextDataField( 'kunde', 'ret_field' ) );
  $loHttpdOptions->AppendButton( ltext( 'eihtdoae_button1' ), 'javascript:doChange()',  cc_IDOk );
 
  $form2 = $loHttpdOptions->GetInputPresentation( array(
                                             'action'=>'einstellungen_httpd_kunde_aendern.php', 
                                             'method'=>'post' ),
                                     $lcTitle );

  $form2->SetWidths('10%','90%');
  $loOptions = new DivElement(array('id'=>'sim_mode'));
  $loOptions->AppendToContent($form2);
}

if( $lbHttpdOptions && $lbHttpdSpecial ){
  $loPage = new MainPageElement( $boxLegend, $loOptions, $loSpecial );
}elseif( $lbHttpdOptions ){
  $loPage = new MainPageElement( $boxLegend, $loOptions );
}elseif( $lbHttpdSpecial){
  $loPage = new MainPageElement( $boxLegend, $loSpecial );
}else{
  $loPage = new MainPageElement( $boxLegend );
}

$loPage->OutputHTML( array( '../../js/paged_form.js' ));

db_close();

?>
