<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once("auth.php");
include_once("../include/class.SQLString.php");
include_once("../include/elements/data/class.SetOfRowsData.php");
include_once("../include/elements/data/class.HTMLDataField.php");
include_once("../include/elements/data/class.TextDataField.php");
include_once("../include/elements/data/class.ReadOnlyDataField.php");
include_once("../include/elements/data/class.CompoundDataField.php");
include_once("../include/elements/data/class.YesNoDataField.php");
include_once("../include/elements/html/class.MainPageElement.php");

global $DEBUG;
//$DEBUG=1;

/*
if ($DEBUG) {
	echo "kunde_aendern_loeschen.php<br>\n";
}
*/

db_master_connect();

$laToDelete      = array();
$gcUserSeparator = '@';
$lcWhere         = '';
$laForbidden     = array();

if ( is_array( $users ) ){
	$laUsers = array();
	foreach ($users as $lcUser) {
	  list($lcKunde, $lcServerID) = explode($gcUserSeparator, $lcUser);
		$loKunde  = new SQLValue($lcKunde, 'C');
		$loId     = new SQLValue($lcServerID, 'C');
		$lcWhere .= "(k.kunde = ".$loKunde->getSQLValue()." AND k.server_id = ".$loId->getSQLValue().") OR ";
	}
	
  $lcWhere = substr($lcWhere, 0 , -3);
	
  $id = safe_query2( " SELECT k.kunde, d.domain, d.richtigedomain, k.anbieter, k.server_id,".
                     " a.confixx_domain, a.userprefix FROM kunden k ".
                     " LEFT JOIN domains d ON k.kunde = d.kunde AND d.richtigedomain NOT IN (2,3) ".
                     " AND d.server_id=k.server_id".
										 " LEFT JOIN admin a ON (k.server_id = a.server_id) ".
										 " WHERE $lcWhere ORDER BY k.kunde,d.domain");
										 
	while ($row = db_fetch_array($id)) {
	  $kunde      = $row['kunde'];
	  $lcHost     = $row['confixx_domain'];
	  $server_id  = $row['server_id'];
	  $user_prefix = $row['userprefix'];
	  if ( $kunde == $user_prefix.'0' ){
      $laForbidden[] = array( 'user'   => $kunde, 
                              'server' => $lcHost            
                            ); 
      
    } else {
			if( !array_key_exists( $kunde.$gcUserSeparator.$server_id, $laToDelete ) ){
				$laToDelete[$kunde.$gcUserSeparator.$server_id] = array();
				$laToDelete[$kunde.$gcUserSeparator.$server_id]['user'] = $kunde;
				$laToDelete[$kunde.$gcUserSeparator.$server_id]['server'] = $lcHost;
				$laToDelete[$kunde.$gcUserSeparator.$server_id]['domains'] = array();
			}
      array_push( $laToDelete[$kunde.$gcUserSeparator.$server_id]['domains'], 
                  array( 'domain' =>  $row["domain"], 
                         'type'   => $row['richtigedomain'] ) );
    }
  }
	}elseif( $kunde ){
	  
	  $loServerID = new SQLString( $server_id );
	  $loKunde    = new SQLString( $kunde );
	  
	  $id = safe_query2("SELECT confixx_domain, userprefix FROM admin WHERE server_id=?" ,$loServerID);
    list($lcHost, $user_prefix) = db_fetch_array($id); 
    
    if ( $kunde == $user_prefix.'0' ){
      $laForbidden[] = array( 'user'   => $kunde, 
                              'server' => $lcHost            
                            ); 
    } else {		
  		$id = safe_query2("SELECT domain, richtigedomain FROM domains WHERE richtigedomain NOT IN (2,3) ".
  											 " AND kunde = ?  AND server_id=? ", $loKunde, $loServerID);
  											   											 
  		$laToDelete[$kunde.$gcUserSeparator.$server_id] = array();
  		$laToDelete[$kunde.$gcUserSeparator.$server_id]['user'] = $kunde;
			$laToDelete[$kunde.$gcUserSeparator.$server_id]['server'] = $lcHost;
			$laToDelete[$kunde.$gcUserSeparator.$server_id]['domains'] = array();

  		while ($werte = db_fetch_array($id)) {
        array_push( $laToDelete[$kunde.$gcUserSeparator.$server_id]['domains'], 
                    array( 'domain' =>  $werte["domain"], 
                           'type'   => $werte['richtigedomain'] ) );
  		}
	 }
	} else {
		$fehlertext = ltext('kuaelo_nothing');
		popPathBar(TRUE);
		include('kunden_start.php');
		exit;
	}

/* -------------------- HTML -------------------- */
$data = new SetOfRowsData();
if ( count( $laForbidden ) ) {
  foreach( $laForbidden as $lcUser ){
  	$loMsg = new HTMLDataField( ltext("kuaelo_forbidden", $lcUser['user'], $lcUser['server'] ) );
  	$loMsg->SetColSpan(2);
  	$data->AppendRow( $loMsg );
 		$data->AppendHidden( new TextDataField( $lcUser['user'], "undelete[]" ) );
  }
}

foreach($laToDelete as $lcKundeKey => $laKunde) {
	
	$loConfirm = new HTMLDataField(ltext("kuaelo_descr1", $laKunde['user']));
	$loDomains = new CompoundDataField();
	foreach($laKunde['domains'] as $domain) {
    $loDomain = new ReadOnlyDataField( $domain['domain'] );
    if( $domain['type'] == 7 ){
      $loDomain->AddParentTag( 'i' );
      $loDomain->AddParentTag( 'b' );
    }else{
      $loDomain->AddParentTag( 'strong' );
    }
		$loDomains->AppendToContent( $loDomain );
	}
	$loDomains->SetSeparator("<br>");

	$loYesNo = new YesNoDataField(array('ja' => ltext("kuaelo_text1", $laKunde['user'])), 
																 array('nein' => ltext("kuaelo_text2", $laKunde['user'])), 
																 'ja', 
																 'loeschen['.$lcKundeKey.']', 
																 cc_RadioGroupPresentation 
																);
	$loYesNo->AppendParentAttributes(array('rowspan'=>2));

	$data->AppendRow($loConfirm, $loYesNo);
	$data->AppendRow($loDomains);

	$data->AppendHidden(new TextDataField($lcKundeKey, 'kunde[]'));

}
$lcLebel = count( $laToDelete ) ? ltext("kuaelo_button1") : ltext("ll_next_2");
$data->AppendButton( $lcLebel ,"javascript: doChange()", cc_IDOk);


$loForm = $data->GetInputPresentation(array('method'=>'post',
																							'action'=>'kunden_aendern_loeschen2.php'), 
																			 ltext('kuae_cell_delete') 
																			);
$loForm->SetWidths('50%', '50%');
$page = new MainPageElement($loForm);
$page->AppendToHelp(array("", "kuaelo_title1"));
$page->OutputHTML();
/* -------------------- end HTML -------------------- */
?>
