<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../languages/'.$shortlang.'/scripts.inc.php' );
include_once( '../include/class.SQLString.php' );
include_once( 'class.SQLFieldSet.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.ButtonURLData.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "kunden_ssl_erstellen3.php : _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
 }

db_master_connect();

$loUser     = new SQLString( $anbieter );
$loServerID = new SQLString( $server_id );
$loKunde    = new SQLString( $kunde );

$id = safe_query2( "SELECT cssl FROM anbieter WHERE anbieter = ?  AND server_id=?", $loUser, $loServerID );
$werte = db_fetch_array($id);
$skssl = $werte["cssl"];

if( $skssl < 1 ){
	$fehlertext = ltext( "kusser_error1" );
	db_close();
	popPathBar();
	include( "kunden_start.php" );
	exit();
}


## prfen, ob kunde eigene ip adresse hat
$id = safe_query2( "SELECT COUNT(*) FROM ipadressen WHERE kunde = ? AND anbieter = ?  AND server_id=? AND status=1",
									 $loKunde, $loUser, $loServerID );
list( $count ) = db_fetch_array( $id );
db_free_query( $id );
if( $count < 1 ){
	$fehlertext = ltext("kusser_error2", array( $kunde ));
	db_close();
	include("kunden_ssl.php");
	exit();
}
## //

## daten in Datenbank schreiben

$loFields = new SQLFieldSet( array( 'aendern' => 1,
																		'loeschen' => 0,
																		'neu' => 1,
																		'countrycode' => array($countrycode,'C'),
																		'state' => array( $state ,'C'), 
																		'city' => array( $city, 'C'), 
																		'firm' => array( $firm, 'C'), 
																		'unit' => array( $unit, 'C'), 
																		'email' => array( $email, 'C'), 
																		'common' => array( $common, 'C')
																		)
														 );

$id = safe_query2( "SELECT COUNT(*) FROM cssl WHERE kunde = ?  AND server_id=?", $loKunde, $loServerID );
list($count) = db_fetch_array($id);
db_free_query( $id );

if( $count < 1 ){
	list ($lcFields,$lcValues) = $loFields->getSQLInsert();
	$lcSQL = "INSERT INTO cssl ( kunde, anbieter, $lcFields, server_id ) VALUES ( ?, ?, $lcValues, ? )";
	safe_query2( $lcSQL, $loKunde, $loUser, $loServerID );

} else	{
	$lcSQL = "UPDATE cssl SET ".$loFields->getSQLUpdate()." WHERE kunde=? AND anbieter=? AND server_id=?";
	safe_query2( $lcSQL, $loKunde, $loUser, $loServerID );
}


$cmd = $bindir."/sslgen.pl -user=$kunde -self=$selfsigned -sid=$server_id";

if( $DEBUG ){
	echo "exec: $cmd<br>\n";
 }

exec($cmd, $crs, $status);

if( $status != 0 ){
	db_close();
	$fehlertext = mlf_text( $crs[0] );
	include( "kunden_ssl_erstellen2.php" );
	exit();
}

if( $selfsigned ){
	db_close();
	include( "kunden_ssl_erstellen.php" );
	exit();
}

$id = safe_query2( "SELECT privatekey, csr FROM cssl WHERE kunde = ?  AND anbieter = ?  AND server_id=?", 
									 $loKunde, $loUser, $loServerID );

list( $privatekey, $csr ) = db_fetch_array( $id, 'N' );
db_free_query( $id );

safe_query2( "UPDATE cssl SET neu=1,aendern=0,loeschen=1 WHERE kunde = ? AND anbieter = ?  AND server_id=?", 
						 $loKunde, $loUser, $loServerID );


/* -------------------- HTML -------------------- */
$data = new SetOfRowsData();
$data->AppendRow( new HTMLDataField( ltext("kusser3_cell_privatekey") ), new HTMLDataField( nl2br($privatekey) ) );
$data->AppendRow( new HTMLDataField( ltext("kusser3_cell_crs") ), new HTMLDataField( nl2br($csr) ) );


$data->AppendRow( new ButtonURLData( ltext('ll_back'), 'kunden_ssl.php'));



$page = new MainPageElement( $data->GetOutputPresentation( "" ) );
$page->AppendToHelp( array( '', 'kusser3_title1' ) );
$page->OutputHTML();
/* -------------------- end HTML -------------------- */
?>
