<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( 'auth.php' );
include_once( '../include/elements/data/class.SetOfRowsData.php' );
include_once( '../include/elements/data/class.HTMLDataField.php' );
include_once( '../include/elements/data/class.CompoundDataField.php' );
include_once( '../include/mail/class.EmailConnect.php' );
include_once( '../include/elements/data/class.LinkDataField.php' );
include_once( '../include/elements/data/class.FileDataField.php' );
include_once( '../include/elements/data/class.YesNoDataField.php' );
include_once( '../include/elements/data/class.TextDataField.php' );
include_once( '../include/elements/data/class.LongTextDataField.php' );
include_once( '../include/elements/data/class.OptionsDataField.php' );
include_once( '../include/elements/html/class.MainPageElement.php' );
include_once( '../include/elements/html/module.Constants.php' );
include_once( '../include/class.SQLString.php' );
include_once( '../include/class.SQLInteger.php' );
include_once( 'email_functions.php' );
include_once( 'email_config.php' );
include_once( '../include/mail/class.ConfixxMime.php' );

global $DEBUG;
//$DEBUG = 1;
    
if( $DEBUG ){
  echo "email_neu.php<br>\n";
}


$gcCurrentFolder = ($folder && strtolower( $incomingMailProtocol ) == "imap" ) 
                   ? $folder : "INBOX";

$JSscriptPart      = '';
$JSscriptInclude   = array();
$JSscriptInclude[] = "email_webmail.js";

$loServerID = new SQLString( $ServerID );
$loKunde    = new SQLString( $PHP_AUTH_USER );
//
// Get number of AdressBook's records
//
$lrId = safe_query2( " SELECT COUNT(*) AS num FROM webmail_ab ".
                     " WHERE pop3 = ? AND server_id=?", $loKunde, $loServerID );
                             
list( $liABCount ) = db_fetch_array( $lrId, 'N' );
db_free_query( $lrId );

if( $DEBUG ){
    echo "Number of records in Adress Book: $liABCount <BR>";
}
																			
$loNewMsgTbl = new SetOfRowsData();

//
// Send message
//
if( $sendmail ){
  
  $crlf = "\n";
  
  $loMimeMsg = new ConfixxMime($crlf);
  $loMimeMsg->buildParams( array(
                           'html_charset'  => $msg_encoding,
                           'text_charset'  => $msg_encoding,
                           'head_charset'  => $msg_encoding
                          )
                    );

  if( $from != "" && $to != "" ){
         
    //  Get signature and add it to the end of content         
    if( $signatur ){
      $lrId = safe_query2( "SELECT * FROM webmail_sign WHERE alias = ? AND server_id=?", 
                           new SQLString( $from ), $loServerID );
      $sign  = db_fetch_array( $lrId );
      db_free_query( $lrId );
      $content .= "\n".$sign['signatur'];
    }
    
    $from    = preg_replace( '~\s+~',' ', $from );
    $to      = preg_replace( '~\s+~',' ', $to );
    $cc      = preg_replace( '~\s+~',' ', $cc );
    $bcc     = preg_replace( '~\s+~',' ', $bcc );
    $subject = preg_replace( '~\s+~',' ', $subject );
    //
    // If user set another charset for message need to convert data
    //
    if( strtoupper( $lang_html_charset ) !== strtoupper( $msg_encoding ) ){
     	$from    = @iconv( $lang_html_charset, $msg_encoding, $from );
     	$to      = @iconv( $lang_html_charset, $msg_encoding, $to );
     	$cc      = @iconv( $lang_html_charset, $msg_encoding, $cc );
     	$bcc     = @iconv( $lang_html_charset, $msg_encoding, $bcc );
     	$subject = @iconv( $lang_html_charset, $msg_encoding, $subject );
     	$content = @iconv( $lang_html_charset, $msg_encoding, $content );
    }

    //
    // To exclude superfluous blank lines
    //
  	$mail_content = '';
  	$lines        = explode("\n",$content);                             
  	
  	foreach( $lines as $line ){
  	  $mail_content.= wordwrap(rtrim($line),72,"\n")."\n";
  	}  
    
  	// there are last blank lines
  	if( preg_match( "/\n\n$/", $mail_content ) ){ 
  	   $lines = explode( "\n", $mail_content );
  	   
  	   while( !( $line = array_pop( $lines ) ) && (count( $lines ) > 0 ) ){
  	    /* pop blank lines*/
  	   }
  	   array_push( $lines,$line );
  	   $mail_content = implode( "\n", $lines );
  	}
  	
  	$loMimeMsg->setTXTBody( $mail_content );
 	  //
    // If we have forward message
    //
    if( $forwardid ){
      $lcFwdBody       = '';
      $lcFwdHeader     = '';	

      // POP3 / IMAP-Connect
      $loEmailConnect = & getEmailConnect( $gcCurrentFolder );
      
      if( $loEmailConnect->MBox() ){
      	$lcFwdBody   = imap_body($mbox, $forwardid);
      	$lcFwdHeader = imap_fetchheader($mbox, $forwardid, FT_PREFETCHTEXT);	
      	$lcFwdBody   = $lcFwdHeader."\n".$lcFwdBody;
      	$loMimeMsg->addAttachment($lcFwdBody, "message/rfc822", $fwd_subject, false, '7bit');
      }
      $loEmailConnect->disconnect();
    }
    
    if( $DEBUG ){
      echo "attachment_name: $attachment_name<br>\n";
    }
    
    if( $attachment_name != "" ){
      $loMimeMsg->addAttachment($attachment, $attachment_type, $attachment_name);
    }
    
    $lcBody = & $loMimeMsg->get();
    //
    // Headers
    //
    $laHeaders = array(
                      'From'    => $from,
                      'To'      => $to,
                      'Cc'      => $cc,
                      'Bcc'     => $bcc,
                      'Subject' => $subject
                     );    
    $laHeaders = $loMimeMsg->headers($laHeaders);
    
     $lcMailHeader = "From: ".$laHeaders['From'];

    switch ($priority) {
      case "1":
        $lcMailHeader .= "\nX-Priority: 1\nImportance: High\nX-MSMail-Priority: High";
        break;
      case "3":
        $lcMailHeader .= "\nX-Priority: 3\nImportance: Normal\nX-MSMail-Priority: Normal";
        break;
      case "5":
        $lcMailHeader .= "\nX-Priority: 5\nImportance: Low\nX-MSMail-Priority: Low";
        break;
    }
    
  	if ($priority) {
  	  $lcMailHeader .= "\nX-MimeOLE: Produced by Confixx WebMail".
                  	  "\nX-Mailer: Confixx WebMail (like SquirrelMail)";
  	  /*  need for spamassassin */
  	}
  	
    $lcMailHeader1  = ''; 
  	$lcMailHeader1 .= "\nTo: ".$laHeaders['To'];
  	$lcMailHeader1 .= "\nSubject: ".chop($laHeaders['Subject']);
  	
  	$lcMailHeader2 = '';
    $lcMailHeader2 .= "\nCc: ".$laHeaders['Cc'];
    $lcMailHeader2 .= "\nBcc: ".$laHeaders['Bcc'];
    $lcMailHeader2 .= "\nMIME-Version: ".$laHeaders['MIME-Version'];
    
    if( !$mail_attach ){
      $lcMailHeader2 .= "\nContent-Type: ".$laHeaders['Content-Type'];
      $lcMailHeader2 .= "\nContent-Transfer-Encoding: ".$laHeaders['Content-Transfer-Encoding'];
    } 
    
    if( $DEBUG ){
      echo "message:<br>\n<pre>$lcMailHeader</pre><br>\n";
    }
    
  //	If is it Draft?
  if( strtolower( $incomingMailProtocol ) == "imap" && $action == "draft" ){
     
    $lcMailHeader .= $lcMailHeader1.$lcMailHeader2."\n\n".$lcBody;
     
    $loEmailConnect = & getEmailConnect( "Drafts" );
				
		if( $draft_id ){
			imap_delete($mbox, intval( $draft_id ) );
			imap_expunge ($mbox);	
		}
		
		imap_append( $mbox, "{".$incomingMailServer.":".$incomingMailPort."}".$loEmailConnect->fullFolderPrefix()."Drafts", 
		            $lcMailHeader );
		imap_close( $mbox );
		
    $loEmailConnect->disconnect();
  
		header("Location: ./email_postfach.php?folder=".$loEmailConnect->fullFolderPrefix()."Drafts");
		exit();
  }elseif( @mail($to,$laHeaders['Subject'], 
                 "", $lcMailHeader.$lcMailHeader2."\n\n".$lcBody, "-f$from" ) )
  {
    /**
     * =========================================================================
     * Form for status of message (Ok/Error) 
     * + additing addresses to address book
     * =========================================================================
     */

     // Save for IMAP message in 'Sends'
		if( strtolower( $incomingMailProtocol ) == "imap" ){
      $loEmailConnect = & getEmailConnect("Drafts");
       
			if( $draft_id ){
				imap_delete( $mbox, intval( $draft_id ) );
				imap_expunge( $mbox );	
			}
			
	    $lcMailHeader.= $lcMailHeader1.$lcMailHeader2."\n\n".$lcBody;
	  
			imap_append( $mbox, "{".$incomingMailServer.":".$incomingMailPort."}".
                  $loEmailConnect->fullFolderPrefix()."Sent", $lcMailHeader );
		            
       $loEmailConnect->disconnect();
		}

		$sendmail_ok = ltext("wbm_sendmail_ok");
    $sendmail_ok = str_replace("%subject%","&quot;$subject&quot;",$sendmail_ok);
    $to2         = str_replace("<","&#139;",$to);
    $to2         = str_replace(">","&#155;",$to2);
    $sendmail_ok = str_replace("%to%","$to2",$sendmail_ok);

		
    $laAddresses  = explode( ',', $to );    
    $laAddresses  = array_map( 'trim', $laAddresses );
    
    if( ! empty( $cc ) && ! preg_match( '~^\s*$~', $cc ) ){
      $laTmp = explode( ',', $cc );
      $laTmp = array_map( 'trim', $laTmp );
      $laAddresses = array_keys( array_flip( $laAddresses ) + array_flip( $laTmp ) );
    }
    
    if( ! empty( $bcc ) && ! preg_match( '~^\s*$~', $bcc ) ){
      $laTmp = explode( ',', $bcc );
      $laTmp = array_map( 'trim', $laTmp );
      $laAddresses = array_keys( array_flip( $laAddresses ) + array_flip( $laTmp ) );
    }
 
    foreach( $laAddresses as $lcAddress ){
      $pos_lt = strrpos( $lcAddress,"<" );
      
      if( $pos_lt === false ){
        $ab_email = trim( $lcAddress );
      }else{
        $ab_email = trim( substr( $lcAddress, $pos_lt + 1, -1 ) );
      }		
 
      $ab_entry = safe_query2( " SELECT * FROM webmail_ab ".
                               " WHERE pop3 = ? AND email = ? AND server_id=?", 
                               $loKunde, 
                               new SQLString( $ab_email ), 
                               $loServerID );
      
      if( db_num_rows($ab_entry) == 0 ){
        $to = preg_replace( '~^"(.*?)"\s*(.*)\s*$~i', '$1 $2', trim( $lcAddress ) );
        $loLink = new LinkDataField( "email_adlist_edit.php?from_email=".urlencode( $to ),
                                     "", array(), ltext("wbm_sendmail_addtoab", $lcAddress ) );
                                  
        $loNewMsgTbl->AppendRow( $loLink );
        
      }
      db_free_query( $ab_entry );
    }
    
    $loNewMsgTbl->AppendRow( new HTMLDataField( "&nbsp;" ) );
		$loNewMsgTbl->AppendRow(new HTMLDataField( $sendmail_ok ) );
	} 
	else {
		$loNewMsgTbl->AppendRow(new HTMLDataField("<b>".ltext("wbm_sendmail_error")."</b>"));
	}
    $loNewMsgTbl->AppendRow(new HTMLDataField("&nbsp;"));
    $loNewMsgTbl->AppendRow(new HTMLDataField(str_replace("\n","<br>",(spec_htmlspecialchars($mail_content)))));

  } else { 
  	$loNewMsgTbl->AppendRow(new HTMLDataField(ltext("wbm_sendmail_norecipient")));
  }
  
	$loNewMsgTbl->AppendButton(ltext("wbm_buttonnext"), "javascript:doChange()", cc_IDOk);
	$loNewemailForm = $loNewMsgTbl->GetInputPresentation(array("action"=>"email_postfach.php", "method"=>"post", "name"=>"form1"), ltext("m_emailneu"));
		
	$loPage = new MainPageElement($loNewemailForm);
	$loPage->OutputHTML($JSscriptInclude, $JSscriptPart);
	exit();
} 
  //
  // Compose new message
  //
  $lcSQL = " SELECT e.* FROM email e, email_forward f ".
		       " WHERE e.ident = f.email_ident AND f.pop3 = ? ".
           " AND e.server_id=? AND f.server_id=?";
		
	$lrId = safe_query2( $lcSQL, $loKunde, $loServerID, $loServerID );
	$from_email_exists = 0;
	
	while( $laRow = db_fetch_array($lrId) ){
		$from_email_exists = 1;
		
		if( $laRow['prefix'] == "*" ){
			$lcFromEmail = "catchall@".$laRow['domain'];
		}else{ 
			$lcFromEmail = $laRow['prefix']."@".$laRow['domain']; 
		}
		
		$lrId2 = safe_query2( " SELECT email FROM webmail_def_from WHERE pop3 = ? ".
                          " AND email = ? AND server_id=?", 
		                      $loKunde, 
                          new SQLString( $lcFromEmail ), 
                          $loServerID );
		$deffrom = db_fetch_array( $lrId2 );

		db_free_query( $lrId2 );
		
		if( $deffrom['email'] == $lcFromEmail ){
		  $lcFromSelect = $lcFromEmail;
		}
		$laFromList[$lcFromEmail] = $lcFromEmail;
	}
  
	db_free_query( $lrId );

	if( !$from_email_exists ){
		$loNewMsgTbl->AppendRow( new HTMLDataField( ltext('wmail_email') ) );
		$loNewemailForm = $loNewMsgTbl->GetOutputPresentation(ltext("m_emailneu"));
		$loPage = new MainPageElement( $loNewemailForm );
		$loPage->OutputHTML( $JSscriptInclude, $JSscriptPart );
		exit();
	}

	$laAddresses = array();
	$laAddresses['to']['address']  = '';
  $laAddresses['to']['label']    = 'wbm_recipient';
  $laAddresses['cc']['address']  = '';
  $laAddresses['cc']['label']    = 'wbm_cc';
  $laAddresses['bcc']['address'] = '';
  $laAddresses['bcc']['label']   = 'wbm_bcc';
  //
  //	Is it Draft?
  //
  if( $draft_id ){
      
    // POP3 / IMAP-Connect
    $loEmailConnect = & getEmailConnect( "Drafts" );
     
    if( $loEmailConnect->MBox() ){
    	$structure  = imap_fetchstructure( $mbox, intval( $draft_id ) );
    	$structarr  = headerArray( $structure );
    	$partscount = sizeof( $structure->parts );
    }else{
      die( ltext( 'wbm_message_warning' ) );
    }
  
    $header    = imap_headerinfo($mbox, $draft_id);
    $mail_uniq = md5($header->subject . $header->date);
    $date      = dateFormat(strtotime($header->date),"datetime");
    $lcSubject = $header->subject ? decode_subject($header->subject) : "[".ltext("wbm_nosubject")."]";
  	
    $laAddresses['to']['address']  = mimeHeaderDecode( $header->toaddress );
    $laAddresses['cc']['address']  = mimeHeaderDecode( $header->ccaddress );
    $laAddresses['bcc']['address'] = mimeHeaderDecode( $header->bccaddress );
  
    $ha = headerArray($structure);
    $lcBody = br2nl( show_mail( imap_fetchbody($mbox, $draft_id, 1), $ha['type'], $ha['encoding'] ) ); 
  }elseif( $ab_id ){
		//
    //	Compose message from address book
    //
    $lrId = safe_query2( " SELECT name, email FROM webmail_ab ".
                         " WHERE ident = ? AND server_id=?",
                         new SQLInteger( $ab_id ), $loServerID );
		$laResAbAdress = db_fetch_array( $lrId );
		db_free_query( $lrId );
    $laAddresses['to']['address']  = '"'.$laResAbAdress['name'].'" <'.$laResAbAdress['email'].'>';
    
	}elseif ( $copy_to ){
	  //
    //	Reply or forward
    //
		$pos_lt = strrpos( $copy_to,"<" );
		if( $pos_lt === false ){
      $laAddresses['to']['address']  = $copy_to;
		}else{
      $laAddresses['to']['address']  = substr( $copy_to, $pos_lt + 1, -1 );
		}
		if ( ! empty( $reply_type ) ){
      $laAddresses['cc']['address']  = $copy_cc;
		}
		$lcBody    = $copy_body;
		$lcSubject = $copy_subject;
	}  
		
	$loFromField = new CompoundDataField();
	$loFromField->SetSeparator("<br>");
	$loFromField->AppendToContent( new OptionsDataField( $laFromList, $lcFromSelect, "from" ) );
	$loFromField->AppendToContent( new LinkDataField("javascript:setStdEmail()", "", 
	                                                 array(), ltext("wbm_deffrom_set") ) );
	                                                 
	$loNewMsgTbl->AppendRow( new HTMLDataField(ltext("wbm_sender")), $loFromField );
		
	foreach ( $laAddresses as $lcKey => $lcAddress ){

  	$loField = new CompoundDataField();
  	$loField->SetSeparator( '&nbsp;' );
  	$loTxtfield = new TextDataField( htmlspecialchars( $lcAddress['address'] ) , $lcKey );
  	$loTxtfield->SetAttributes( array( "size"=>"40" ) );
  	$loField->AppendToContent( $loTxtfield );
  	
  	if( $liABCount ){ 
  		$loField->AppendToContent( new LinkDataField("javascript:showAdBook('$lcKey')", "", array(), ltext("wbm_getad")));
  	}else{
  		$loField->AppendToContent( new HTMLDataField( ltext("wbm_ab_is_empty") ) );
  	}
  		
  	$loNewMsgTbl->AppendRow(new HTMLDataField(ltext($lcAddress['label'])), $loField);
	}
	
	$loSubjTxtfield = new TextDataField(htmlspecialchars( $lcSubject ), "subject");
	$loSubjTxtfield->SetAttributes( array( "size" => "40" ) );
	$loNewMsgTbl->AppendRow(new HTMLDataField(ltext("wbm_subject")), $loSubjTxtfield);
	
	$loContentField = new LongTextDataField( $lcBody, "content" );
	$loContentField->SetAttributes( array( "cols" => "80", 
	                                       "rows" => "15", 
	                                       "wrap" => "physical" 
	                                     ) );
	$loNewMsgTbl->AppendRow( new HTMLDataField( ltext("wbm_text") ), $loContentField );
		
	$loSignField = new CompoundDataField();
	$loSignField->SetSeparator("&nbsp;");
	$loSignField->AppendToContent( new YesNoDataField(array("1"=>""), array("0"=>""), "1", "signatur"));
	$loSignField->AppendToContent( new LinkDataField("javascript:showSignatur()", "", array(), ltext("wbm_sign_showedit")));
	
	if( $copy_mail ){
	  $loSignField->AppendToContent( new ButtonData( ltext('wmb_zitat'),
	                                                 'javascript:document.mail_form.content.value += document.mail_form.copy_body.value;return false;',
	                                                 cc_IDOk)
	                               );
	}
	
	$loNewMsgTbl->AppendRow( new HTMLDataField(ltext("wbm_sign_add")), $loSignField);
	$loNewMsgTbl->AppendRow( new HTMLDataField(ltext("wbm_prio")), 
								           new OptionsDataField( array( "3" => ltext("wbm_prio_normal"),
								                                        "1" => ltext( "wbm_prio_high" ),
								                                        "5"=>ltext("wbm_prio_low")
								                                      ), "3", "priority" ) );
  $loEncodingField  = new OptionsDataField(array(), $lang_html_charset, "msg_encoding");
  		
  foreach( $charsets as $key => $value ){
    $loEncodingField->AppendToOptions( array( $key => $value ) );
  }
  
  $loNewMsgTbl->AppendRow(new HTMLDataField(ltext("wbm_message_encoding")), $loEncodingField);

	$loAttachmentsField = new CompoundDataField();
	$loAttachmentsField->SetSeparator("<br>");
		
	if( $forwardid ){
    $loAttachCb = new CompoundDataField();
		$loAttachCb->SetSeparator("&nbsp;");
		$loAttachCb->AppendToContent( new YesNoDataField( array( $forwardid => $fwd_subject), 
		                                                  $fwd_subject, $forwardid, "forwardid" ) );
//	$loAttachCb->AppendToContent(new HTMLDataField("(".sizeFormat($ha['bytes']).")"));
		$loAttachmentsField->AppendToContent($loAttachCb );
		$loNewMsgTbl->AppendHidden( new TextDataField( $fwd_subject, 'fwd_subject' ) );
		$loNewMsgTbl->AppendHidden( new TextDataField( $gcCurrentFolder, 'folder' ) );
  }
  	
		$loAttachInput = new FileDataField("attachment");
		$loAttachInput->SetAttributes(array("size"=>"20"));
		$loAttachmentsField->AppendToContent( $loAttachInput );
		$loNewMsgTbl->AppendRow( new HTMLDataField( ltext( "wbm_attachment" ) ), $loAttachmentsField );
		
		$listFormIndex = 0;
		
		if( strtolower( $incomingMailProtocol ) == "imap" ){
	  	$loButtonsField = new CompoundDataField(new ButtonData(ltext('wmb_send'),'javascript:document.forms[0].submit()',cc_IDOk) );
			$loButtonsField->AppendToContent(new ButtonData(ltext('wbm_save_as_draft'),"javascript:submitForm('action','draft',$listFormIndex)",cc_IDOk));
			$loButtonsField->SetSeparator(' ');
			$loTmp = $loNewMsgTbl->AppendRow(new HTMLDataField("&nbsp;"), $loButtonsField );
			$loNewMsgTbl->AppendHidden(new TextDataField(' ', "action"));
		} else {
			$loNewMsgTbl->AppendRow(new HTMLDataField("&nbsp;"), 
																	new ButtonData(ltext('wmb_send'),'javascript:document.forms[0].submit()',cc_IDOk));
		}		
		
		$loNewMsgTbl->AppendHidden(new TextDataField("1", "sendmail"));

		if( $draft_id ){
		  $loNewMsgTbl->AppendHidden(new TextDataField($draft_id, "draft_id"));
		}elseif ($forwardid) {
			$loNewMsgTbl->AppendHidden(new TextDataField($forwardid, "forwardid"));
		}
		
		if( $copy_mail ){
			$loNewMsgTbl->AppendHidden(new TextDataField( $lcBody, "copy_body" ) );
		}
		
		$loNewMsgTbl->AppendHidden(new TextDataField("1", "sendmail"));
		
		$loNewemailForm = $loNewMsgTbl->GetInputPresentation( array( "action" => "email_neu.php", 
		                                                             "method" => "post", 
		                                                             "name"   => "mail_form", 
		                                                             "enctype"=> "multipart/form-data"), 
		                                                             ltext( "m_emailneu" ) );
		
$loPage = new MainPageElement( $loNewemailForm );
$loPage->OutputHTML( $JSscriptInclude, $JSscriptPart );		
?>
