<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com #####

include_once( "auth.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.LongTextDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/module.Constants.php" );
include_once( "email_functions.php" );
include_once( "../include/class.SQLString.php" );
include_once( "../include/class.SQLInteger.php" );

$JSscriptInclude = array();
$JSscriptInclude[] = "email_webmail.js";

// SIGNATUR:
$query_sign = safe_query2( "SELECT * FROM webmail_sign WHERE pop3 = ? AND alias = ? AND server_id='$ServerID'", 
                          new SQLString( $PHP_AUTH_USER ),new SQLString( $alias ) );
		
$sign = db_fetch_array( $query_sign );

if(!$setsign) {
	$data = new SetOfRowsData();
	$data->AppendHidden( new TextDataField( $sign['ident'], "edit_sign_id" ) );
	$data->AppendHidden( new TextDataField( $alias, "alias" ) );
	$data->AppendHidden( new TextDataField( "1", "setsign" ) );
	
	$head_label = new HTMLDataField( ltext( 'wbm_sign_alias', $alias ).':' );
	$head_label->SetColSpan("2");
	
	$data->AppendHeaderRow( $head_label );
	$sign_field = new LongTextDataField($sign['signatur'], "sign_text");
	$sign_field->SetAttributes(array("cols"=>"30", "rows"=>"10", "wrap"=>"virtual"));
	$sign_field->SetColSpan("2");
	$data->AppendRow( $sign_field );
	$data->AppendRow( new ButtonData(ltext('wbm_form_reset'),'javascript:document.forms[0].reset()',cc_IDOk),
						new ButtonData(ltext('wbm_form_submit'),'javascript:document.forms[0].submit()',cc_IDOk) );
	$data->AppendRow(new HTMLDataField( "&nbsp;" ));
	$data->AppendRow( new LinkDataField( "javascript:window.self.close()", "", array(), ltext( 'wbm_winclose' ) ), 
	                  new HTMLDataField( "&nbsp;" ) );
	
	$form = $data->GetInputPresentation( array( "action" => "email_signatur.php", 
	                                            "method" => "post", 
	                                            "name"   => "sign_form" ), 
	                                     ltext( 'wbm_sign_add' ) );
	
	$page = new MainPageElement( $form );
	$page->OutputHTML($JSscriptInclude);	

}else {
  
	if($edit_sign_id == "") {
		safe_query( "INSERT INTO webmail_sign ( alias, pop3, signatur, server_id ) VALUES ( ?, ?, ?, '$ServerID' )", 
		             TRUE, new SQLString($alias),
					new SQLString($PHP_AUTH_USER), new SQLString($sign_text) );
	} 
	else {
		safe_query( "UPDATE webmail_sign SET signatur = ? WHERE ident = ? AND pop3 = ? AND server_id='$ServerID'", 
		            TRUE, new SQLString($sign_text),
					new SQLInteger($edit_sign_id), new SQLString($PHP_AUTH_USER) );
	}
	
	$data = new SetOfRowsData();

	$data->AppendHeaderRow( new HTMLDataField( ltext( 'wbm_sign_change', $alias ).":" ) );
	$data->AppendRow( new HTMLDataField( "&nbsp;" ) );
	$data->AppendRow( new HTMLDataField( htmlspecialchars( nl2br( $sign_text ) ) ) );
	$data->AppendRow(new HTMLDataField( "&nbsp;" ) );
	$data->AppendRow( new LinkDataField( "javascript:window.self.close()", "", array(), ltext( 'wbm_winclose') ), 
	                 new HTMLDataField( "&nbsp;" ) );
	
	$form = $data->GetOutputPresentation( ltext('wbm_sign_add') );
	
	$page = new MainPageElement( $form );
	$page->OutputHTML($JSscriptInclude);
}
?>