<?php
########## Confixx(R) 3.2 Professional ############
####### Copyright SWsoft, Inc. 2004-2006 ##########
##### http://www.swsoft.com - info@swsoft.com ##### 

include_once( "auth.php" );
include_once( "../include/class.SQLString.php" );
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.ReadOnlyDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.YesNoDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );

global $DEBUG;
//$DEBUG=1;
/*
if($DEBUG){
	echo "kunde_aendern_loeschen.php<br>\n";
}
*/

db_connect($db_host, $db_user, $db_pass);

$laToDelete = array();

if ( $PHP_AUTH_USER == 'res0' && $kunde == $user_prefix.'0'){
	$forbidden=1;
	$lcForbiddenUser = $kunde;
}else{
## domains ins array

	$loRes = new SQLString( $PHP_AUTH_USER );
	if( is_array( $users ) && count($users)) {
		$loFields = new SQLFieldSet();
		foreach( $users as $lcUser ){
			$loFields->addField('kunde',$lcUser,'C');
		}
		$lcWhere = $loFields->getSQLValues();
		$id = safe_query2( " SELECT k.kunde, d.domain, d.richtigedomain FROM kunden k ".
                       " LEFT JOIN domains d ON k.kunde = d.kunde AND d.richtigedomain ".
                       " NOT IN (2,3) AND d.server_id=k.server_id".
                       " WHERE k.kunde IN ($lcWhere) AND k.anbieter=? AND k.server_id='$ServerID' ".
                       " ORDER BY k.kunde,d.domain", $loRes );
		while( $row = db_fetch_array( $id ) ) {
			$kunde = $row['kunde'];
			if( $kunde == $user_prefix.'0'){ // can't delete web0
				$forbidden = 1;
				$lcForbiddenUser = $kunde;
			} else {
				if(!array_key_exists( $kunde, $laToDelete )){
					$laToDelete[$kunde] = array();
				}
        array_push( $laToDelete[$kunde], array( 'domain' =>  $row["domain"], 
                                                'type'   => $row['richtigedomain'] ) );
      }
		}
	} elseif($kunde) {
		$id = safe_query2( "SELECT domain, richtigedomain FROM domains WHERE richtigedomain NOT IN (2,3) ".
											 " AND kunde = ?  AND anbieter = ?  AND server_id='$ServerID' ", 
											 new SQLString( $kunde ), $loRes );
		$laToDelete[$kunde] = array();
		while( $werte = db_fetch_array( $id ) ){
      array_push( $laToDelete[$kunde],  array( 'domain' =>  $werte["domain"], 
                                               'type'   => $werte['richtigedomain'] ) );
		}
	} else {
		$fehlertext = ltext('kuaelo_nothing');
		popPathBar( TRUE );
		include('kunden_start.php');
		exit;
	}
## /domains ins array
}
/*
echo "<br><pre>\n";
print_r($laToDelete);
echo "</pre><hr>\n";
*/

/* -------------------- HTML -------------------- */
$data = new SetOfRowsData();
if( $forbidden ) {
	$loMsg = new HTMLDataField( ltext( "kuaelo_forbidden", $lcForbiddenUser, $PHP_AUTH_USER ) );
	$loMsg->SetColSpan(2);
	$data->AppendRow( $loMsg );
	$data->AppendHidden( new TextDataField( $lcForbiddenUser, "undelete[]" ) );
}

foreach( $laToDelete as $kunde => $domains ){
	
	$loConfirm = new HTMLDataField( ltext( "kuaelo_descr1", $kunde ) );
	$loDomains = new CompoundDataField();
	foreach( $domains as $domain ){
    $loDomain = new ReadOnlyDataField( $domain['domain'] );
    if( $domain['type'] == 7 ){
      $loDomain->AddParentTag( 'i' );
      $loDomain->AddParentTag( 'b' );
    }else{
      $loDomain->AddParentTag( 'strong' );
    }
		$loDomains->AppendToContent( $loDomain );
	}
	$loDomains->SetSeparator( "<br>" );

	$loYesNo = new YesNoDataField( array( 'ja' => ltext( "kuaelo_text1", $kunde ) ), 
																 array( 'nein' => ltext( "kuaelo_text2", $kunde ) ), 
																 'ja', 
																 'loeschen['.$kunde.']', 
																 cc_RadioGroupPresentation 
																 );
	$loYesNo->AppendParentAttributes(array('rowspan'=>2));

	$data->AppendRow( $loConfirm, $loYesNo );
	$data->AppendRow( $loDomains );

	$data->AppendHidden( new TextDataField( $kunde, 'kunde[]' ) );

}
$lcLebel = count( $laToDelete ) ? ltext("kuaelo_button1") : ltext("ll_next_2");
$data->AppendButton( $lcLebel ,"javascript: doChange()", cc_IDOk);



$loForm = $data->GetInputPresentation( array( 'method'=>'post',
																							'action'=>'kunden_aendern_loeschen2.php' ), 
																			 ltext( 'kuae_cell_delete') 
																			 );
$loForm->SetWidths( '50%', '50%' );
$page = new MainPageElement( $loForm );
$page->AppendToHelp( array( "", "kuaelo_title1" ) );
$page->OutputHTML();
/* -------------------- end HTML -------------------- */
?>
