<?include_once( "../include/class.SQLString.php" );?><?
####### Confixx(R) 2.0 Professional
### Copyright Yippi-Yeah! E-Business GmbH 2001-2003
####### http://www.confixx.de - info@yippi-yeah.com
include_once("auth.php");
include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.LinkDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/module.Constants.php" );

global $DBEUG;
//$DEBUG=1;

if($DEBUG){
	echo "email_pop3_loeschen.php: _POST<br><pre>\n";
	print_r($_POST);
	echo "</pre><hr>\n";
}
db_connect($db_host, $db_user, $db_pass);

if(!is_array($pop3s)){
	$pop3s = array( $pop3 );
}

$loUser = new SQLString( $PHP_AUTH_USER );
$unique_pop3s = array();
foreach ( $pop3s as $pop3 ){
	if( !in_array( $pop3, $unique_pop3s ) ) {
		$unique_pop3s[] = $pop3;
	}
}

if($DEBUG){
	echo "unique_pop3s<br><pre>\n";
	print_r($unique_pop3s);
	echo "</pre><hr>\n";
}


$toReduce = array(); /* email's ident => number of forwards to delete */
foreach ( $unique_pop3s as $pop3 ) {
	$loPop3 = new SQLString( $pop3 );
	$id = safe_query2( "SELECT email_ident, COUNT(pop3) FROM email_forward WHERE pop3=? AND kunde=? AND server_id='$ServerID'".
	                  " GROUP BY email_ident", $loPop3, $loUser );
	while ( list( $ident, $count ) = db_fetch_array( $id, 'N' ) ) {
		if( in_array( $ident, $toReduce ) ) {
			$toReduce[$ident] += $count;
		} else {
			$toReduce[$ident] = $count;
		}
	}
}

if( $DEBUG ){
	echo "found:<br><pre>\n";
	print_r($toReduce);
	echo "</pre><hr>\n";
}

$totalForwars = array();
$toDelete = array();
$toChange = array();
$emails = array();
if( count( $toReduce ) ) {
	$idents = join( ',', array_keys( $toReduce ) );

	$id = safe_query2( "SELECT ident,prefix,domain FROM email WHERE ident IN ( $idents ) AND kunde=? AND server_id='$ServerID'", 
	                    $loUser);
	while( list( $ident, $prefix, $domain ) = db_fetch_array( $id ) ) {
		$emails[$ident] = $prefix.'@'.$domain;
	}

	$id = safe_query2( "SELECT email_ident, COUNT(pop3) FROM email_forward ".
										 " WHERE email_ident IN ( $idents) AND kunde = ? AND server_id='$ServerID' GROUP BY email_ident", $loUser );
	while( list( $ident, $count ) = db_fetch_array( $id, 'N' ) ) {
		if( $toReduce[$ident] >= $count ) {
			$toDelete[] = $emails[$ident];
		} else {
			$toChange[] = $emails[$ident];
		}
	}

}

if( $DEBUG ){
	echo "to delete:<br><pre>\n";
	print_r($toDelete);
	echo "</pre><hr>to change: <br><pre>\n";
	print_r($toChange);
	echo "</pre><hr>\n";
}

/* -------------------- HTML -------------------- */
$data = new SetOfRowsData();

foreach ($unique_pop3s as $pop3){
	$data->AppendHidden( new TextDataField( $pop3, "pop3s[]" ) );
}

$header_label = ltext("empolo_desc", array( join( ',', $unique_pop3s ) ) )."<br><br>";

$header_label .= join( '<br>', $toChange );
$header_label .= '<br><br>';
$header_label .= join( '<br>', $toDelete );
$header_label .= '<br><br>';

$data->AppendRow( new HTMLDataField( $header_label ) );
$data->AppendRow( new LinkDataField( "email_pop3.php", 
																		 "", 
																		 array( 'cur_page'=>'email_pop3.php',
																						'menu_node_id'=>'menu_node_email_pop3'
																						), 
																		 ltext("empolo_link")
																		 ) 
									);

$data->AppendButton( ltext("empolo_btn"), "javascript:doChange()", cc_IDOk );
$form = $data->GetInputPresentation( array( "action"=>"email_pop3_loeschen2.php", "method"=>"post", "name"=>"form1" ), 
																		 ltext("alst_cell_pop3") );

$page = new MainPageElement( $form );
$page->OutputHTML(js_f_call_help('', 'empolo_title'));
/* -------------------- end HTML -------------------- */

db_close();
?>