<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once( 'module.url.inc.php' );
include_once( 'class.SQLFieldSet.php' );

function checkAtName( $pcName ){
	return strstr( $pcName, '@')? 0: 1;
}

function checkToURL( $pcURL ){
	
	global $DEBUG;

	$pcURL = trim( $pcURL );

	if( !$pcURL || preg_match( '/\n|\t|\r/', $pcURL) ){
		if( $DEBUG ){
			echo "checkToURL: empty or bad sumbols '$pcURL'<br>\n";
		}
		return FALSE; /* empty or bad sumbols*/
	}
	$laURL =& parseURL( $pcURL );
	if( ! $laURL['host'] ){
		if( $DEBUG ){
			echo "checkToURL: there is not a host<br>\n";
		}
		return FALSE; /* there is not a host */
	}
	if( ! checkDomain( $laURL['host'] ) ){
		if( $DEBUG ){
			echo "checkToURL: the host is not valid<br>\n";
		}
		return FALSE; /* the host is not valid */
	}

	if( array_key_exists( 'prot', $laURL ) ){
		if( ! ( $laURL['prot'] == 'http' || $laURL['prot'] == 'https') ){
			if( $DEBUG ){
				echo "checkToURL: the bad protocol: ".$laURL['prot']."<br>\n";
			}
			return FALSE; /* only http:// or https:// */
		}
	} else {
		$laURL['prot'] = 'http';
		$pcURL = makeURL( $laURL );
	}

	return $pcURL;
}

function addAtDomain( $name, $id_from, $todomain ){
	global $fehlertext, $PHP_AUTH_USER;
	global $DEBUG;
	global $ServerID;

	if( $DEBUG ){
		echo "addAtDomain: $name, $id_from, $todomain<br>\n";
	}

	$loUser  = new SQLString( $PHP_AUTH_USER );

	$liRet = 0;

	if (checkAtName($name)) {
		
		// If $todomain == URL
		if (checkToURL($todomain)) { 
			$todomain = checkToURL($todomain);
			$loId = new SQLInteger( $id_from );
			$loName = new SQLString($name);
			$id = safe_query2( "SELECT id FROM atdomains WHERE id_from=? AND name=? AND server_id='$ServerID'",
												 $loId, $loName );
			if( db_num_rows( $id ) ){
				db_free_query( $id );
				$fehlertext = ltext( "ad_nameinuse" );
				
			} else {
				$id = safe_query2( "SELECT id FROM domains WHERE id=? AND kunde=? AND server_id='$ServerID'",
														 $loId, $loUser );
				if( db_num_rows( $id ) ){
					db_free_query( $id );
					safe_query2( "INSERT INTO atdomains( name, id_from, todomain, server_id ) ".
											 " VALUES( ?, ?, ?, '$ServerID' )",
												 $loName, $loId, new SQLString( $todomain) );
					$liRet++;
						
					safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser );
					safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
				}
			}
			
		// if $todomain == directory
		} elseif ($todomain[0]=='/'){
			$loId = new SQLInteger( $id_from );
			$loName = new SQLString($name);
			$id = safe_query2( "SELECT id FROM atdomains WHERE id_from=? AND name=? AND server_id='$ServerID'",
												 $loId, $loName );
			if( db_num_rows( $id ) ){
				db_free_query( $id );
				$fehlertext = ltext( "ad_nameinuse" );
				
			} else {
				$id = safe_query2( "SELECT id FROM domains WHERE id=? AND kunde=? AND server_id='$ServerID'",
														 $loId, $loUser );
				if( db_num_rows( $id ) ){
					db_free_query( $id );
					safe_query2( "INSERT INTO atdomains( name, id_from, todomain, server_id ) ".
											 " VALUES( ?, ?, ?, '$ServerID' )",
												 $loName, $loId, new SQLString( $todomain) );
					$liRet++;
						
					safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser );
					safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
				}
			}
		}	else {
			$fehlertext = ltext("ad_incorrectdomain");
		}
		
	} else {
		 $fehlertext = ltext("ad_incorrectname");
	}

	return $liRet;
}	

function changeAtDomain( $at_id, $name, $id_from, $todomain){
	global $fehlertext, $PHP_AUTH_USER;
	global $DEBUG;
	global $ServerID;

	$loUser  = new SQLString( $PHP_AUTH_USER );

	$liRet = 0;

	if (checkAtName($name)){
			
		  // If $todomain == URL
			if (checkToURL($todomain)) {
			$todoamin = checkToURL( $todomain );
			$loFromId = new SQLInteger( $id_from );
			$loId = new SQLInteger( $at_id );

			$loName = new SQLString($name);
			$id = safe_query2( "SELECT id FROM atdomains WHERE id_from=? AND name=? AND id != ? AND server_id='$ServerID'",
												 $loFromId, $loName, $loId );
			if( db_num_rows( $id ) ){
				db_free_query( $id );
				$fehlertext = ltext( "ad_nameinuse" );
				
			} else {
				$id = safe_query2( "SELECT id FROM domains WHERE id=? AND kunde=? AND server_id='$ServerID'",
														 $loFromId, $loUser );
				if( db_num_rows( $id ) ){

					safe_query2( "UPDATE atdomains SET name=?, id_from=?, todomain=? WHERE id=? AND server_id='$ServerID'",
											 $loName, $loFromId, new SQLString( $todomain), $loId );

					$liRet++;
						
					safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser );
					safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
				}
			}

		// if $todomain == directory
		} elseif ($todomain[0]=='/'){
			$loFromId = new SQLInteger( $id_from );
			$loId = new SQLInteger( $at_id );

			$loName = new SQLString($name);
			$id = safe_query2( "SELECT id FROM atdomains WHERE id_from=? AND name=? AND id != ? AND server_id='$ServerID'",
												 $loFromId, $loName, $loId );
			if( db_num_rows( $id ) ){
				db_free_query( $id );
				$fehlertext = ltext( "ad_nameinuse" );
				
			} else {
				$id = safe_query2( "SELECT id FROM domains WHERE id=? AND kunde=? AND server_id='$ServerID'",
														 $loFromId, $loUser );
				if( db_num_rows( $id ) ){

					safe_query2( "UPDATE atdomains SET name=?, id_from=?, todomain=? WHERE id=? AND server_id='$ServerID'",
											 $loName, $loFromId, new SQLString( $todomain), $loId );

					$liRet++;
						
					safe_query2( "UPDATE kunden SET httpd=1 WHERE kunde=? AND server_id='$ServerID'", $loUser );
					safe_query2( "UPDATE allgemein SET httpd=1, httpdupdate=0 WHERE server_id='$ServerID'" );
				}
			}
		} else {
			$fehlertext = ltext("ad_incorrectdomain");
		}
		
	} else {
		 $fehlertext = ltext("ad_incorrectname");
	}

	return $liRet;
	
}

function delAtDomains( &$ids ){

	global $PHP_AUTH_USER;
	global $ServerID;

	if( ! is_array( $ids ) ){
		return TRUE;
	}

	$loFlds = new SQLFieldSet();
	foreach( $ids as $idAt){
		$loFlds->addField( 'id', $idAt, 'N' );
	}
	
	$lcSQL = "SELECT at.id FROM atdomains at, domains d ".
		" WHERE at.id_from=d.id AND d.kunde =? AND at.id IN (". $loFlds->getSQLValues() .")".
		" AND at.server_id='$ServerID' AND d.server_id='$ServerID'";

	$loFlds->clean();
	
	$loUser = new SQLString( $PHP_AUTH_USER );
	$id = safe_query2( $lcSQL, $loUser );

	while( list($idAt) = db_fetch_array( $id, 'N' )){
		$loFlds->addField( 'id', $idAt, 'N' );
	}
	db_free_query( $id );

	if($loFlds->getCount()){
		$lcSQL = "DELETE FROM atdomains WHERE id IN (".$loFlds->getSQLValues().") AND server_id='$ServerID'";
		safe_query2( $lcSQL );
		safe_query2( "UPDATE kunden SET httpd = 1 WHERE kunde = ? AND server_id='$ServerID'", $loUser );
		safe_query2( "UPDATE allgemein SET httpd = 1, httpdupdate = 0 WHERE server_id='$ServerID'" );
	}
}

?>