<?
########## Confixx(R) 3.1 Professional ############
####### Copyright SWsoft, Inc. 2004-2005 ##########
#### http://www.sw-soft.com - info@sw-soft.com ####

include_once("auth.php");

include_once( "../include/elements/data/class.SetOfRowsData.php" );
include_once( "../include/elements/data/class.HTMLDataField.php" );
include_once( "../include/elements/data/class.YesNoDataField.php" );
include_once( "../include/elements/data/class.TextDataField.php" );
include_once( "../include/elements/data/class.PasswordDataField.php" );
include_once( "../include/elements/data/class.IconDataField.php" );
include_once( "../include/elements/data/class.CheckDataField.php" );
include_once( "../include/elements/data/class.CompoundDataField.php" );
include_once( "../include/elements/data/class.ButtonData.php" );
include_once( "../include/elements/data/class.OptionsDataField.php" );

include_once( "../include/elements/html/class.MainPageElement.php" );
include_once( "../include/elements/html/module.Constants.php" );

include_once( "./module.backup.inc.php" );
include_once( "defines.php" );

global $DEBUG;
//$DEBUG=1;

if($DEBUG){
	echo "tools_backup.php: _POST<br><pre>\n";
	print_r( $_POST );
	echo "</pre><hr>\n";
	/*	
	echo "<br>_SESSION<br><pre>\n";
	print_r( $_SESSION );
	echo "</pre><hr>\n";
	*/
 }


db_connect($db_host, $db_user, $db_pass);

$loUser = new SQLString($PHP_AUTH_USER);


$id = safe_query2 ( "SELECT maxmysql,backup,backup_url,backup_paswd  FROM kunden WHERE kunde=? AND server_id='$ServerID'",
                   $loUser );
$options = db_fetch_array($id);
$mysqlCount = 0;
if($options['maxmysql']){
	$id = safe_query2("SELECT COUNT(dbname) FROM mysql_datenbanken WHERE kunde=? AND server_id='$ServerID'",$loUser);
	list($mysqlCount) = db_fetch_array($id);
 }

if(!isset($backup_url)){
	$backup_url = $options['backup_url'];
 }

if(!isset($backup_paswd)){
	$backup_paswd = $options['backup_paswd'];
 }


//================================================================
//
// backup form

if( $lcURL = $options['backup_url'] ){
	if(!preg_match('/^\w+:\/\//',$lcURL)){
		$lcURL = 'ftp://'.$lcURL;
	}
	$laURL = parse_url($lcURL);
 }else{
	$laURL = NULL;
 }


$id = safe_query2( "SELECT src,dst FROM backup WHERE kunde=? AND server_id='$ServerID' ".
									 "AND src IN ('html','mysql','files')", $loUser);
$laState = array('html' => 0, 'files' => 0, 'mysql' => 0 );
$laStateled = array();
$laDests = array();

while(list($src,$dst) = db_fetch_array($id,'N')){

	prepareDestination($dst, $src, $laDests, $laURL);

	switch($dst){
	case 'backup':
	case '/backup':
	case '':
		$laState[$src] = 'backup';
		break;
	default:
		$laState[$src] = $lcURL? $lcURL: 'backup';
	}
 }

if(!isset($destination)){
	$destination = 'backup';
 }

prepareDestination( $destination, '*', $laDests, $laURL);


$laFileDates = getFileDates( $laDests );

/*
echo "<br><pre>\n";
print_r($laFileDates);
echo "</pre><hr>\n";
*/


$laDates = array('html' => '&nbsp;', 'files' => '&nbsp;', 'mysql' => '&nbsp;' );
$laSizes = $laDates;

foreach( $laDates as $src => $date ){
	$dst = $laState[$src];
	if(!$dst){
		$dst = $destination;
	}

	switch( $dst ){

	case 'backup':
	case '/backup':
	case '':
		$lcHost = $ftp_host;
		$lcPath = 'backup';
		break;

	default:
		if(is_array($laURL)){
			$lcHost = $laURL['host'];
			if(array_key_exists('path',$laURL)){
				$lcPath = prepareTildaPath($laURL['path']);
			}else{
				$lcPath = '';
			}
		}else{
			$lcHost = $ftp_host;
			$lcPath = 'backup';
		}
	}

	//	echo "host: $lcHost, path: $lcPath, src: $src<br>\n";

	$lcDate = '';
	$liSize = '';

	if( array_key_exists( $lcHost, $laFileDates ) ) {
		$lcDate = ltext('ftp_file_not_exists');
		if( array_key_exists( $lcPath, $laFileDates[$lcHost] ) ) {
			if( array_key_exists( $src, $laFileDates[$lcHost][$lcPath] ) ) {
				$lcDate = $laFileDates[$lcHost][$lcPath][$src][0];
				$liSize = prepSize($laFileDates[$lcHost][$lcPath][$src][2]);
			}
		}
	}
	$laDates[$src] = $lcDate;
	$laSizes[$src] = $liSize;

}

/*
echo "<br><pre>\n";
print_r($laDates);
echo "</pre><hr>\n";
*/

// end preparation of date
//
//===========================================


$formInd = 0;

$data = new SetOfRowsData();

$data->AppendHidden( new TextDataField( 'backup', 'action' ) );

$hasIdle = 0;
foreach($laState as $src => $dst){

	if(!$dst){
		$hasIdle = 1;
		break;
	}
}

if($hasIdle && ($options['backup'] > 1) && $options['backup_url']){
	$laOptions = array( 'backup'  => '/backup',
											'upload' => $options['backup_url']
											);
	
  $data->AppendRow( new HTMLDataField(ltext('tobk_ttl_dest')),
                                    new OptionsDataField( $laOptions, 
                                                          $destination, 
                                                          'destination'
                                                          ),
                                    
                                    new ButtonData( ltext('ll_show'),
                                                    "submitForm('action','destination',$formInd)",cc_IDSearch ));


}else{
	$data->AppendHidden( new TextDataField( '/backup', 'destination' ) );

 }


if($hasIdle){
	$loCheckBox = new CheckDataField( 1, 'selectAll' );
	$loCheckBox->Attribute( 'onclick', "javascript:checkedAll('backup',this.checked,$formInd)");
	$loCheckBox->SetParentAttributes( array( 'align' => 'center' ) );
	$loCheckBox->isChecked( 1 );
 }else{
	$loCheckBox = new HtmlDataField( '&nbsp;' );
 }
$data->AppendHeaderRow( new HtmlDataField( ltext('tobk_ttl_state')),
												new HtmlDataField( ltext('tobk_ttl_source')),
												new HtmlDataField( ltext('tobk_ttl_dest')),
												new HtmlDataField( ltext('tobk_ttl_date')),
												new HtmlDataField( ltext('tobk_ttl_size')),
												$loCheckBox						
												);

$lcSheduled = ltext('tobk_state_sheduled');
$lcIdle = ltext('tobk_state_idle');

foreach($laState as $src => $dst){
	if( $dst ){
    if ($confixx_interface_version == 'powp') {
      $loIcon = new IcondataField( cc_SheduledIcon,
                                         array( 'alt' => $lcSheduled, 
                                                'title' => $lcSheduled ),
                                         array( 'align' => 'center')
                                         ); 
    } else {
      $loIcon = new HTMLDataField($lcSheduled, FALSE, array(), array( 'align'=>'center'));
    }
		$data->AppendRow( $loIcon,
											new HtmlDataField( $src ),
											new HtmlDataField( $dst?$dst:'&nbsp;' ),
											new HtmlDataField( $laDates[$src] ),
											new HtmlDataField( $laSizes[$src],array(),array('align'=>'right') ),
											new HtmlDataField( '&nbsp;' )
											); 
	} else {
		if( $src == 'mysql' && !$options['maxmysql'] ){
			break;
		}
		$loCheckBackup = new CheckDataField( $src, 'backup[]' );

		$loCheckBackup->ParentAttribute( 'align', 'center' );

		if( $src == 'mysql' && !$mysqlCount){
			$loCheckBackup->setAttribute( 'disabled' );
		}else{
			$loCheckBackup->isChecked( 1 );
		}
    if ($confixx_interface_version == 'powp') {
      $loIcon = new IcondataField( cc_IdleIcon,
                                         array( 'alt' => $lcIdle, 
                                                'title' => $lcIdle ),
                                         array( 'align' => 'center')
                                         ); 
    } else {
      $loIcon = new HTMLDataField($lcIdle, FALSE, array(), array( 'align'=>'center'));
    }
		$data->AppendRow( $loIcon,
											new HtmlDataField( $src ),
											new HtmlDataField( '&nbsp;' ),
											new HtmlDataField( $laDates[$src] ),
											new HtmlDataField( $laSizes[$src],array(),array('align'=>'right') ),
											$loCheckBackup
											);
	}
}

$data->AppendButton( ltext("tobk_apply"), "javascript:doChange($formInd)", cc_IDOk );
$data->LabelIndex(1);

$formBackup = $data->GetInputPresentation( array( 'action' => 'tools_backup2.php', 
																						'method' => 'post', 
																						'name' => 'form1' ),
																		 ltext("tobk_backup") 
																		 );

//  end backup form
//
//=====================================================================


$page = new MainPageElement(  $formBackup );
$page->OutputHTML( array( '../../js/paged_form.js' ) );

/* -------------------- end HTML -------------------- */
?>